/*
 * Decompiled with CFR 0.152.
 */
package com.topisystems.midp.bigblocks;

import com.topisystems.midp.bigblocks.BlockField;
import com.topisystems.shared.ui.Dimension;
import com.topisystems.shared.ui.Location;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class FieldDisplay {
    public BlockField bField;
    public Image[] images;
    public Dimension blockDim;
    public Dimension displayDim;
    private Image f1;
    private Graphics f2;
    private Location[] f3;
    private int f4;
    public byte[] field;
    public int size;
    public Image offImg;
    public Graphics og;
    public boolean refresh;

    public FieldDisplay(Image[] imageArray) {
        this.images = imageArray;
        this.f3 = new Location[20];
        this.blockDim = new Dimension(0, 0, 0, 0);
        this.displayDim = new Dimension(0, 0, 0, 0);
    }

    public void init(BlockField blockField, int n, int n2, int n3, int n4, Image image, Graphics graphics) {
        this.refresh = true;
        this.bField = blockField;
        this.offImg = image;
        this.og = graphics;
        this.blockDim.set(0, 0, n3, n4);
        int n5 = this.blockDim.width * blockField.blockWidth;
        int n6 = this.blockDim.height * blockField.blockHeight;
        if (this.f1 == null || n5 != this.f1.getWidth() || n6 != this.f1.getHeight()) {
            this.f1 = Image.createImage((int)n5, (int)n6);
            this.f2 = this.f1.getGraphics();
        }
        this.displayDim.set(n, n2, n5, n6);
        this.size = blockField.width * blockField.height;
        if (this.field == null || this.field.length < this.size) {
            this.field = new byte[this.size];
        }
        System.arraycopy(blockField.field, 0, this.field, 0, this.size);
        this.f4 = 0;
    }

    public int getRow(int n) {
        int n2 = (n - this.displayDim.y) / this.bField.blockHeight;
        if (n2 >= this.blockDim.height) {
            return -1;
        }
        return n2 + this.blockDim.y;
    }

    public int getColumn(int n) {
        int n2 = (n - this.displayDim.x) / this.bField.blockWidth;
        if (n2 >= this.blockDim.width) {
            return -1;
        }
        return n2 + this.blockDim.x;
    }

    private void m1() {
        int n = this.displayDim.x;
        int n2 = this.displayDim.y;
        int n3 = this.blockDim.y + this.blockDim.height;
        int n4 = this.blockDim.x + this.blockDim.width;
        int n5 = this.blockDim.y;
        while (n5 < n3) {
            int n6 = this.blockDim.x;
            while (n6 < n4) {
                int n7 = n5 * this.bField.width + n6;
                Image image = this.images[this.field[n7]];
                if (image != null) {
                    this.og.drawImage(image, n, n2, 20);
                }
                ++n6;
                n += this.bField.blockWidth;
            }
            n = this.displayDim.x;
            n2 += this.bField.blockHeight;
            ++n5;
        }
    }

    public void paintBackground(int n) {
        if (this.bField != null) {
            this.og.setColor(n);
            this.og.fillRect(this.displayDim.x, this.displayDim.y, this.displayDim.width, this.displayDim.height);
            this.refresh = true;
            this.f4 = 0;
        }
    }

    public void paintBlock(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.images[n] != null) {
            this.og.drawImage(this.images[n], n5 + this.displayDim.x + (n2 - this.blockDim.x) * this.bField.blockWidth, n6 + this.displayDim.y + (n3 - this.blockDim.y) * this.bField.blockHeight, 20);
        }
    }

    public void paint() {
        if (this.bField != null) {
            if (this.refresh) {
                this.m1();
                this.refresh = false;
                return;
            }
            int n = this.f4;
            while (n > 0) {
                Location location = this.f3[--n];
                if (this.images[this.field[location.index]] == null) continue;
                this.og.drawImage(this.images[this.field[location.index]], this.displayDim.x + (location.x - this.blockDim.x) * this.bField.blockWidth, this.displayDim.y + (location.y - this.blockDim.y) * this.bField.blockHeight, 20);
            }
            this.f4 = 0;
        }
    }

    public void scrollX(int n) {
        if (n < 0 || n > this.bField.width - this.blockDim.width) {
            return;
        }
        int n2 = this.blockDim.x - n;
        this.f2.drawImage(this.offImg, 0 - this.displayDim.x, 0 - this.displayDim.y, 20);
        this.og.setClip(this.displayDim.x, this.displayDim.y, this.displayDim.width, this.displayDim.height);
        this.og.drawImage(this.f1, this.displayDim.x + n2 * this.bField.blockHeight, this.displayDim.y, 20);
        if (n2 < 0) {
            FieldDisplay fieldDisplay = this;
            fieldDisplay.validate(fieldDisplay.blockDim.x + this.blockDim.width - 1, n + this.blockDim.width - 1, this.blockDim.y, this.blockDim.y, Math.abs(n2), this.blockDim.height);
        } else {
            FieldDisplay fieldDisplay = this;
            fieldDisplay.validate(fieldDisplay.blockDim.x, n, this.blockDim.y, this.blockDim.y, n2, this.blockDim.height);
        }
        this.blockDim.x = n;
    }

    public void scrollY(int n) {
        if (n < 0 || n > this.bField.height - this.blockDim.height) {
            return;
        }
        int n2 = this.blockDim.y - n;
        this.f2.drawImage(this.offImg, 0 - this.displayDim.x, 0 - this.displayDim.y, 20);
        this.og.setClip(this.displayDim.x, this.displayDim.y, this.displayDim.width, this.displayDim.height);
        this.og.drawImage(this.f1, this.displayDim.x, this.displayDim.y + n2 * this.bField.blockHeight, 20);
        if (n2 < 0) {
            FieldDisplay fieldDisplay = this;
            fieldDisplay.validate(fieldDisplay.blockDim.x, this.blockDim.x, this.blockDim.y + this.blockDim.height - 1, n + this.blockDim.height - 1, this.blockDim.width, Math.abs(n2));
        } else {
            FieldDisplay fieldDisplay = this;
            fieldDisplay.validate(fieldDisplay.blockDim.x, this.blockDim.x, this.blockDim.y, n, this.blockDim.width, n2);
        }
        this.blockDim.y = n;
    }

    public int getValue(int n, int n2) {
        if (n < 0 || n >= this.bField.width) {
            return -1;
        }
        if (n2 < 0 || n2 >= this.bField.height) {
            return -1;
        }
        return this.field[n2 * this.bField.width + n];
    }

    public void set(int n, int n2, int n3, int n4) {
        if (n4 < 0 || n4 >= this.size) {
            return;
        }
        this.field[n4] = (byte)n;
        if (n2 >= this.blockDim.x && n2 < this.blockDim.x + this.blockDim.width && n3 >= this.blockDim.y && n3 < this.blockDim.y + this.blockDim.height) {
            if (this.f4 == this.f3.length) {
                int n5 = this.f4;
                Location[] locationArray = new Location[n5 + n5];
                System.arraycopy(this.f3, 0, locationArray, 0, this.f4);
                this.f3 = locationArray;
            }
            if (this.f3[this.f4] == null) {
                this.f3[this.f4] = new Location(n2, n3, n4);
            } else {
                this.f3[this.f4].set(n2, n3, n4);
            }
            ++this.f4;
        }
    }

    public void set(Location location) {
        FieldDisplay fieldDisplay = this;
        fieldDisplay.set(fieldDisplay.field[location.index], location.x, location.y, location.index);
    }

    public void set(int n, Location location) {
        this.set(n, location.x, location.y, location.index);
    }

    void validate(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 * this.bField.width + n;
        int n8 = n4 * this.bField.width + n2;
        int n9 = 0;
        int n10 = n5 * n6;
        while (n10 > 0) {
            if (n9 == n5) {
                n9 = 0;
                n7 += this.bField.width - n5;
                n8 += this.bField.width - n5;
                ++n4;
                n2 -= n5;
            }
            if (this.field[n7] != this.field[n8]) {
                if (this.f4 == this.f3.length) {
                    int n11 = this.f4;
                    Location[] locationArray = new Location[n11 + n11];
                    System.arraycopy(this.f3, 0, locationArray, 0, this.f4);
                    this.f3 = locationArray;
                }
                if (this.f3[this.f4] == null) {
                    this.f3[this.f4] = new Location(n2, n4, n8);
                } else {
                    this.f3[this.f4].set(n2, n4, n8);
                }
                ++this.f4;
            }
            ++n9;
            --n10;
            ++n7;
            ++n8;
            ++n2;
        }
    }
}

