/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class NvHighScores {
    private Vector m_highScores;
    private Font m_pFont;
    private int m_iWidth;
    private int m_iHeight;
    private NvProfile m_profile;

    public NvHighScores(NvProfile nvProfile, int n, int n2, Font font) {
        this.m_profile = nvProfile;
        this.m_pFont = font;
        this.m_iWidth = n;
        this.m_iHeight = n2;
        this.m_highScores = new Vector();
        boolean bl = this.load();
        if (!bl || this.size() <= 0) {
            this.reset();
        }
    }

    private void reset() {
        this.m_highScores.removeAllElements();
        this.m_highScores.addElement(new NvHighScore("Noname", 0));
        this.m_highScores.addElement(new NvHighScore("Noname", 0));
        this.m_highScores.addElement(new NvHighScore("Noname", 0));
        this.m_highScores.addElement(new NvHighScore("Noname", 0));
        this.m_highScores.addElement(new NvHighScore("Noname", 0));
        this.m_highScores.addElement(new NvHighScore("Noname", 0));
    }

    public boolean load() {
        RecordStore recordStore = null;
        RecordEnumeration recordEnumeration = null;
        boolean bl = true;
        try {
            recordStore = RecordStore.openRecordStore((String)"stackmatch.hsc", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
            bl = false;
        }
        try {
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
            bl = false;
        }
        this.m_highScores.removeAllElements();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(n));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    this.insert(new NvHighScore(dataInputStream.readUTF(), dataInputStream.readInt()));
                }
                catch (EOFException eOFException) {
                    System.out.println(eOFException);
                    eOFException.printStackTrace();
                    bl = false;
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
            bl = false;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            bl = false;
        }
        try {
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public void delete() {
        RecordStore recordStore = null;
        RecordEnumeration recordEnumeration = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"stackmatch.hsc", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
        }
        try {
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
        }
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                try {
                    recordStore.deleteRecord(n);
                }
                catch (RecordStoreException recordStoreException) {
                    System.out.println((Object)recordStoreException);
                    recordStoreException.printStackTrace();
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
        }
        try {
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
        }
    }

    public void save() {
        RecordStore recordStore = null;
        RecordEnumeration recordEnumeration = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n = 0;
        try {
            recordStore = RecordStore.openRecordStore((String)"stackmatch.hsc", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
        }
        try {
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
        }
        try {
            while (recordEnumeration.hasNextElement()) {
                int n2 = recordEnumeration.nextRecordId();
                try {
                    recordStore.deleteRecord(n2);
                }
                catch (RecordStoreException recordStoreException) {
                    System.out.println((Object)recordStoreException);
                    recordStoreException.printStackTrace();
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
        }
        for (n = 0; n < this.size(); ++n) {
            NvHighScore nvHighScore = (NvHighScore)this.m_highScores.elementAt(n);
            try {
                dataOutputStream.writeUTF(nvHighScore.m_strName);
                dataOutputStream.writeInt(nvHighScore.m_iScore);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                iOException.printStackTrace();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                recordStore.addRecord(byArray, 0, byArray.length);
                byteArrayOutputStream.reset();
                continue;
            }
            catch (RecordStoreException recordStoreException) {
                System.out.println((Object)recordStoreException);
                recordStoreException.printStackTrace();
            }
        }
        try {
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
        }
    }

    public int size() {
        return this.m_highScores.size();
    }

    public void update(int n) {
        NvHighScore nvHighScore = new NvHighScore(this.m_profile.getName(), n);
        int n2 = this.isTopSix();
        if (n2 != -1) {
            NvHighScore nvHighScore2 = (NvHighScore)this.m_highScores.elementAt(n2);
            if (nvHighScore.m_iScore > nvHighScore2.m_iScore) {
                this.m_highScores.removeElementAt(n2);
                this.insert(nvHighScore);
            }
        } else {
            NvHighScore nvHighScore3 = (NvHighScore)this.m_highScores.elementAt(this.size() - 1);
            if (nvHighScore.m_iScore > nvHighScore3.m_iScore) {
                this.insert(nvHighScore);
                this.m_highScores.removeElementAt(this.size() - 1);
            }
        }
    }

    private void insert(NvHighScore nvHighScore) {
        Enumeration enumeration = this.m_highScores.elements();
        while (enumeration.hasMoreElements()) {
            NvHighScore nvHighScore2 = (NvHighScore)enumeration.nextElement();
            if (nvHighScore2.m_iScore >= nvHighScore.m_iScore) continue;
            this.m_highScores.insertElementAt(nvHighScore, this.m_highScores.indexOf(nvHighScore2));
            return;
        }
        this.m_highScores.addElement(nvHighScore);
    }

    public int isTopSix() {
        String string = this.m_profile.getName().toUpperCase();
        for (int i = 0; i < this.size(); ++i) {
            NvHighScore nvHighScore = (NvHighScore)this.m_highScores.elementAt(i);
            String string2 = nvHighScore.m_strName.toUpperCase();
            if (string.compareTo(string2) != 0) continue;
            return i;
        }
        return -1;
    }

    public void render(Graphics graphics) {
        String string = TextResources.getString(2);
        int n = this.size() + 2;
        int n2 = (this.m_iHeight - (this.m_pFont.getHeight() * n + 3 * (n - 1))) / 2;
        graphics.setFont(this.m_pFont);
        int n3 = (this.m_iWidth - this.m_pFont.stringWidth(string)) / 2;
        graphics.setColor(64, 32, 0);
        graphics.drawString(string, n3, n2, 20);
        graphics.setColor(255, 128, 0);
        graphics.drawString(string, n3 + 1, n2 + 1, 20);
        n2 += this.m_pFont.getHeight() + this.m_pFont.getHeight() + 3;
        n3 = (this.m_iWidth - this.m_pFont.stringWidth("Novel Yahya   9999")) / 2;
        int n4 = n3 + this.m_pFont.stringWidth("Novel Yahya   9999");
        String string2 = this.m_profile.getName().toUpperCase();
        for (int i = 0; i < this.size(); ++i) {
            String string3;
            NvHighScore nvHighScore = (NvHighScore)this.m_highScores.elementAt(i);
            String string4 = nvHighScore.m_strName.toUpperCase();
            if (string2.compareTo(string4) == 0) {
                graphics.setColor(64, 64, 0);
                graphics.drawString(nvHighScore.m_strName, n3, n2, 20);
                graphics.setColor(255, 255, 0);
                graphics.drawString(nvHighScore.m_strName, n3 + 1, n2 + 1, 20);
                string3 = Integer.toString(nvHighScore.m_iScore);
                graphics.setColor(64, 64, 0);
                graphics.drawString(string3, n4 - this.m_pFont.stringWidth(string3), n2, 20);
                graphics.setColor(255, 255, 0);
                graphics.drawString(string3, n4 - this.m_pFont.stringWidth(string3) + 1, n2 + 1, 20);
            } else {
                graphics.setColor(64, 32, 0);
                graphics.drawString(nvHighScore.m_strName, n3, n2, 20);
                graphics.setColor(255, 128, 0);
                graphics.drawString(nvHighScore.m_strName, n3 + 1, n2 + 1, 20);
                string3 = Integer.toString(nvHighScore.m_iScore);
                graphics.setColor(64, 32, 0);
                graphics.drawString(string3, n4 - this.m_pFont.stringWidth(string3), n2, 20);
                graphics.setColor(255, 128, 0);
                graphics.drawString(string3, n4 - this.m_pFont.stringWidth(string3) + 1, n2 + 1, 20);
            }
            n2 += this.m_pFont.getHeight() + 3;
        }
    }
}

