/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

class StackMatchCanvas
extends Canvas
implements CommandListener,
Runnable {
    private static final int GS_LOAD = 0;
    private static final int GS_LOGO = 1;
    private static final int GS_PRESENT = 2;
    private static final int GS_TITLE = 3;
    private static final int GS_MENU = 4;
    private static final int GS_PLAY = 5;
    private static final int GS_GAMEOVER = 6;
    private static final int GS_WIN = 7;
    private static final int GS_GAME_CONTROLS = 8;
    private static final int GS_CREDITS = 9;
    private static final int GS_HIGHSCORES = 10;
    private int m_iGameState = 0;
    public int m_iResumeState = 0;
    public static final int VK_STAR = 0;
    public static final int VK_POUND = 1;
    public static final int VK_LEFT = 2;
    public static final int VK_RIGHT = 3;
    public static final int VK_UP = 4;
    public static final int VK_DOWN = 5;
    public static final int VK_FIRE = 6;
    public boolean[] m_pressedKeys = new boolean[7];
    public boolean[] m_releasedKeys = new boolean[7];
    private final StackMatchMIDlet m_midlet;
    private final Display m_display;
    private final byte FPS = (byte)50;
    private long m_oldFrameTick;
    private volatile Thread m_animationThread = null;
    private long m_lFrameTickDiff;
    private boolean m_bPaused = false;
    public Image m_imgLogo;
    public Image m_imgTitle;
    public Image m_imgBackground;
    public Image m_imgTartsets;
    public Image m_imgFrame;
    public Image m_imgCursorHand;
    public Image m_imgCursorArrow;
    public Image m_imgCursorStop;
    private Image m_imgBlack = null;
    private Font m_fontTexts1;
    private Font m_fontTexts2;
    private Font m_fontTexts3;
    private Random m_rnd;
    private long m_lLogoTick = 0L;
    private long m_lWinTick = 0L;
    private long m_lGameOverTick = 0L;
    private long m_lPresentTick = 0L;
    private long m_lBlinkTick = 0L;
    private boolean m_bBlinkShow = true;
    private String[] m_strMenuTexts = new String[]{TextResources.getString(0), TextResources.getString(1), TextResources.getString(29), TextResources.getString(2), TextResources.getString(3), TextResources.getString(4), TextResources.getString(5), TextResources.getString(6)};
    private static final int m_iNumMenuTexts = 8;
    private NvMenu m_menu;
    private boolean m_bSoundOn = true;
    private int m_iCreditTextYPos;
    private NvHighScores m_highScores;
    private NvProfile m_profile;
    private boolean m_bWin = false;
    private boolean m_bPauseDone = false;
    private static final int FLAG_KEY_LEFT = 0;
    private static final int FLAG_KEY_RIGHT = 1;
    private static final int FLAG_KEY_UP = 2;
    private static final int FLAG_KEY_DOWN = 3;
    private static final int FLAG_KEY_ACTION = 4;
    private static final int NUM_KEY_FLAGS = 5;
    private boolean[] m_bKeyPressedFlags = new boolean[5];
    public int m_relX = 0;
    public int m_relY = 0;
    public static final int TARGET_W = 176;
    public static final int TARGET_H = 208;
    public static final int CURSOR_DELTA_DISTANCE = 1;
    private boolean m_bCanGameResume = false;
    public NvCursor m_cursor;
    public Image m_imgOffScreen;
    public Graphics m_gOffScreen;
    Mahmatch m_mahmatch;
    private NvProgressbar m_progressBar;
    public Player m_sndTileMatch = null;
    public Player m_sndTileMiss = null;
    public Player m_sndTileSelect = null;
    public Player m_sndWarning = null;
    public Player m_sndGameover = null;
    public Player m_sndWin = null;

    public StackMatchCanvas(StackMatchMIDlet stackMatchMIDlet, Display display) {
        this.setFullScreenMode(true);
        this.m_fontTexts1 = Font.getFont((int)64, (int)0, (int)8);
        this.repaint();
        this.m_fontTexts2 = Font.getFont((int)64, (int)1, (int)0);
        this.m_fontTexts3 = Font.getFont((int)64, (int)1, (int)16);
        this.m_midlet = stackMatchMIDlet;
        this.m_display = display;
        this.m_lFrameTickDiff = 0L;
        this.m_rnd = new Random();
    }

    private void initSprites() {
    }

    private void initGame() {
        int n;
        this.m_bSoundOn = true;
        this.m_sndTileMatch = this.createMMPlayer("/tilematch.wav", "audio/x-wav");
        this.m_sndTileMiss = this.createMMPlayer("/tilemiss.wav", "audio/x-wav");
        this.m_sndTileSelect = this.createMMPlayer("/tileselect.wav", "audio/x-wav");
        this.m_sndWarning = this.createMMPlayer("/warning.wav", "audio/x-wav");
        this.m_sndGameover = this.createMMPlayer("/gameover.wav", "audio/x-wav");
        this.m_imgLogo = StackMatchMIDlet.loadImage("condetsoft");
        this.m_imgTitle = StackMatchMIDlet.loadImage("title");
        this.m_imgBackground = StackMatchMIDlet.loadImage("bkg");
        this.m_imgTartsets = StackMatchMIDlet.loadImage("tartsets");
        this.m_imgFrame = StackMatchMIDlet.loadImage("frame");
        this.m_imgCursorArrow = StackMatchMIDlet.loadImage("cursor_arrow");
        this.m_imgCursorHand = StackMatchMIDlet.loadImage("cursor_hand");
        this.m_imgCursorStop = StackMatchMIDlet.loadImage("cursor_stop");
        this.createBlackImage(this.getWidth(), this.getHeight());
        this.createOffScreenImage(this.getWidth(), this.getHeight());
        this.m_relX = (this.getWidth() - this.m_imgBackground.getWidth()) / 2;
        this.m_relY = (this.getHeight() - this.m_imgBackground.getHeight()) / 2;
        this.m_menu = new NvMenu(this.m_strMenuTexts, 8, new NvRectangle(0, 0, this.getWidth(), this.getHeight()), this.m_fontTexts1);
        this.m_profile = new NvProfile(this.m_display, this);
        this.m_highScores = new NvHighScores(this.m_profile, this.getWidth(), this.getHeight(), this.m_fontTexts1);
        for (n = 0; n < 5; ++n) {
            this.m_bKeyPressedFlags[n] = false;
        }
        this.m_cursor = new NvCursor(this, this.m_imgCursorArrow);
        this.m_mahmatch = new Mahmatch(0, this, this.m_relX, this.m_relY, 176, 208, 50, 30000, 50);
        n = 50;
        int n2 = 6;
        int n3 = this.m_relX + 4;
        int n4 = this.m_relY + 2;
        this.m_progressBar = new NvProgressbar(n3, n4, n, n2, 255, 128, 0, 202, 210, 174, 50);
    }

    private void createOffScreenImage(int n, int n2) {
        this.m_imgOffScreen = Image.createImage((int)n, (int)n2);
        this.m_gOffScreen = this.m_imgOffScreen.getGraphics();
        this.m_gOffScreen.setColor(0);
        this.m_gOffScreen.fillRect(0, 0, n, n2);
    }

    private void createBlackImage(int n, int n2) {
        this.m_imgBlack = Image.createImage((int)n, (int)n2);
        Graphics graphics = this.m_imgBlack.getGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, n, n2);
    }

    public synchronized void start() {
        this.initGame();
        this.m_animationThread = new Thread(this);
        this.m_oldFrameTick = System.currentTimeMillis();
        this.m_animationThread.start();
    }

    public synchronized void stop() {
        this.m_animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = 20L;
        Thread thread = Thread.currentThread();
        this.m_iGameState = 1;
        try {
            while (thread == this.m_animationThread && thread != null && !this.m_midlet.m_bNeedExit) {
                long l2 = System.currentTimeMillis();
                this.m_lFrameTickDiff = l2 - this.m_oldFrameTick;
                if (this.m_lFrameTickDiff == 0L) continue;
                this.m_oldFrameTick = l2;
                this.processInput();
                this.repaint(0, 0, this.getWidth(), this.getHeight());
                this.serviceRepaints();
                if (this.m_lFrameTickDiff < l) {
                    StackMatchCanvas stackMatchCanvas = this;
                    synchronized (stackMatchCanvas) {
                        this.wait(l - this.m_lFrameTickDiff);
                        continue;
                    }
                }
                if (thread == null) continue;
                thread.yield();
            }
            if (this.m_midlet != null) {
                this.m_midlet.exitRequested();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void blackened(Graphics graphics) {
        if (this.m_imgBlack == null) {
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            graphics.drawImage(this.m_imgBlack, 0, 0, 20);
        }
    }

    public void paint(Graphics graphics) {
        switch (this.m_iGameState) {
            case 0: {
                this.blackened(graphics);
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(7), this.m_fontTexts1);
                break;
            }
            case 1: {
                this.blackened(graphics);
                this.renderMenuBkg(graphics);
                this.renderLogo(graphics, this.m_imgLogo);
                this.m_lLogoTick += this.m_lFrameTickDiff;
                if (this.m_lLogoTick <= 1000L) break;
                this.m_iGameState = 2;
                this.m_lLogoTick = 0L;
                break;
            }
            case 2: {
                this.blackened(graphics);
                this.renderMenuBkg(graphics);
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(8), this.m_fontTexts2);
                this.m_lPresentTick += this.m_lFrameTickDiff;
                if (this.m_lPresentTick <= 1000L) break;
                this.newTitle();
                this.m_lPresentTick = 0L;
                break;
            }
            case 3: {
                this.blackened(graphics);
                this.renderMenuBkg(graphics);
                this.renderSplash(graphics);
                break;
            }
            case 4: {
                this.blackened(graphics);
                this.renderMenuBkg(graphics);
                this.m_menu.render(graphics);
                break;
            }
            case 5: {
                this.updateNDrawAll(graphics);
                if (this.m_mahmatch.DoesPlayerWin()) {
                    this.win();
                    break;
                }
                if (!this.m_mahmatch.DoesPlayerLose() && !this.m_mahmatch.DoesPlayerOutOfTime()) break;
                this.gameOver();
                break;
            }
            case 6: {
                this.updateNDrawAll(graphics);
                if (this.m_bPaused) break;
                if (this.m_mahmatch.DoesPlayerLose()) {
                    this.renderCenteredScreenYellowText(graphics, TextResources.getString(9), this.m_fontTexts3);
                } else if (this.m_mahmatch.DoesPlayerOutOfTime()) {
                    this.renderCenteredScreenYellowText(graphics, TextResources.getString(11), this.m_fontTexts3);
                }
                this.m_lGameOverTick += this.m_lFrameTickDiff;
                if (this.m_lGameOverTick <= 3000L) break;
                this.m_lGameOverTick = 0L;
                if (this.m_highScores.isTopSix() != -1) {
                    this.newHighscores();
                    break;
                }
                this.newMenu();
                break;
            }
            case 7: {
                this.updateNDrawAll(graphics);
                if (this.m_bPaused) break;
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(10), this.m_fontTexts3);
                this.m_lWinTick += this.m_lFrameTickDiff;
                if (this.m_lWinTick <= 3000L) break;
                this.m_lWinTick = 0L;
                this.m_bCanGameResume = false;
                this.newCredits();
                break;
            }
            case 9: {
                this.blackened(graphics);
                this.renderMenuBkg(graphics);
                this.renderLogo(graphics, this.m_imgLogo);
                this.renderCredits(graphics);
                break;
            }
            case 8: {
                this.blackened(graphics);
                this.renderMenuBkg(graphics);
                this.renderGameControls(graphics);
                break;
            }
            case 10: {
                this.blackened(graphics);
                this.renderMenuBkg(graphics);
                this.m_highScores.render(graphics);
            }
        }
    }

    int getGameState() {
        return this.m_iGameState;
    }

    void setGameState(int n) {
        this.m_iGameState = n;
    }

    private void newTitle() {
        this.m_lBlinkTick = 0L;
        this.m_bBlinkShow = true;
        this.m_releasedKeys[6] = false;
        this.m_iGameState = 3;
    }

    private void newGameControls() {
        this.m_iGameState = 8;
    }

    private void newHighscores() {
        this.m_iGameState = 10;
    }

    private void renderSplash(Graphics graphics) {
        int n = (this.getWidth() - this.m_imgTitle.getWidth()) / 2;
        int n2 = (this.getHeight() - this.m_imgTitle.getHeight()) / 2;
        graphics.drawImage(this.m_imgTitle, n, n2, 20);
        if (this.m_bBlinkShow) {
            this.renderCenteredYellowText(graphics, TextResources.getString(12), this.m_fontTexts1, this.getWidth() / 2, this.m_imgBackground.getHeight() - 8 + this.m_relY);
        }
        this.m_lBlinkTick += this.m_lFrameTickDiff;
        if (this.m_lBlinkTick > 500L) {
            this.m_bBlinkShow = !this.m_bBlinkShow;
            this.m_lBlinkTick = 0L;
        }
    }

    private void renderPauseMsg(Graphics graphics, String string, Font font) {
        if (this.m_bBlinkShow) {
            this.renderCenteredScreenYellowText(graphics, string, font);
        }
        this.m_lBlinkTick += this.m_lFrameTickDiff;
        if (this.m_lBlinkTick > 500L) {
            this.m_bBlinkShow = !this.m_bBlinkShow;
            this.m_lBlinkTick = 0L;
        }
    }

    private void renderLogo(Graphics graphics, Image image) {
        int n = (this.getWidth() - image.getWidth()) / 2;
        int n2 = (this.getHeight() - image.getHeight()) / 2;
        graphics.drawImage(image, n, n2, 20);
    }

    private void renderCenteredYellowText(Graphics graphics, String string, Font font, int n, int n2) {
        int n3 = font.stringWidth(string) / 2;
        int n4 = font.getHeight() / 2;
        int n5 = n - n3;
        int n6 = n2 - n4;
        graphics.setFont(font);
        graphics.setColor(64, 32, 0);
        graphics.drawString(string, n5, n6, 20);
        graphics.setColor(255, 128, 0);
        graphics.drawString(string, n5 + 1, n6 + 1, 20);
    }

    private void renderCenteredScreenYellowText(Graphics graphics, String string, Font font) {
        int n = (this.getWidth() - font.stringWidth(string)) / 2;
        int n2 = (this.getHeight() - font.getHeight()) / 2;
        graphics.setFont(font);
        graphics.setColor(64, 32, 0);
        graphics.drawString(string, n, n2, 20);
        graphics.setColor(255, 128, 0);
        graphics.drawString(string, n + 1, n2 + 1, 20);
    }

    private void renderCredits(Graphics graphics) {
        String[] stringArray = new String[]{"Stack Match", "Version 1.0", "", "Design & Programming", "Novel Yahya", "", "Arts", "Cahya and Novel", "", "Thanks to", "Hurriah & Hafidz A."};
        int n = this.m_fontTexts1.getHeight() * stringArray.length + 3 * (stringArray.length - 1);
        int n2 = this.m_iCreditTextYPos;
        graphics.setFont(this.m_fontTexts1);
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = (this.getWidth() - this.m_fontTexts1.stringWidth(stringArray[i])) / 2;
            graphics.setColor(64, 64, 32);
            graphics.drawString(stringArray[i], n3, n2, 20);
            graphics.setColor(255, 128, 0);
            graphics.drawString(stringArray[i], n3 + 1, n2 + 1, 20);
            n2 += this.m_fontTexts1.getHeight() + 3;
        }
        --this.m_iCreditTextYPos;
        if (this.m_iCreditTextYPos <= -n) {
            this.m_iCreditTextYPos = this.getHeight();
        }
    }

    private void renderGameControls(Graphics graphics) {
        String string = TextResources.getString(13);
        String[] stringArray = new String[]{TextResources.getString(14), "2", "8", "4", "6", "5", "*", "#"};
        String[] stringArray2 = new String[]{TextResources.getString(24), TextResources.getString(16), TextResources.getString(17), TextResources.getString(18), TextResources.getString(19), TextResources.getString(20), TextResources.getString(21), TextResources.getString(27)};
        int n = (this.getHeight() - (this.m_fontTexts1.getHeight() * 11 + 10)) / 2;
        graphics.setFont(this.m_fontTexts1);
        int n2 = (this.getWidth() - this.m_fontTexts1.stringWidth(string)) / 2;
        graphics.setColor(64, 32, 0);
        graphics.drawString(string, n2, n, 20);
        graphics.setColor(255, 128, 0);
        graphics.drawString(string, n2 + 1, n + 1, 20);
        n += this.m_fontTexts1.getHeight() + this.m_fontTexts1.getHeight() * 2 + 1;
        n2 = (this.getWidth() - this.m_fontTexts1.stringWidth(TextResources.getString(14) + "   " + stringArray2[1])) / 2;
        int n3 = n2 + this.m_fontTexts1.stringWidth(TextResources.getString(14) + "   ");
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.setColor(64, 32, 0);
            graphics.drawString(stringArray[i], n2, n, 20);
            graphics.setColor(255, 128, 0);
            graphics.drawString(stringArray[i], n2 + 1, n + 1, 20);
            graphics.setColor(64, 32, 0);
            graphics.drawString(stringArray2[i], n3, n, 20);
            graphics.setColor(255, 128, 0);
            graphics.drawString(stringArray2[i], n3 + 1, n + 1, 20);
            n += this.m_fontTexts1.getHeight() + 1;
        }
    }

    private void newGame() {
        this.m_bPaused = false;
        this.m_bCanGameResume = true;
        this.m_bWin = false;
        this.m_mahmatch.Reset(this.getRand(3));
        this.m_mahmatch.Play();
        this.m_progressBar.setValue(this.m_mahmatch.GetMatchScore());
        this.m_iGameState = 5;
    }

    public int getRand(int n) {
        int n2 = Math.abs(this.m_rnd.nextInt()) % n;
        return n2;
    }

    public void gameOver() {
        this.m_bCanGameResume = false;
        this.m_highScores.update(this.m_mahmatch.GetTotalScore());
        this.m_highScores.save();
        this.m_lGameOverTick = 0L;
        this.m_oldFrameTick = System.currentTimeMillis();
        this.m_iGameState = 6;
        this.startMM(this.m_sndGameover);
    }

    private void newCredits() {
        this.m_iCreditTextYPos = this.getHeight();
        this.m_iGameState = 9;
    }

    public void win() {
        this.m_bWin = true;
        this.m_highScores.update(this.m_mahmatch.GetTotalScore());
        this.m_highScores.save();
        this.m_lWinTick = 0L;
        this.m_oldFrameTick = System.currentTimeMillis();
        this.m_iGameState = 7;
        this.startMM(this.m_sndWin);
    }

    public boolean isPlaying() {
        return this.m_iGameState == 5;
    }

    private void processInput() {
        if (this.m_iGameState == 3) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                this.m_display.setCurrent((Displayable)this.m_profile);
            }
        } else if (this.m_iGameState == 10) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                this.newMenu();
            }
        } else if (this.m_iGameState == 8) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                this.newMenu();
            }
        } else if (this.m_iGameState == 9) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                if (this.m_bWin && this.m_highScores.isTopSix() != -1) {
                    this.newHighscores();
                } else {
                    this.newMenu();
                }
            }
        } else if (this.m_iGameState == 4) {
            this.m_menu.ProcessInput(this);
        } else {
            if (this.m_pressedKeys[0]) {
                this.m_iResumeState = this.m_iGameState;
                this.newMenu();
            }
            if (this.m_pressedKeys[1]) {
                if (!this.m_bPauseDone) {
                    this.m_bPauseDone = true;
                    boolean bl = this.m_bPaused = !this.m_bPaused;
                    if (this.m_bPaused) {
                        this.m_lBlinkTick = 0L;
                        this.m_bBlinkShow = true;
                    }
                }
            } else {
                this.m_bPauseDone = false;
            }
            this.processGameInput();
        }
    }

    private void processGameInput() {
        if (this.m_iGameState != 5 || this.m_bPaused) {
            return;
        }
        if (this.m_pressedKeys[2]) {
            this.m_cursor.move(-1, 0);
        }
        if (this.m_pressedKeys[3]) {
            this.m_cursor.move(1, 0);
        }
        if (this.m_pressedKeys[4]) {
            this.m_cursor.move(0, -1);
        }
        if (this.m_pressedKeys[5]) {
            this.m_cursor.move(0, 1);
        }
        if (this.m_pressedKeys[6]) {
            if (!this.m_bKeyPressedFlags[4]) {
                this.m_mahmatch.Click(this.m_cursor.getSpotX(), this.m_cursor.getSpotY());
                this.m_bKeyPressedFlags[4] = true;
            }
        } else {
            this.m_bKeyPressedFlags[4] = false;
        }
    }

    private synchronized void updateNDrawAll(Graphics graphics) {
        this.m_mahmatch.Update(graphics, !this.m_bPaused);
        this.m_mahmatch.UpdateMousePos(this.m_cursor.getSpotX(), this.m_cursor.getSpotY());
        String string = TextResources.getString(25) + ": " + this.m_mahmatch.GetTotalScore();
        this.renderCenteredYellowText(graphics, string, this.m_fontTexts2, this.m_relX + (this.m_imgBackground.getWidth() - this.m_fontTexts2.stringWidth(string) / 2 - 5), this.m_relY + this.m_fontTexts2.getHeight() / 2);
        this.m_progressBar.setValue(this.m_mahmatch.GetMatchScore());
        this.m_progressBar.render(graphics);
        if (this.m_mahmatch.IsTileBlocked()) {
            string = TextResources.getString(26);
            this.renderCenteredYellowText(graphics, string, this.m_fontTexts2, this.m_relX + 88, this.m_relY + (this.m_imgBackground.getHeight() - this.m_fontTexts2.getHeight() / 2));
        }
        this.m_cursor.render(graphics);
        if (this.m_bPaused) {
            this.renderPauseMsg(graphics, TextResources.getString(28), this.m_fontTexts2);
        }
    }

    private boolean canGameResume() {
        return this.m_bCanGameResume;
    }

    public void newMenu() {
        this.m_menu.m_bEnabledFirstItem = this.canGameResume();
        this.m_menu.reset();
        this.m_releasedKeys[6] = false;
        this.m_iGameState = 4;
    }

    public void menuDone(int n) {
        switch (n) {
            case 0: {
                this.m_iGameState = this.m_iResumeState;
                break;
            }
            case 1: {
                this.newGame();
                break;
            }
            case 2: {
                boolean bl = this.m_bSoundOn = !this.m_bSoundOn;
                if (this.m_bSoundOn) {
                    this.m_strMenuTexts[2] = TextResources.getString(29);
                    break;
                }
                this.m_strMenuTexts[2] = TextResources.getString(30);
                break;
            }
            case 3: {
                this.newHighscores();
                break;
            }
            case 4: {
                this.newGameControls();
                break;
            }
            case 5: {
                NvHelp.showInstructions(this.m_display);
                break;
            }
            case 6: {
                this.newCredits();
                break;
            }
            case 7: {
                this.m_midlet.m_bNeedExit = true;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 2: {
                this.m_pressedKeys[2] = true;
                this.m_releasedKeys[2] = false;
                break;
            }
            case 5: {
                this.m_pressedKeys[3] = true;
                this.m_releasedKeys[3] = false;
                break;
            }
            case 8: {
                this.m_pressedKeys[6] = true;
                this.m_releasedKeys[6] = false;
                break;
            }
            case 1: {
                this.m_pressedKeys[4] = true;
                this.m_releasedKeys[4] = false;
                break;
            }
            case 6: {
                this.m_pressedKeys[5] = true;
                this.m_releasedKeys[5] = false;
                break;
            }
            case 0: {
                switch (n) {
                    case 52: {
                        this.m_pressedKeys[2] = true;
                        this.m_releasedKeys[2] = false;
                        break block0;
                    }
                    case 54: {
                        this.m_pressedKeys[3] = true;
                        this.m_releasedKeys[3] = false;
                        break block0;
                    }
                    case 53: {
                        this.m_pressedKeys[6] = true;
                        this.m_releasedKeys[6] = false;
                        break block0;
                    }
                    case 50: {
                        this.m_pressedKeys[4] = true;
                        this.m_releasedKeys[4] = false;
                        break block0;
                    }
                    case 56: {
                        this.m_pressedKeys[5] = true;
                        this.m_releasedKeys[5] = false;
                    }
                }
            }
        }
        if (n == 42) {
            this.m_pressedKeys[0] = true;
            this.m_releasedKeys[0] = false;
        } else if (n == 35) {
            this.m_pressedKeys[1] = true;
            this.m_releasedKeys[1] = false;
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 2: {
                this.m_pressedKeys[2] = false;
                this.m_releasedKeys[2] = true;
                break;
            }
            case 5: {
                this.m_pressedKeys[3] = false;
                this.m_releasedKeys[3] = true;
                break;
            }
            case 8: {
                this.m_pressedKeys[6] = false;
                this.m_releasedKeys[6] = true;
                break;
            }
            case 1: {
                this.m_pressedKeys[4] = false;
                this.m_releasedKeys[4] = true;
                break;
            }
            case 6: {
                this.m_pressedKeys[5] = false;
                this.m_releasedKeys[5] = true;
                break;
            }
            case 0: {
                switch (n) {
                    case 52: {
                        this.m_pressedKeys[2] = false;
                        this.m_releasedKeys[2] = true;
                        break block0;
                    }
                    case 54: {
                        this.m_pressedKeys[3] = false;
                        this.m_releasedKeys[3] = true;
                        break block0;
                    }
                    case 53: {
                        this.m_pressedKeys[6] = false;
                        this.m_releasedKeys[6] = true;
                        break block0;
                    }
                    case 50: {
                        this.m_pressedKeys[4] = false;
                        this.m_releasedKeys[4] = true;
                        break block0;
                    }
                    case 56: {
                        this.m_pressedKeys[5] = false;
                        this.m_releasedKeys[5] = true;
                    }
                }
            }
        }
        if (n == 42) {
            this.m_pressedKeys[0] = false;
            this.m_releasedKeys[0] = true;
        } else if (n == 35) {
            this.m_pressedKeys[1] = false;
            this.m_releasedKeys[1] = true;
        }
    }

    public void bitblt(Graphics graphics, int n, int n2, int n3, int n4, Image image, int n5, int n6) {
        graphics.setClip(n, n2, n3, n4);
        graphics.drawImage(image, n - n5, n2 - n6, 20);
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    private void clearScreen(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(n, n2, n3);
        graphics.fillRect(this.m_relX, this.m_relY, 176, 208);
    }

    private void renderMenuBkg(Graphics graphics) {
        graphics.drawImage(this.m_imgBackground, this.m_relX, this.m_relY, 20);
    }

    public void playSimpleWAV(String string) {
        block14: {
            if (!this.m_bSoundOn) {
                return;
            }
            Player player = null;
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream(string);
                player = Manager.createPlayer((InputStream)inputStream, (String)"audio/X-wav");
                player.start();
            }
            catch (IOException iOException) {
                if (player == null) break block14;
                try {
                    player.deallocate();
                    player.close();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (MediaException mediaException) {
                if (player == null) break block14;
                try {
                    player.deallocate();
                    player.close();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                if (player == null) break block14;
                try {
                    player.deallocate();
                    player.close();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    private Player createMMPlayer(String string, String string2) {
        Player player = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            player = Manager.createPlayer((InputStream)inputStream, (String)string2);
            player.prefetch();
        }
        catch (IOException iOException) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        return player;
    }

    public void startMM(Player player) {
        if (!this.m_bSoundOn) {
            return;
        }
        if (player != null) {
            try {
                player.stop();
                player.setMediaTime(0L);
                player.start();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }
}

