/*
 * Decompiled with CFR 0.152.
 */
package AfterDark;

import AfterDark.GameConstant;
import AfterDark.Rectangle;
import AfterDark.Room;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MovingObject
implements GameConstant {
    static Image weaponImg = null;
    protected int DEFAULT_HIT_POWER;
    protected int hitPower;
    protected int speedX;
    protected int speedY;
    protected int stage;
    protected int direction;
    protected int moveDis;
    protected boolean destroy;
    protected boolean canAttack;
    protected int type;
    protected Rectangle curLoc;

    public MovingObject(int objType, int locX, int locY, int width, int height) {
        this.hitPower = this.DEFAULT_HIT_POWER = 1;
        this.speedX = 3;
        this.speedY = 3;
        this.stage = 0;
        this.direction = 1;
        this.moveDis = 0;
        this.destroy = false;
        this.canAttack = false;
        this.type = 0;
        this.curLoc = new Rectangle();
        this.type = objType;
        this.curLoc.SetBounds(locX, locY, width, height);
        this.destroy = false;
        this.hitPower = this.DEFAULT_HIT_POWER;
        this.speedX = 3;
        this.speedY = 3;
        this.stage = 0;
        try {
            if (weaponImg == null) {
                weaponImg = Image.createImage((String)"/AfterDark/Images/Player/weapon.png");
            }
        }
        catch (Exception ioe) {
            return;
        }
    }

    public void Initial(int objType, int hitPow, int speedX, int speedY, int locX, int locY, int width, int height) {
        this.type = objType;
        this.curLoc.SetBounds(locX, locY, width, height);
        this.DEFAULT_HIT_POWER = hitPow;
        this.hitPower = hitPow;
        this.speedX = speedX;
        this.speedY = speedY;
        this.stage = 0;
        this.destroy = false;
        this.canAttack = false;
        this.direction = Math.abs(speedX) > Math.abs(speedY) ? (speedX > 0 ? 3 : 2) : (speedY > 0 ? 1 : 0);
        this.moveDis = Math.abs(speedX + speedY);
    }

    public void Run() {
        if (!this.IsDestroy()) {
            int absDis = Math.abs(this.speedX + this.speedY);
            if (this.moveDis < absDis) {
                this.SetDestroy(true);
            } else {
                this.moveDis = this.MoveToDirection(absDis);
            }
        }
    }

    public void Reset() {
        this.curLoc.SetLocation(0, 0);
        this.destroy = false;
        this.hitPower = this.DEFAULT_HIT_POWER;
        this.speedX = 3;
        this.speedY = 3;
        this.stage = 0;
        this.moveDis = 0;
        this.direction = 1;
        this.destroy = false;
        this.canAttack = false;
    }

    public int GetType() {
        return this.type;
    }

    public void SetType(int objType) {
        this.type = objType;
    }

    public void SetLocation(int x, int y) {
        this.curLoc.SetX(x);
        this.curLoc.SetY(y);
    }

    public int GetLocationX() {
        return this.curLoc.GetX();
    }

    public int GetLocationY() {
        return this.curLoc.GetY();
    }

    public void SetWidth(int width) {
        this.curLoc.SetWidth(width);
    }

    public int GetWidth() {
        return this.curLoc.GetWidth();
    }

    public void SetHeight(int height) {
        this.curLoc.SetHeight(height);
    }

    public int GetHeight() {
        return this.curLoc.GetHeight();
    }

    public Rectangle GetBounds() {
        return this.curLoc;
    }

    public int GetCenterLocationX() {
        return this.GetLocationX() + this.GetWidth() / 2;
    }

    public int GetCenterLocationY() {
        return this.GetLocationY() + this.GetHeight() / 2;
    }

    public void SetDirection(int newDir) {
        this.direction = newDir;
    }

    public int GetDirection() {
        return this.direction;
    }

    public void SetDestroy(boolean isDestroy) {
        this.destroy = isDestroy;
    }

    public boolean CanAttack() {
        return this.canAttack;
    }

    public boolean IsDestroy() {
        return this.destroy;
    }

    public int GetHitPower() {
        return this.hitPower;
    }

    public void SetHitPower(int newPower) {
        this.hitPower = newPower;
    }

    public int GetSpeedX() {
        return this.speedX;
    }

    public void SetSpeedX(int speed) {
        this.speedX = speed;
    }

    public int GetSpeedY() {
        return this.speedY;
    }

    public void SetSpeedY(int speed) {
        this.speedY = speed;
    }

    public void MoveX(int moveoffset) {
        this.curLoc.MoveX(moveoffset);
    }

    public void MoveY(int moveoffset) {
        this.curLoc.MoveY(moveoffset);
    }

    public void Move(int moveoffsetX, int moveoffsetY) {
        this.curLoc.MoveX(moveoffsetX);
        this.curLoc.MoveY(moveoffsetY);
    }

    public int MoveToDirection(int dis) {
        int canMoveDis = 0;
        switch (this.direction) {
            case 0: {
                canMoveDis = this.CheckCollision(dis, 0);
                this.MoveY(-canMoveDis);
                return canMoveDis;
            }
            case 1: {
                canMoveDis = this.CheckCollision(dis, 1);
                this.MoveY(canMoveDis);
                return canMoveDis;
            }
            case 2: {
                canMoveDis = this.CheckCollision(dis, 2);
                this.MoveX(-canMoveDis);
                return canMoveDis;
            }
            case 3: {
                canMoveDis = this.CheckCollision(dis, 3);
                this.MoveX(canMoveDis);
                return canMoveDis;
            }
        }
        return -1;
    }

    public int CheckCollision(int moveOffset, int direct) {
        int widthOffset = this.curLoc.GetWidth() / 2;
        int curPosX = this.GetCenterLocationX();
        int curPosY = this.GetCenterLocationY();
        try {
            switch (direct) {
                case 0: {
                    int posY2;
                    int rightBound;
                    int leftBound;
                    int width;
                    int rWidth;
                    int lWidth;
                    int objPosX;
                    int minX = curPosX - widthOffset;
                    int maxX = curPosX + widthOffset;
                    int leftPosX = minX / 30;
                    int rightPosX = maxX / 30;
                    int posY1 = curPosY / 30;
                    int leftRoomData = Room.GetObjectId(leftPosX, posY1);
                    int rightRoomData = Room.GetObjectId(rightPosX, posY1);
                    int objPosY = (posY1 + 1) * 30;
                    int leftDisY = objPosY - Room.GetObstructionDistance(leftRoomData, direct);
                    int rightDisY = objPosY - Room.GetObstructionDistance(rightRoomData, direct);
                    int moveTo = curPosY - moveOffset;
                    if (moveTo <= rightDisY && curPosY >= rightDisY && rightRoomData != -1) {
                        objPosX = Room.GetObstructionDistance(rightRoomData, 3);
                        lWidth = 30 - Room.GetObstructionDistance(rightRoomData, 2);
                        width = lWidth - (rWidth = objPosX);
                        if (width > 0) {
                            leftBound = objPosX += rightPosX * 30;
                            rightBound = objPosX + width;
                            if (minX < rightBound && maxX > leftBound || minX > leftBound && maxX < rightBound || minX < leftBound && maxX > leftBound || minX < rightBound && maxX > rightBound) {
                                return curPosY - rightDisY;
                            }
                        }
                    }
                    if (moveTo <= leftDisY && curPosY >= leftDisY && leftPosX != rightPosX && leftRoomData != -1 && (width = (rWidth = 30 - (objPosX = Room.GetObstructionDistance(leftRoomData, 3))) - (lWidth = Room.GetObstructionDistance(leftRoomData, 2))) > 0) {
                        leftBound = objPosX += leftPosX * 30;
                        rightBound = objPosX + width;
                        if (minX < rightBound && maxX > leftBound || minX > leftBound && maxX < rightBound || minX < leftBound && maxX > leftBound || minX < rightBound && maxX > rightBound) {
                            return curPosY - leftDisY;
                        }
                    }
                    if (posY1 != (posY2 = moveTo / 30)) {
                        while (--posY1 >= posY2) {
                            int rightBound2;
                            int leftBound2;
                            int width2;
                            int rWidth2;
                            int lWidth2;
                            int objPosX2;
                            leftRoomData = Room.GetObjectId(leftPosX, posY1);
                            rightRoomData = Room.GetObjectId(rightPosX, posY1);
                            leftDisY = (objPosY -= 30) - Room.GetObstructionDistance(leftRoomData, direct);
                            rightDisY = objPosY - Room.GetObstructionDistance(rightRoomData, direct);
                            if (rightRoomData != -1) {
                                objPosX2 = Room.GetObstructionDistance(rightRoomData, 3);
                                lWidth2 = 30 - Room.GetObstructionDistance(rightRoomData, 2);
                                width2 = lWidth2 - (rWidth2 = objPosX2);
                                if (width2 > 0) {
                                    leftBound2 = objPosX2 += rightPosX * 30;
                                    rightBound2 = objPosX2 + width2;
                                    if (minX < rightBound2 && maxX > leftBound2 || minX > leftBound2 && maxX < rightBound2 || minX < leftBound2 && maxX > leftBound2 || minX < rightBound2 && maxX > rightBound2) {
                                        return curPosY >= rightDisY && moveTo <= rightDisY ? curPosY - rightDisY : moveOffset;
                                    }
                                }
                            }
                            if (leftPosX == rightPosX || leftRoomData == -1 || (width2 = (rWidth2 = 30 - (objPosX2 = Room.GetObstructionDistance(leftRoomData, 3))) - (lWidth2 = Room.GetObstructionDistance(leftRoomData, 2))) <= 0) continue;
                            leftBound2 = objPosX2 += leftPosX * 30;
                            rightBound2 = objPosX2 + width2;
                            if (!(minX < rightBound2 && maxX > leftBound2 || minX > leftBound2 && maxX < rightBound2 || minX < leftBound2 && maxX > leftBound2) && (minX >= rightBound2 || maxX <= rightBound2)) continue;
                            return curPosY >= leftDisY && moveTo <= leftDisY ? curPosY - leftDisY : moveOffset;
                        }
                    }
                    break;
                }
                case 1: {
                    int posY2;
                    int rightBound;
                    int leftBound;
                    int width;
                    int rWidth;
                    int lWidth;
                    int objPosX;
                    int minX = curPosX - widthOffset;
                    int maxX = curPosX + widthOffset;
                    int leftPosX = minX / 30;
                    int rightPosX = maxX / 30;
                    int posY1 = curPosY / 30;
                    int leftRoomData = Room.GetObjectId(leftPosX, posY1);
                    int rightRoomData = Room.GetObjectId(rightPosX, posY1);
                    int objPosY = posY1 * 30;
                    int leftDisY = objPosY + Room.GetObstructionDistance(leftRoomData, direct);
                    int rightDisY = objPosY + Room.GetObstructionDistance(rightRoomData, direct);
                    int moveTo = curPosY + moveOffset;
                    if (rightRoomData != -1) {
                        objPosX = Room.GetObstructionDistance(rightRoomData, 3);
                        lWidth = 30 - Room.GetObstructionDistance(rightRoomData, 2);
                        width = lWidth - (rWidth = objPosX);
                        if (width > 0) {
                            leftBound = objPosX += rightPosX * 30;
                            rightBound = objPosX + width;
                            if (minX < rightBound && maxX > leftBound || minX > leftBound && maxX < rightBound || minX < leftBound && maxX > leftBound || minX < rightBound && maxX > rightBound) {
                                if (moveTo >= rightDisY) {
                                    return rightDisY - curPosY - 1;
                                }
                                return moveOffset;
                            }
                        }
                    }
                    if (leftPosX != rightPosX && leftRoomData != -1 && (width = (rWidth = 30 - (objPosX = Room.GetObstructionDistance(leftRoomData, 3))) - (lWidth = Room.GetObstructionDistance(leftRoomData, 2))) > 0) {
                        leftBound = objPosX += leftPosX * 30;
                        rightBound = objPosX + width;
                        if (minX < rightBound && maxX > leftBound || minX > leftBound && maxX < rightBound || minX < leftBound && maxX > leftBound || minX < rightBound && maxX > rightBound) {
                            if (moveTo >= leftDisY) {
                                return leftDisY - curPosY - 1;
                            }
                            return moveOffset;
                        }
                    }
                    if (posY1 != (posY2 = moveTo / 30)) {
                        while (++posY1 <= posY2) {
                            int rightBound3;
                            int leftBound3;
                            int width3;
                            int rWidth3;
                            int lWidth3;
                            int objPosX3;
                            leftRoomData = Room.GetObjectId(leftPosX, posY1);
                            rightRoomData = Room.GetObjectId(rightPosX, posY1);
                            leftDisY = (objPosY += 30) + Room.GetObstructionDistance(leftRoomData, direct);
                            rightDisY = objPosY + Room.GetObstructionDistance(rightRoomData, direct);
                            if (rightRoomData != -1) {
                                objPosX3 = Room.GetObstructionDistance(rightRoomData, 3);
                                lWidth3 = 30 - Room.GetObstructionDistance(rightRoomData, 2);
                                width3 = lWidth3 - (rWidth3 = objPosX3);
                                if (width3 > 0) {
                                    leftBound3 = objPosX3 += rightPosX * 30;
                                    rightBound3 = objPosX3 + width3;
                                    if (minX < rightBound3 && maxX > leftBound3 || minX > leftBound3 && maxX < rightBound3 || minX < leftBound3 && maxX > leftBound3 || minX < rightBound3 && maxX > rightBound3) {
                                        return moveTo >= rightDisY ? rightDisY - curPosY - 1 : moveOffset;
                                    }
                                }
                            }
                            if (leftPosX == rightPosX || leftRoomData == -1 || (width3 = (rWidth3 = 30 - (objPosX3 = Room.GetObstructionDistance(leftRoomData, 3))) - (lWidth3 = Room.GetObstructionDistance(leftRoomData, 2))) <= 0) continue;
                            leftBound3 = objPosX3 += leftPosX * 30;
                            rightBound3 = objPosX3 + width3;
                            if (!(minX < rightBound3 && maxX > leftBound3 || minX > leftBound3 && maxX < rightBound3 || minX < leftBound3 && maxX > leftBound3) && (minX >= rightBound3 || maxX <= rightBound3)) continue;
                            return moveTo >= leftDisY ? leftDisY - curPosY - 1 : moveOffset;
                        }
                    }
                    break;
                }
                case 2: {
                    int leftPosX2;
                    int downDisY2;
                    int upDisY2;
                    int objPosY2;
                    int minX = curPosX - widthOffset;
                    int leftPosX1 = minX / 30;
                    int posY = curPosY / 30;
                    int leftRoomData = Room.GetObjectId(leftPosX1, posY);
                    int objPosX = (leftPosX1 + 1) * 30;
                    int leftDisX = objPosX - Room.GetObstructionDistance(leftRoomData, direct);
                    int moveTo = minX - moveOffset;
                    if (leftRoomData != -1 && leftDisX <= minX) {
                        if (leftDisX >= moveTo) {
                            if (!Room.IsCornerWallId(leftRoomData)) {
                                int downDisY2;
                                int upDisY2;
                                int objPosY2 = posY * 30;
                                int objDis = Room.GetObstructionDistance(leftRoomData, 0);
                                if (objDis < 30 && curPosY > (upDisY2 = objPosY2 + 30 - objDis)) {
                                    return moveOffset;
                                }
                                objDis = Room.GetObstructionDistance(leftRoomData, 1);
                                if (objDis < 30 && curPosY < (downDisY2 = objPosY2 + Room.GetObstructionDistance(leftRoomData, 1))) {
                                    return moveOffset;
                                }
                            }
                            return minX - leftDisX;
                        }
                        objPosY2 = posY * 30;
                        upDisY2 = objPosY2 + 30 - Room.GetObstructionDistance(leftRoomData, 0);
                        downDisY2 = objPosY2 + Room.GetObstructionDistance(leftRoomData, 1);
                        if (curPosY < upDisY2 && curPosY > downDisY2) {
                            return minX - leftDisX > moveOffset ? moveOffset : minX - leftDisX;
                        }
                    }
                    if (leftPosX1 != (leftPosX2 = moveTo / 30)) {
                        while (--leftPosX1 >= leftPosX2) {
                            leftRoomData = Room.GetObjectId(leftPosX1, posY);
                            leftDisX = (objPosX -= 30) - Room.GetObstructionDistance(leftRoomData, direct);
                            if (leftRoomData == -1 || leftDisX > minX) continue;
                            if (leftDisX >= moveTo) {
                                if (!Room.IsCornerWallId(leftRoomData)) {
                                    objPosY2 = posY * 30;
                                    int objDis = Room.GetObstructionDistance(leftRoomData, 0);
                                    if (objDis < 30 && curPosY > (upDisY2 = objPosY2 + 30 - objDis)) {
                                        return moveOffset;
                                    }
                                    objDis = Room.GetObstructionDistance(leftRoomData, 1);
                                    if (objDis < 30 && curPosY < (downDisY2 = objPosY2 + Room.GetObstructionDistance(leftRoomData, 1))) {
                                        return moveOffset;
                                    }
                                }
                                return minX - leftDisX;
                            }
                            objPosY2 = posY * 30;
                            upDisY2 = objPosY2 + 30 - Room.GetObstructionDistance(leftRoomData, 0);
                            downDisY2 = objPosY2 + Room.GetObstructionDistance(leftRoomData, 1);
                            if (curPosY >= upDisY2 || curPosY <= downDisY2) continue;
                            return minX - leftDisX > moveOffset ? moveOffset : minX - leftDisX;
                        }
                    }
                    break;
                }
                case 3: {
                    int rightPosX2;
                    int downDisY3;
                    int upDisY3;
                    int objPosY3;
                    int maxX = curPosX + widthOffset;
                    int rightPosX1 = maxX / 30;
                    int posY = curPosY / 30;
                    int rightRoomData = Room.GetObjectId(rightPosX1, posY);
                    int objPosX = rightPosX1 * 30;
                    int rightDisX = objPosX + Room.GetObstructionDistance(rightRoomData, direct);
                    int moveTo = maxX + moveOffset;
                    if (rightRoomData != -1 && rightDisX >= maxX) {
                        if (rightDisX <= moveTo) {
                            if (!Room.IsCornerWallId(rightRoomData)) {
                                int downDisY3;
                                int upDisY3;
                                int objPosY3 = posY * 30;
                                int objDis = Room.GetObstructionDistance(rightRoomData, 0);
                                if (objDis < 30 && curPosY > (upDisY3 = objPosY3 + 30 - objDis)) {
                                    return moveOffset;
                                }
                                objDis = Room.GetObstructionDistance(rightRoomData, 1);
                                if (objDis < 30 && curPosY < (downDisY3 = objPosY3 + Room.GetObstructionDistance(rightRoomData, 1))) {
                                    return moveOffset;
                                }
                            }
                            return rightDisX - maxX - 1;
                        }
                        objPosY3 = posY * 30;
                        upDisY3 = objPosY3 + 30 - Room.GetObstructionDistance(rightRoomData, 0);
                        downDisY3 = objPosY3 + Room.GetObstructionDistance(rightRoomData, 1);
                        if (curPosY < upDisY3 && curPosY > downDisY3) {
                            return rightDisX - maxX - 1 > moveOffset ? moveOffset : rightDisX - maxX - 1;
                        }
                    }
                    if (rightPosX1 == (rightPosX2 = moveTo / 30)) break;
                    while (++rightPosX1 <= rightPosX2) {
                        rightRoomData = Room.GetObjectId(rightPosX1, posY);
                        rightDisX = (objPosX += 30) + Room.GetObstructionDistance(rightRoomData, direct);
                        if (rightRoomData == -1 || rightDisX < maxX) continue;
                        if (rightDisX <= moveTo) {
                            if (!Room.IsCornerWallId(rightRoomData)) {
                                objPosY3 = posY * 30;
                                int objDis = Room.GetObstructionDistance(rightRoomData, 0);
                                if (objDis < 30 && curPosY > (upDisY3 = objPosY3 + 30 - objDis)) {
                                    return moveOffset;
                                }
                                objDis = Room.GetObstructionDistance(rightRoomData, 1);
                                if (objDis < 30 && curPosY < (downDisY3 = objPosY3 + Room.GetObstructionDistance(rightRoomData, 1))) {
                                    return moveOffset;
                                }
                            }
                            return rightDisX - maxX - 1;
                        }
                        objPosY3 = posY * 30;
                        upDisY3 = objPosY3 + 30 - Room.GetObstructionDistance(rightRoomData, 0);
                        downDisY3 = objPosY3 + Room.GetObstructionDistance(rightRoomData, 1);
                        if (curPosY >= upDisY3 || curPosY <= downDisY3) continue;
                        return rightDisX - maxX - 1 > moveOffset ? moveOffset : rightDisX - maxX - 1;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return moveOffset;
    }

    public void Draw(Graphics g, int xOffset, int yOffset) {
        int width = this.curLoc.GetWidth();
        int height = this.curLoc.GetHeight();
        int posX = xOffset + this.curLoc.GetX();
        int posY = yOffset + this.curLoc.GetY();
        g.setClip(posX, posY, width, height);
        switch (this.GetType()) {
            case 30: {
                g.drawImage(weaponImg, posX - this.stage * 25 - 114, posY - 318, 20);
                break;
            }
            case 50: {
                switch (this.direction) {
                    case 0: {
                        g.drawImage(weaponImg, posX - 114, posY - 228, 20);
                        break;
                    }
                    case 1: {
                        g.drawImage(weaponImg, posX - 134, posY - 228, 20);
                        break;
                    }
                    case 2: {
                        g.drawImage(weaponImg, posX - 154, posY - 228, 20);
                        break;
                    }
                    case 3: {
                        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
                        dg.drawImage(weaponImg, posX - 16, posY - 228, 20, 8192);
                    }
                }
                break;
            }
            case 60: {
                g.drawImage(weaponImg, posX - this.stage * 20 - 114, posY - 248, 20);
            }
        }
        if (this.stage < 2) {
            ++this.stage;
        } else if (this.stage >= 2) {
            this.stage = this.GetType() == 60 ? 0 : --this.stage;
            this.canAttack = true;
        }
    }
}

