/*
 * Decompiled with CFR 0.152.
 */
package AfterDark;

import AfterDark.GameConstant;
import AfterDark.GameManager;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Room
implements GameConstant {
    private static int[][] roomData = null;
    private static int[][] floorData = null;
    private static int NUM_OBJ_X = 10;
    static Image sourceImg = null;
    private Image img = null;
    private int id = 0;
    private int width = 0;
    private int height = 0;
    private boolean loadOk = false;
    private Thread thread = null;

    public Room() {
        if (sourceImg == null) {
            try {
                sourceImg = Image.createImage((String)"/AfterDark/Images/Map/map01.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void Initial(int roomID, int[][] rData, int[][] fData) {
        this.id = roomID;
        this.width = rData.length;
        this.height = rData[0].length;
        roomData = rData;
        floorData = fData;
        this.CreateImage();
    }

    public static int GetObstructionDistance(int objId, int direct) {
        switch (objId) {
            case 20: 
            case 30: 
            case 50: 
            case 53: 
            case 55: 
            case 69: 
            case 74: 
            case 75: 
            case 83: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 105: 
            case 165: {
                if (direct != 1) break;
                return 17;
            }
            case 28: 
            case 29: 
            case 36: 
            case 138: 
            case 139: 
            case 146: {
                if (direct != 1) break;
                return 22;
            }
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 72: 
            case 80: 
            case 81: 
            case 97: 
            case 98: 
            case 190: {
                if (direct == 1) {
                    return 17;
                }
                if (direct == 2) {
                    return 5;
                }
                if (direct != 3) break;
                return 5;
            }
            case 64: {
                if (direct == 1) {
                    return 10;
                }
                if (direct == 2) {
                    return 5;
                }
                if (direct != 3) break;
                return 5;
            }
            case 66: 
            case 70: 
            case 86: 
            case 87: 
            case 88: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 176: 
            case 213: 
            case 214: {
                if (direct != 1) break;
                return 9;
            }
            case 77: 
            case 78: 
            case 187: 
            case 188: {
                if (direct != 1) break;
                return 2;
            }
            case 108: 
            case 109: {
                if (direct != 2) break;
                return 10;
            }
            case 218: 
            case 219: {
                if (direct != 3) break;
                return 10;
            }
            case 73: {
                if (direct == 1) {
                    return 9;
                }
                if (direct != 2) break;
                return 10;
            }
            case 183: {
                if (direct == 1) {
                    return 9;
                }
                if (direct != 3) break;
                return 10;
            }
            case 21: 
            case 31: {
                if (direct == 1) {
                    return 17;
                }
                if (direct != 3) break;
                return 23;
            }
            case 131: 
            case 141: {
                if (direct == 1) {
                    return 17;
                }
                if (direct != 2) break;
                return 23;
            }
            case 37: {
                if (direct == 1) {
                    return 22;
                }
                if (direct != 3) break;
                return 25;
            }
            case 147: {
                if (direct == 1) {
                    return 22;
                }
                if (direct != 2) break;
                return 25;
            }
            case 35: {
                if (direct != 3) break;
                return 25;
            }
            case 145: {
                if (direct != 2) break;
                return 25;
            }
            case 22: 
            case 24: 
            case 32: 
            case 34: 
            case 38: 
            case 39: 
            case 52: {
                if (direct != 3) break;
                return 23;
            }
            case 132: 
            case 134: 
            case 142: 
            case 144: 
            case 148: 
            case 149: 
            case 162: {
                if (direct != 2) break;
                return 23;
            }
            case 25: 
            case 26: {
                if (direct == 2) {
                    return 11;
                }
                if (direct != 3) break;
                return 11;
            }
            case 23: 
            case 33: {
                if (direct == 1) {
                    return 17;
                }
                if (direct != 3) break;
                return 23;
            }
            case 133: 
            case 143: {
                if (direct == 1) {
                    return 17;
                }
                if (direct != 2) break;
                return 23;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 65: 
            case 82: 
            case 106: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 159: 
            case 175: {
                break;
            }
            default: {
                return 60;
            }
        }
        return 0;
    }

    public static int GetRoomData(int i, int j) {
        try {
            return roomData[i][j];
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static void SetRoomData(int newId, int i, int j) {
        Room.roomData[i][j] = newId;
    }

    public static int GetFloorData(int i, int j) {
        try {
            return floorData[i][j];
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static void SetFloorData(int newId, int i, int j) {
        Room.floorData[i][j] = newId;
    }

    public static int GetObjectId(int posX, int posY) {
        if (Room.IsCannotWalkFloor(floorData[posX][posY])) {
            return floorData[posX][posY];
        }
        if (Room.IsWallId(floorData[posX][posY])) {
            return floorData[posX][posY];
        }
        if (roomData[posX][posY] != -1) {
            return roomData[posX][posY];
        }
        return -1;
    }

    public static void SetObjectId(int newId, int posX, int posY) {
        if (Room.IsCannotWalkFloor(floorData[posX][posY])) {
            Room.floorData[posX][posY] = newId;
        } else if (Room.IsWallId(floorData[posX][posY])) {
            Room.floorData[posX][posY] = newId;
        } else {
            Room.roomData[posX][posY] = newId;
        }
    }

    public static boolean IsCannotWalkFloor(int id) {
        if (id >= 11 && id <= 19) {
            return true;
        }
        if (id >= 121 && id <= 129) {
            return true;
        }
        return id == 36 || id == 37 || id == 147;
    }

    public static boolean IsWallId(int id) {
        if (id == 20 || id == 21 || id == 131) {
            return true;
        }
        if (id == 30 || id == 31 || id == 141) {
            return true;
        }
        if (id >= 40 && id <= 43) {
            return true;
        }
        if (id >= 150 && id <= 153) {
            return true;
        }
        return id == 55 || id == 165;
    }

    static final boolean IsCornerWallId(int id) {
        if (id == 21 || id == 131) {
            return true;
        }
        if (id == 31 || id == 141) {
            return true;
        }
        return id == 37 || id == 147;
    }

    static final boolean IsCloseDoorXId(int id) {
        return id == 52 || id == 162;
    }

    static final boolean IsCloseDoorYId(int id) {
        if (id == 50 || id == 160) {
            return true;
        }
        return id == 53 || id == 163;
    }

    static final boolean IsOpenDoorYId(int id) {
        if (id == 51 || id == 161) {
            return true;
        }
        return id == 54 || id == 164;
    }

    static final boolean IsCloseTreasureId(int id) {
        return id == 97 || id == 207;
    }

    static final boolean IsOpenTreasureId(int id) {
        return id == 98 || id == 208;
    }

    static final boolean IsExaminableId(int id) {
        return id == 56 || id == 59 || id == 61 || id == 62 || id == 63 || id == 67 || id == 68 || id == 69 || id == 71 || id == 72 || id == 74 || id == 76 || id == 80 || id == 81 || id == 83 || id == 87 || id == 91 || id == 92 || id == 93 || id == 95 || id == 97 || id == 98;
    }

    static final boolean IsLinkAreaId(int id) {
        if (id >= 110 && id <= 121) {
            return true;
        }
        return id == 8 || id == 9;
    }

    public int GetWidth() {
        return this.width;
    }

    public int GetHeight() {
        return this.height;
    }

    public void SetLoadMapOk(boolean ok) {
        this.loadOk = ok;
    }

    public boolean IsLoadOk() {
        return this.loadOk;
    }

    public void Draw(Graphics g, int xOffset, int yOffset) {
        g.setClip(0, 0, 176, 178);
        g.setColor(0);
        g.fillRect(0, 0, 176, 178);
        g.drawImage(this.img, xOffset, yOffset, 20);
    }

    public static void DrawObjData(Graphics g, int id, int xOffset, int yOffset) {
        g.setClip(xOffset, yOffset, 30, 30);
        if (id < 110) {
            int posY = id / NUM_OBJ_X;
            int posX = id - posY * NUM_OBJ_X;
            g.drawImage(sourceImg, xOffset - posX * 30, yOffset - posY * 30, 20);
        } else {
            int flipId = id - 110;
            int posY = flipId / NUM_OBJ_X;
            int posX = flipId - posY * NUM_OBJ_X + 1;
            DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
            dg.drawImage(sourceImg, xOffset - sourceImg.getWidth() + posX * 30, yOffset - posY * 30, 20, 8192);
        }
    }

    public void CreateImage() {
        this.loadOk = false;
        int posX = 0;
        int posY = 0;
        this.img = Image.createImage((int)(30 * this.width), (int)(30 * this.height));
        Graphics g = this.img.getGraphics();
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        g.setClip(0, 0, this.img.getWidth(), this.img.getHeight());
        g.setColor(0);
        g.fillRect(0, 0, this.img.getWidth(), this.img.getHeight());
        int x = 0;
        int y = 0;
        int flipId = 0;
        int mapImgWidth = sourceImg.getWidth();
        boolean increaseY = false;
        int i = 0;
        while (i < floorData.length) {
            x = i * 30;
            int j = 0;
            while (j < floorData[0].length) {
                increaseY = false;
                if (floorData[i][j] != -1) {
                    y = j * 30;
                    increaseY = true;
                    if (floorData[i][j] < 110) {
                        posY = floorData[i][j] / NUM_OBJ_X;
                        posX = floorData[i][j] - posY * NUM_OBJ_X;
                        g.setClip(x, y, 30, 30);
                        g.drawImage(sourceImg, x - posX * 30, y - posY * 30, 20);
                    } else if (!GameManager.drawStupidLoop) {
                        flipId = floorData[i][j] - 110;
                        posY = flipId / NUM_OBJ_X;
                        posX = flipId - posY * NUM_OBJ_X + 1;
                        g.setClip(x, y, 30, 30);
                        dg.drawImage(sourceImg, x - mapImgWidth + posX * 30, y - posY * 30, 20, 8192);
                    }
                }
                if (!(roomData[i][j] == -1 || Room.IsCloseTreasureId(roomData[i][j]) || Room.IsOpenTreasureId(roomData[i][j]) || Room.IsCloseDoorXId(roomData[i][j]) || Room.IsCloseDoorYId(roomData[i][j]) || Room.IsOpenDoorYId(roomData[i][j]))) {
                    if (!increaseY) {
                        y = j * 30;
                    }
                    if (roomData[i][j] < 110) {
                        posY = roomData[i][j] / NUM_OBJ_X;
                        posX = roomData[i][j] - posY * NUM_OBJ_X;
                        g.setClip(x, y, 30, 30);
                        g.drawImage(sourceImg, x - posX * 30, y - posY * 30, 20);
                    } else if (!GameManager.drawStupidLoop) {
                        flipId = roomData[i][j] - 110;
                        posY = flipId / NUM_OBJ_X;
                        posX = flipId - posY * NUM_OBJ_X + 1;
                        g.setClip(x, y, 30, 30);
                        dg.drawImage(sourceImg, x - mapImgWidth + posX * 30, y - posY * 30, 20, 8192);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.loadOk = true;
    }
}

