/*
 * Decompiled with CFR 0.152.
 */
package com.auer.pLib.common_util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.rms.RecordStore;

public class RMS {
    public static final byte BOOLEAN = 0;
    public static final byte BYTE = 1;
    public static final byte CHAR = 2;
    public static final byte CHARS = 3;
    public static final byte UTF = 4;
    public static final byte SHORT = 5;
    public static final byte INT = 6;
    public static final byte LONG = 7;
    public static final byte FLOAT = 8;
    public static final byte DOUBLE = 9;
    private Vector writeRmsData = new Vector();
    private Vector readRmsData = new Vector();
    private Vector rmsDataType = new Vector();

    public void resetRmsVector() {
        this.writeRmsData.removeAllElements();
        this.rmsDataType.removeAllElements();
    }

    public Vector getDataTypeVct() {
        return this.rmsDataType;
    }

    public void add2RmsVector(Vector vct, boolean data) {
        vct.addElement(new Boolean(data));
    }

    public void add2RmsVector(Vector vct, byte data) {
        vct.addElement(new Byte(data));
    }

    public void add2RmsVector(Vector vct, char data) {
        vct.addElement(new Character(data));
    }

    public void add2RmsVector(Vector vct, char[] data) {
        vct.addElement(data);
    }

    public void add2RmsVector(Vector vct, String data) {
        vct.addElement(data);
    }

    public void add2RmsVector(Vector vct, short data) {
        vct.addElement(new Short(data));
    }

    public void add2RmsVector(Vector vct, int data) {
        vct.addElement(new Integer(data));
    }

    public void add2RmsVector(Vector vct, float data) {
        vct.addElement(new Float(data));
    }

    public void add2RmsVector(Vector vct, long data) {
        vct.addElement(new Long(data));
    }

    public void add2RmsVector(Vector vct, double data) {
        vct.addElement(new Double(data));
    }

    public void add2WriteRmsVector(boolean data) {
        this.writeRmsData.addElement(new Boolean(data));
        this.rmsDataType.addElement(new Byte(0));
    }

    public void add2WriteRmsVector(byte data) {
        this.writeRmsData.addElement(new Byte(data));
        this.rmsDataType.addElement(new Byte(1));
    }

    public void add2WriteRmsVector(char data) {
        this.writeRmsData.addElement(new Character(data));
        this.rmsDataType.addElement(new Byte(2));
    }

    public void add2WriteRmsVector(char[] data) {
        this.writeRmsData.addElement(data);
        this.rmsDataType.addElement(new Byte(3));
    }

    public void add2WriteRmsVector(String data) {
        this.writeRmsData.addElement(data);
        this.rmsDataType.addElement(new Byte(4));
    }

    public void add2WriteRmsVector(short data) {
        this.writeRmsData.addElement(new Short(data));
        this.rmsDataType.addElement(new Byte(5));
    }

    public void add2WriteRmsVector(int data) {
        this.writeRmsData.addElement(new Integer(data));
        this.rmsDataType.addElement(new Byte(6));
    }

    public void add2WriteRmsVector(long data) {
        this.writeRmsData.addElement(new Long(data));
        this.rmsDataType.addElement(new Byte(7));
    }

    public void add2WriteRmsVector(float data) {
        this.writeRmsData.addElement(new Float(data));
        this.rmsDataType.addElement(new Byte(8));
    }

    public void add2WriteRmsVector(double data) {
        this.writeRmsData.addElement(new Double(data));
        this.rmsDataType.addElement(new Byte(9));
    }

    public Vector getReadRmsVct() {
        return this.readRmsData;
    }

    public boolean getReadRmsVct(boolean data, int index) {
        return (Boolean)this.readRmsData.elementAt(index);
    }

    public byte getReadRmsVct(byte data, int index) {
        return (Byte)this.readRmsData.elementAt(index);
    }

    public char getReadRmsVct(char data, int index) {
        return ((Character)this.readRmsData.elementAt(index)).charValue();
    }

    public String getReadRmsVct(char[] data, int index) {
        return (String)this.readRmsData.elementAt(index);
    }

    public String getReadRmsVct(String data, int index) {
        return (String)this.readRmsData.elementAt(index);
    }

    public short getReadRmsVct(short data, int index) {
        return (Short)this.readRmsData.elementAt(index);
    }

    public int getReadRmsVct(int data, int index) {
        return (Integer)this.readRmsData.elementAt(index);
    }

    public long getReadRmsVct(long data, int index) {
        return (Long)this.readRmsData.elementAt(index);
    }

    public float getReadRmsVct(float data, int index) {
        return ((Float)this.readRmsData.elementAt(index)).floatValue();
    }

    public double getReadRmsVct(double data, int index) {
        return (Double)this.readRmsData.elementAt(index);
    }

    public boolean loadFromRMS(String RmsName, int recordNo) {
        byte[] data;
        RecordStore rs;
        block17: {
            if (this.rmsDataType == null || this.rmsDataType.size() == 0) {
                System.out.println("Loading RMS Failed !!");
                return false;
            }
            this.readRmsData.removeAllElements();
            rs = this.openRSAnyway(RmsName);
            data = rs.getRecord(recordNo);
            if (data != null) break block17;
            return false;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bis);
            int i = 0;
            while (i < this.rmsDataType.size()) {
                switch ((Byte)this.rmsDataType.elementAt(i)) {
                    case 0: {
                        this.add2RmsVector(this.readRmsData, dis.readBoolean());
                        break;
                    }
                    case 1: {
                        this.add2RmsVector(this.readRmsData, dis.readByte());
                        break;
                    }
                    case 2: {
                        this.add2RmsVector(this.readRmsData, dis.readChar());
                        break;
                    }
                    case 3: {
                        this.add2RmsVector(this.readRmsData, dis.readUTF());
                        break;
                    }
                    case 4: {
                        this.add2RmsVector(this.readRmsData, dis.readUTF());
                        break;
                    }
                    case 5: {
                        this.add2RmsVector(this.readRmsData, dis.readShort());
                        break;
                    }
                    case 6: {
                        this.add2RmsVector(this.readRmsData, dis.readInt());
                        break;
                    }
                    case 7: {
                        this.add2RmsVector(this.readRmsData, dis.readLong());
                        break;
                    }
                    case 8: {
                        this.add2RmsVector(this.readRmsData, dis.readFloat());
                        break;
                    }
                    case 9: {
                        this.add2RmsVector(this.readRmsData, dis.readDouble());
                    }
                }
                ++i;
            }
            data = null;
            dis.close();
            bis.close();
            rs.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Load RMS error ! ");
            return false;
        }
        return true;
    }

    public boolean store2RMS(String RmsName, int recordNo) {
        if (this.rmsDataType == null || this.rmsDataType.size() == 0 || this.writeRmsData == null || this.writeRmsData.size() == 0 || this.writeRmsData.size() != this.rmsDataType.size()) {
            System.out.println("Loading RMS Failed !!");
            return false;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            RecordStore rs = this.openRSAnyway(RmsName);
            int i = 0;
            while (i < this.rmsDataType.size()) {
                switch ((Byte)this.rmsDataType.elementAt(i)) {
                    case 0: {
                        dos.writeBoolean((Boolean)this.writeRmsData.elementAt(i));
                        break;
                    }
                    case 1: {
                        dos.writeByte(((Byte)this.writeRmsData.elementAt(i)).byteValue());
                        break;
                    }
                    case 2: {
                        dos.writeChar(((Character)this.writeRmsData.elementAt(i)).charValue());
                        break;
                    }
                    case 3: {
                        dos.writeChars((String)this.writeRmsData.elementAt(i));
                        break;
                    }
                    case 4: {
                        dos.writeUTF((String)this.writeRmsData.elementAt(i));
                        break;
                    }
                    case 5: {
                        dos.writeShort(((Short)this.writeRmsData.elementAt(i)).shortValue());
                        break;
                    }
                    case 6: {
                        dos.writeInt((Integer)this.writeRmsData.elementAt(i));
                        break;
                    }
                    case 7: {
                        dos.writeLong((Long)this.writeRmsData.elementAt(i));
                        break;
                    }
                    case 8: {
                        dos.writeFloat(((Float)this.writeRmsData.elementAt(i)).floatValue());
                        break;
                    }
                    case 9: {
                        dos.writeDouble((Double)this.writeRmsData.elementAt(i));
                    }
                }
                ++i;
            }
            byte[] infoTemp = bos.toByteArray();
            if (rs.getNumRecords() <= 0) {
                int currentId = rs.addRecord(infoTemp, 0, infoTemp.length);
            } else {
                rs.setRecord(recordNo, infoTemp, 0, infoTemp.length);
            }
            infoTemp = null;
            dos.close();
            bos.close();
            rs.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Store error ! ");
            return false;
        }
        return true;
    }

    public boolean deleteRS(String RmsName) {
        if (RmsName.length() > 32) {
            return false;
        }
        try {
            RecordStore.deleteRecordStore((String)RmsName);
        }
        catch (Exception e) {
            System.err.println("-------delete Record Store error");
        }
        return true;
    }

    public RecordStore openRSAnyway(String RmsName) {
        RecordStore rs = null;
        if (RmsName.length() > 32) {
            return null;
        }
        try {
            rs = RecordStore.openRecordStore((String)RmsName, (boolean)true);
        }
        catch (Exception e) {
            System.err.println("Open RMS error !");
        }
        return rs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean findRS(String RmsName) {
        try {
            String[] RMS_Names = RecordStore.listRecordStores();
            if (RmsName == null) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= RMS_Names.length) {
                    return false;
                }
                if (RMS_Names[i].equals(RmsName)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
    }
}

