/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GGameData;
import game.GMain;
import game.GParam;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import role.RoleObj;

public class GInjectScreen {
    private Graphics g_Game = null;
    GGameData gD;
    private long frameDelay;
    private short inputDelay;
    private int keyPressedCode;
    private long startTime = 0L;
    private long stopTime = 0L;
    private boolean keyWaiting = false;
    private int keyInput;
    private boolean stopping = false;
    private Sprite screenFrame_Spr;
    private Sprite menuWord_Spr;
    private Sprite msg_Spr;
    private Sprite YN_Spr;
    private Sprite volFrame_Spr;
    private Sprite vol_Spr;
    private Sprite arrow_Spr;
    private short[] paintRecoverRange = new short[4];
    private short[][] YN_POS = new short[][]{{20, 30}, {48, 30}};
    private short selected = 0;
    public final short SEL_N;
    public final short SEL_Y;
    private short vol_Index = 0;
    private Vector stringTemp;
    private String[] msgArray;
    private short words_Of_Line = (short)26;
    private short start_Of_Line = 0;
    private short line_Of_Screen = (short)10;
    private short line_Height = (short)15;
    private short words_Width = 0;
    private short words_Height = 0;
    private byte arrowBlinkLimit = (byte)3;
    private byte arrowBlink = 0;
    private short[] text_color = new short[]{148, 97, 82};
    private short x;
    private short y;
    private boolean addCredit = false;
    private boolean addSkillCount = false;
    private final byte[] addCredit_Command = new byte[]{8, 8, 2, 2, 4, 6, 4, 6, 2, 8};
    private final byte[] addSkill_Command = new byte[]{4, 6, 4, 6, 4, 4, 4, 2, 8};
    private byte addCreditIndex = 0;
    private byte addSkillIndex = 0;
    private byte commandCode = 0;
    private boolean inject_Occur = false;
    private short gameFlow = 0;
    public final short GF_MENU;
    public final short GF_SHOW_MSG = (short)2;
    public final short GF_YN = (short)3;
    public final short GF_OPTION = (short)4;
    private short inject_Kinds = 0;
    public final short SOUND_ON;
    public final short EXIT_GAME = (short)2;
    public final short CONTINUE_GAME = (short)3;
    public final short SOUND_SET = (short)4;
    public final short NOTIFY_MSG = (short)5;
    private Font thisFont;

    public GInjectScreen(Graphics g, GGameData gData) {
        this.SEL_N = 0;
        this.SEL_Y = 1;
        this.GF_MENU = 1;
        this.SOUND_ON = 1;
        this.g_Game = g;
        this.gD = gData;
        this.thisFont = Font.getFont((int)0, (int)0, (int)8);
        this.g_Game.setFont(this.thisFont);
        this.stringTemp = new Vector();
        this.preload();
    }

    private void preload() {
        try {
            Image tempImg = Image.createImage((String)"/images/injectFrame.png");
            this.screenFrame_Spr = new Sprite(tempImg, tempImg.getWidth(), tempImg.getHeight());
            tempImg = Image.createImage((String)"/images/sysmenu_w.png");
            this.menuWord_Spr = new Sprite(tempImg, tempImg.getWidth(), tempImg.getHeight() / 6);
            tempImg = Image.createImage((String)"/images/msg.png");
            this.msg_Spr = new Sprite(tempImg, tempImg.getWidth(), tempImg.getHeight() / 2);
            tempImg = Image.createImage((String)"/images/yn2.png");
            this.YN_Spr = new Sprite(tempImg, tempImg.getWidth(), tempImg.getHeight() / 4);
            tempImg = Image.createImage((String)"/images/volume.png");
            this.volFrame_Spr = new Sprite(tempImg, tempImg.getWidth(), tempImg.getHeight());
            tempImg = Image.createImage((String)"/images/volume_mark.png");
            this.vol_Spr = new Sprite(tempImg, tempImg.getWidth() / 5, tempImg.getHeight());
            tempImg = Image.createImage((String)"/images/arrow_small.png");
            this.arrow_Spr = new Sprite(tempImg, tempImg.getWidth() / 2, tempImg.getHeight());
            System.gc();
        }
        catch (IOException e) {
            System.err.println("Failed loading images in InjectScreen");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initial() {
        if (this.x == -1 && this.y == -1) {
            if (this.inject_Kinds == 5) {
                this.x = (short)((this.gD.realCanvasWidth - this.words_Width) / 2);
                this.y = (short)((this.gD.realCanvasHeight - this.words_Height) / 2);
            } else {
                this.screenFrame_Spr.setPosition((this.gD.realCanvasWidth - this.screenFrame_Spr.getWidth()) / 2, (this.gD.realCanvasHeight - this.screenFrame_Spr.getHeight()) / 2);
            }
        } else {
            this.screenFrame_Spr.setPosition((int)this.x, (int)this.y);
        }
        switch (this.gameFlow) {
            case 1: {
                this.selected = 0;
                this.addCreditIndex = 0;
                this.addSkillIndex = 0;
                this.g_Game.setClip(this.screenFrame_Spr.getX(), this.screenFrame_Spr.getY(), this.screenFrame_Spr.getWidth(), this.screenFrame_Spr.getHeight());
                break;
            }
            case 2: {
                this.g_Game.setClip((int)this.x, (int)this.y, (int)this.words_Width, (int)this.words_Height);
                this.g_Game.setColor(250, 250, 250);
                this.g_Game.fillRect(this.g_Game.getClipX(), this.g_Game.getClipY(), this.g_Game.getClipWidth(), this.g_Game.getClipHeight());
                this.g_Game.setColor((int)this.text_color[0], (int)this.text_color[1], (int)this.text_color[2]);
                int i = 0;
                while (i < 3) {
                    this.g_Game.drawRect(this.g_Game.getClipX() + 5 - i, this.g_Game.getClipY() + 5 - i, this.g_Game.getClipWidth() - 10 + i * 2, this.g_Game.getClipHeight() - 10 + i * 2);
                    ++i;
                }
                this.arrow_Spr.setPosition(this.x + this.words_Width - 15, this.y + 10);
                break;
            }
            case 3: {
                this.selected = 0;
                this.msg_Spr.setPosition(this.screenFrame_Spr.getX() + 8, this.screenFrame_Spr.getY() + 15);
                if (this.inject_Kinds == 1) {
                    this.msg_Spr.setFrame(0);
                } else if (this.inject_Kinds == 2) {
                    this.msg_Spr.setFrame(1);
                }
                this.g_Game.setClip(this.screenFrame_Spr.getX(), this.screenFrame_Spr.getY(), this.screenFrame_Spr.getWidth(), this.screenFrame_Spr.getHeight());
                break;
            }
            case 4: {
                if (this.inject_Kinds == 4) {
                    this.volFrame_Spr.setPosition(this.screenFrame_Spr.getX() + 9, this.screenFrame_Spr.getY() + 12);
                    this.vol_Index = (short)(this.gD.volume / 20);
                }
                this.g_Game.setClip(this.screenFrame_Spr.getX(), this.screenFrame_Spr.getY(), this.screenFrame_Spr.getWidth(), this.screenFrame_Spr.getHeight());
            }
        }
    }

    public boolean keyProc(int keyState, int pressKeyCode) {
        switch (this.gameFlow) {
            case 1: {
                this.keyProc_Menu(keyState, pressKeyCode);
                break;
            }
            case 2: {
                this.keyProc_ShowMsg(keyState, pressKeyCode);
                break;
            }
            case 3: {
                this.keyProc_YN(keyState, pressKeyCode);
                break;
            }
            case 4: {
                this.keyProc_Option(keyState, pressKeyCode);
            }
        }
        return false;
    }

    private void keyProc_Menu(int keyState, int pressKeyCode) {
        this.commandCode = 0;
        if ((keyState & 2) != 0) {
            this.selected = (short)(this.selected - 1);
            if (this.selected < 0) {
                this.selected = (short)2;
            }
            this.commandCode = (byte)8;
        } else if ((keyState & 0x40) != 0) {
            this.selected = (short)(this.selected + 1);
            if (this.selected > 2) {
                this.selected = 0;
            }
            this.commandCode = (byte)2;
        } else if ((keyState & 4) != 0) {
            this.commandCode = (byte)4;
        } else if ((keyState & 0x20) != 0) {
            this.commandCode = (byte)6;
        } else if ((keyState & 0x100) != 0) {
            if (this.selected == 0) {
                this.fire_press();
            } else if (this.selected == 1) {
                this.gameFlow = (short)4;
                this.inject_Kinds = (short)4;
                this.initial();
            } else if (this.selected == 2) {
                this.gameFlow = (short)3;
                this.inject_Kinds = (short)2;
                this.initial();
            }
        } else if (pressKeyCode != GParam.RightSoftKey) {
            // empty if block
        }
        if (this.commandCode > 0) {
            this.addCreditIndex = this.addCredit_Command[this.addCreditIndex] == this.commandCode ? (byte)(this.addCreditIndex + 1) : (byte)0;
            this.addSkillIndex = this.addSkill_Command[this.addSkillIndex] == this.commandCode ? (byte)(this.addSkillIndex + 1) : (byte)0;
            if (this.addCreditIndex == this.addCredit_Command.length) {
                this.addCredit = true;
                this.addCreditIndex = 0;
            }
            if (this.addSkillIndex == this.addSkill_Command.length) {
                this.addSkillCount = true;
                this.addSkillIndex = 0;
            }
        }
    }

    private void keyProc_ShowMsg(int keyState, int pressKeyCode) {
        if ((keyState & 2) != 0) {
            this.start_Of_Line = (short)(this.start_Of_Line - 1);
            if (this.start_Of_Line < 0) {
                this.start_Of_Line = 0;
            }
        } else if ((keyState & 0x40) != 0) {
            this.start_Of_Line = (short)(this.start_Of_Line + 1);
            if (this.start_Of_Line + this.line_Of_Screen > this.msgArray.length) {
                this.start_Of_Line = (short)(this.start_Of_Line - 1);
            }
        } else if ((keyState & 4) == 0 && (keyState & 0x20) == 0) {
            if ((keyState & 0x100) != 0) {
                this.fire_press();
            } else if (pressKeyCode == GParam.RightSoftKey) {
                this.fire_press();
            }
        }
    }

    private void keyProc_YN(int keyState, int pressKeyCode) {
        if ((keyState & 2) == 0 && (keyState & 0x40) == 0) {
            if ((keyState & 4) != 0) {
                this.selected = (short)(this.selected + 1);
                if (this.selected > 1) {
                    this.selected = 0;
                }
            } else if ((keyState & 0x20) != 0) {
                this.selected = (short)(this.selected - 1);
                if (this.selected < 0) {
                    this.selected = 1;
                }
            } else if ((keyState & 0x100) != 0) {
                if (this.inject_Kinds == 1) {
                    this.gD.volume = this.selected == 0 ? (short)0 : (short)40;
                    GMain.callback(11);
                }
                this.fire_press();
            } else if (pressKeyCode == GParam.RightSoftKey) {
                this.selected = 0;
                this.fire_press();
            } else if (pressKeyCode == GParam.LeftSoftKey) {
                this.selected = 1;
                this.fire_press();
            }
        }
    }

    private void keyProc_Option(int keyState, int pressKeyCode) {
        if ((keyState & 2) == 0 && (keyState & 0x40) == 0) {
            if ((keyState & 4) != 0) {
                this.vol_Index = (short)(this.vol_Index - 1);
                if (this.vol_Index < 0) {
                    this.vol_Index = 0;
                }
                this.gD.volume = (short)(this.vol_Index * 20);
                GMain.callback(11);
            } else if ((keyState & 0x20) != 0) {
                this.vol_Index = (short)(this.vol_Index + 1);
                if (this.vol_Index > 5) {
                    this.vol_Index = (short)5;
                }
                this.gD.volume = (short)(this.vol_Index * 20);
                GMain.callback(11);
            } else if ((keyState & 0x100) != 0) {
                this.gD.volume = (short)(this.vol_Index * 20);
                if (this.inject_Kinds == 4) {
                    GMain.callback(11);
                }
                this.fire_press();
            } else if (pressKeyCode == GParam.RightSoftKey) {
                this.fire_press();
            }
        }
    }

    private void fire_press() {
        this.inject_Occur = false;
        this.g_Game.setClip((int)this.paintRecoverRange[0], (int)this.paintRecoverRange[1], (int)this.paintRecoverRange[2], (int)this.paintRecoverRange[3]);
    }

    public boolean gameProc(int switching) {
        switch (this.gameFlow) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        return false;
    }

    public boolean paintScr(Graphics g) {
        this.screenFrame_Spr.paint(g);
        switch (this.gameFlow) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.msg_Spr.paint(g);
                this.paintYN_Button(g);
                break;
            }
        }
        GMain.flushGraphic();
        return false;
    }

    public boolean paintScrCenter(Graphics g) {
        switch (this.gameFlow) {
            case 1: {
                this.screenFrame_Spr.paint(g);
                this.paint_Menu(g);
                break;
            }
            case 2: {
                this.paint_Msg(g);
                break;
            }
            case 3: {
                this.screenFrame_Spr.paint(g);
                this.msg_Spr.paint(g);
                this.paintYN_Button(g);
                break;
            }
            case 4: {
                this.screenFrame_Spr.paint(g);
                this.volFrame_Spr.paint(g);
                if (this.vol_Index <= 0) break;
                int i = 0;
                while (i < this.vol_Index) {
                    this.vol_Spr.setPosition(this.volFrame_Spr.getX() + (this.vol_Spr.getWidth() + 3) * i + 24, this.volFrame_Spr.getY() + 19);
                    this.vol_Spr.setFrame(i);
                    this.vol_Spr.paint(g);
                    ++i;
                }
                break;
            }
        }
        GMain.flushGraphic();
        return false;
    }

    private void paintYN_Button(Graphics g) {
        this.YN_Spr.setPosition(this.screenFrame_Spr.getX() + this.YN_POS[0][0], this.screenFrame_Spr.getY() + this.YN_POS[0][1]);
        if (this.selected == 0) {
            this.YN_Spr.setFrame(0);
        } else {
            this.YN_Spr.setFrame(2);
        }
        this.YN_Spr.paint(g);
        this.YN_Spr.setPosition(this.screenFrame_Spr.getX() + this.YN_POS[1][0], this.screenFrame_Spr.getY() + this.YN_POS[1][1]);
        if (this.selected == 0) {
            this.YN_Spr.setFrame(3);
        } else {
            this.YN_Spr.setFrame(1);
        }
        this.YN_Spr.paint(g);
    }

    private void paint_Menu(Graphics g) {
        int i = 0;
        while (i < 3) {
            this.menuWord_Spr.setPosition(this.screenFrame_Spr.getX() + 15, this.screenFrame_Spr.getY() + 12 + i * this.menuWord_Spr.getHeight());
            if (this.selected == i) {
                this.menuWord_Spr.setFrame(i + 3);
            } else {
                this.menuWord_Spr.setFrame(i);
            }
            this.menuWord_Spr.paint(g);
            ++i;
        }
    }

    private void paint_Msg(Graphics g) {
        this.g_Game.setColor(250, 250, 250);
        this.g_Game.fillRect(this.g_Game.getClipX() + 5, this.g_Game.getClipY() + 5, this.g_Game.getClipWidth() - 10, this.g_Game.getClipHeight() - 10);
        this.g_Game.setColor((int)this.text_color[0], (int)this.text_color[1], (int)this.text_color[2]);
        int i = 0;
        while (i < this.line_Of_Screen) {
            if (this.start_Of_Line + i >= 0 && this.start_Of_Line + i < this.msgArray.length) {
                g.drawString(this.msgArray[this.start_Of_Line + i], this.g_Game.getClipX() + 7, this.g_Game.getClipY() + 10 + i * this.line_Height, 20);
            }
            ++i;
        }
        byte by = this.arrowBlink;
        this.arrowBlink = (byte)(by + 1);
        if (by >= this.arrowBlinkLimit) {
            if (this.start_Of_Line > 0) {
                this.arrow_Spr.setPosition(this.arrow_Spr.getX(), this.g_Game.getClipY() + 10);
                this.arrow_Spr.setFrame(0);
                this.arrow_Spr.paint(g);
            }
            if (this.start_Of_Line + this.line_Of_Screen <= this.msgArray.length - 1) {
                this.arrow_Spr.setPosition(this.arrow_Spr.getX(), this.g_Game.getClipY() + this.g_Game.getClipHeight() - 15);
                this.arrow_Spr.setFrame(1);
                this.arrow_Spr.paint(g);
            }
            if (this.arrowBlink >= this.arrowBlinkLimit * 2) {
                this.arrowBlink = 0;
            }
        }
    }

    public void stop() {
    }

    public void setParamAndOccur(short flow, short code, int x, int y, int rx, int ry, int rw, int rh) {
        this.gameFlow = flow;
        this.inject_Kinds = code;
        this.x = (short)x;
        this.y = (short)y;
        this.paintRecoverRange[0] = (short)rx;
        this.paintRecoverRange[1] = (short)ry;
        this.paintRecoverRange[2] = (short)rw;
        this.paintRecoverRange[3] = (short)rh;
        this.inject_Occur = true;
        this.initial();
    }

    public void setMsg(String msg, int width, int height) {
        if (msg == null) {
            return;
        }
        String strCopy = new String(msg);
        this.words_Width = (short)width;
        this.words_Height = (short)height;
        this.start_Of_Line = 0;
        this.line_Height = (short)Font.getDefaultFont().getHeight();
        this.line_Of_Screen = (short)(this.words_Height / this.line_Height);
        this.line_Of_Screen = (short)(this.line_Of_Screen - 2);
        this.stringTemp.removeAllElements();
        int stringWidth = 0;
        int i = 0;
        while (i < strCopy.length()) {
            if ((stringWidth += Font.getDefaultFont().charWidth(strCopy.charAt(i))) >= width - Font.getDefaultFont().charWidth(strCopy.charAt(i))) {
                this.stringTemp.addElement(strCopy.substring(0, i));
                strCopy = strCopy.substring(i);
                stringWidth = 0;
                i = -1;
            }
            ++i;
        }
        if (strCopy.length() > 0) {
            this.stringTemp.addElement(strCopy);
        }
        String[] newStr = new String[this.stringTemp.size()];
        int i2 = 0;
        while (i2 < this.stringTemp.size()) {
            newStr[i2] = (String)this.stringTemp.elementAt(i2);
            ++i2;
        }
        this.stringTemp.removeAllElements();
        strCopy = null;
        this.msgArray = newStr;
    }

    public void setMsg(String[] msg, int width, int height) {
        if (msg == null) {
            return;
        }
        String[] strCopy = new String[msg.length];
        int i = 0;
        while (i < msg.length) {
            strCopy[i] = msg[i] == "" ? "" : new String(msg[i]);
            ++i;
        }
        this.words_Width = (short)width;
        this.words_Height = (short)height;
        this.start_Of_Line = 0;
        this.line_Height = (short)Font.getDefaultFont().getHeight();
        this.line_Of_Screen = (short)(this.words_Height / this.line_Height);
        this.line_Of_Screen = (short)(this.line_Of_Screen - 2);
        this.stringTemp.removeAllElements();
        int stringWidth = 0;
        int i2 = 0;
        while (i2 < strCopy.length) {
            stringWidth = 0;
            int j = 0;
            while (j < strCopy[i2].length()) {
                if ((stringWidth += Font.getDefaultFont().charWidth(strCopy[i2].charAt(j))) >= width + 30 - Font.getDefaultFont().charWidth(strCopy[i2].charAt(j))) {
                    this.stringTemp.addElement(strCopy[i2].substring(0, j));
                    strCopy[i2] = strCopy[i2].substring(j);
                    stringWidth = 0;
                    j = -1;
                }
                ++j;
            }
            if (strCopy[i2].length() > 0 || strCopy[i2] == "") {
                this.stringTemp.addElement(strCopy[i2]);
            }
            ++i2;
        }
        String[] newStr = new String[this.stringTemp.size()];
        int i3 = 0;
        while (i3 < this.stringTemp.size()) {
            newStr[i3] = (String)this.stringTemp.elementAt(i3);
            ++i3;
        }
        this.stringTemp.removeAllElements();
        strCopy = null;
        this.msgArray = newStr;
    }

    public int getInjectKinds() {
        return this.inject_Kinds;
    }

    public int getSelect() {
        return this.selected;
    }

    public boolean getInjectOccur() {
        return this.inject_Occur;
    }

    public void getSecretCommand(RoleObj role) {
        if (this.addCredit) {
            role.r_Credit = (byte)(role.r_Credit + 2);
            this.addCredit = false;
        }
        if (this.addSkillCount) {
            role.r_SkillCount = (byte)(role.r_SkillCount + 2);
            this.addSkillCount = false;
        }
    }
}

