/*
 * Decompiled with CFR 0.152.
 */
package map.m_event;

import game.GGameData;
import game.GParam;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import map.m_event.MapEvent;

public class StageSwitch
extends MapEvent {
    private GGameData gD;
    private Image gameScreen;
    private Sprite alphaBlackSpr;
    private Sprite markSpr;
    private byte type = 0;
    private byte fadeOut_Counter = 0;
    private byte gameflow = 0;
    private final byte START;
    private final byte START_WAR = (byte)2;
    private final byte END_WAR = (byte)3;
    private final byte FADE_OUT = (byte)4;

    public StageSwitch(DataInputStream dis) {
        this.START = 1;
        this.dataRead(dis);
    }

    public void dataRead(DataInputStream dis) {
        try {
            this.type = dis.readByte();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void keyProc(int keyState, int pressKeyCode) {
        if ((keyState & 2) != 0 || (keyState & 0x40) != 0 || (keyState & 4) != 0 || (keyState & 0x20) != 0 || (keyState & 0x100) != 0 || pressKeyCode != GParam.RightSoftKey) {
            // empty if block
        }
    }

    public void gameProc() {
        switch (this.gameflow) {
            case 1: {
                if (this.type == 0) {
                    this.gameflow = (byte)2;
                    break;
                }
                if (this.type != 1) break;
                this.gameflow = (byte)3;
                break;
            }
            case 2: {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.alphaBlackSpr = null;
                this.markSpr = null;
                this.stopping = true;
                break;
            }
            case 3: {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.gameflow = (byte)4;
            }
        }
    }

    public void gamePaint(Graphics g, int x, int y) {
        g.drawImage(this.gameScreen, x, y, 20);
        this.markSpr.paint(g);
        if (this.gameflow == 4) {
            int i = 0;
            while (i < this.fadeOut_Counter) {
                this.alphaBlackSpr.setPosition(x, y);
                this.alphaBlackSpr.paint(g);
                ++i;
            }
            this.fadeOut_Counter = (byte)(this.fadeOut_Counter + 1);
            if (this.fadeOut_Counter > 5) {
                this.alphaBlackSpr = null;
                this.markSpr = null;
                this.stopping = true;
            }
        }
    }

    public void run(Image gameScr, GGameData gData) {
        this.gD = gData;
        this.gameScreen = gameScr;
        this.gameflow = 1;
        try {
            Image tempImg = Image.createImage((String)"/images/alpha_b.png");
            this.alphaBlackSpr = new Sprite(tempImg, tempImg.getWidth(), tempImg.getHeight());
            tempImg = Image.createImage((String)"/images/start_win.png");
            this.markSpr = new Sprite(tempImg, tempImg.getWidth() / 2, tempImg.getHeight());
            this.markSpr.setFrame((int)this.type);
            this.markSpr.setPosition(this.gD.X_Shift + (gameScr.getWidth() - this.markSpr.getWidth() >> 1), this.gD.Y_Shift + GParam.Map_Y_POS[1] + (160 - this.markSpr.getHeight() >> 1));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.deleteEvent = true;
    }
}

