/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public final class MusicPlayer {
    public static final byte MUSIC_NONE = 0;
    public static final byte MUSIC_PLAY = 1;
    public static final byte MUSIC_FIGHT = 2;
    public static final int MAX_SONGS = 10;
    public static Player m_musicPlayer = null;
    public static int m_currentMusic = 0;
    public static int soundSetting = 2;

    public static final void loadMusic(int n) {
        if (m_musicPlayer != null) {
            m_musicPlayer.deallocate();
            while (m_musicPlayer.getState() != 200) {
            }
            m_musicPlayer.close();
            while (m_musicPlayer.getState() != 0) {
            }
            System.gc();
        }
        String string = "";
        switch (n) {
            case 1: {
                string = "/sound/forest.mid";
                break;
            }
            case 2: {
                string = "/sound/fight.mid";
            }
        }
        try {
            InputStream inputStream = string.getClass().getResourceAsStream(string);
            m_musicPlayer = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
            m_musicPlayer.realize();
            while (m_musicPlayer.getState() != 200) {
            }
            m_musicPlayer.prefetch();
            while (m_musicPlayer.getState() != 300) {
            }
            if (n == 2) {
                m_musicPlayer.setLoopCount(-1);
            } else {
                m_musicPlayer.setLoopCount(0);
            }
            inputStream.close();
            inputStream = null;
            ((VolumeControl)m_musicPlayer.getControl("VolumeControl")).setLevel(soundSetting * 25);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void setSoundSetting(int n) {
        soundSetting = n;
        MusicPlayer.stopMusic();
    }

    public static final void playMusic(int n) {
        if (n != m_currentMusic) {
            if (m_musicPlayer != null && m_musicPlayer.getState() == 400) {
                MusicPlayer.stopMusic();
            }
            MusicPlayer.loadMusic(n);
            m_currentMusic = n;
        }
        if (m_musicPlayer.getState() == 400) {
            return;
        }
        try {
            ((VolumeControl)m_musicPlayer.getControl("VolumeControl")).setLevel(soundSetting * 25);
            m_musicPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void reLoadMusic() {
        if (m_musicPlayer == null) {
            return;
        }
        if (m_musicPlayer.getState() == 400) {
            MusicPlayer.stopMusic();
        }
        MusicPlayer.loadMusic(m_currentMusic);
    }

    public static final void stopMusic() {
        if (m_musicPlayer == null) {
            return;
        }
        if (m_musicPlayer.getState() != 400) {
            return;
        }
        try {
            m_musicPlayer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (m_musicPlayer.getState() != 300) {
        }
    }
}

