/*
 * Decompiled with CFR 0.152.
 */
package com.game5u.rpg;

import com.game5u.rpg.Plant;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    public Image imgTile;
    public int gridWH;
    public int viewportX;
    public int viewportY;
    public int mapRealWidth;
    public int mapRealHeight;
    public int viewportTileX;
    public int viewportTileY;
    public int mapHeight;
    public int mapWidth;
    public int[][] mapData;
    public int seeLong = 40;
    public int currentNo;
    public String mapName = "NoName";
    public Image bufferImg;
    public Graphics buffer_g;
    public int screenWidth;
    public int screenHeight_map;
    public int viewportTileWidth;
    public int viewportTileHeight;

    public final void saveMap() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.currentNo);
        dataOutputStream.writeInt(this.viewportX);
        dataOutputStream.writeInt(this.viewportY);
        dataOutputStream.writeInt(GameSystem.hero.getCellx());
        dataOutputStream.writeInt(GameSystem.hero.getCelly());
        dataOutputStream.writeInt(GameSystem.hero.dec);
        Tool.rwDOC(false, byteArrayOutputStream.toByteArray(), "map");
    }

    public final void restoreMap() throws Exception {
        byte[] byArray = Tool.rwDOC(true, null, "map");
        if (byArray == null) {
            throw new Exception();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        GameSystem.instance.loadValue = new int[]{n, n2, n3, dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt()};
    }

    public final void initMapData() {
        this.viewportX = 0;
        this.viewportY = 0;
        this.mapRealWidth = this.mapWidth << 4;
        this.mapRealHeight = this.mapHeight << 4;
        this.gridWH = 16;
        this.screenWidth = GameSystem.instance.screenWidth;
        this.screenHeight_map = GameSystem.instance.screenHeight + 15 >> 4 << 4;
        if (this.bufferImg == null) {
            this.bufferImg = Image.createImage((int)(this.screenWidth + this.gridWH), (int)(this.screenHeight_map + this.gridWH));
            this.buffer_g = this.bufferImg.getGraphics();
        }
        this.adjustViewport();
    }

    public final void loadMap(int n) {
        this.currentNo = n;
        try {
            int n2;
            DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/map/" + n + ".map"));
            short s = dataInputStream.readShort();
            if (s < 0) {
                this.mapName = Tool.readString(dataInputStream);
                String string = Tool.readString(dataInputStream);
                this.imgTile = Tool.getImage("/map/" + string);
            }
            this.mapWidth = dataInputStream.readShort();
            this.mapHeight = dataInputStream.readShort();
            this.gridWH = dataInputStream.readByte();
            this.gridWH = dataInputStream.readByte();
            this.mapData = new int[this.mapHeight][this.mapWidth];
            int n3 = 0;
            while (n3 < this.mapHeight) {
                n2 = 0;
                while (n2 < this.mapWidth) {
                    this.mapData[n3][n2] = dataInputStream.readInt();
                    ++n2;
                }
                ++n3;
            }
            n3 = dataInputStream.readByte();
            n2 = 0;
            while (n2 < n3) {
                byte by = dataInputStream.readByte();
                byte by2 = dataInputStream.readByte();
                short s2 = dataInputStream.readShort();
                short s3 = dataInputStream.readShort();
                Plant.addCell(by, s2, s3, by2);
                ++n2;
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        this.initMapData();
    }

    public final void drawBasicLayer1(Graphics graphics, int n) {
        if (this.viewportX < 0) {
            this.viewportX = 0;
        }
        if (this.viewportY < 0) {
            this.viewportY = 0;
        }
        if (this.viewportX > this.mapRealWidth - GameSystem.instance.screenWidth) {
            this.viewportX = this.mapRealWidth - GameSystem.instance.screenWidth;
        }
        if (this.viewportY > this.mapRealHeight - GameSystem.instance.screenHeight) {
            this.viewportY = this.mapRealHeight - GameSystem.instance.screenHeight;
        }
        int n2 = this.viewportX >> 4;
        int n3 = this.viewportY >> 4;
        int n4 = n2 + (GameSystem.instance.screenWidth >> 4) + 1;
        int n5 = n3 + (GameSystem.instance.screenHeight >> 4) + 1;
        int n6 = n3;
        while (n6 < n5 && n6 < this.mapHeight) {
            int n7 = n2;
            while (n7 < n4 && n7 < this.mapWidth) {
                int n8 = this.mapData[n6][n7];
                if (n8 != 0) {
                    int n9 = (n7 << 4) - this.viewportX;
                    int n10 = (n6 << 4) - this.viewportY;
                    int n11 = ((n8 & 0xFF00) >> 8) - 1;
                    int n12 = (n8 & 0xF00000) >> 20;
                    if (n11 > -1) {
                        Tool.drawPartImg(graphics, this.imgTile, n9, n10, n11 << 4, 0, 16, 16, n12);
                    }
                }
                ++n7;
            }
            ++n6;
        }
    }

    public final synchronized void drawBasicLayer(Graphics graphics) {
        boolean bl;
        if (this.viewportX < 0) {
            this.viewportX = 0;
        }
        if (this.viewportY < 0) {
            this.viewportY = 0;
        }
        if (this.viewportX > this.mapRealWidth - this.screenWidth) {
            this.viewportX = this.mapRealWidth - this.screenWidth;
        }
        if (this.viewportY > this.mapRealHeight - this.screenHeight_map) {
            this.viewportY = this.mapRealHeight - this.screenHeight_map;
        }
        int n = this.viewportX >> 4;
        int n2 = this.viewportY >> 4;
        int n3 = this.viewportX + this.screenWidth >> 4;
        int n4 = this.viewportY + this.screenHeight_map >> 4;
        if (n != this.viewportTileX || n3 != this.viewportTileWidth) {
            if (n3 > this.viewportTileWidth) {
                this.drawSurface(this.viewportTileWidth + 1, n2, n3, n4);
            } else if (n < this.viewportTileX) {
                this.drawSurface(n, n2, this.viewportTileX - 1, n4);
            }
            this.viewportTileX = n;
            this.viewportTileWidth = n3;
        }
        if (n2 != this.viewportTileY || n4 != this.viewportTileHeight) {
            if (n4 > this.viewportTileHeight) {
                this.drawSurface(n, this.viewportTileHeight + 1, n3, n4);
            } else if (n2 < this.viewportTileY) {
                this.drawSurface(n, n2, n3, this.viewportTileY - 1);
            }
            this.viewportTileY = n2;
            this.viewportTileHeight = n4;
        }
        int n5 = this.bufferImg.getWidth();
        int n6 = this.bufferImg.getHeight();
        int n7 = this.viewportX % n5;
        int n8 = this.viewportY % n6;
        int n9 = (this.viewportX + this.screenWidth) % n5;
        int n10 = (this.viewportY + this.screenHeight_map) % n6;
        boolean bl2 = n7 <= n9;
        boolean bl3 = bl = n8 <= n10;
        if (bl2 && bl) {
            this.drawBufferToScreen(graphics, n7, n8, this.screenWidth, this.screenHeight_map, 0, 0);
            return;
        }
        if (bl) {
            int n11 = n5 - n7;
            this.drawBufferToScreen(graphics, n7, n8, n11, this.screenHeight_map, 0, 0);
            this.drawBufferToScreen(graphics, 0, n8, n9, this.screenHeight_map, n11, 0);
            return;
        }
        if (bl2) {
            int n12 = n6 - n8;
            this.drawBufferToScreen(graphics, n7, n8, this.screenWidth, n12, 0, 0);
            this.drawBufferToScreen(graphics, n7, 0, this.screenWidth, n10, 0, n12);
            return;
        }
        int n13 = n5 - n7;
        int n14 = n6 - n8;
        this.drawBufferToScreen(graphics, n7, n8, n13, n14, 0, 0);
        this.drawBufferToScreen(graphics, 0, n8, n9, n14, n13, 0);
        this.drawBufferToScreen(graphics, n7, 0, n13, n10, 0, n14);
        this.drawBufferToScreen(graphics, 0, 0, n9, n10, n13, n14);
    }

    public final void drawBufferToScreen(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setClip(n5, n6, n3, n4);
        graphics.drawImage(this.bufferImg, n5 - n, n6 - n2, 0);
    }

    public void ChangeScreenView() {
        switch (GameSystem.hero.dec) {
            case 0: {
                if (this.viewportY <= GameSystem.hero.posy - (GameSystem.instance.screenHeight - this.seeLong)) break;
                this.viewportY -= this.viewportY - (GameSystem.hero.posy - (GameSystem.instance.screenHeight - this.seeLong)) >> 2;
                return;
            }
            case 1: {
                if (this.viewportY >= GameSystem.hero.posy - this.seeLong) break;
                this.viewportY += GameSystem.hero.posy - this.seeLong - this.viewportY >> 2;
                return;
            }
            case 2: {
                if (this.viewportX <= GameSystem.hero.posx - (GameSystem.instance.screenWidth - this.seeLong)) break;
                this.viewportX -= this.viewportX - (GameSystem.hero.posx - (GameSystem.instance.screenWidth - this.seeLong)) >> 2;
                return;
            }
            case 3: {
                if (this.viewportX >= GameSystem.hero.posx - this.seeLong) break;
                this.viewportX += GameSystem.hero.posx - this.seeLong - this.viewportX >> 2;
            }
        }
    }

    public void changerView(int n, int n2) {
        this.viewportX = n << 4;
        this.viewportY = n2 << 4;
    }

    public final void adjustViewport() {
        if (this.viewportX < 0) {
            this.viewportX = 0;
        }
        if (this.viewportY < 0) {
            this.viewportY = 0;
        }
        if (this.viewportX > this.mapRealWidth - this.screenWidth) {
            this.viewportX = this.mapRealWidth - this.screenWidth;
        }
        if (this.viewportY > this.mapRealHeight - this.screenHeight_map) {
            this.viewportY = this.mapRealHeight - this.screenHeight_map;
        }
        this.viewportTileX = this.viewportX >> 4;
        this.viewportTileY = this.viewportY >> 4;
        this.viewportTileWidth = this.viewportX + this.screenWidth >> 4;
        this.viewportTileHeight = this.viewportY + this.screenHeight_map >> 4;
        this.drawSurface(this.viewportTileX, this.viewportTileY, this.viewportTileWidth, this.viewportTileHeight);
    }

    public final void drawSurface(int n, int n2, int n3, int n4) {
        int n5 = this.bufferImg.getWidth() >> 4;
        int n6 = this.bufferImg.getHeight() >> 4;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = n2;
        while (n11 <= n4 && n11 < this.mapHeight) {
            int n12 = n;
            while (n12 <= n3 && n12 < this.mapWidth) {
                n7 = this.mapData[n11][n12];
                if (n7 != 0) {
                    n8 = (n7 & 0xF0000) >> 16;
                    int n13 = (n7 & 0xFF) - 1;
                    if (n13 > -1) {
                        n9 = n12 % n5 << 4;
                        n10 = n11 % n6 << 4;
                        Tool.drawPartImg(this.buffer_g, this.imgTile, n9, n10, n13 << 4, 0, this.gridWH, this.gridWH, n8);
                    }
                }
                ++n12;
            }
            ++n11;
        }
    }
}

