/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public final class MediaControl {
    public static final byte MEDIA_SFX = 0;
    public static final byte MEDIA_BGM = 1;
    public static final byte MEDIA_VIB = 2;
    public static final byte MEDIA_LEVEL = 3;
    private static byte[] volumeLevel = new byte[]{0, 20, 40, 80, 100};
    public static byte[][] mediaData = new byte[][]{{2, 2, 0, 0}, {(byte)(volumeLevel.length - 1), (byte)(volumeLevel.length - 1), 1, 2}, {2, 2, 0, 0}};
    public static final byte FM_TONE = 0;
    public static final byte FM_MIDI = 1;
    public static final byte FM_WAVE = 2;
    private static final String[] mFormat = new String[]{"audio/x-tone-seq", "audio/midi", "audio/x-wav"};
    private static String rmsName = "media_state";
    private static Object volumeControl = null;

    public MediaControl() {
        MediaControl.readMediaState();
    }

    public static final void setLoop(Object sound, int t) {
        if (MediaControl.isSupportClass("javax.microedition.media.Player")) {
            ((Player)sound).setLoopCount(t);
        }
    }

    public final Object soundInitial(String sound_name, int format) {
        try {
            switch (format) {
                case 1: 
                case 2: {
                    if (!MediaControl.isSupportClass("javax.microedition.media.Player")) break;
                    return Manager.createPlayer((InputStream)"".getClass().getResourceAsStream(sound_name), (String)mFormat[format]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final Object soundInitial(InputStream dataStream, int format) {
        try {
            switch (format) {
                case 1: 
                case 2: {
                    if (!MediaControl.isSupportClass("javax.microedition.media.Player")) break;
                    return Manager.createPlayer((InputStream)dataStream, (String)mFormat[format]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final Object soundInitial(byte[] data, int format) {
        ByteArrayInputStream arrayIs = new ByteArrayInputStream(data);
        try {
            switch (format) {
                case 1: 
                case 2: {
                    if (!MediaControl.isSupportClass("javax.microedition.media.Player")) break;
                    return Manager.createPlayer((InputStream)arrayIs, (String)mFormat[format]);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public void soundPlay(Object player, int format, int mediaType, int times, int reset) {
        if (player != null) {
            try {
                if (mediaData[0][mediaType] != 0) {
                    switch (format) {
                        case 1: 
                        case 2: {
                            if (!MediaControl.isSupportClass("javax.microedition.media.Player")) break;
                            ((Player)player).prefetch();
                            if (((Player)player).getState() != 300) break;
                            ((Player)player).setLoopCount(times);
                            if (reset == 1) {
                                ((Player)player).setMediaTime(0L);
                            }
                            MediaControl.setVolume(player, volumeLevel[mediaData[0][mediaType]]);
                            ((Player)player).start();
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void setMute(int mediaType) {
        MediaControl.mediaData[0][mediaType] = 0;
    }

    public void setDefaultVolume(int mediaType) {
        MediaControl.mediaData[0][mediaType] = mediaData[2][mediaType];
    }

    public void soundStop(Object player, int format) {
        if (player != null) {
            try {
                switch (format) {
                    case 1: 
                    case 2: {
                        if (!MediaControl.isSupportClass("javax.microedition.media.Player")) break;
                        ((Player)player).stop();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final void setVolume(Object player, int level) {
        if (MediaControl.isSupportClass("javax.microedition.media.control.VolumeControl")) {
            volumeControl = ((Player)player).getControl("javax.microedition.media.control.VolumeControl");
            ((VolumeControl)volumeControl).setLevel(level);
        }
    }

    public static void soundClose(Object player, int format) {
        if (player != null) {
            switch (format) {
                case 1: 
                case 2: {
                    if (!MediaControl.isSupportClass("javax.microedition.media.Player")) break;
                    ((Player)player).deallocate();
                    ((Player)player).close();
                }
            }
            player = null;
        }
    }

    public static void writeMediaState() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            int recordNum = rs.getNumRecords();
            if (recordNum == 0) {
                rs.addRecord(mediaData[0], 0, 1);
            }
            RecordEnumeration recordEnu = rs.enumerateRecords(null, null, false);
            recordEnu.reset();
            rs.setRecord(recordEnu.nextRecordId(), mediaData[0], 0, mediaData[0].length);
            rs.closeRecordStore();
            recordEnu.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void readMediaState() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            RecordEnumeration recordEnu = rs.enumerateRecords(null, null, false);
            int recordNum = rs.getNumRecords();
            if (recordNum == 0) {
                rs.addRecord(mediaData[0], 0, mediaData[0].length);
            } else {
                recordEnu = rs.enumerateRecords(null, null, false);
                recordEnu.reset();
                rs.getRecord(recordEnu.nextRecordId(), mediaData[0], 0);
            }
            rs.closeRecordStore();
            recordEnu.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isSupportClass(String fullNameofClass) {
        try {
            if (Class.forName(fullNameofClass) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static byte mediaState(byte mediaType) {
        return mediaData[0][mediaType];
    }

    public static boolean isMediaOff(byte mediaType) {
        return mediaData[0][mediaType] == 0;
    }

    public static boolean isStoped(Object player) {
        try {
            if (MediaControl.isSupportClass("javax.microedition.media.Player")) {
                ((Player)player).prefetch();
                if (((Player)player).getState() == 300) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void mediaSwitch(byte mediaType, boolean increase) {
        if (increase) {
            byte[] byArray = mediaData[0];
            byte by = mediaType;
            byArray[by] = (byte)(byArray[by] + 1);
            if (byArray[by] > mediaData[1][mediaType]) {
                MediaControl.mediaData[0][mediaType] = mediaData[1][mediaType];
            }
        } else {
            byte[] byArray = mediaData[0];
            byte by = mediaType;
            byArray[by] = (byte)(byArray[by] - 1);
            if (byArray[by] < 0) {
                MediaControl.mediaData[0][mediaType] = 0;
            }
        }
    }

    public String getLevelName() {
        String[] s = new String[]{"\u521d\u7ea7", "\u4e2d\u7ea7", "\u9ad8\u7ea7"};
        return s[mediaData[0][3]];
    }
}

