/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class DeviceImage {
    public static final int SPLASH_TEXT_OFFSET = 0;
    public static final boolean USE_NEW_MS_LOGO = false;
    public static final boolean USE_BIG_SPLASH = false;
    public static final int MENU_ARROW_LEVEL_OFFSET = 0;
    public static final boolean NO_SPLASH = true;
    public static final boolean USE_MENU_LOGO = true;
    public static final byte INGAME_BORDER_TOP = 20;
    public static final byte MENU_BORDER_TOP = 20;
    public static final byte MENU_BORDER_WIDTH = 20;
    public static final boolean MENU_USE_BORDERS = true;
    public static final byte MENU_ADDLINES_INGAME = 0;
    public static final byte SOFTKEYS_OFFSET_X = 12;
    public static final byte SOFTKEYS_OFFSET_Y = 8;
    public static final boolean EHANCED_MENU = true;
    public static final byte MENU_SELECT_OFFSET = 1;
    public static final boolean USE_CHARS = true;
    public static final boolean USE_READYIMAGES = false;
    public static final boolean USE_PORTRAITS = false;
    public static final byte STORY_OFFSET_Y = 1;
    public static final int BOSS_OFFSET = 94;
    public static final int FLAG_OFFSET_2 = 0;
    public static final boolean SHOW_LOADING = false;
    public static boolean SOUND_ACTIVATED = true;
    public static final boolean GL_USE_DX = false;
    public static final boolean GL_FULLCACHING = true;
    public static final boolean GL_PARTIALCACHING = false;
    public static final boolean GL_FULLCACHING_COMPLETE = false;
    public static final int MAX_STORY_LEVELS = 12;
    public static final int MAX_SKIRIMISH_LEVELS = 4;
    public static final short GL_CACHING_MAX_WIDTH = 155;
    public static final short GL_CACHING_MAX_HEIGHT = 15;
    public static final short GL_CACHING_MAX_ADDHEIGHT = 4;
    public static final int continueKey = 242;
    public static final int skipKey = 238;
    public static final int story_size = 3;
    public static final String MODEL = "s60";
    public static final byte TEXT_OFFSET = -1;
    public static final byte SPR_AMOUNT = 95;
    public static final byte SPR_NUMS = 0;
    public static final byte SPR_ARROW = 1;
    public static final byte SPR_BBODY = 2;
    public static final byte SPR_BG_1_0 = 3;
    public static final byte SPR_BG_1_1 = 4;
    public static final byte SPR_BG_2_0 = 5;
    public static final byte SPR_BG_2_1 = 6;
    public static final byte SPR_BG_3_1 = 7;
    public static final byte SPR_BG_4_1 = 8;
    public static final byte SPR_BHAND = 9;
    public static final byte SPR_BHEAD = 10;
    public static final byte SPR_BHIT = 11;
    public static final byte SPR_BODY = 12;
    public static final byte SPR_BOSS1 = 13;
    public static final byte SPR_BRING = 14;
    public static final byte SPR_BULLET = 15;
    public static final byte SPR_BULLET2 = 16;
    public static final byte SPR_BULLET3 = 17;
    public static final byte SPR_BULLETTIMEICON = 18;
    public static final byte SPR_CANNONBALL = 19;
    public static final byte SPR_CHAR = 20;
    public static final byte SPR_CRATE = 21;
    public static final byte SPR_CLOCK = 22;
    public static final byte SPR_DEBRIS = 23;
    public static final byte SPR_DOM = 24;
    public static final byte SPR_EGG = 25;
    public static final byte SPR_ENEMY_BULLET = 26;
    public static final byte SPR_ENEMY_GRANADE = 27;
    public static final byte SPR_EXPL_GREEN = 28;
    public static final byte SPR_EXPL_RED = 29;
    public static final byte SPR_ENEMYFIRE = 30;
    public static final byte SPR_FLAGS = 31;
    public static final byte SPR_FLYINGALIENS = 32;
    public static final byte SPR_FLYINGROBOT = 33;
    public static final byte SPR_FREEZER = 34;
    public static final byte SPR_GAMEOVER = 35;
    public static final byte SPR_GRANADE = 36;
    public static final byte SPR_GUN = 37;
    public static final byte SPR_GUNFIRE = 38;
    public static final byte SPR_H01 = 39;
    public static final byte SPR_H02 = 40;
    public static final byte SPR_H03 = 41;
    public static final byte SPR_H04 = 42;
    public static final byte SPR_H05 = 43;
    public static final byte SPR_H06 = 44;
    public static final byte SPR_H07 = 45;
    public static final byte SPR_H08 = 46;
    public static final byte SPR_H09 = 47;
    public static final byte SPR_H10 = 48;
    public static final byte SPR_H11 = 49;
    public static final byte SPR_H12 = 50;
    public static final byte SPR_H13 = 51;
    public static final byte SPR_H14 = 52;
    public static final byte SPR_H15 = 53;
    public static final byte SPR_H16 = 54;
    public static final byte SPR_H17 = 55;
    public static final byte SPR_H18 = 56;
    public static final byte SPR_HEALTH = 57;
    public static final byte SPR_HEAVYUNIT = 58;
    public static final byte SPR_HELI = 59;
    public static final byte SPR_HELIB = 60;
    public static final byte SPR_LIGHTENEMY = 61;
    public static final byte SPR_LINEFX = 62;
    public static final byte SPR_MBODY = 63;
    public static final byte SPR_MENU_ARROW = 64;
    public static final byte SPR_MENU_BG = 65;
    public static final byte SPR_MENULOGO = 66;
    public static final byte SPR_MLEGS = 67;
    public static final byte SPR_MTILES = 68;
    public static final byte SPR_PADS = 69;
    public static final byte SPR_PORTRAITS = 70;
    public static final byte SPR_POWERUPS = 71;
    public static final byte SPR_PRESSANYKEY = 72;
    public static final byte SPR_QUAD = 73;
    public static final byte SPR_READY = 74;
    public static final byte SPR_ROCKET = 75;
    public static final byte SPR_ROLLINGENEMY = 76;
    public static final byte SPR_SAT = 77;
    public static final byte SPR_SAT_SHOT = 78;
    public static final byte SPR_SCOREBOARD = 79;
    public static final byte SPR_SELECT = 80;
    public static final byte SPR_SELECT2 = 81;
    public static final byte SPR_SHIELD = 82;
    public static final byte SPR_SMOKE = 83;
    public static final byte SPR_SNOW = 84;
    public static final byte SPR_SPAWN = 85;
    public static final byte SPR_SPLASH = 86;
    public static final byte SPR_STATIONARYGUN = 87;
    public static final byte SPR_T_1 = 88;
    public static final byte SPR_T_2 = 89;
    public static final byte SPR_T_3 = 90;
    public static final byte SPR_T_4 = 91;
    public static final byte SPR_TOOLTIPS = 92;
    public static final byte SPR_WATERDROP = 93;
    public static final byte SPR_WEAPON_SELECTED = 94;
    public static byte MAX_NUMBER_OF_BOTS = (byte)9;
    public static DeviceImage[] body_blue;
    public static DeviceImage[] body_red;
    public Image image;
    public Image image2;
    public int width;
    public int height;
    public int tileX;
    public int tileX2;
    public int tileY;
    public int tileY2;
    public boolean doClip = false;
    public boolean doClip2 = false;
    public static final int[] transformations;
    public byte transformation = 0;
    public byte transformation2 = 0;
    public static DeviceImage[][] sprites;
    private static String[] names;
    private static byte[][][] sprites_infos;
    private static byte[] sprite_sizes;
    public static final short BITMAP_CHAR_WIDTH = 5;
    public static final short BITMAP_CHAR_HEIGHT = 9;
    public static final short BITMAP_CHAR_FIRST_INDEX = 48;
    public static final short BITMAP_CHAR_LAST_INDEX = 57;
    public static final byte MAX_ARTEFACT = 10;
    public static final byte MAX_PARTICLES = 0;
    public static final byte MAX_WATER_DROPS = 0;
    public static final byte MAX_SNOW = 0;
    public static final byte MAX_AIR_STRIKE = 4;
    public static byte FIX_BOTTOM_LINES;
    public static int bg_color;
    public static int bg_startY;
    public static int bg_endY;
    public static final byte[] SGFX_GENERAL;
    public static final byte[] SGFX_MENU;
    public static final byte[] SGFX_GAME;
    public static final byte[] SGFX_GAME_STORY;
    public static final byte[] SGFX_GAME_SKIRMISH;
    public static final byte[] SGFX_BOSS_1;
    public static final byte[] SGFX_BOSS_2;
    public static final byte[] SGFX_ALLENV;
    public static boolean gameLoaded;
    public static final boolean FREEPIXS = true;
    public static final byte BULLET_TIME_FX_COUNT = 30;
    public static DeviceImage cached_spawn_arrow;
    public static DeviceImage cached_clouds;
    public static DeviceImage cached_bg_1;
    public static DeviceImage cached_bg_2;
    public static DeviceImage[] cached_tiles_i;
    public static final byte THEME_MAIN = 0;
    public static final byte THEME_OUT1 = 1;
    public static final byte THEME_OUT2 = 2;
    public static final byte THEME_IN1 = 3;
    public static final byte THEME_IN2 = 4;
    public static final byte THEME_BOSS = 5;
    public static final byte THEME_AMOUNT = 1;
    private static Player[] bass_sounds;
    private static Player bass_activePlayer;
    public static int bass_last;
    public static boolean bass_playing;
    public static boolean muteSound;
    public static String instructions;

    public static void draw_textOutline(Graphics graphics, String string, int n, int n2) {
        graphics.setColor(276381837);
        graphics.drawString(string, n - 1, n2 + 1, 17);
        graphics.drawString(string, n - 1, n2 - 1, 17);
        graphics.drawString(string, n + 1, n2 - 1, 17);
        graphics.drawString(string, n + 1, n2 + 1, 17);
        graphics.setColor(-1);
        graphics.drawString(string, n, n2, 17);
    }

    private static int crcByte(byte by, int n) {
        int n2 = by & 0xFF;
        n ^= n2;
        for (int i = 0; i < 8; ++i) {
            if ((n & 1) != 0) {
                n = n >>> 1 ^ 0xEDB88320;
                continue;
            }
            n >>>= 1;
        }
        return n;
    }

    public DeviceImage(String string) {
        DeviceUtils.info = string;
        DeviceUtils.instance.repaintAll();
        try {
            this.image = GameStage.getResourceAsImage(string);
            this.width = (short)this.image.getWidth();
            this.height = (short)this.image.getHeight();
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeviceImage(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.image = deviceImage.image;
        this.width = (short)n3;
        this.height = (short)n4;
        this.tileX = (short)n;
        this.tileY = (short)n2;
        this.doClip = true;
    }

    public void drawImageCenter(Graphics graphics) {
        this.drawImage(graphics, DeviceUtils.width - this.width >> 1, DeviceUtils.height - this.height >> 1);
    }

    public void drawImage(Graphics graphics, int n, int n2) {
        if (this.doClip) {
            int n3 = graphics.getClipX();
            int n4 = graphics.getClipY();
            int n5 = graphics.getClipWidth();
            int n6 = graphics.getClipHeight();
            graphics.clipRect(n, n2, Math.min(n + this.width, n3 + n5) - n, Math.min(n2 + this.height, n4 + n6) - n2);
            if (this.transformation == 0) {
                graphics.drawImage(this.image, n - this.tileX, n2 - this.tileY, 20);
            } else {
                graphics.drawRegion(this.image, this.tileX, this.tileY, this.width, this.height, transformations[this.transformation], n, n2, 20);
            }
            graphics.setClip(n3, n4, n5, n6);
        } else if (this.transformation == 0) {
            graphics.drawImage(this.image, n, n2, 20);
        } else {
            graphics.drawRegion(this.image, 0, 0, this.width, this.height, transformations[this.transformation], n, n2, 20);
        }
    }

    public DeviceImage(DeviceImage deviceImage, int n) {
        this.image = deviceImage.image;
        this.width = deviceImage.width;
        this.height = deviceImage.height;
        this.tileX = deviceImage.tileX;
        this.tileY = deviceImage.tileY;
        this.doClip = deviceImage.doClip;
        this.image2 = deviceImage.image2;
        this.tileX2 = deviceImage.tileX2;
        this.tileY2 = deviceImage.tileY2;
        this.doClip2 = deviceImage.doClip2;
        this.transformation = (byte)(deviceImage.transformation | n);
    }

    public DeviceImage(DeviceImage deviceImage) {
        this.image = deviceImage.image;
        this.width = deviceImage.width;
        this.height = deviceImage.height;
        this.tileX = deviceImage.tileX;
        this.tileY = deviceImage.tileY;
        this.doClip = deviceImage.doClip;
    }

    public DeviceImage(DeviceImage[] deviceImageArray, byte by, byte by2) {
        this.transformation = deviceImageArray[by2].transformation;
        this.width = deviceImageArray[by2].width;
        this.height = deviceImageArray[by2].height;
        this.image = deviceImageArray[by2].image;
        this.tileX = deviceImageArray[by2].tileX;
        this.tileY = deviceImageArray[by2].tileY;
        this.doClip = deviceImageArray[by2].doClip;
        this.image2 = deviceImageArray[by].image;
        this.tileX2 = deviceImageArray[by].tileX;
        this.tileY2 = deviceImageArray[by].tileY;
        this.doClip2 = deviceImageArray[by].doClip;
        this.transformation2 = deviceImageArray[by].transformation;
    }

    public void drawImageMixed(Graphics graphics, int n, int n2) {
        if (this.image2 != null) {
            if (this.doClip2) {
                int n3 = graphics.getClipX();
                int n4 = graphics.getClipY();
                int n5 = graphics.getClipWidth();
                int n6 = graphics.getClipHeight();
                graphics.clipRect(n, n2, Math.min(n + this.width, n3 + n5) - n, Math.min(n2 + this.height, n4 + n6) - n2);
                if (this.transformation2 == 0) {
                    graphics.drawImage(this.image2, n - this.tileX2, n2 - this.tileY2, 20);
                } else {
                    graphics.drawRegion(this.image2, this.tileX2, this.tileY2, this.width, this.height, transformations[this.transformation2], n, n2, 20);
                }
                graphics.setClip(n3, n4, n5, n6);
            } else if (this.transformation2 == 0) {
                graphics.drawImage(this.image2, n, n2, 20);
            } else {
                graphics.drawRegion(this.image2, 0, 0, this.width, this.height, transformations[this.transformation2], n, n2, 20);
            }
        }
        this.drawImage(graphics, n, n2);
    }

    public static final void loadSprite(int n) {
        DeviceImage[] deviceImageArray = null;
        int n2 = 0;
        if (sprites[n] == null) {
            int n3;
            int n4;
            ++GameStage.loadingCnt;
            if (sprite_sizes[n * 3 + 2] > 0 && (sprites_infos[n][0][0] == 32 || sprites_infos[n][0][0] == 64)) {
                n2 = sprites_infos[n][0][1];
                if (sprites_infos[n][0][0] == 64) {
                    n2 /= 2;
                }
                deviceImageArray = new DeviceImage[n2 + (sprite_sizes[n * 3 + 2] - 1)];
                for (n4 = 0; n4 < n2; ++n4) {
                    deviceImageArray[n4] = new DeviceImage(names[n] + "_" + n4 + ".png");
                }
            } else {
                DeviceImage deviceImage = new DeviceImage(names[n]);
                n3 = sprite_sizes[n * 3];
                int n5 = sprite_sizes[n * 3 + 1];
                if (n3 < 0) {
                    n3 += 256;
                }
                if (n5 < 0) {
                    n5 += 256;
                }
                int n6 = 1;
                if (n3 < deviceImage.width && n3 != 0) {
                    n6 = deviceImage.width / n3;
                }
                int n7 = 1;
                if (n5 < deviceImage.height && n5 != 0) {
                    n7 = deviceImage.height / n5;
                }
                n2 = n6 * n7;
                int n8 = n2 + sprite_sizes[n * 3 + 2];
                deviceImageArray = new DeviceImage[n8];
                if (n2 == 1) {
                    deviceImageArray[0] = deviceImage;
                } else {
                    for (int i = 0; i < n7; ++i) {
                        for (int j = 0; j < n6; ++j) {
                            deviceImageArray[i * n6 + j] = new DeviceImage(deviceImage, n3 * j, n5 * i, n3, n5);
                        }
                    }
                }
                deviceImage = null;
            }
            n4 = 0;
            for (n3 = 0; n3 < sprite_sizes[n * 3 + 2]; ++n3) {
                if (sprites_infos[n][0][0] == 64) {
                    n4 = -1;
                }
                if (sprites_infos[n][n3].length == 2) {
                    if (sprites_infos[n][0][0] == 32 || sprites_infos[n][0][0] == 64 && n3 == 0) continue;
                    try {
                        deviceImageArray[n2 + n3 + n4] = new DeviceImage(deviceImageArray[sprites_infos[n][n3][1]], sprites_infos[n][n3][0]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                deviceImageArray[n2 + n3 + n4] = new DeviceImage(deviceImageArray, sprites_infos[n][n3][1], sprites_infos[n][n3][2]);
            }
            DeviceImage.sprites[n] = deviceImageArray;
        }
    }

    public static final void initSprites(int n) throws Exception {
        if (sprites == null) {
            GameStage.glInitCacheImage(n);
            sprites = new DeviceImage[95][];
            names = new String[95];
            sprites_infos = new byte[95][][];
            sprite_sizes = new byte[285];
            DataInputStream dataInputStream = new DataInputStream(GameStage.getResourceAsBAIS("spr_s60.dat"));
            GameStage.closeStream();
            dataInputStream.readByte();
            for (int i = 0; i < 95; ++i) {
                DeviceImage.names[i] = dataInputStream.readUTF();
                DeviceImage.sprite_sizes[i * 3] = dataInputStream.readByte();
                DeviceImage.sprite_sizes[i * 3 + 1] = dataInputStream.readByte();
                DeviceImage.sprite_sizes[i * 3 + 2] = dataInputStream.readByte();
                int n2 = DeviceImage.sprite_sizes[i * 3 + 2];
                if (n2 <= 0) continue;
                DeviceImage.sprites_infos[i] = new byte[n2][];
                for (int j = 0; j < n2; ++j) {
                    short s = dataInputStream.readByte();
                    short s2 = dataInputStream.readByte();
                    if (s == 4) {
                        DeviceImage.sprites_infos[i][j] = new byte[3];
                        DeviceImage.sprites_infos[i][j][2] = dataInputStream.readByte();
                    } else {
                        DeviceImage.sprites_infos[i][j] = new byte[2];
                    }
                    DeviceImage.sprites_infos[i][j][0] = (byte)s;
                    DeviceImage.sprites_infos[i][j][1] = (byte)s2;
                }
            }
            dataInputStream.close();
        }
    }

    public static void drawBitmapString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4;
        for (n4 = string.length(); n4 < n3; ++n4) {
            string = "0" + string;
        }
        int n5 = 0;
        int n6 = n;
        for (int i = 0; i < n4; ++i) {
            char c = string.charAt(n5);
            if (c == ':') {
                sprites[0][10].drawImage(graphics, n6, n2);
                --n6;
            } else {
                sprites[0][c - 48].drawImage(graphics, n6, n2);
            }
            n6 += 5;
            ++n5;
        }
    }

    public static void sgfx_free(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            DeviceImage.sprites[byArray[i]] = null;
        }
        System.gc();
    }

    public static void sgfx_read(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            DeviceImage.loadSprite(byArray[i]);
        }
    }

    public static void loadMenu() {
        DeviceImage.sgfx_free(SGFX_ALLENV);
        DeviceImage.sgfx_free(SGFX_BOSS_1);
        DeviceImage.sgfx_free(SGFX_BOSS_2);
        DeviceImage.sgfx_free(SGFX_GAME);
        DeviceImage.sgfx_free(SGFX_GAME_SKIRMISH);
        DeviceImage.sgfx_free(SGFX_GAME_STORY);
        DeviceImage.sgfx_read(SGFX_MENU);
        gameLoaded = false;
    }

    public static void loadGenericPictures() {
        GameStage.notToFree = names[12];
        DeviceImage.sgfx_read(SGFX_GENERAL);
        try {
            DeviceImage.loadSprite(12);
            body_blue = sprites[12];
            body_red = sprites[12];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadLevel() throws Exception {
        DeviceImage.sgfx_free(SGFX_ALLENV);
        DeviceImage.sgfx_free(SGFX_BOSS_1);
        DeviceImage.sgfx_free(SGFX_BOSS_2);
        if (!gameLoaded) {
            DeviceImage.sgfx_free(SGFX_MENU);
            DeviceImage.sgfx_free(SGFX_BOSS_1);
            DeviceImage.sgfx_free(SGFX_BOSS_2);
            DeviceImage.sgfx_read(SGFX_GAME);
            gameLoaded = true;
            if (InGame.LEVEL_MODE == 0) {
                DeviceImage.sgfx_read(SGFX_GAME_STORY);
            } else {
                DeviceImage.sgfx_read(SGFX_GAME_SKIRMISH);
            }
            gameLoaded = true;
        }
        cached_spawn_arrow = sprites[85][0];
        cached_clouds = null;
        cached_bg_1 = null;
        cached_bg_2 = null;
        cached_tiles_i = null;
        bg_color = MovingObject.BG_COLOR[InGame.LEVEL_ENV];
        switch (InGame.LEVEL_ENV) {
            case 0: {
                DeviceImage.sgfx_read(SGFX_BOSS_1);
                DeviceImage.loadSprite(3);
                DeviceImage.loadSprite(4);
                DeviceImage.loadSprite(88);
                cached_bg_1 = sprites[3][0];
                cached_bg_2 = sprites[4][0];
                cached_tiles_i = sprites[88];
                bg_color = 15324246;
                break;
            }
            case 1: {
                DeviceImage.loadSprite(5);
                DeviceImage.loadSprite(6);
                DeviceImage.loadSprite(89);
                cached_bg_1 = sprites[5][0];
                cached_bg_2 = sprites[6][0];
                cached_tiles_i = sprites[89];
                bg_color = 10500120;
                break;
            }
            case 2: {
                DeviceImage.loadSprite(7);
                DeviceImage.loadSprite(90);
                DeviceImage.loadSprite(58);
                cached_bg_1 = null;
                cached_bg_2 = sprites[7][0];
                cached_tiles_i = sprites[90];
                bg_color = 1908012;
                break;
            }
            case 3: {
                DeviceImage.loadSprite(58);
                DeviceImage.sgfx_read(SGFX_BOSS_2);
                DeviceImage.loadSprite(8);
                DeviceImage.loadSprite(91);
                cached_bg_1 = null;
                cached_bg_2 = sprites[8][0];
                cached_tiles_i = sprites[91];
                bg_color = 87552;
            }
        }
        bg_startY = cached_clouds == null ? 0 : DeviceImage.cached_clouds.height;
        bg_endY = cached_bg_1 == null ? DeviceUtils.height : DeviceUtils.height - MovingObject.BG_OFFSETS[InGame.LEVEL_ENV];
    }

    public static void bass_fixFlashBug() {
        try {
            Manager.createPlayer(null, (String)"audio/midi");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void bass_init() {
        try {
            if (!SOUND_ACTIVATED) {
                ++GameStage.loadingCnt;
                return;
            }
            int n = 116;
            bass_sounds = new Player[1];
            for (int i = 0; i < 1; ++i) {
                ++GameStage.loadingCnt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void bass_continue() {
        if (bass_playing) {
            return;
        }
        DeviceImage.bass_play(bass_last);
    }

    public static void bass_play(int n) {
        if (!SOUND_ACTIVATED || muteSound) {
            bass_last = n;
            return;
        }
        if (bass_last == n && bass_playing) {
            return;
        }
        bass_last = n;
        if (n == -1) {
            return;
        }
        try {
            int n2 = -1;
            DeviceImage.bass_stop();
            bass_activePlayer = Manager.createPlayer((InputStream)DeviceUtils.instance.getClass().getResourceAsStream("1.mid"), (String)"audio/midi");
            bass_activePlayer.realize();
            bass_activePlayer.prefetch();
            bass_activePlayer.setLoopCount(n2);
            bass_activePlayer.start();
            bass_playing = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void bass_stop() {
        bass_playing = false;
        if (!SOUND_ACTIVATED) {
            return;
        }
        try {
            if (bass_activePlayer != null) {
                bass_activePlayer.stop();
                bass_activePlayer.deallocate();
                bass_activePlayer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void initInstructions() {
        String string = OObject.get(134);
        string = OObject.replace(string, "%F", OObject.get(233));
        string = OObject.replace(string, "%M", OObject.get(234));
        string = OObject.replace(string, "%J", OObject.get(235));
        string = OObject.replace(string, "%B", OObject.get(238));
        string = OObject.replace(string, "%L", OObject.get(239));
        string = OObject.replace(string, "%D", OObject.get(240));
        string = OObject.replace(string, "%Q", OObject.get(236));
        instructions = string = OObject.replace(string, "%W", OObject.get(237));
    }

    static {
        transformations = new int[]{0, 2, 1, 3, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 5};
        sprites = null;
        names = null;
        sprites_infos = null;
        sprite_sizes = null;
        FIX_BOTTOM_LINES = 0;
        SGFX_GENERAL = new byte[]{1, 12, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 64, 72, 92, 0};
        SGFX_MENU = new byte[]{65, 68, 66, 80, 81, 4, 6, 70, 20};
        SGFX_GAME = new byte[]{15, 16, 17, 18, 19, 23, 26, 27, 30, 28, 29, 36, 37, 38, 57, 71, 73, 75, 82, 83, 84, 84, 94, 85};
        SGFX_GAME_STORY = new byte[]{21, 25, 32, 33, 34, 59, 60, 61, 63, 67, 76, 77, 78, 87};
        SGFX_GAME_SKIRMISH = new byte[]{22, 24, 31, 69, 79};
        SGFX_BOSS_1 = new byte[]{13};
        SGFX_BOSS_2 = new byte[]{2, 9, 10, 11, 14};
        SGFX_ALLENV = new byte[]{3, 4, 5, 6, 7, 8, 88, 89, 90, 91};
        bass_last = -1;
    }
}

