/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class DeviceUtils
extends Canvas
implements Runnable {
    public static final int HUD_HEIGHT = 34;
    public static final boolean USE_HUD = true;
    public static final boolean SHOW_MEMORY = false;
    public static final boolean SHOW_INFO = false;
    public static final boolean NPRELOAD_SEPARATE = true;
    public static final boolean PRELOAD = false;
    public static final boolean PRELOAD_AUTOFREEPICTURES = false;
    public static final boolean PRELOAD_AUTOFREEPICTURES_USETWOPACKS = false;
    public static final boolean USE_SIZECHANGED = false;
    public static String info = "";
    public static final int DEVICE_KEY_SOFT_LEFT = 21;
    public static final int DEVICE_KEY_SOFT_RIGHT = 22;
    public static final int DEVICE_KEY_SOFT_LEFT_2 = -21;
    public static final int DEVICE_KEY_SOFT_RIGHT_2 = -22;
    public static final int MAX_ARTEFACT = 10;
    public static final int MAX_PARTICLES = 5;
    public static DeviceUtils instance;
    public static final int FF_KEY_NOKEY = 0;
    public static final int FF_KEY_UP = 2;
    public static final int FF_KEY_WALKER = 4;
    public static final int FF_KEY_LEFT = 8;
    public static final int FF_KEY_RIGHT = 16;
    public static final int FF_KEY_FIRE = 32;
    public static final int FF_KEY_SOFT_LEFT = 64;
    public static final int FF_KEY_SOFT_RIGHT = 128;
    public static final int FF_KEY_UPLEFT = 256;
    public static final int FF_KEY_UPRIGHT = 512;
    public static final int FF_KEY_7 = 1024;
    public static final int FF_KEY_9 = 2048;
    public static final int FF_KEY_STAR = 4096;
    public static final int FF_KEY_BULLET_SKIP = 8192;
    public static final int FF_KEY_POUND = 16384;
    public static final int FF_KEY_ANY = 32768;
    public static final short REFRESH_DELAY = 40;
    public static long gameTime;
    public static int width;
    public static int height;
    public static int inputBuffer;
    public Display display;
    public GameStage currentGameStage;
    public static String loadingString;
    public static boolean tickAllowed;
    public static boolean pausedMode;
    public static boolean mustSwitchToPausedMode;
    public static long lastVisibleTime;
    public static boolean lastVisible;
    public static final boolean AUTOSWITCHTOMENU = false;
    public static boolean painting;
    public static boolean sizeWasChanged;

    public DeviceUtils(MIDlet mIDlet) throws Exception {
        this.setFullScreenMode(true);
        GameStage.OVERLAY_HEIGHT = 20;
        GameStage.MENU_BUTTON_HEIGHT = (byte)19;
        GameStage.MENU_TEXT_HEIGHT = (byte)(GameStage.MENU_TEXT_HEIGHT + 2);
        GameStage.INGAME_SELECT_Y_OFF = -2;
        instance = this;
        DeviceImage.bass_fixFlashBug();
        OObject.init("/lang.dat");
        DeviceImage.initInstructions();
        loadingString = OObject.get(130);
        this.display = Display.getDisplay((MIDlet)mIDlet);
        GameStage.deviceScreen = this;
        this.display.setCurrent((Displayable)this);
        gameTime = System.currentTimeMillis();
        width = this.getWidth();
        height = this.getHeight();
        GameStage.rms_read();
        new Thread(this).start();
    }

    public void endPaint() {
        painting = false;
    }

    public void paint(Graphics graphics) {
        try {
            if (Main.instance == null) {
                this.endPaint();
                return;
            }
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            if (pausedMode) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, width, height);
                if (DeviceImage.sprites != null && DeviceImage.sprites[72] != null) {
                    DeviceImage deviceImage = DeviceImage.sprites[72][0];
                    if (lastVisible) {
                        deviceImage.drawImage(graphics, width - deviceImage.width >> 1, height - deviceImage.height >> 1);
                    }
                } else {
                    graphics.setColor(-1);
                    String string = OObject.get(230);
                    if (lastVisible) {
                        graphics.drawString(string, width >> 1, height >> 1, 17);
                    }
                }
                this.endPaint();
                return;
            }
            if (this.currentGameStage != null) {
                this.currentGameStage.paintScreen(graphics);
            } else if (width != 0) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, width, height);
                graphics.setColor(-1);
                graphics.setFont(GameStage.boldFont);
                graphics.drawString(loadingString, width >> 1, height >> 1, 17);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.endPaint();
    }

    public int remapKey(int n) {
        switch (n) {
            case 48: {
                return 8192;
            }
            case 49: {
                return 256;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 512;
            }
            case 52: {
                return 8;
            }
            case 53: {
                return 32;
            }
            case 54: {
                return 16;
            }
            case 55: {
                return 1024;
            }
            case 56: {
                return 4;
            }
            case 57: {
                return 2048;
            }
            case -21: 
            case 21: {
                return 64;
            }
            case -22: 
            case 22: {
                return 128;
            }
        }
        switch (this.getGameAction(n)) {
            case 1: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 8: {
                return 32;
            }
        }
        return 32768;
    }

    public void keyPressed(int n) {
        inputBuffer |= this.remapKey(n);
    }

    public void keyReleased(int n) {
        inputBuffer &= ~this.remapKey(n);
    }

    public void switchToTextBox(TextBox textBox) {
        mustSwitchToPausedMode = false;
        this.display.setCurrent((Displayable)textBox);
        this.repaint();
        this.serviceRepaints();
    }

    public void switchToMainScreen() {
        this.display.setCurrent((Displayable)this);
        this.repaint();
        this.serviceRepaints();
        mustSwitchToPausedMode = true;
    }

    public void showNotify() {
        Agent.updateHud = true;
        if (!pausedMode) {
            DeviceImage.bass_continue();
        }
        tickAllowed = true;
    }

    public void hideNotify() {
        DeviceImage.bass_stop();
        if (this.currentGameStage != null) {
            this.currentGameStage.hideNotify();
        }
        tickAllowed = false;
        pausedMode = mustSwitchToPausedMode;
    }

    public void tick() {
        long l = System.currentTimeMillis();
        if (l - lastVisibleTime > 200L) {
            lastVisibleTime = l;
            boolean bl = lastVisible = !lastVisible;
        }
        if (pausedMode) {
            if (tickAllowed) {
                if (inputBuffer != 0) {
                    inputBuffer = 0;
                    pausedMode = false;
                    DeviceImage.bass_continue();
                }
                this.repaintAll();
            }
            return;
        }
        if (this.currentGameStage != null && tickAllowed) {
            this.currentGameStage.tick();
            this.repaintAll();
        }
    }

    public void repaintAll() {
        instance.repaint();
        instance.serviceRepaints();
    }

    public void waitForPaint() {
        painting = true;
        while (painting) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    public void sizeChanged(int n, int n2) {
        if (!sizeWasChanged) {
            sizeWasChanged = true;
        }
    }

    public void run() {
        if (!Main.running) {
            DeviceImage.bass_stop();
            Main.instance.notifyDestroyed();
            return;
        }
        width = this.getWidth();
        height = 204;
        this.currentGameStage = new GameStage(-2);
        while (Main.running) {
            try {
                long l = System.currentTimeMillis();
                this.tick();
                gameTime += 40L;
                long l2 = System.currentTimeMillis() - l;
                if (l2 >= 40L) continue;
                try {
                    Thread.sleep(40L - l2);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {}
        }
        DeviceImage.bass_stop();
        Main.instance.notifyDestroyed();
    }

    static {
        inputBuffer = 0;
        loadingString = "";
        tickAllowed = true;
        pausedMode = false;
        mustSwitchToPausedMode = true;
    }
}

