/*
 * Decompiled with CFR 0.152.
 */
package com.boragame.utils.j2me.nokiadp1;

import com.nokia.mid.sound.Sound;
import java.io.InputStream;

public class SoundPlayer {
    private Sound[] players = null;
    private boolean isOn = true;
    private int currentIndex = -1;
    private int currentLoopCount = 1;
    private int volume = 200;
    public static int FORMAT_WAV = 5;
    public static int FORMAT_OTT = 1;

    public SoundPlayer(int count) throws Exception {
        if (count <= 0) {
            throw new ArrayIndexOutOfBoundsException(count);
        }
        this.players = new Sound[count];
    }

    private void checkPlayers() throws Exception {
        if (this.players == null) {
            throw new NullPointerException();
        }
    }

    private void checkIndex(int index, boolean checkNull) throws Exception {
        this.checkPlayers();
        if (index < 0 || index >= this.players.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (checkNull && this.players[index] == null) {
            throw new NullPointerException();
        }
    }

    public void setSoundData(int index, byte[] data, int offset, int count, int format) throws Exception {
        this.checkIndex(index, false);
        if (data == null) {
            this.players[index] = null;
            System.gc();
            return;
        }
        if (offset < 0 || offset >= data.length || offset + count > data.length || count <= 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.players[index] = null;
        byte[] buffer = new byte[count];
        System.arraycopy(data, offset, buffer, 0, count);
        this.players[index] = new Sound(buffer, format);
        buffer = null;
        System.gc();
    }

    public void setSoundData(int index, String fileName, int format) throws Exception {
        byte[] buffer = this.getDataFromFile(fileName);
        this.setSoundData(index, buffer, 0, buffer.length, format);
        buffer = null;
        System.gc();
    }

    private byte[] realloc(byte[] buffer, int newSize) {
        if (newSize <= 0) {
            return buffer;
        }
        int dataSize = 0;
        byte[] newBuffer = null;
        if (buffer != null) {
            if (newSize == buffer.length) {
                return buffer;
            }
            newBuffer = new byte[newSize];
            dataSize = newSize < buffer.length ? newSize : buffer.length;
            System.arraycopy(buffer, 0, newBuffer, 0, dataSize);
        } else {
            newBuffer = new byte[newSize];
        }
        return newBuffer;
    }

    private int getBufferSize(byte[] buffer) {
        if (buffer == null) {
            return 0;
        }
        return buffer.length;
    }

    private byte[] getDataFromFile(String fileName) throws Exception {
        int bufferSize = 512;
        byte[] buffer = new byte[512];
        byte[] dataBuffer = null;
        InputStream is = this.getClass().getResourceAsStream(fileName);
        int count = is.read(buffer);
        while (count > 0) {
            int oldSize = this.getBufferSize(dataBuffer);
            dataBuffer = this.realloc(dataBuffer, this.getBufferSize(dataBuffer) + count);
            System.arraycopy(buffer, 0, dataBuffer, oldSize, count);
            count = is.read(buffer);
        }
        is.close();
        is = null;
        System.gc();
        return dataBuffer;
    }

    public void setSoundOn(boolean on) throws Exception {
        this.isOn = on;
        if (!this.isOn) {
            this.stopSound();
        }
    }

    public boolean isSoundOn() {
        return this.isOn;
    }

    private void play(Sound player, int loopCount) throws Exception {
        if (player == null) {
            return;
        }
        player.setGain(this.volume);
        player.play(loopCount);
    }

    public void playSound(int index, int loopCount) throws Exception {
        if (!this.isOn) {
            return;
        }
        this.checkIndex(index, true);
        if (loopCount < 0) {
            loopCount = 0;
        }
        this.stopSound();
        this.play(this.players[index], loopCount);
        this.currentIndex = index;
        this.currentLoopCount = loopCount;
    }

    public void stopSound() throws Exception {
        if (this.currentIndex == -1) {
            return;
        }
        this.checkPlayers();
        if (this.players[this.currentIndex].getState() == 0) {
            this.players[this.currentIndex].stop();
        }
        this.currentIndex = -1;
    }

    public void pauseSound() throws Exception {
        if (this.currentIndex == -1) {
            return;
        }
        this.checkPlayers();
        if (this.players[this.currentIndex].getState() == 0) {
            this.players[this.currentIndex].stop();
        }
    }

    public void resumeSound() throws Exception {
        if (!this.isOn) {
            return;
        }
        if (this.currentIndex == -1) {
            return;
        }
        this.checkPlayers();
        if (this.players[this.currentIndex].getState() == 1 && this.currentLoopCount == 0) {
            this.players[this.currentIndex].play(this.currentLoopCount);
        }
    }

    public void setVolume(int level) throws Exception {
        if (level < 0) {
            level = 0;
        }
        if (level > 255) {
            level = 255;
        }
        this.volume = level;
        this.checkPlayers();
        if (this.currentIndex != -1 && this.players[this.currentIndex].getState() == 0) {
            this.players[this.currentIndex].setGain(level);
        }
    }

    public int getVolume() {
        return this.volume;
    }

    public void close() throws Exception {
        this.stopSound();
        if (this.players == null) {
            return;
        }
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null) continue;
            this.players[i].release();
            this.players[i] = null;
        }
        this.players = null;
        System.gc();
    }
}

