/*
 * Decompiled with CFR 0.152.
 */
package dragoneyes;

import dragoneyes.GameControl;
import dragoneyes.Game_Canvas;

public class GameMap {
    Game_Canvas gc;
    byte[][][] mapBoard = new byte[3][50][50];
    byte CURRENT_BLOCK_WIDTH;
    byte CURRENT_BLOCK_HEIGHT;
    int CURRENT_BLOCK_FIXEL_WIDTH;
    int CURRENT_BLOCK_FIXEL_HEIGHT;
    static String[] mapName = null;
    static final byte MAP_DETAIL_TILE_TYPE = 0;
    static final byte MAP_DETAIL_SOUND = 1;
    static byte[][] mapDetailData = null;
    static byte[][] mapTileLoadingDirection = null;
    static byte[] miniMapDrawList = null;
    static int[][] battleMappingList = null;

    GameMap(Game_Canvas gc) {
        this.gc = gc;
        if (mapName == null) {
            mapName = Game_Canvas.gb.loadStringArrayBuffer(33, mapName, true);
        }
        if (mapDetailData == null) {
            mapDetailData = Game_Canvas.gb.loadByteArrayBufferDirect(0, mapDetailData, true, true);
        }
        if (mapTileLoadingDirection == null) {
            mapTileLoadingDirection = Game_Canvas.gb.loadByteArrayBufferDirect(1, mapTileLoadingDirection, false, true);
        }
        if (battleMappingList == null) {
            battleMappingList = Game_Canvas.gb.loadShortArrayBufferDirect(2, battleMappingList, false, true);
        }
        if (miniMapDrawList == null) {
            miniMapDrawList = Game_Canvas.gb.loadByteSingleArrayBufferDirect(29, miniMapDrawList);
        }
    }

    public void removeFieldPosition(int xObjPos, int yObjPos, int unitNum) {
        if (unitNum == this.mapBoard[2][xObjPos][yObjPos]) {
            this.mapBoard[2][xObjPos][yObjPos] = -1;
        }
    }

    public boolean setPosition(int xObjPos, int yObjPos, int unitNum, boolean overwrite) {
        if (overwrite || this.mapBoard[2][xObjPos][yObjPos] == -1) {
            this.mapBoard[2][xObjPos][yObjPos] = (byte)unitNum;
            return true;
        }
        return false;
    }

    public void clearPosition() {
        for (int i = 0; i < this.CURRENT_BLOCK_WIDTH; ++i) {
            for (int j = 0; j < this.CURRENT_BLOCK_HEIGHT; ++j) {
                this.mapBoard[2][i][j] = -1;
            }
        }
    }

    public int getWarMapNumber(int currentFieldTempMap) {
        for (int i = 0; i < battleMappingList.length; ++i) {
            if (currentFieldTempMap != battleMappingList[i][0]) continue;
            if (battleMappingList[i].length == 2) {
                return battleMappingList[i][1];
            }
            return battleMappingList[i][1 + GameControl.getRandom(battleMappingList[i].length - 1)];
        }
        return -1;
    }

    public boolean checkPositionMove(int xPos, int yPos, int unitNum) {
        if (xPos < 0 || yPos < 0 || xPos >= this.CURRENT_BLOCK_WIDTH || yPos >= this.CURRENT_BLOCK_HEIGHT) {
            return false;
        }
        if (this.mapBoard[0][xPos][yPos] >= 30) {
            return false;
        }
        if (this.mapBoard[1][xPos][yPos] >= 0 && this.mapBoard[1][xPos][yPos] <= 39) {
            return false;
        }
        return this.mapBoard[2][xPos][yPos] == -1 || this.mapBoard[2][xPos][yPos] == unitNum;
    }

    public boolean dropUnit(int objectPositionX, int objectPositionY, int unitNum) {
        if (this.checkPositionMove(objectPositionX, objectPositionY, unitNum)) {
            GameControl.unitStatus[unitNum][0] = Game_Canvas.gcon.cOtP(objectPositionX);
            GameControl.unitStatus[unitNum][1] = Game_Canvas.gcon.cOtP(objectPositionY);
            this.setPosition(objectPositionX, objectPositionY, unitNum, true);
            return true;
        }
        for (int i = 0; i <= 7; ++i) {
            for (int j = 0; j <= 7; ++j) {
                int tempPosX = objectPositionX + GameControl.directionResult[i][0] + GameControl.directionResult[j][0];
                int tempPosY = objectPositionY + GameControl.directionResult[i][1] + GameControl.directionResult[j][1];
                if (!this.checkPositionMove(tempPosX, tempPosY, unitNum)) continue;
                GameControl.unitStatus[unitNum][0] = Game_Canvas.gcon.cOtP(tempPosX);
                GameControl.unitStatus[unitNum][1] = Game_Canvas.gcon.cOtP(tempPosY);
                this.setPosition(tempPosX, tempPosY, unitNum, true);
                return true;
            }
        }
        return false;
    }
}

