/*
 * Decompiled with CFR 0.152.
 */
package dragoneyes;

import com.boragame.utils.j2me.PackageReader;
import com.nokia.mid.ui.FullCanvas;
import dragoneyes.DragonEyes;
import dragoneyes.GameBuffer;
import dragoneyes.GameControl;
import dragoneyes.GameMap;
import dragoneyes.GameMenu;
import dragoneyes.GameScreen;
import dragoneyes.ResourceManager;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Game_Canvas
extends FullCanvas
implements Runnable {
    PackageReader pr;
    Thread t = null;
    Font font;
    public static final int KEY_VOL_UP = -1;
    public static final int KEY_VOL_DOWN = -2;
    public static final int KEY_DOWN = -2;
    public static final int KEY_UP = -1;
    public static final int KEY_LEFT = -3;
    public static final int KEY_RIGHT = -4;
    public static final int KEY_FIRE = -5;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    public static final int KEY_SOFTKEY2 = -7;
    public static final int KEY_SOFTKEY1 = -6;
    static Display display;
    static DragonEyes midlet;
    static GameControl gcon;
    static GameMenu gm;
    static GameScreen gs;
    static ResourceManager rm;
    static GameMap fieldMap;
    static GameMap warMap;
    static GameBuffer gb;
    static int SCRWIDTH;
    static int SCRHEIGHT;
    static int CX;
    static int CY;
    static int gamePlayMenuStatus;
    static int gameTimeCount;
    static final int GLT = 20;
    static final int GHT = 17;
    static final int GHV = 3;
    static final int GHB = 65;
    static final int GRV = 10;
    static final int GLV = 6;
    static Graphics g;
    static Graphics mainGraphics;
    static Graphics bufferGraphics;
    static Graphics mapGraphics;
    static byte speedlevel;
    static int speedgap;
    static int keyInput;
    static boolean keyPressed;
    static byte lcnt;
    static boolean lFlag;
    static byte lStatus;
    static int bufferRemakeFlag;
    static byte keyPressedCount;
    int keyPressedCode = 0;
    int keyReleaseCode = 0;
    boolean keyReleaseFlag = false;
    static Image drawBorderImage;
    static byte rankingStatus;
    static Thread thread;
    public boolean quit = false;
    static final byte SAVE_PER_BLOCK = 55;
    static final String[] helpStringBuKey;
    static final String[] helpStringBuAI;
    static final String[] helpString;

    public Game_Canvas(DragonEyes midlet1) {
        midlet = midlet1;
        try {
            this.pr = new PackageReader("/pic11", false);
            this.pr.bufferData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.THREAD_START();
    }

    public void setGamePlayStatus(byte st) {
        gamePlayMenuStatus = st;
        if (gamePlayMenuStatus == 1) {
            rm.loadTotal();
        }
    }

    public void setLoadType(byte type) {
        lcnt = 0;
        lStatus = type;
        this.setGamePlayStatus((byte)3);
    }

    void init() {
        gb = new GameBuffer(this);
        fieldMap = new GameMap(this);
        warMap = new GameMap(this);
        gs = new GameScreen(this);
        gcon = new GameControl(this);
        gm = new GameMenu(this);
        rm = new ResourceManager(this);
        gs.connect();
        gcon.connect();
        rm.loadOption();
        rm.loadTotal();
        rm.init();
        this.setSpeed();
        this.setLoadType((byte)2);
    }

    public void paint(Graphics pg) {
        mainGraphics = pg;
        g = pg;
        if (g != null && GameScreen.myFont != null) {
            g.setFont(GameScreen.myFont);
        }
        switch (gamePlayMenuStatus) {
            case 2: {
                gs.paint();
                break;
            }
            case 1: {
                gm.paint();
            }
        }
    }

    public void changeGraphics(byte gType) {
        switch (gType) {
            case 0: {
                g = mainGraphics;
                break;
            }
            case 1: {
                g = bufferGraphics;
                break;
            }
            case 2: {
                g = mapGraphics;
            }
        }
    }

    public void keyPressed(int code) {
        this.keyPressedCode = code;
    }

    public void keyPressed2(int keyP) {
        if (keyP == -500) {
            return;
        }
        switch (gamePlayMenuStatus) {
            case 2: {
                gs.keyPressed(keyP);
                break;
            }
            case 1: {
                gm.keyPressed(keyP);
            }
        }
        if (keyP == -1) {
            return;
        }
        if (keyP == -2) {
            return;
        }
    }

    public void keyReleased(int code) {
        this.keyReleaseCode = code;
    }

    public void keyReleased2(int keyR) {
        if (keyR != -500) {
            gs.keyReleased(keyR);
        }
    }

    public void setSpeed() {
        switch (speedlevel) {
            case 0: {
                speedgap = 170;
                break;
            }
            case 1: {
                speedgap = 120;
                break;
            }
            case 2: {
                speedgap = 70;
                break;
            }
            case 3: {
                speedgap = 50;
                break;
            }
            default: {
                speedgap = 30;
            }
        }
    }

    public void update() {
        keyPressedCount = 0;
        switch (gamePlayMenuStatus) {
            case 2: {
                gcon.update();
                break;
            }
            case 1: {
                gm.update();
                break;
            }
            case 3: {
                this.updateLoad();
            }
        }
    }

    public void updateLoad() {
        block0 : switch (lStatus) {
            case 0: {
                gcon.init();
                gcon.clearDialogBuffer();
                rm.freeEnemy();
                rm.freeImage(1);
                rm.loadImages(2);
                gcon.setGameStatus(24);
                this.setGamePlayStatus((byte)2);
                break;
            }
            case 1: {
                gcon.init();
                rm.freeEnemy();
                GameControl.nextPortalNum = -1;
                if (!rm.loadPlayer() || !rm.loadData()) {
                    ResourceManager.loadFlag = 0;
                    rm.saveTotal();
                    GameMenu.editFlag = true;
                    this.setGamePlayStatus((byte)1);
                    gm.setMenuStatus(2);
                    break;
                }
                rm.loadTotal();
                rm.freeImage(1);
                rm.loadImages(2);
                gcon.setGameStatus(26);
                this.setGamePlayStatus((byte)2);
                break;
            }
            case 2: {
                switch (lcnt) {
                    case 0: {
                        rm.loadImages(3);
                        break block0;
                    }
                    case 1: {
                        rm.loadImages(4);
                        break block0;
                    }
                    case 2: {
                        rm.loadImages(5);
                        break block0;
                    }
                    case 3: {
                        rm.loadImages(6);
                        break block0;
                    }
                    case 4: {
                        rm.loadImages(1);
                        this.setGamePlayStatus((byte)1);
                        gm.setMenuStatus(11);
                    }
                }
            }
        }
        lcnt = (byte)(lcnt + 1);
    }

    public void run() {
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SCRWIDTH = this.getWidth();
        SCRHEIGHT = this.getHeight() + 16;
        CX = SCRWIDTH / 2;
        CY = SCRHEIGHT / 2;
        this.init();
        while (!this.quit) {
            long t1 = System.currentTimeMillis();
            this.updateTimeCount();
            this.update();
            int keyP = this.keyPressedCode;
            this.keyPressedCode = -500;
            this.keyPressed2(keyP);
            int keyR = this.keyReleaseCode;
            this.keyReleaseCode = -500;
            this.keyReleased2(keyR);
            this.repaint(0, 0, SCRWIDTH, SCRHEIGHT);
            this.serviceRepaints();
            long t2 = System.currentTimeMillis();
            try {
                if (gamePlayMenuStatus != 3) {
                    if (t2 - t1 >= (long)speedgap) continue;
                    Thread.sleep((long)speedgap - (t2 - t1));
                    continue;
                }
                Thread.sleep(10L);
            }
            catch (Exception e) {}
        }
        this.quitApp();
    }

    public void quitApp() {
        rm.stop();
        midlet.notifyDestroyed();
    }

    public void freeAll() {
        rm.freeImage(2);
        gcon.clearCheckEnemyFlag();
        rm.freeEnemy();
        gcon.clearObjectCheckFlag();
        rm.freeObject();
    }

    public void THREAD_START() {
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
        }
    }

    public void THREAD_STOP() {
        if (this.t != null) {
            this.quit = true;
            this.t = null;
        }
    }

    public void showNotify() {
        try {
            if (rm != null && Game_Canvas.rm.soundplayer != null) {
                Game_Canvas.rm.soundplayer.resumeSound();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideNotify() {
        if (GameControl.gameStatus == 10) {
            GameControl.menuIndex = (byte)7;
            this.keyPressed(-6);
        }
        try {
            Game_Canvas.rm.soundplayer.pauseSound();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBufferFlag(int bm) {
        bufferRemakeFlag = bm;
    }

    public int drawNumber(int inputNumber, int xPosition, int yPosition, int drawType, int drawCount, int margin, boolean direction) {
        int tempNumber = inputNumber;
        int numberCount = 0;
        int coordStartNumber = drawType + 27;
        if (inputNumber < 0) {
            inputNumber = 0;
        }
        if (inputNumber == 0) {
            numberCount = 1;
        } else {
            while (tempNumber > 0) {
                tempNumber /= 10;
                ++numberCount;
            }
        }
        if (numberCount < drawCount) {
            numberCount = drawCount;
        }
        int startPosition = direction ? xPosition + ResourceManager.txt6Coord[coordStartNumber][2] * numberCount + margin * (numberCount - 1) : xPosition;
        tempNumber = inputNumber;
        for (int i = 0; i < numberCount; ++i) {
            startPosition -= ResourceManager.txt6Coord[coordStartNumber][2];
            this.drawImage(ResourceManager.img_txt6, rm.getImageCoord(tempNumber % 10, ResourceManager.txt6Coord[coordStartNumber][0], ResourceManager.txt6Coord[coordStartNumber][1], ResourceManager.txt6Coord[coordStartNumber][2], ResourceManager.txt6Coord[coordStartNumber][3]), startPosition, yPosition);
            if (tempNumber > 0) {
                tempNumber /= 10;
            }
            startPosition -= margin;
        }
        return direction ? startPosition + ResourceManager.txt6Coord[coordStartNumber][2] * numberCount + margin * (numberCount - 1) : startPosition;
    }

    public int drawCharsNumber(char[] numberArray, int xPosition, int yPosition, int drawType, int margin, int endCount) {
        int i;
        int numberCount = 0;
        int coordStartNumber = drawType + 27;
        numberCount = numberArray.length;
        int startPosition = xPosition;
        int j = 0;
        for (i = numberCount - 1; i >= 0 && (numberArray[i] < '0' || numberArray[i] > '9' || ++j < endCount); --i) {
        }
        if (i < 0) {
            i = 0;
        }
        while (i < numberCount) {
            if (numberArray[i] >= '0' && numberArray[i] <= '9') {
                this.drawImage(ResourceManager.img_txt6, rm.getImageCoord((numberArray[i] - 48) % 10, ResourceManager.txt6Coord[coordStartNumber][0], ResourceManager.txt6Coord[coordStartNumber][1], ResourceManager.txt6Coord[coordStartNumber][2], ResourceManager.txt6Coord[coordStartNumber][3]), startPosition, yPosition);
                startPosition += ResourceManager.txt6Coord[coordStartNumber][2] + margin;
            }
            ++i;
        }
        return startPosition;
    }

    public void drawBorder(int sx, int sy, int sw, int sh, int type) {
        int sn = 0;
        switch (type) {
            case 0: {
                drawBorderImage = ResourceManager.img_txt6;
                sn = 0;
                break;
            }
            case 1: {
                drawBorderImage = ResourceManager.img_txt6;
                sn = 16;
            }
            case 2: {
                drawBorderImage = ResourceManager.img_txt6;
                sn = 24;
                break;
            }
            case 3: {
                drawBorderImage = ResourceManager.img_txt6;
                sn = 32;
                break;
            }
            case 4: {
                drawBorderImage = ResourceManager.img_txt5;
                sn = 40;
                break;
            }
            case 5: {
                drawBorderImage = ResourceManager.img_txt6;
                sn = 48;
                break;
            }
            case 6: {
                drawBorderImage = ResourceManager.img_txt6;
                sn = 60;
                break;
            }
            case 7: {
                drawBorderImage = ResourceManager.img_item;
                sn = 68;
                break;
            }
            default: {
                return;
            }
        }
        int j = ResourceManager.gameIngameMenuCoord[sn][3];
        while (true) {
            if (j >= sh - ResourceManager.gameIngameMenuCoord[sn + 3][3] - ResourceManager.gameIngameMenuCoord[sn + 5][3]) break;
            this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 5], sx, sy + j);
            this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 6], sx + sw - ResourceManager.gameIngameMenuCoord[sn + 6][2], sy + j);
            j += ResourceManager.gameIngameMenuCoord[sn + 5][3];
        }
        if (j != sy + sh - ResourceManager.gameIngameMenuCoord[sn + 2][3]) {
            this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 5], sx, sy + sh - ResourceManager.gameIngameMenuCoord[sn + 5][3] - ResourceManager.gameIngameMenuCoord[sn + 2][3]);
            this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 6], sx + sw - ResourceManager.gameIngameMenuCoord[sn + 6][2], sy + sh - ResourceManager.gameIngameMenuCoord[sn + 6][3] - ResourceManager.gameIngameMenuCoord[sn + 3][3]);
        }
        j = ResourceManager.gameIngameMenuCoord[sn][2];
        while (true) {
            if (j > sw - ResourceManager.gameIngameMenuCoord[sn + 1][2] - ResourceManager.gameIngameMenuCoord[sn + 4][2]) break;
            this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 4], sx + j, sy);
            this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 7], sx + j, sy + sh - ResourceManager.gameIngameMenuCoord[sn + 7][3]);
            j += ResourceManager.gameIngameMenuCoord[sn + 4][2];
        }
        if (j != sx + sw - ResourceManager.gameIngameMenuCoord[sn + 1][2]) {
            this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 4], sx + sw - ResourceManager.gameIngameMenuCoord[sn + 4][2] - ResourceManager.gameIngameMenuCoord[sn + 1][2], sy);
            this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 7], sx + sw - ResourceManager.gameIngameMenuCoord[sn + 4][2] - ResourceManager.gameIngameMenuCoord[sn + 3][2], sy + sh - ResourceManager.gameIngameMenuCoord[sn + 7][3]);
        }
        this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn], sx, sy);
        this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 2], sx, sy + sh - ResourceManager.gameIngameMenuCoord[sn + 2][3]);
        this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 1], sx + sw - ResourceManager.gameIngameMenuCoord[sn + 1][2], sy);
        this.drawImage(drawBorderImage, ResourceManager.gameIngameMenuCoord[sn + 3], sx + sw - ResourceManager.gameIngameMenuCoord[sn + 3][2], sy + sh - ResourceManager.gameIngameMenuCoord[sn + 3][3]);
        drawBorderImage = null;
    }

    public void updateTimeCount() {
        if (++gameTimeCount == Integer.MAX_VALUE) {
            gameTimeCount = 0;
        }
    }

    public void end() {
        midlet.notifyDestroyed();
    }

    public void drawImage(Image img, int x, int y, int align) {
        g.setClip(0, 0, SCRWIDTH, SCRHEIGHT);
        g.drawImage(img, x, y, align);
    }

    public void drawImage(Image img, int[] imgcoord, int x, int y) {
        g.setClip(x, y, imgcoord[2], imgcoord[3]);
        g.drawImage(img, x - imgcoord[0], y - imgcoord[1], 20);
    }

    public void drawImage(Image img, byte[] imgcoord, int x, int y) {
        g.setClip(x, y, (int)imgcoord[2], (int)imgcoord[3]);
        g.drawImage(img, x - imgcoord[0], y - imgcoord[1], 20);
    }

    public void drawImage(Image img, char[] imgcoord, int x, int y) {
        g.setClip(x, y, (int)imgcoord[2], (int)imgcoord[3]);
        g.drawImage(img, x - imgcoord[0], y - imgcoord[1], 20);
    }

    public void drawImageCenter(Image img, int x, int y) {
        g.drawImage(img, x, y, 3);
    }

    public void drawImageCenter(Image img, char[] imgcoord, int x, int y) {
        g.setClip(x - imgcoord[2] / 2, y - imgcoord[3] / 2, (int)imgcoord[2], (int)imgcoord[3]);
        g.drawImage(img, x - imgcoord[2] / 2 - imgcoord[0], y - imgcoord[3] / 2 - imgcoord[1], 20);
    }

    public void drawImageCenter(Image img, int[] imgcoord, int x, int y) {
        g.setClip(x - imgcoord[2] / 2, y - imgcoord[3] / 2, imgcoord[2], imgcoord[3]);
        g.drawImage(img, x - imgcoord[2] / 2 - imgcoord[0], y - imgcoord[3] / 2 - imgcoord[1], 20);
    }

    public void drawImageCenter(Image img, byte[] imgcoord, int x, int y) {
        g.setClip(x - imgcoord[2] / 2, y - imgcoord[3] / 2, (int)imgcoord[2], (int)imgcoord[3]);
        g.drawImage(img, x - imgcoord[2] / 2 - imgcoord[0], y - imgcoord[3] / 2 - imgcoord[1], 20);
    }

    public void drawImage(Image img, int x, int y) {
        g.setClip(0, 0, SCRWIDTH, SCRHEIGHT);
        g.drawImage(img, x, y, 20);
    }

    public void fillScreen(int tcolor) {
        g.setClip(0, 0, SCRWIDTH, SCRHEIGHT);
        g.setColor(tcolor);
        g.fillRect(0, 0, SCRWIDTH, SCRHEIGHT);
    }

    public void fillArea(int tcolor, int x, int y, int w, int h) {
        g.setClip(0, 0, SCRWIDTH, SCRHEIGHT);
        g.setColor(tcolor);
        g.fillRect(x, y, w, h);
    }

    public void drawOption() {
        int sx = CX - 24;
        int sy = CY - 40;
        g.setClip(0, 0, SCRWIDTH, SCRHEIGHT);
        g.setColor(0xFFFFFF);
        g.drawString("sound", sx, sy, 20);
        g.drawString("speed", sx, sy + 60, 20);
        g.drawString(ResourceManager.soundFlag ? "ON" : "OFF", sx + 42, sy, 20);
        g.drawString(GameScreen.numberChar[speedlevel + 1], sx + 46, sy + 60, 20);
        block3: for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 1: {
                    continue block3;
                }
                default: {
                    this.drawImage(ResourceManager.img_txt6, rm.getImageCoord(i, 60, 65, 19, 15), sx - 20, sy - 1 + i * 30);
                }
            }
        }
        this.drawImage(ResourceManager.img_txt6, ResourceManager.txt6Coord[20], sx + 33, sy + 3 + GameControl.menuSelectStep * 60);
        this.drawImage(ResourceManager.img_txt6, ResourceManager.txt6Coord[21], sx + 63, sy + 3 + GameControl.menuSelectStep * 60);
    }

    public void drawLoadSaved() {
        byte i = 0;
        this.drawBorder(CX - 52, CY - 46, 104, 51, 2);
        g.setClip(0, 0, SCRWIDTH, SCRHEIGHT);
        g.setColor(0xFFFFFF);
        if (ResourceManager.loadFlag == 0) {
            g.drawString("EMPTY", CX, CY - 36 + i * 55, 17);
        } else if (GameMap.mapName[ResourceManager.loadStageName] != null) {
            if (i == GameControl.menuSelectStep) {
                g.setColor(65535);
            } else {
                g.setColor(0xFFFFFF);
            }
            g.drawString(GameMap.mapName[ResourceManager.loadStageName], CX, CY - 43 + i * 55, 17);
            if (ResourceManager.loadLevel[0] > 0) {
                this.drawImage(ResourceManager.img_txt6, ResourceManager.txt6Coord[11], CX - 48, CY - 29 + i * 55);
                this.drawNumber(ResourceManager.loadLevel[0], CX - 18, CY - 25, 2, 0, 0, false);
            }
            if (ResourceManager.loadLevel[1] > 0) {
                this.drawImage(ResourceManager.img_txt6, ResourceManager.txt6Coord[12], CX - 17, CY - 28 + i * 55);
                this.drawNumber(ResourceManager.loadLevel[1], CX + 16, CY - 25, 2, 0, -1, false);
            }
            if (ResourceManager.loadLevel[2] > 0) {
                this.drawImage(ResourceManager.img_txt6, ResourceManager.txt6Coord[13], CX + 17, CY - 28 + i * 55);
                this.drawNumber(ResourceManager.loadLevel[2], CX + 49, CY - 25, 2, 0, -1, false);
            }
            this.drawClock(GameControl.checkTime, CX + 45, CY - 8, 0);
        }
    }

    public void drawClock(long timeNumber, int xpos, int ypos, int margin) {
        int i = this.drawNumber((int)(timeNumber % 100L), xpos, ypos, 1, 2, margin, false);
        if (margin < 0) {
            i += margin;
        }
        this.drawImage(ResourceManager.img_txt5, ResourceManager.menuTextNewCoord[63], i - 1, ypos);
        i = this.drawNumber((int)(timeNumber / 100L % 100L), i - 1, ypos, 1, 2, margin, false);
        if (margin < 0) {
            i += margin;
        }
        this.drawImage(ResourceManager.img_txt5, ResourceManager.menuTextNewCoord[63], i - 1, ypos);
        this.drawNumber((int)(timeNumber / 10000L), i - 1, ypos, 1, 0, margin, false);
    }

    public void drawHelp() {
        g.setClip(0, 0, SCRWIDTH, SCRHEIGHT);
        g.setColor(0xFFFFFF);
        g.drawString(helpString[GameControl.menuSelectStep + 3], CX, CY - 45, 17);
        CX += 3;
        if (GameControl.menuSelectStep == 0) {
            if (GameScreen.currentStartLineNum > 10) {
                switch (GameScreen.currentStartLineNum) {
                    case 11: {
                        g.drawString(helpStringBuKey[0], CX - 50, CY + 41, 20);
                        break;
                    }
                    case 12: {
                        g.drawString(helpStringBuKey[0], CX - 50, CY + 26, 20);
                        g.drawString(helpStringBuKey[1], CX - 50, CY + 41, 20);
                        break;
                    }
                    case 13: {
                        g.drawString(helpStringBuKey[0], CX - 50, CY + 11, 20);
                        g.drawString(helpStringBuKey[1], CX - 50, CY + 26, 20);
                        g.drawString(helpStringBuKey[2], CX - 50, CY + 41, 20);
                        break;
                    }
                    case 14: {
                        g.drawString(helpStringBuKey[0], CX - 50, CY - 4, 20);
                        g.drawString(helpStringBuKey[1], CX - 50, CY + 11, 20);
                        g.drawString(helpStringBuKey[2], CX - 50, CY + 26, 20);
                        g.drawString(helpStringBuKey[3], CX - 50, CY + 41, 20);
                        break;
                    }
                    case 15: {
                        g.drawString(helpStringBuKey[0], CX - 50, CY - 19, 20);
                        g.drawString(helpStringBuKey[1], CX - 50, CY - 4, 20);
                        g.drawString(helpStringBuKey[2], CX - 50, CY + 11, 20);
                        g.drawString(helpStringBuKey[3], CX - 50, CY + 26, 20);
                        g.drawString(helpStringBuKey[4], CX - 50, CY + 41, 20);
                    }
                }
            }
        } else if (GameControl.menuSelectStep == 2) {
            if (GameScreen.currentStartLineNum > 7) {
                switch (GameScreen.currentStartLineNum) {
                    case 8: {
                        g.drawString(helpStringBuAI[0], CX - 50, CY + 41, 20);
                        break;
                    }
                    case 9: {
                        g.drawString(helpStringBuAI[0], CX - 50, CY + 26, 20);
                        g.drawString(helpStringBuAI[1], CX - 50, CY + 41, 20);
                        break;
                    }
                    case 10: {
                        g.drawString(helpStringBuAI[0], CX - 50, CY + 11, 20);
                        g.drawString(helpStringBuAI[1], CX - 50, CY + 26, 20);
                        g.drawString(helpStringBuAI[2], CX - 50, CY + 41, 20);
                        break;
                    }
                    case 11: {
                        g.drawString(helpStringBuAI[0], CX - 50, CY - 4, 20);
                        g.drawString(helpStringBuAI[1], CX - 50, CY + 11, 20);
                        g.drawString(helpStringBuAI[2], CX - 50, CY + 26, 20);
                        g.drawString(helpStringBuAI[3], CX - 50, CY + 41, 20);
                    }
                }
            }
        }
        gs.drawText(helpString[GameControl.menuSelectStep], CX - 50, CY - 33, 90, 90, 0, 1);
        CX -= 3;
        if (GameScreen.currentTotalLineNum > GameScreen.currentPrintEnableHeight) {
            if (GameScreen.currentStartLineNum != 0) {
                this.drawImageCenter(ResourceManager.img_item, ResourceManager.gameIngameMenuCoord[14], CX + 42, CY - 33);
            }
            if (GameControl.menuSelectStep == 0) {
                if (GameScreen.currentTotalLineNum + 5 > GameScreen.currentStartLineNum + GameScreen.currentPrintEnableHeight) {
                    this.drawImageCenter(ResourceManager.img_item, ResourceManager.gameIngameMenuCoord[15], CX + 42, CY + 52);
                }
            } else if (GameControl.menuSelectStep == 2) {
                if (GameScreen.currentTotalLineNum + 4 > GameScreen.currentStartLineNum + GameScreen.currentPrintEnableHeight) {
                    this.drawImageCenter(ResourceManager.img_item, ResourceManager.gameIngameMenuCoord[15], CX + 42, CY + 52);
                }
            } else if (GameScreen.currentTotalLineNum > GameScreen.currentStartLineNum + GameScreen.currentPrintEnableHeight) {
                this.drawImageCenter(ResourceManager.img_item, ResourceManager.gameIngameMenuCoord[15], CX + 42, CY + 52);
            }
        }
        this.drawImageCenter(ResourceManager.img_item, ResourceManager.gameIngameMenuCoord[12], CX - 25, CY - 38);
        this.drawImageCenter(ResourceManager.img_item, ResourceManager.gameIngameMenuCoord[13], CX + 25, CY - 38);
    }

    static {
        gameTimeCount = 0;
        speedlevel = (byte)4;
        speedgap = 10;
        keyInput = 0;
        keyPressed = false;
        lcnt = 0;
        lFlag = false;
        lStatus = 0;
        bufferRemakeFlag = 2;
        keyPressedCount = 0;
        drawBorderImage = null;
        rankingStatus = 0;
        helpStringBuKey = new String[]{"1,3: leader change", "*,7: quick skill", "#,9: quick item", "0: change", "battle order"};
        helpStringBuAI = new String[]{"automatic skill:", "press ON,", "use quick slot's", "skill except leader"};
        helpString = new String[]{"field|director key,2,4,6,8: character movement|5, confirm key: item confirm,dialog|1,3: change leader|7: show item bar|#: minimap|battle|director key,2,4,6,8: character mivement|5, confirm key: attack", "HP: life power|MP: lefted mana|ATK: attack power in physic|DEF: defense power inphysic|MATK: skill attack power|MDEF: Skill's defense power|SP: get skill point", "battle freely: characters battle freely without leader|maintain place: not move attack enemies that getting in attack scope only|crowding order:leader in center move with certain distance", "key", "start", "A.I."};
    }
}

