/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.game;

import com.jarbull.efw.game.EFLayer;
import javax.microedition.lcdui.Graphics;

public class EFLayerManager {
    private int nlayers;
    private EFLayer[] component = new EFLayer[4];
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;

    public EFLayerManager() {
        this.setViewWindow(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void append(EFLayer l) {
        this.removeImpl(l);
        this.addImpl(l, this.nlayers);
    }

    public void insert(EFLayer l, int index) {
        if (index < 0 || index > this.nlayers || this.exist(l) && index >= this.nlayers) {
            throw new IndexOutOfBoundsException();
        }
        this.removeImpl(l);
        this.addImpl(l, index);
    }

    public EFLayer getLayerAt(int index) {
        if (index < 0 || index >= this.nlayers) {
            throw new IndexOutOfBoundsException();
        }
        return this.component[index];
    }

    public int getSize() {
        return this.nlayers;
    }

    public void remove(EFLayer l) {
        this.removeImpl(l);
    }

    public void removeByID(int index) {
        this.remove(index);
    }

    public void removeAllLayers() {
        int i = this.nlayers;
        while (--i >= 0) {
            this.remove(i);
        }
    }

    public void paint(Graphics g, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.translate(x - this.viewX, y - this.viewY);
        g.clipRect(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        int i = this.nlayers;
        while (--i >= 0) {
            EFLayer comp = this.component[i];
            if (!comp.visible) continue;
            comp.paint(g);
        }
        g.translate(-x + this.viewX, -y + this.viewY);
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public void setViewWindow(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.viewX = x;
        this.viewY = y;
        this.viewWidth = width;
        this.viewHeight = height;
    }

    private void addImpl(EFLayer layer, int index) {
        if (this.nlayers == this.component.length) {
            EFLayer[] newcomponents = new EFLayer[this.nlayers + 4];
            System.arraycopy(this.component, 0, newcomponents, 0, this.nlayers);
            System.arraycopy(this.component, index, newcomponents, index + 1, this.nlayers - index);
            this.component = newcomponents;
        } else {
            System.arraycopy(this.component, index, this.component, index + 1, this.nlayers - index);
        }
        this.component[index] = layer;
        ++this.nlayers;
    }

    private void removeImpl(EFLayer l) {
        if (l == null) {
            throw new NullPointerException();
        }
        int i = this.nlayers;
        while (--i >= 0) {
            if (this.component[i] != l) continue;
            this.remove(i);
        }
    }

    private boolean exist(EFLayer l) {
        if (l == null) {
            return false;
        }
        int i = this.nlayers;
        while (--i >= 0) {
            if (this.component[i] != l) continue;
            return true;
        }
        return false;
    }

    private void remove(int index) {
        System.arraycopy(this.component, index + 1, this.component, index, this.nlayers - index - 1);
        this.component[--this.nlayers] = null;
    }
}

