/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.game;

import com.jarbull.efw.controller.IMemoryListener;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.Level;
import com.jarbull.efw.manager.EMidlet;
import java.util.Vector;

public class LevelHolder {
    private static final LevelHolder INSTANCE = new LevelHolder();
    private int currentLevel;
    private Vector levelList = new Vector();

    public static LevelHolder getInstance() {
        return INSTANCE;
    }

    private LevelHolder() {
    }

    public int getCurrentTotalScore() {
        int totalScore = 0;
        for (int i = 0; i < this.levelList.size(); ++i) {
            Level level = (Level)this.levelList.elementAt(i);
            totalScore += level.getCurrentScore();
        }
        return totalScore;
    }

    public int getBestTotalScore() {
        int totalScore = 0;
        for (int i = 0; i < this.levelList.size(); ++i) {
            Level level = (Level)this.levelList.elementAt(i);
            totalScore += level.getBestScore();
        }
        return totalScore;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public int nextLevel() {
        if (this.currentLevel < this.levelList.size()) {
            this.setCurrentLevel(this.currentLevel + 1, false);
        }
        return this.currentLevel + 1;
    }

    public Level getLevel(int levelIndex) {
        return (Level)this.levelList.elementAt(levelIndex);
    }

    public void setCurrentLevel(final int currentLevel, final boolean firstStart) {
        if (!this.levelList.isEmpty()) {
            ((Level)this.levelList.elementAt(this.currentLevel)).unload();
        }
        this.currentLevel = currentLevel;
        final IMemoryListener oldListener = ImageHandler.getInstance().getListener();
        IMemoryListener listener = new IMemoryListener(){

            public void onHandlerLoaded() {
                if (firstStart) {
                    EMidlet.getInstance().start();
                }
                EMidlet.getInstance().getUserCanvas().levelChanged(currentLevel);
                if (oldListener != null) {
                    oldListener.onHandlerLoaded();
                }
                EMidlet.getInstance().pauseGame(false);
            }
        };
        ImageHandler.getInstance().setListener(listener);
        ((Level)this.levelList.elementAt(this.currentLevel)).load();
    }

    public int getLevelCount() {
        return this.levelList.size();
    }

    public void addLevel(Level level) {
        this.levelList.addElement(level);
    }

    public void removeLevel(int index) {
        this.levelList.removeElementAt(index);
    }

    public void clearAll() {
        this.levelList.removeAllElements();
    }

    public void resetAllLevels() {
        for (int i = 0; i < this.getLevelCount(); ++i) {
            Level lvl = (Level)this.levelList.elementAt(i);
            lvl.setCurrentScore(0);
            lvl.setBestScore(0);
            lvl.setLevelStatus(0);
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.saveAllLevels();
    }

    public void saveAllLevels() {
        for (int i = 0; i < this.getLevelCount(); ++i) {
            Level lvl = (Level)this.levelList.elementAt(i);
            lvl.saveLevelInfo();
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void loadAllLevels() {
        for (int i = 0; i < this.getLevelCount(); ++i) {
            Level lvl = (Level)this.levelList.elementAt(i);
            lvl.loadLevelInfo();
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

