/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.input;

import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.input.IController;
import com.jarbull.efw.input.Point;
import com.jarbull.efw.util.MathEx;
import java.util.Vector;

public class TouchPad
implements IController {
    private Vector pathPoints = new Vector();
    private boolean enabled;
    private boolean supported;

    public Point adaptXY(Point pt) {
        int newX = ResolutionHandler.getInstance().adaptX(pt.getX(), pt.getY());
        int newY = ResolutionHandler.getInstance().adaptY(pt.getX(), pt.getY());
        return new Point(newX, newY);
    }

    public Point adaptXY(Point pt, boolean save) {
        if (save) {
            this.pathPoints.addElement(pt);
        }
        return this.adaptXY(pt);
    }

    public int getDirectionAngle() {
        int total = 0;
        Point firstPoint = (Point)this.pathPoints.elementAt(0);
        for (int i = 1; i < this.pathPoints.size(); ++i) {
            total += MathEx.getLineAngle(firstPoint, (Point)this.pathPoints.elementAt(i));
        }
        return total / (this.pathPoints.size() - 1);
    }

    public void clearPath() {
        this.pathPoints.removeAllElements();
    }

    public boolean checkCollisionWithPath(int x, int y, int width, int height) {
        for (int i = 0; i < this.pathPoints.size(); ++i) {
            Point pnt = (Point)this.pathPoints.elementAt(i);
            if (pnt.getX() < x || pnt.getX() > x + width || pnt.getY() < y || pnt.getY() > y + height) continue;
            return true;
        }
        return false;
    }

    public Point[] getPath() {
        Point[] pathArray = new Point[this.pathPoints.size()];
        for (int i = 0; i < this.pathPoints.size(); ++i) {
            pathArray[i] = (Point)this.pathPoints.elementAt(i);
        }
        return pathArray;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSupported() {
        return this.supported;
    }
}

