/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.manager;

import com.jarbull.efw.manager.Advertisement;
import com.jarbull.efw.manager.GameModeHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

class AdXmlReader {
    private static final AdXmlReader INSTANCE = new AdXmlReader();
    public long parseTime;

    AdXmlReader() {
    }

    public static AdXmlReader getInstance() {
        return INSTANCE;
    }

    private void readTextAd(KXmlParser parser) throws XmlPullParserException, IOException {
        Advertisement ad = new Advertisement();
        ad.setAdType(0);
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            String text = parser.nextText();
            if (name.equals("alive_time")) {
                ad.setAliveTime(Integer.parseInt(text));
                continue;
            }
            if (name.equals("text_ad_text")) {
                ad.setAdData(text);
                continue;
            }
            if (!name.equals("text_ad_link")) continue;
            if (text.indexOf("http://") == -1) {
                ad.setAddress("http://" + text);
                continue;
            }
            ad.setAddress(text);
        }
        GameModeHandler.getInstance().addAdvertisement(ad);
    }

    private void readImageAd(KXmlParser parser) throws XmlPullParserException, IOException {
        Advertisement ad = new Advertisement();
        ad.setAdType(1);
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            String text = parser.nextText();
            if (name.equals("alive_time")) {
                ad.setAliveTime(Integer.parseInt(text));
                continue;
            }
            if (name.equals("image_ad_src")) {
                ad.askRemoteImage(text);
                continue;
            }
            if (!name.equals("image_ad_link")) continue;
            if (text.indexOf("http://") == -1) {
                ad.setAddress("http://" + text);
                continue;
            }
            ad.setAddress(text);
        }
        GameModeHandler.getInstance().addAdvertisement(ad);
    }

    public void readAdXml(String xmlPath) {
        try {
            KXmlParser parser = new KXmlParser();
            parser.setInput(new InputStreamReader(this.getClass().getResourceAsStream(xmlPath)));
            parser.nextTag();
            while (parser.nextTag() != 3) {
                if (parser.getName().equals("text_ad")) {
                    this.readTextAd(parser);
                    continue;
                }
                this.readImageAd(parser);
            }
            this.parseTime = System.currentTimeMillis();
            parser.next();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readAdString(String stringToParse) {
        try {
            KXmlParser parser = new KXmlParser();
            ByteArrayInputStream a = new ByteArrayInputStream(stringToParse.getBytes());
            parser.setInput(new InputStreamReader(a));
            parser.nextTag();
            while (parser.nextTag() != 3) {
                if (parser.getName().equals("text_ad")) {
                    this.readTextAd(parser);
                    continue;
                }
                this.readImageAd(parser);
            }
            this.parseTime = System.currentTimeMillis();
            parser.next();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

