/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.text;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.text.EFont;
import com.jarbull.efw.text.TextWriter;
import javax.microedition.lcdui.Graphics;

class WexWriter {
    private static final WexWriter INSTANCE = new WexWriter();

    WexWriter() {
    }

    public static WexWriter getInstance() {
        return INSTANCE;
    }

    void drawText(Graphics g, String text, int x, int y, int anchor, EFont font) {
        int[] arr = (int[])font.getMappingHash().get(text);
        if (arr == null) {
            arr = (int[])font.getMappingHash().get("?");
        }
        if (ImageHandler.getInstance().getImage(font.getFontImagePath()) == null) {
            ImageHandler.getInstance().load(font.getFontImagePath());
        }
        g.drawRegion(ImageHandler.getInstance().getImage(font.getFontImagePath()), arr[0], arr[1], arr[2], arr[3], TextWriter.getInstance().getOrientation(), x, y, anchor);
    }

    int getTextWidth(String text, EFont font) {
        int[] arr = (int[])font.getMappingHash().get(text);
        if (arr == null) {
            arr = (int[])font.getMappingHash().get("?");
        }
        switch (TextWriter.getInstance().getOrientation()) {
            case 0: 
            case 3: {
                return arr[2];
            }
            case 5: 
            case 6: {
                return arr[3];
            }
        }
        return -1;
    }

    int getTextHeight(String text, EFont font) {
        int[] arr = (int[])font.getMappingHash().get(text);
        if (arr == null) {
            arr = (int[])font.getMappingHash().get("?");
        }
        switch (TextWriter.getInstance().getOrientation()) {
            case 0: 
            case 3: {
                return arr[3];
            }
            case 5: 
            case 6: {
                return arr[2];
            }
        }
        return -1;
    }
}

