/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.ui.IScreen;
import com.jarbull.efw.ui.Screen;
import java.util.Enumeration;
import java.util.Hashtable;

public class ScreenHolder {
    private static final ScreenHolder INSTANCE = new ScreenHolder();
    private Hashtable disposableScreens = new Hashtable();
    private Hashtable nondisposableScreens = new Hashtable();
    private String activeScreenId;

    private ScreenHolder() {
    }

    public static ScreenHolder getInstance() {
        return INSTANCE;
    }

    public String getActiveScreenId() {
        return this.activeScreenId;
    }

    public void setActiveScreenId(String activeScreenId) {
        Screen screen;
        if (this.activeScreenId != null) {
            try {
                screen = (Screen)this.getScreen(this.activeScreenId);
                screen.cancelAutoAction();
                if (screen.actionListener != null) {
                    screen.actionListener.onClose();
                }
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
        }
        this.activeScreenId = activeScreenId;
        try {
            screen = (Screen)this.getScreen(this.activeScreenId);
            if (screen.actionListener != null) {
                screen.actionListener.onShown();
            }
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        IScreen iScreen = this.getScreen(activeScreenId);
        if (iScreen instanceof Screen) {
            ((Screen)iScreen).activateAutoAction();
        }
    }

    public Enumeration getScreens() {
        Enumeration result = new Enumeration(){
            Enumeration disposables;
            Enumeration nondisposables;
            {
                this.disposables = ScreenHolder.this.disposableScreens.elements();
                this.nondisposables = ScreenHolder.this.nondisposableScreens.elements();
            }

            public boolean hasMoreElements() {
                return this.disposables.hasMoreElements() || this.nondisposables.hasMoreElements();
            }

            public Object nextElement() {
                if (this.disposables.hasMoreElements()) {
                    return this.disposables.nextElement();
                }
                return this.nondisposables.nextElement();
            }
        };
        return result;
    }

    public synchronized IScreen getScreen(String id) {
        if (this.disposableScreens.containsKey(id)) {
            return (IScreen)this.disposableScreens.get(id);
        }
        if (this.nondisposableScreens.containsKey(id)) {
            return (IScreen)this.nondisposableScreens.get(id);
        }
        return null;
    }

    public synchronized void addScreen(IScreen screen, boolean disposable) {
        if (disposable) {
            this.disposableScreens.put(screen.getId(), screen);
        } else {
            this.nondisposableScreens.put(screen.getId(), screen);
        }
    }

    public void removeScreen(String id) {
        if (this.nondisposableScreens.containsKey(id)) {
            throw new IllegalArgumentException();
        }
        if (this.disposableScreens.containsKey(id)) {
            this.disposableScreens.remove(id);
        }
    }

    public void clear() {
        this.disposableScreens.clear();
    }

    public int getScreenCount() {
        return this.disposableScreens.size() + this.nondisposableScreens.size();
    }
}

