/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.util;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.util.FP;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageEx {
    private static final int FP_PI_OVER_180 = FP.Div(205887, FP.intToFP(180));
    private static final int FP_256 = FP.intToFP(256);

    private ImageEx() {
    }

    public static Image setImageAlpha(String imageId, int alpha) {
        int[] pixels = new int[ImageHandler.getInstance().getImage(imageId).getWidth() * ImageHandler.getInstance().getImage(imageId).getHeight()];
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = alpha << 24 & 0xFF000000 | pixels[i] & 0xFFFFFF;
        }
        return Image.createRGBImage((int[])pixels, (int)ImageHandler.getInstance().getImage(imageId).getWidth(), (int)ImageHandler.getInstance().getImage(imageId).getHeight(), (boolean)true);
    }

    public static Image resizeImage(Image src, int newWidth, int newHeight, boolean transparent) {
        int sourceWidth = src.getWidth();
        int sourceHeight = src.getHeight();
        Image tempImage = src;
        if (sourceWidth != newWidth) {
            tempImage = Image.createImage((int)newWidth, (int)sourceHeight);
            Graphics g = tempImage.getGraphics();
            int ratio = (sourceWidth << 16) / newWidth;
            int pos = ratio / 2;
            for (int x = 0; x < newWidth; ++x) {
                g.setClip(x, 0, 1, sourceHeight);
                g.drawImage(src, x - (pos >> 16), 0, 20);
                pos += ratio;
            }
        }
        Image resizedImage = tempImage;
        if (sourceHeight != newHeight) {
            resizedImage = Image.createImage((int)newWidth, (int)newHeight);
            Graphics g = resizedImage.getGraphics();
            int ratio = (sourceHeight << 16) / newHeight;
            int pos = ratio / 2;
            for (int y = 0; y < newHeight; ++y) {
                g.setClip(0, y, newWidth, 1);
                g.drawImage(tempImage, 0, y - (pos >> 16), 20);
                pos += ratio;
            }
        }
        if (transparent) {
            int[] rgbData = new int[newWidth * newHeight];
            resizedImage.getRGB(rgbData, 0, resizedImage.getWidth(), 0, 0, resizedImage.getWidth(), resizedImage.getHeight());
            for (int i = 0; i < rgbData.length; ++i) {
                if ((rgbData[i] & 0xFFFFFF) >> 24 <= 250) continue;
                rgbData[i] = 0;
            }
            resizedImage = Image.createRGBImage((int[])rgbData, (int)resizedImage.getWidth(), (int)resizedImage.getHeight(), (boolean)true);
        }
        return resizedImage;
    }

    public static Image rotateImage(Image src, int angle) {
        int sw = src.getWidth();
        int sh = src.getHeight();
        int[] srcData = new int[sw * sh];
        src.getRGB(srcData, 0, sw, 0, 0, sw, sh);
        int[] dstData = new int[sw * sh];
        int fpRads = FP.Mul(FP.intToFP(angle), FP_PI_OVER_180);
        int isa = FP.toInt(FP.Mul(FP_256, FP.Sin(fpRads)));
        int ica = FP.toInt(FP.Mul(FP_256, FP.Cos(fpRads)));
        int my = -(sh >> 1);
        for (int i = 0; i < sh; ++i) {
            int wpos = i * sw;
            int xacc = my * isa - (sw >> 1) * ica + (sw >> 1 << 8);
            int yacc = my * ica + (sw >> 1) * isa + (sh >> 1 << 8);
            for (int j = 0; j < sw; ++j) {
                int srcx = xacc >> 8;
                int srcy = yacc >> 8;
                if (srcx < 0) {
                    srcx = 0;
                }
                if (srcy < 0) {
                    srcy = 0;
                }
                if (srcx > sw - 1) {
                    srcx = sw - 1;
                }
                if (srcy > sh - 1) {
                    srcy = sh - 1;
                }
                dstData[wpos++] = srcData[srcx + srcy * sw];
                xacc += ica;
                yacc -= isa;
            }
            ++my;
        }
        return Image.createRGBImage((int[])dstData, (int)sw, (int)sh, (boolean)true);
    }
}

