/*
 * Decompiled with CFR 0.152.
 */
package subjects;

import com.jarbull.efw.game.EFSprite;
import constants.Data;
import utilities.MyMath;

public class Bomb
extends EFSprite {
    private int speed;
    private int bombID;
    private int id;
    private int scoreVisible;
    private boolean flagActivity;
    private boolean flagVectorMove;
    private int[] frames = new int[]{16, 17, 18, 19};

    public Bomb(String ImagePath) {
        super(ImagePath, 8, 8);
        this.setVisible(false);
        this.scoreVisible = 0;
        this.flagActivity = false;
        this.flagVectorMove = false;
        this.setFrameSequence(this.frames);
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public void setBombID(int id) {
        this.bombID = id;
    }

    public int getBombID() {
        return this.bombID;
    }

    public void setActivity(boolean flag) {
        this.flagActivity = flag;
    }

    public boolean getActivity() {
        return this.flagActivity;
    }

    public int getScoreVisible() {
        return this.scoreVisible;
    }

    public void setBombPosition(int i, int currentLevel) {
        this.setPosition(Data.X_MINES_POSITION[currentLevel][i] / 24 * 20 + this.getWidth() / 2, Data.Y_MINES_POSITION[currentLevel][i] / 24 * 20 + this.getHeight() / 2);
    }

    public void moveBomb(int hero_x, int hero_y) {
        if (this.flagActivity) {
            this.flagVectorMove = this.scoreVisible > 30;
            if (!this.flagVectorMove) {
                if (this.bombID == 1) {
                    this.move(0, -this.speed);
                } else if (this.bombID == 2) {
                    this.move(0, this.speed);
                } else if (this.bombID == 3) {
                    this.move(this.speed, 0);
                } else if (this.bombID == 4) {
                    this.move(-this.speed, 0);
                }
                ++this.scoreVisible;
                if (this.scoreVisible > 5) {
                    this.setVisible(true);
                }
            } else {
                this.speed = 4;
                int vx = MyMath.getVXMove(hero_x, hero_y, this.getX(), this.getY(), this.speed);
                int vy = MyMath.getVYMove(hero_x, hero_y, this.getX(), this.getY(), this.speed);
                ++this.scoreVisible;
                this.move(vx, vy);
            }
        }
    }
}

