/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;

public class SecondRole
extends GameInterface {
    public static GameEngine engine;
    GameMap map;
    byte curIndex;
    byte[][] roleCilpData = new byte[0][];
    byte[][] roleFrameData = new byte[0][];
    byte[][] indent = new byte[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}};
    Vector dirs = new Vector();
    Utils u1 = new Utils(0);
    Utils u2 = new Utils(2);
    Utils u3 = new Utils(3);
    Utils u4 = new Utils(1);
    Random random;

    public SecondRole() {
    }

    public SecondRole(GameEngine ge) {
        engine = ge;
    }

    public void init(int gameRank, int x, int y, byte dir) {
        this.x = x;
        this.y = y;
        this.dir = dir;
        this.w = 24;
        this.h = 24;
        this.speed = 12;
        this.curStatus = 1;
        this.roleCilpData = SecondRole.engine.role.roleCilpData;
        this.roleFrameData = SecondRole.engine.role.roleFrameData;
    }

    public void move() {
        switch (this.curStatus) {
            case 1: {
                switch (this.dir) {
                    case 2: {
                        this.motion = new byte[]{2, 3, 4, 1};
                        this.roleMove(0, this.speed);
                        break;
                    }
                    case 0: {
                        this.motion = new byte[]{21, 22, 23, 24};
                        this.roleMove(0, -this.speed);
                        break;
                    }
                    case 3: {
                        this.motion = new byte[]{17, 14, 15, 16};
                        this.roleMove(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        this.motion = new byte[]{17, 14, 15, 16};
                        this.roleMove(this.speed, 0);
                        break;
                    }
                }
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
            }
        }
    }

    public boolean hitDEC(int loca) {
        return loca == -1;
    }

    public void roleMove(int mx, int my) {
        GameMap map = SecondRole.engine.map;
        int newDir = -1;
        int loca = 0;
        if (my < 0) {
            loca = map.checkDEC(this.x + this.w / 2, this.y - this.h - 1);
            if (map.canMove(this.x + this.w / 2, this.y - this.h - 1) && this.hitDEC(loca) && !this.hitUpEdge(this.x, this.y)) {
                this.y += my;
                if (this.y % GameMap.tileHight == 0) {
                    newDir = this.getDirs(mx, my);
                }
            } else {
                newDir = this.getDirs(mx, my);
            }
        }
        if (my > 0) {
            loca = map.checkDEC(this.x + this.w / 2, this.y + 1);
            if (map.canMove(this.x + this.w / 2, this.y + 1) && this.hitDEC(loca) && !this.hitDownEdge(this.x, this.y)) {
                this.y += my;
                if (this.y % GameMap.tileHight == 0) {
                    newDir = this.getDirs(mx, my);
                }
            } else {
                newDir = this.getDirs(mx, my);
            }
        }
        if (mx < 0) {
            loca = map.checkDEC(this.x - 1, this.y - this.h / 2);
            if (map.canMove(this.x - 1, this.y - this.h / 2) && this.hitDEC(loca) && !this.hitLeftEdge(this.x, this.y)) {
                this.x += mx;
                if (this.x % GameMap.tileWidth == 0) {
                    newDir = this.getDirs(mx, my);
                }
            } else {
                newDir = this.getDirs(mx, my);
            }
        }
        if (mx > 0) {
            loca = map.checkDEC(this.x + this.w + 1, this.y - this.h / 2);
            if (map.canMove(this.x + this.w, this.y - this.h / 2) && this.hitDEC(loca) && !this.hitRightEdge(this.x, this.y)) {
                this.x += mx;
                if (this.x % GameMap.tileWidth == 0) {
                    newDir = this.getDirs(mx, my);
                }
            } else {
                newDir = this.getDirs(mx, my);
            }
        }
        switch (newDir) {
            case 0: {
                this.dir = 0;
                break;
            }
            case 1: {
                this.dir = 1;
                break;
            }
            case 2: {
                this.dir = (byte)2;
                break;
            }
            case 3: {
                this.dir = (byte)3;
                break;
            }
        }
        this.x = Math.max(0, this.x);
        this.x = Math.min(GameMap.mapSize[0] * GameMap.tileWidth - this.w, this.x);
        this.y = Math.max(this.h, this.y);
        this.y = Math.min((GameMap.mapSize[1] - 1) * GameMap.tileHight, this.y);
    }

    boolean hitLeftEdge(int x, int y) {
        return x <= 0;
    }

    boolean hitRightEdge(int x, int y) {
        GameMap map = SecondRole.engine.map;
        return x >= GameMap.mapSize[0] * GameMap.tileWidth - this.w;
    }

    boolean hitUpEdge(int x, int y) {
        return y <= this.h;
    }

    boolean hitDownEdge(int x, int y) {
        GameMap map = SecondRole.engine.map;
        return y >= (GameMap.mapSize[1] - 1) * GameMap.tileHight;
    }

    public boolean hitEnemy() {
        Vector enemy = SecondRole.engine.enemy;
        this.map = SecondRole.engine.map;
        int upY = this.y - 3 * GameMap.tileHight;
        int downY = this.y + 3 * GameMap.tileHight;
        int leftX = this.x - 3 * GameMap.tileWidth;
        int rightX = this.x + 3 * GameMap.tileWidth;
        int i = 0;
        while (i < enemy.size()) {
            block5: {
                block4: {
                    int enemyY;
                    int enemyX;
                    block3: {
                        enemyX = ((Enemy)enemy.elementAt((int)i)).x;
                        enemyY = ((Enemy)enemy.elementAt((int)i)).y;
                        if (enemyX < leftX || enemyX > rightX || enemyY > this.y) break block3;
                        if (enemyY < this.y - GameMap.tileHight) break block4;
                    }
                    if (enemyY < upY || enemyY > downY || enemyX < this.x) break block5;
                    if (enemyX >= this.x + GameMap.tileWidth) break block5;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canPutBomb(int row) {
        block5: {
            block4: {
                block2: {
                    block3: {
                        GameMap map = SecondRole.engine.map;
                        if (row == -1) break block2;
                        if (GameMap.dexData[row][0] == 5) break block3;
                        if (GameMap.dexData[row][0] == 1) break block3;
                        if (GameMap.dexData[row][0] == 6) break block3;
                        if (GameMap.dexData[row][0] == 7) break block3;
                        if (GameMap.dexData[row][0] == 8) break block3;
                        if (GameMap.dexData[row][0] == 9) break block3;
                        if (GameMap.dexData[row][0] == 4) break block3;
                        if (GameMap.dexData[row][0] == 10) break block3;
                        if (GameMap.dexData[row][0] == 11) break block3;
                        if (GameMap.dexData[row][0] == 12) break block3;
                        if (GameMap.dexData[row][0] == 13) break block3;
                        if (GameMap.dexData[row][0] == 14) break block3;
                        if (GameMap.dexData[row][0] == 15) break block3;
                        if (GameMap.dexData[row][0] == 16) break block3;
                        if (GameMap.dexData[row][0] == 17) break block3;
                        if (GameMap.dexData[row][0] == 18) break block3;
                        if (GameMap.dexData[row][0] == 19) break block3;
                        if (GameMap.dexData[row][0] == 21) break block3;
                        if (GameMap.dexData[row][0] == 22) break block3;
                        if (GameMap.dexData[row][0] == 23) break block3;
                        if (GameMap.dexData[row][0] == 26) break block3;
                        if (GameMap.dexData[row][0] == 27) break block3;
                        if (GameMap.dexData[row][0] != 28) break block2;
                    }
                    if (GameMap.dexData[row][6] <= SecondRole.engine.maxDestroyTime) break block4;
                }
                if (!this.hitEnemy()) break block5;
            }
            return true;
        }
        return false;
    }

    public void putBomb() {
        int bounx = this.x;
        int bouny = this.y;
        int minx = this.x / GameMap.tileWidth * GameMap.tileWidth;
        int maxx = this.x / GameMap.tileWidth * GameMap.tileWidth + GameMap.tileWidth;
        int miny = this.y / GameMap.tileHight * GameMap.tileHight;
        int maxy = this.y / GameMap.tileHight * GameMap.tileHight + GameMap.tileHight;
        if (this.x % GameMap.tileWidth != 0) {
            bounx = Math.abs(this.x - minx) <= GameMap.tileWidth / 2 ? minx : maxx;
        }
        if (this.y % GameMap.tileHight != 0) {
            bouny = Math.abs(this.y - miny) <= GameMap.tileHight / 2 ? miny : maxy;
        }
        if (this.bounIsZero() && !this.putOnTool(bounx, bouny)) {
            ((Boun)SecondRole.engine.bouns.elementAt(SecondRole.engine.role.bounCount)).init(bounx, bouny, 0, 1, true);
            ++SecondRole.engine.role.bounCount;
            if (SecondRole.engine.role.bounCount >= SecondRole.engine.bouns.size()) {
                SecondRole.engine.role.bounCount = 0;
            }
        }
    }

    public int getDirs(int mx, int my) {
        this.map = SecondRole.engine.map;
        int before = -1;
        if (mx > 0) {
            before = 3;
        }
        if (mx < 0) {
            before = 1;
        }
        if (my > 0) {
            before = 0;
        }
        if (my < 0) {
            before = 2;
        }
        this.dirs.removeAllElements();
        int upRow = this.map.checkDEC(this.x + this.w / 2, this.y - this.h - 1);
        if (this.map.canMove(this.x + this.w / 2, this.y - this.h - this.speed) && upRow == -1 && !this.hitUpEdge(this.x, this.y) && !this.checkBoun(this.x + this.w / 2, this.y - this.h - 1)) {
            this.dirs.addElement(this.u1);
        } else if (this.canPutBomb(upRow)) {
            this.putBomb();
        }
        int downRow = this.map.checkDEC(this.x + this.w / 2, this.y + 1);
        if (this.map.canMove(this.x + this.w / 2, this.y + this.speed) && downRow == -1 && !this.hitDownEdge(this.x, this.y) && !this.checkBoun(this.x + this.w / 2, this.y + 1)) {
            this.dirs.addElement(this.u2);
        } else if (this.canPutBomb(downRow)) {
            this.putBomb();
        }
        int leftRow = this.map.checkDEC(this.x - 1, this.y - this.h / 2);
        if (this.map.canMove(this.x - this.speed, this.y - this.h / 2) && leftRow == -1 && !this.hitLeftEdge(this.x, this.y) && !this.checkBoun(this.x - 1, this.y - this.h / 2)) {
            this.dirs.addElement(this.u3);
        } else if (this.canPutBomb(leftRow)) {
            this.putBomb();
        }
        int rightRow = this.map.checkDEC(this.x + this.w + 1, this.y - this.h / 2);
        if (this.map.canMove(this.x + this.speed + this.w, this.y - this.h / 2) && rightRow == -1 && !this.hitRightEdge(this.x, this.y) && !this.checkBoun(this.x + this.w + 1, this.y - this.h / 2)) {
            this.dirs.addElement(this.u4);
        } else if (this.canPutBomb(rightRow)) {
            this.putBomb();
        }
        int random = GameEngine.nextInt(0, this.dirs.size() - 1);
        int dir = 0;
        if (this.dirs.size() == 0) {
            return 0;
        }
        dir = ((Utils)this.dirs.elementAt((int)random)).i;
        while (dir == before && this.dirs.size() != 1 || this.dirs.size() == 0) {
            random = GameEngine.nextInt(0, this.dirs.size() - 1);
            dir = ((Utils)this.dirs.elementAt((int)random)).i;
        }
        return dir;
    }

    public boolean bounIsZero() {
        Vector bouns = SecondRole.engine.bouns;
        int i = 0;
        while (i < bouns.size()) {
            if (((Boun)bouns.elementAt((int)i)).state == 0 && ((Boun)bouns.elementAt((int)i)).property == 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean putOnTool(int bounx, int bouny) {
        Vector gameTools = SecondRole.engine.gameTools;
        int i = 0;
        while (i < gameTools.size()) {
            GameTool tool = (GameTool)gameTools.elementAt(i);
            if (bounx == tool.x && bouny == tool.y && tool.type != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean checkBoun(int x, int y) {
        Vector bouns = SecondRole.engine.bouns;
        int i = 0;
        while (i < bouns.size()) {
            Boun boun = (Boun)bouns.elementAt(i);
            if (boun.being && boun.hitBoun(boun.x, boun.y, x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void paint() {
        try {
            this.rx = this.x - this.indent[this.curIndex][this.isMir ? 1 : 0];
            this.ry = this.y + this.indent[this.curIndex][2] - 8;
            this.isMir = false;
            if (this.dir == 1) {
                this.isMir = true;
            }
            Tools.addFrame(8, this.roleFrameData, this.roleCilpData, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 1);
            Tools.addImage(157, this.rx + 3, this.ry + 4, 36, (byte)0, this.y);
        }
        catch (Exception e) {
            System.out.println("secondRole paint\u6570\u7ec4\u8d8a\u754c");
        }
    }
}

