/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import javax.microedition.rms.RecordStore;

public final class Record {
    static String rmsName = "sg_zdr5";
    static byte RECORDMAX = 1;
    static byte[][] saveTime = new byte[RECORDMAX][4];
    static short[][] saveTeam = new short[RECORDMAX][];
    static byte[][] saveLevel = new byte[RECORDMAX][];
    static String[] saveRankName = new String[RECORDMAX];
    static RecordStore db;
    static int saveX;
    static int saveY;
    static short saveDir;

    static void setRecordInfo(int recordId) {
        Calendar cal = Calendar.getInstance();
        Record.saveTime[recordId][0] = (byte)(cal.get(2) + 1);
        Record.saveTime[recordId][1] = (byte)cal.get(5);
        Record.saveTime[recordId][2] = (byte)cal.get(11);
        Record.saveTime[recordId][3] = (byte)cal.get(12);
    }

    private static void openDB() {
        try {
            db = RecordStore.openRecordStore((String)rmsName, (boolean)true);
        }
        catch (Exception e) {}
    }

    private static void closeDB() {
        try {
            db.closeRecordStore();
        }
        catch (Exception e) {}
    }

    public static void initDB() {
        Record.openDB();
        try {
            if (db.getNumRecords() < 1) {
                byte[] data = new byte[]{1};
                db.addRecord(data, 0, data.length);
                System.out.println("\u521d\u59cb\u5316DB");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Record.closeDB();
    }

    static void readSmsDB() {
        Record.openDB();
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(db.getRecord(1)));
            int i = 0;
            while (i < Message.PPData.length) {
                Message.PPData[i] = dis.readByte();
                ++i;
            }
            int i2 = 0;
            while (i2 < MyGameCanvas.starsCount.length) {
                int j = 0;
                while (j < MyGameCanvas.starsCount[i2].length) {
                    MyGameCanvas.starsCount[i2][j] = dis.readByte();
                    ++j;
                }
                ++i2;
            }
            MyGameCanvas.isFirstPlay = dis.readByte();
            MyGameCanvas.isFirstThrough = dis.readByte();
            MyGameCanvas.saveBigRank = dis.readByte();
            int i3 = 0;
            while (i3 < MyGameCanvas.saveSmallRank.length) {
                MyGameCanvas.saveSmallRank[i3] = dis.readByte();
                ++i3;
            }
            dis.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Record.closeDB();
    }

    public static void writeSmsDB() {
        Record.openDB();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            int i = 0;
            while (i < Message.PPData.length) {
                dos.writeByte(Message.PPData[i]);
                System.out.println("writeSmsDB Message.PPData[" + i + "]:" + Message.PPData[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < MyGameCanvas.starsCount.length) {
                int j = 0;
                while (j < MyGameCanvas.starsCount[i2].length) {
                    dos.writeByte(MyGameCanvas.starsCount[i2][j]);
                    ++j;
                }
                ++i2;
            }
            dos.writeByte(MyGameCanvas.isFirstPlay);
            dos.writeByte(MyGameCanvas.isFirstThrough);
            dos.writeByte(MyGameCanvas.saveBigRank);
            int i3 = 0;
            while (i3 < MyGameCanvas.saveSmallRank.length) {
                dos.writeByte(MyGameCanvas.saveSmallRank[i3]);
                ++i3;
            }
            byte[] data = baos.toByteArray();
            db.setRecord(1, data, 0, data.length);
            baos.close();
            dos.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Record.closeDB();
    }

    static boolean writeDB(int recordId, int writeIndex) {
        switch (writeIndex) {
            case 1: {
                Record.writeSmsDB();
            }
            case 2: {
                Record.setRecordInfo(recordId);
                break;
            }
            case 3: {
                Record.openDB();
                break;
            }
            case 4: {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    int i = 0;
                    while (i < saveTime[recordId].length) {
                        dos.writeByte(saveTime[recordId][i]);
                        ++i;
                    }
                    dos.writeByte(saveTeam[recordId].length);
                    int i2 = 0;
                    while (i2 < saveTeam[recordId].length) {
                        dos.writeShort(saveTeam[recordId][i2]);
                        ++i2;
                    }
                    int i3 = 0;
                    while (i3 < saveLevel[recordId].length) {
                        dos.writeByte(saveLevel[recordId][i3]);
                        ++i3;
                    }
                    dos.writeUTF(saveRankName[recordId]);
                    dos.writeShort(saveX);
                    dos.writeShort(saveY);
                    dos.writeShort(saveDir);
                    byte[] data = baos.toByteArray();
                    baos.close();
                    dos.close();
                    try {
                        db.setRecord(recordId + 1, data, 0, data.length);
                    }
                    catch (Exception e) {
                        db.addRecord(data, 0, data.length);
                    }
                    db.closeRecordStore();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static void writeArray(DataOutputStream dos, short[][] array) throws IOException {
        if (array == null) {
            dos.writeByte(0);
        } else {
            dos.writeByte(array.length);
            int i = 0;
            while (i < array.length) {
                if (array[i] == null) {
                    dos.writeByte(0);
                } else {
                    dos.writeByte(array[i].length);
                    int j = 0;
                    while (j < array[i].length) {
                        dos.writeShort(array[i][j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private static short[][] readArray(DataInputStream dis) throws IOException {
        short[][] array = null;
        byte len = dis.readByte();
        if (len != 0) {
            array = new short[len][];
            int i = 0;
            while (i < array.length) {
                byte tmp = dis.readByte();
                if (tmp != 0) {
                    array[i] = new short[tmp];
                    int j = 0;
                    while (j < array[i].length) {
                        array[i][j] = dis.readShort();
                        ++j;
                    }
                }
                ++i;
            }
        }
        return array;
    }

    static boolean readDB(int recordId, boolean isLoad) {
        Record.openDB();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(db.getRecord(recordId + 1));
            DataInputStream dis = new DataInputStream(bais);
            int i = 0;
            while (i < saveTime[recordId].length) {
                Record.saveTime[recordId][i] = dis.readByte();
                ++i;
            }
            byte teamLen = dis.readByte();
            Record.saveTeam[recordId] = new short[teamLen];
            Record.saveLevel[recordId] = new byte[teamLen];
            int i2 = 0;
            while (i2 < saveTeam[recordId].length) {
                Record.saveTeam[recordId][i2] = dis.readShort();
                ++i2;
            }
            int i3 = 0;
            while (i3 < saveLevel[recordId].length) {
                Record.saveLevel[recordId][i3] = dis.readByte();
                ++i3;
            }
            Record.saveRankName[recordId] = dis.readUTF();
            if (isLoad) {
                // empty if block
            }
            bais.close();
            dis.close();
            db.closeRecordStore();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

