/*
 * Decompiled with CFR 0.152.
 */
package com.mroad.engine.act;

import com.mroad.engine.act.Map;
import com.mroad.engine.act.ResourceHandle;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Animation {
    private static short[][] Modules = null;
    private static short[] HeroModules = null;
    private static short[] ImgWidth = null;
    private static short HeroImgWidth;
    private static byte[][] Frames;
    private static byte[][] Actions;
    private static byte[] HeroFrames;
    private static byte[] HeroActions;
    private static byte[] TmpActionData;
    private static byte[] TmpAnimationData;
    private static boolean KeepHeroData;
    private static Image[] SpriteImg;
    private static Image HeroImg;
    private static String[] SpriteType_Id_List;
    private static short[] SpriteTypeId;
    private static byte[] SpriteSubType;
    private static byte[] SpriteWidth;
    private static byte[] SpriteHeight;
    private static byte[] SpriteAnimationId;
    private static byte[] ActionId;
    private static byte[] ExtentionId;
    private static int ExtensionPointer;
    protected static short[][] Extention_Properties;
    private static DirectGraphics Dg;

    protected static void NewSpriteObjectList(int n) {
        SpriteTypeId = new short[n];
        SpriteSubType = new byte[n];
        SpriteWidth = new byte[n];
        SpriteHeight = new byte[n];
        SpriteAnimationId = new byte[n];
        ActionId = new byte[n];
        ExtentionId = new byte[n];
    }

    protected static void InsertSpriteObjdetList(int n, short s, byte by, byte by2, byte by3, byte by4, String string) {
        Animation.SpriteTypeId[n] = s;
        Animation.SpriteSubType[n] = by;
        Animation.SpriteWidth[n] = by2;
        Animation.SpriteHeight[n] = by3;
        Animation.SpriteAnimationId[n] = Animation.Get_SpriteTypeIdByName(string);
        Animation.ActionId[n] = by4;
        Animation.ExtentionId[n] = Animation.Get_Extention_Position(s);
    }

    protected static byte[] Get_ObjdetProperties(int n, int n2) {
        byte[] byArray = new byte[4];
        if (n != 0) {
            for (int i = 0; i < ActionId.length; ++i) {
                if (SpriteTypeId[i] != n || SpriteSubType[i] != n2) continue;
                byArray[0] = SpriteWidth[i];
                byArray[1] = SpriteHeight[i];
                byArray[2] = SpriteAnimationId[i];
                byArray[3] = ActionId[i];
                ExtensionPointer = i;
                break;
            }
        } else {
            ExtensionPointer = 999;
        }
        return byArray;
    }

    protected static final short[] Get_My_Extention_Properties() {
        short[] sArray;
        if (ExtensionPointer == 999) {
            sArray = new short[Extention_Properties[Animation.Get_Extention_Position(0)].length - 1];
            System.arraycopy(Extention_Properties[Animation.Get_Extention_Position(0)], 1, sArray, 0, sArray.length);
        } else {
            sArray = new short[Extention_Properties[ExtentionId[ExtensionPointer]].length - 1];
            System.arraycopy(Extention_Properties[ExtentionId[ExtensionPointer]], 1, sArray, 0, sArray.length);
        }
        return sArray;
    }

    private static final byte Get_Extention_Position(int n) {
        byte by = 0;
        for (int i = 0; i < Extention_Properties.length; ++i) {
            if (n != Extention_Properties[i][0]) continue;
            by = (byte)i;
            break;
        }
        return by;
    }

    private static void DestroySpriteObjdetList() {
        try {
            SpriteTypeId = null;
            SpriteSubType = null;
            SpriteWidth = null;
            SpriteHeight = null;
            SpriteAnimationId = null;
            ActionId = null;
            ExtentionId = null;
            System.gc();
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void NewCharacterDataList(int n) {
        try {
            SpriteImg = new Image[n];
            Modules = new short[n][];
            Frames = new byte[n][];
            Actions = new byte[n][];
            ImgWidth = new short[n];
            SpriteType_Id_List = new String[n];
            if (KeepHeroData) {
                Animation.SpriteImg[0] = HeroImg;
                Animation.Modules[0] = HeroModules;
                Animation.Frames[0] = HeroFrames;
                Animation.Actions[0] = HeroActions;
                Animation.ImgWidth[0] = HeroImgWidth;
                Animation.SpriteType_Id_List[0] = "Hero";
                HeroImg = null;
                HeroModules = null;
                HeroFrames = null;
                HeroActions = null;
                HeroImgWidth = 0;
                System.gc();
                Thread.sleep(500L);
            }
        }
        catch (Exception exception) {
            System.out.println("NewSpriteTypeList Err: " + exception.toString());
        }
    }

    public static void DestoryCharacterData(boolean bl) {
        try {
            KeepHeroData = bl;
            if (KeepHeroData) {
                HeroImg = SpriteImg[0];
                HeroModules = Modules[0];
                HeroFrames = Frames[0];
                HeroActions = Actions[0];
                HeroImgWidth = ImgWidth[0];
            } else if (HeroImg != null) {
                HeroImg = null;
                HeroModules = null;
                HeroFrames = null;
                HeroActions = null;
                HeroImgWidth = 0;
            }
            for (int i = 0; i < SpriteImg.length; ++i) {
                Animation.SpriteImg[i] = null;
                Animation.Modules[i] = null;
                Animation.Frames[i] = null;
                Animation.Actions[i] = null;
            }
            SpriteImg = null;
            Modules = null;
            Frames = null;
            Actions = null;
            ImgWidth = null;
            SpriteType_Id_List = null;
            Animation.DestroySpriteObjdetList();
            System.gc();
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            System.out.println("DestoryCharacterData Err: " + exception.toString());
        }
    }

    public static void LoadCharacterData(String string, int n) {
        try {
            if (SpriteImg[n] != null) {
                System.out.println("LoadCharacterData Err: SpriteImg[" + n + "] is not empty");
            } else {
                Animation.SpriteImg[n] = ResourceHandle.LoadImage(string + ".png");
                Animation.ImgWidth[n] = (short)SpriteImg[n].getWidth();
                Animation.Modules[n] = ResourceHandle.LoadModule(string + ".cmu");
                Animation.Frames[n] = ResourceHandle.LoadFrames(string + ".frm");
                Animation.Actions[n] = ResourceHandle.LoadActions(string + ".act");
                Animation.SpriteType_Id_List[n] = string;
            }
        }
        catch (Exception exception) {
            System.out.println("LoadCharacterData Err" + exception.toString() + "FileName: " + string);
        }
    }

    protected static byte[] PerpareActionData(int n, int n2) {
        short s = (short)(Actions[n][n2 * 8 + 2] & 0xFF | Actions[n][n2 * 8 + 3] << 8);
        Animation.TmpActionData[0] = (byte)(s << 8 >> 8 & 0xFF);
        Animation.TmpActionData[1] = (byte)(s >> 8 & 0xFF);
        System.arraycopy(Actions[n], n2 * 8 + 4, TmpActionData, 2, 6);
        return TmpActionData;
    }

    protected static byte[] PerpareAnimationData(int n, int n2, short s) {
        short s2 = (short)(s + n2 * 12);
        System.arraycopy(Actions[n], s2, TmpAnimationData, 0, 12);
        return TmpAnimationData;
    }

    protected static void Paint(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (n4 < 0) {
            n4 += 256;
        }
        Dg = DirectUtils.getDirectGraphics((Graphics)graphics);
        short s = Map.GetGraXFMX(n);
        short s2 = Map.GetGraYFMY(n2);
        short s3 = (short)(Frames[n3][n4 * 3 + 2] & 0xFF | Frames[n3][n4 * 3 + 3] << 8);
        int n5 = Frames[n3][n4 * 3 + 4];
        for (int i = 0; i < n5; ++i) {
            short s4 = (short)(Frames[n3][s3 + i * 6] & 0xFF | Frames[n3][s3 + i * 6 + 1] << 8);
            short s5 = (short)(Frames[n3][s3 + i * 6 + 2] & 0xFF | Frames[n3][s3 + i * 6 + 3] << 8);
            short s6 = (short)(Frames[n3][s3 + i * 6 + 4] & 0xFF | Frames[n3][s3 + i * 6 + 5] << 8);
            short s7 = Modules[n3][s4 * 4];
            short s8 = Modules[n3][s4 * 4 + 1];
            short s9 = Modules[n3][s4 * 4 + 2];
            short s10 = Modules[n3][s4 * 4 + 3];
            if (bl) {
                s5 = (short)(s - s5 - s9);
                s7 = (short)(ImgWidth[n3] - s7 - s9);
                graphics.setClip((int)s5, s2 + s6, (int)s9, (int)s10);
                Dg.drawImage(SpriteImg[n3], s5 - s7, s2 + s6 - s8, 20, 8192);
                continue;
            }
            graphics.setClip(s + s5, s2 + s6, (int)s9, (int)s10);
            graphics.drawImage(SpriteImg[n3], s + s5 - s7, s2 + s6 - s8, 20);
        }
    }

    public static int Get_SpriteTypeCount() {
        return SpriteImg.length;
    }

    protected static byte Get_SpriteTypeIdByName(String string) {
        byte by = 0;
        for (int i = 0; i < SpriteType_Id_List.length; ++i) {
            if (!SpriteType_Id_List[i].equals(string)) continue;
            by = (byte)i;
            break;
        }
        return by;
    }

    static {
        Frames = null;
        Actions = null;
        HeroFrames = null;
        HeroActions = null;
        TmpActionData = new byte[8];
        TmpAnimationData = new byte[12];
        KeepHeroData = false;
        SpriteImg = null;
        HeroImg = null;
        SpriteType_Id_List = null;
    }
}

