/*
 * Decompiled with CFR 0.152.
 */
package com.mroad.engine.act;

import com.mroad.engine.act.Animation;
import com.mroad.engine.act.ResourceHandle;
import com.mroad.engine.act.SpriteController;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    private static int World_X;
    private static int World_Y;
    private static int Vx;
    private static int Vy;
    private static int TileSize;
    private static int LastRow;
    private static int LastCol;
    private static int MaxRow;
    private static int MaxCol;
    private static int RecCol;
    private static int RecRow;
    private static int offsetX;
    private static int offsetY;
    private static int LayerCount;
    private static short RecentTileId;
    private static Image MapImage;
    private static Image L1Img;
    private static Graphics L1Gra;
    protected static byte[][][] Layers;
    protected static byte[][] TileType;
    protected static short[] TileIdPx;
    protected static short[] TileIdPy;
    protected static int StartRow;
    protected static int StartCol;
    private static short ScreenWidth;
    private static short ScreenHeight;
    private static short MapCanvasWidth;
    private static short MapCanvasHeight;
    private static byte Map_Rows;
    private static byte Map_Colums;
    private static int VisibleX;
    private static int VisibleY;
    private static int VisibleW;
    private static int VisibleH;

    public Map(int n, int n2, int n3) {
        Vy = 0;
        Vx = 0;
        World_Y = 0;
        World_X = 0;
        ScreenWidth = (short)n;
        ScreenHeight = (short)n2;
        TileSize = n3;
        Map_Rows = n2 % n3 == 0 ? (byte)(n2 / n3 + 1) : (byte)(n2 / n3 + 2);
        Map_Colums = n % n3 == 0 ? (byte)(n / n3 + 1) : (byte)(n / n3 + 2);
        MapCanvasWidth = (short)(Map_Colums * n3);
        MapCanvasHeight = (short)(Map_Rows * n3);
        L1Img = Image.createImage((int)MapCanvasWidth, (int)MapCanvasHeight);
        L1Gra = L1Img.getGraphics();
        VisibleX = 0;
        VisibleY = 0;
        VisibleW = n;
        VisibleH = n2;
    }

    public static final void SetVisible(int n, int n2, int n3, int n4) {
        VisibleX = n;
        VisibleY = n2;
        VisibleW = n3;
        VisibleH = n4;
    }

    public static final int Get_VisibleX() {
        return VisibleX;
    }

    public static final int Get_VisibleY() {
        return VisibleY;
    }

    public static final int Get_VisibleWidth() {
        return VisibleW;
    }

    public static final int Get_VisibleHeight() {
        return VisibleH;
    }

    public static final void SetPosition(int n, int n2) {
        World_X = n;
        World_Y = n2;
        LastRow = World_Y / TileSize;
        LastCol = World_X / TileSize;
        Map.BufferMap(LastRow, LastCol, 0, Map_Rows, 0, Map_Colums);
    }

    public static final void SetPosition(short s, short s2) {
        LastRow = s;
        LastCol = s2;
        World_X = Map.GetMapXFCol(s2);
        World_Y = Map.GetMapYFRow(s);
        Map.BufferMap(LastRow, LastCol, 0, Map_Rows, 0, Map_Colums);
    }

    public static final void LoadMap(String string) {
        StartCol = 0;
        StartRow = 0;
        ResourceHandle.LoadMap(string);
        ResourceHandle.LoadTiles();
        MapImage = ResourceHandle.LoadMapImage();
        System.gc();
        LayerCount = Layers.length;
        MaxRow = Layers[0].length;
        MaxCol = Layers[0][0].length;
        int n = StartCol - 2 < 0 ? 2 : StartCol;
        n = StartCol + Map_Colums - 2 > Layers[0][0].length ? Layers[0][0].length - Map_Colums + 3 : n;
        int n2 = StartRow - Map_Rows + 2 < 0 ? Map_Rows - 2 : StartRow;
        n2 = StartRow + Map_Rows - 2 > Layers[0].length ? Layers[0].length - 1 : n2;
        Map.SetPosition((short)(n2 - (Map_Rows - 2)), (short)(n - 2));
    }

    public static final void LoadMapNoImage(String string) {
        StartCol = 0;
        StartRow = 0;
        ResourceHandle.LoadMap(string);
        ResourceHandle.LoadTiles();
        LayerCount = Layers.length;
        MaxRow = Layers[0].length;
        MaxCol = Layers[0][0].length;
        int n = StartCol - 2 < 0 ? 2 : StartCol;
        n = StartCol + Map_Colums - 2 > Layers[0][0].length ? Layers[0][0].length - Map_Colums + 3 : n;
        int n2 = StartRow - Map_Rows + 2 < 0 ? Map_Rows - 2 : StartRow;
        n2 = StartRow + Map_Rows - 2 > Layers[0].length ? Layers[0].length - 1 : n2;
        Map.SetPosition((short)(n2 - (Map_Rows - 2)), (short)(n - 2));
    }

    public static final void LoadMapImage(String string) {
        MapImage = ResourceHandle.LoadImage(string);
        System.gc();
    }

    public static final void LoadLevelSprite(String string, SpriteController spriteController, SpriteController spriteController2, SpriteController spriteController3) {
        Object var21_4 = null;
        byte[] byArray = null;
        ResourceHandle.LoadOblFile(string);
        byte[] byArray2 = ResourceHandle.LoadSpriteInMap();
        short s = (short)(byArray2[1] << 8 | byArray2[0] & 0xFF);
        short s2 = (short)(byArray2[3] << 8 | byArray2[2] & 0xFF);
        short s3 = (short)(byArray2[5] << 8 | byArray2[4] & 0xFF);
        spriteController.NewSpriteList(s);
        spriteController2.NewSpriteList(s2);
        spriteController3.NewSpriteList(s3);
        block5: for (int i = 0; i < s + s2 + s3; ++i) {
            byArray = ResourceHandle.Get_NextSprite();
            short s4 = (short)(byArray[1] << 8 | byArray[0] & 0xFF);
            short s5 = (short)(byArray[3] << 8 | byArray[2] & 0xFF);
            byte by = byArray[4];
            short s6 = (short)(byArray[6] << 8 | byArray[5] & 0xFF);
            short s7 = (short)(byArray[8] << 8 | byArray[7] & 0xFF);
            short s8 = (short)(byArray[10] << 8 | byArray[9] & 0xFF);
            short s9 = (short)(byArray[12] << 8 | byArray[11] & 0xFF);
            short s10 = (short)(byArray[34] << 8 | byArray[33] & 0xFF);
            byte by2 = byArray[42];
            byte by3 = byArray[43];
            byte[] byArray3 = Animation.Get_ObjdetProperties(s10, s6);
            short[] sArray = Animation.Get_My_Extention_Properties();
            switch (by) {
                case 0: {
                    spriteController.InsertSprite(byArray3[2], s4, s5, s10, (byte)s6, s7, s8, s9, byArray3[0], byArray3[1], byArray3[3], sArray, by2, by3);
                    continue block5;
                }
                case 1: {
                    spriteController2.InsertSprite(byArray3[2], s4, s5, s10, (byte)s6, s7, s8, s9, byArray3[0], byArray3[1], byArray3[3], sArray, by2, by3);
                    continue block5;
                }
                case 2: {
                    spriteController3.InsertSprite(byArray3[2], s4, s5, s10, (byte)s6, s7, s8, s9, byArray3[0], byArray3[1], byArray3[3], sArray, by2, by3);
                }
            }
        }
    }

    private static String readString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n2; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString().trim();
    }

    public static final void MoveMap() {
        if (Vx != 0) {
            World_X = World_X + Vx <= 0 ? 0 : World_X + Vx;
            int n = World_X = World_X + ScreenWidth > MaxCol * TileSize ? MaxCol * TileSize - ScreenWidth : World_X;
        }
        if (Vy != 0) {
            World_Y = World_Y + Vy <= 0 ? 0 : World_Y + Vy;
            World_Y = World_Y + ScreenHeight > MaxRow * TileSize ? MaxRow * TileSize - ScreenHeight : World_Y;
        }
    }

    public static final void Paint(Graphics graphics) {
        try {
            RecCol = Map.GetMapColFPX(World_X);
            RecRow = Map.GetMapRowFPY(World_Y);
            RecRow = RecRow < 0 ? 0 : RecRow;
            RecCol = RecCol < 0 ? 0 : RecCol;
            offsetX = World_X & TileSize - 1;
            offsetY = World_Y & TileSize - 1;
            if (RecRow != LastRow || RecCol != LastCol) {
                Map.CreateMap(RecRow, RecCol, offsetX, offsetY);
            }
            graphics.drawImage(L1Img, -offsetX - RecCol % Map_Colums * TileSize, -offsetY - RecRow % Map_Rows * TileSize, 20);
            if (RecCol % Map_Colums != 0) {
                graphics.drawImage(L1Img, -offsetX + (MapCanvasWidth - RecCol % Map_Colums * TileSize), -offsetY - RecRow % Map_Rows * TileSize, 20);
            }
            if (RecRow % Map_Rows != 0) {
                graphics.drawImage(L1Img, -offsetX - RecCol % Map_Colums * TileSize, -offsetY + (MapCanvasHeight - RecRow % Map_Rows * TileSize), 20);
            }
            if (RecRow % Map_Rows != 0 && RecCol % Map_Colums != 0) {
                graphics.drawImage(L1Img, -offsetX + (MapCanvasWidth - RecCol % Map_Colums * TileSize), -offsetY + (MapCanvasHeight - RecRow % Map_Rows * TileSize), 20);
            }
        }
        catch (Exception exception) {
            System.out.println("PaintMap Error: " + exception.toString());
        }
    }

    public static final void paintLayer(Graphics graphics, int n) {
        if (n > LayerCount - 1) {
            n = LayerCount - 1;
        }
        RecCol = Map.GetMapColFPX(World_X);
        RecRow = Map.GetMapRowFPY(World_Y);
        RecRow = RecRow < 0 ? 0 : RecRow;
        RecCol = RecCol < 0 ? 0 : RecCol;
        offsetX = World_X & TileSize - 1;
        offsetY = World_Y & TileSize - 1;
        for (int i = 0; i < Map_Rows; ++i) {
            for (int j = 0; j < Map_Colums; ++j) {
                if (RecRow + i >= MaxRow || RecCol + j >= MaxCol || (RecentTileId = (short)Layers[n][RecRow + i][RecCol + j]) == 0) continue;
                RecentTileId = RecentTileId < 0 ? (short)(RecentTileId + 129 + 127) : RecentTileId;
                graphics.setClip(j * TileSize - offsetX, i * TileSize - offsetY, TileSize, TileSize);
                graphics.drawImage(MapImage, j * TileSize - offsetX - TileIdPx[RecentTileId], i * TileSize - offsetY - TileIdPy[RecentTileId], 20);
            }
        }
    }

    private static final void CreateMap(int n, int n2, int n3, int n4) {
        switch (-(n - LastRow)) {
            case 1: {
                Map.BufferMap(n, n2, 0, 1, 0, Map_Colums);
                break;
            }
            case -1: {
                Map.BufferMap(n, n2, Map_Rows - 1, Map_Rows, 0, Map_Colums);
            }
        }
        LastRow = n;
        switch (-(n2 - LastCol)) {
            case 1: {
                Map.BufferMap(n, n2, 0, Map_Rows, 0, 1);
                break;
            }
            case -1: {
                Map.BufferMap(n, n2, 0, Map_Rows, Map_Colums - 1, Map_Colums);
            }
        }
        LastCol = n2;
    }

    private static final void BufferMap(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            for (int i = 0; i < LayerCount; ++i) {
                for (int j = n3; j < n4; ++j) {
                    for (int k = n5; k < n6; ++k) {
                        if (n + j >= MaxRow || n2 + k >= MaxCol || (RecentTileId = (short)Layers[i][n + j][n2 + k]) == 0) continue;
                        RecentTileId = RecentTileId < 0 ? (short)(RecentTileId + 129 + 127) : RecentTileId;
                        L1Gra.setClip((n2 + k) % Map_Colums * TileSize, (n + j) % Map_Rows * TileSize, TileSize, TileSize);
                        L1Gra.drawImage(MapImage, (n2 + k) % Map_Colums * TileSize + TileIdPx[RecentTileId] * -1, (n + j) % Map_Rows * TileSize + TileIdPy[RecentTileId] * -1, 20);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("BufferMap Error: " + exception.toString());
        }
    }

    public static final void Set_Vx(int n) {
        Vx = n;
    }

    public static final void Set_Vy(int n) {
        Vy = n;
    }

    public static final int Get_ScreenWidth() {
        return ScreenWidth;
    }

    public static final int Get_ScreenHeight() {
        return ScreenHeight;
    }

    public static final int GetWorld_X() {
        return World_X;
    }

    public static final int GetWorld_Y() {
        return World_Y;
    }

    public static final int GetMapYFRow(short s) {
        return s * TileSize;
    }

    public static final int GetMapXFCol(short s) {
        return s * TileSize;
    }

    public static final int GetMapRowFPY(long l) {
        return (int)(l / (long)TileSize);
    }

    public static final int GetMapColFPX(long l) {
        return (int)(l / (long)TileSize);
    }

    public static final short GetGraXFMX(long l) {
        return (short)(l - (long)World_X);
    }

    public static final short GetGraYFMY(long l) {
        return (short)(l - (long)World_Y);
    }

    public static final byte GetTileTypeFromMap(int n, int n2) {
        return TileType[n2 / TileSize][n / TileSize];
    }

    public static final void setTileType(int n, int n2, byte by) {
        Map.TileType[n2 / Map.TileSize][n / Map.TileSize] = by;
    }

    public static final byte GetTileIdFromMap(int n, int n2, int n3) {
        return Layers[n][n3 / TileSize][n2 / TileSize];
    }

    public static final int GetMapWidth() {
        return MaxCol * TileSize;
    }

    public static final int GetMapHeight() {
        return MaxRow * TileSize;
    }

    public static final void Destroy() {
        MapImage = null;
        L1Img = null;
        L1Gra = null;
        Layers = null;
        TileType = null;
        TileIdPx = null;
        TileIdPy = null;
        TileType = null;
        TileIdPx = null;
        TileIdPy = null;
        try {
            System.gc();
            Thread.yield();
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

