import javax.microedition.media.*;
import java.io.*;
import javax.microedition.media.control.VolumeControl;

/**
 * <p>Title:SoundPlayerUtil </p>
 * <p>Description:SoundPlayerUtil </p>
 * <p>Copyright: Copyright (c) 2009</p>
 * <p>Company: songge</p>
 * @version 1.0
 */

//Wave audio files: audio/x-wav
//AU audio files: audio/basic
//MP3 audio files: audio/mpeg
//MIDI files: audio/midi
//Tone sequences: audio/x-tone-seq
//static String[] name = {
//      "open.mid", "att.wav", "drop.wav"};
//  static String[] type = {
//      "audio/midi", "audio/x-wav", "audio/x-wav"};

//Wave audio files: audio/x-wav
//AU audio files: audio/basic
//MP3 audio files: audio/mpeg
//MIDI files: audio/midi
//Tone sequences: audio/x-tone-seq

public final class Sound {

  public static byte MUSIC_ = 0;
  public static byte MUSIC_Ұ = 1;
  public static byte MUSIC_ = 2;
  public static byte MUSIC_ = 3;
  public static byte MUSIC_ = 3;
  public static byte Music_ׯ = 4;
  public static byte Music_ = 5;
  public static byte Music_ս = 6;
  public static byte Music_BOSS = 7;

  static private Player sndPlayers;
  private static int curMusic = -1;
  private static int curLoop = -1;
  static int volume = 60; //

  private static void initMusic(int musicID, int loop) {

    InputStream is = "".getClass().getResourceAsStream("/mid/" + musicID +
        ".mid");
    if (is == null) {
      return;
    }
    try {
      sndPlayers = Manager.createPlayer(is, "audio/midi");
      sndPlayers.realize();
      sndPlayers.prefetch();
      sndPlayers.setLoopCount(loop);
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  public static void setVolume(int vol) {
    if (vol == 0) {
      pauseCurMusic();
    }
    if (volume == 0 && vol > 0) {
      playCurMusic();
    }
    volume = vol;
    volume = Math.max(0, volume);
    volume = Math.min(100, volume);
    if (curMusic != -1) {
      VolumeControl vc = (VolumeControl) sndPlayers.getControl("VolumeControl");
      vc.setLevel(volume);
    }
  }

  public static void playmusic(int currentPlay, int loop) {
    if (currentPlay == -1 || currentPlay == curMusic /*|| volume == 0*/) {
      return;
    }
    if (curMusic != -1) {

      stopMusic();
    }
    curMusic = currentPlay;
    curLoop = loop;
    initMusic(currentPlay, loop);
    try {
      setVolume(volume);
      sndPlayers.start();
    }
    catch (Exception e) {}
  }

  private static void stopMusic() {

    try {
      sndPlayers.close();
    }
    catch (Exception ex) {
    }
  }

  public static void stopCurMusic() { //ֹͣ
    if (curMusic == -1) {
      return;
    }
    try {
      sndPlayers.close();
      curMusic = -1;
    }
    catch (Exception ex) {
    }
  }

  public static void pauseCurMusic() { //ͣ
    if (curMusic == -1) {
      return;
    }
    try {
      sndPlayers.stop();
    }
    catch (Exception ex) {
    }
  }

  public static void playCurMusic() { //

    if (curMusic == -1) {
      return;
    }
    try {
      sndPlayers.start();
    }
    catch (Exception ex) {
    }
  }

}
