/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public final class Screen
extends Canvas
implements _Config,
Runnable {
    public static Screen instance = null;
    public static int keyMode = -1;
    public static final int PRESSED_MODE = 10000;
    public static final int RELEASED_MODE = 20000;
    public static boolean keyboardLock = true;
    public static int pKeyCode;
    public static int rKeyCode;
    public static int pTimes;
    public static boolean running;
    private static Thread thread;
    public static int FRAME_TIME;
    public static final byte GAME_NONE = -1;
    public static final byte GAME_LOGO = 0;
    public static final byte GAME_MENU = 1;
    public static final byte GAME_BODY = 2;
    public static final byte GAME_LOADING = 3;
    public static byte GAME_STATE;

    static {
        running = true;
        thread = null;
        FRAME_TIME = 100;
        GAME_STATE = 1;
    }

    public static final void init(Display dis) {
        instance = new Screen();
        instance.setFullScreenMode(true);
        dis.setCurrent((Displayable)instance);
        thread = new Thread(instance);
        thread.setPriority(10);
        thread.start();
        if (GAME_STATE == 1) {
            Load.setStructState((byte)0, (byte)1);
        }
    }

    protected final void paint(Graphics g) {
        ++pTimes;
        g.setFont(Util.font);
        g.setClip(0, 0, 240, 320);
        g.setColor(-1);
        g.fillRect(0, 0, 240, 320);
        switch (GAME_STATE) {
            case 0: {
                Logo.drawLogo(g);
                break;
            }
            case 1: {
                Menu.paint(g);
                break;
            }
            case 2: {
                Body.paint(g);
                break;
            }
            case 3: {
                Load.drawLoading(g);
                break;
            }
        }
        _ClientPay.paint(g);
    }

    protected static final void update() {
        switch (GAME_STATE) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Body.update();
                break;
            }
            case 3: {
                Load.dataLoading();
                break;
            }
        }
    }

    protected final void keyPressed(int keyCode) {
        if (!keyboardLock) {
            return;
        }
        if (_ClientPay.keyPressed(keyCode)) {
            return;
        }
        pKeyCode = keyCode;
        keyMode = 10000;
        switch (GAME_STATE) {
            case 0: {
                Logo.keyPressedLogo();
                break;
            }
            case 1: {
                Menu.keyPressed();
                break;
            }
            case 2: {
                Body.keyPressed();
                break;
            }
            case 3: {
                break;
            }
        }
    }

    protected final void keyReleased(int keyCode) {
        if (!keyboardLock) {
            return;
        }
        rKeyCode = keyCode;
        keyMode = 20000;
        switch (GAME_STATE) {
            case 0: {
                break;
            }
            case 1: {
                Menu.keyReleased();
                break;
            }
            case 2: {
                Body.keyReleased();
                break;
            }
            case 3: {
                break;
            }
        }
    }

    protected final void pointerPressed(int x, int y) {
        switch (GAME_STATE) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Body.pointerPressed(x, y);
                break;
            }
            case 3: {
                break;
            }
        }
    }

    protected final void pointerReleased(int x, int y) {
        switch (GAME_STATE) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Body.pointerReleased(x, y);
                break;
            }
            case 3: {
                break;
            }
        }
    }

    protected final void showNotify() {
        Audio.startAudio();
    }

    protected final void hideNotify() {
        Audio.stopAudio();
        if (GAME_STATE == 2) {
            Body.pause = true;
        }
    }

    public static final void render() {
        instance.repaint();
        instance.serviceRepaints();
    }

    public final void run() {
        while (running) {
            long loopStart = System.currentTimeMillis();
            Screen.update();
            this.repaint();
            int yieldTime = 0;
            long loopEnd = System.currentTimeMillis();
            while (loopEnd - loopStart < (long)FRAME_TIME) {
                loopEnd = System.currentTimeMillis();
                if ((yieldTime & 0xF) == 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ++yieldTime;
            }
            Thread.yield();
        }
    }
}

