/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public final class Audio {
    public static byte isVolume = (byte)3;
    public static boolean sound = true;
    public static String music;
    public static String currenMusic;
    public static String previousMusic;
    public static boolean vibrate;
    private static Player player;
    private static VolumeControl volume;
    private static byte loop;

    static {
        vibrate = true;
        player = null;
        volume = null;
    }

    public static void loadAudio(String name) {
        Audio.reloadAudio();
        if (player == null) {
            currenMusic = name;
            name = "/audio/" + name + ".mid";
            InputStream is = "".getClass().getResourceAsStream(name);
            if (is != null) {
                try {
                    player = Manager.createPlayer((InputStream)is, (String)Audio.guessContentType(name));
                    if (player == null) {
                        System.out.println("player is null");
                    } else {
                        player.setLoopCount((int)loop);
                        player.realize();
                        player.prefetch();
                        volume = (VolumeControl)player.getControl("VolumeControl");
                        volume.setLevel(isVolume * 20);
                    }
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (MediaException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static final void setLevel(int level) {
        if (volume != null) {
            volume.setLevel(20 * level);
        }
    }

    public static final void reloadAudio() {
        if (player != null) {
            Audio.stopAudio();
            player.close();
            player = null;
        }
    }

    public static final void stopAudio() {
        try {
            if (player != null) {
                player.stop();
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public static final void startAudio() {
        if (sound && currenMusic != null) {
            Audio.playAudio(currenMusic, loop);
        }
    }

    public static final void playAudio(String name, int loop) {
        try {
            if (sound) {
                Audio.loop = (byte)loop;
                if (name != music) {
                    previousMusic = music;
                    currenMusic = name;
                    music = name;
                    Audio.loadAudio(currenMusic);
                }
                if (player != null) {
                    player.start();
                } else {
                    Audio.loadAudio(currenMusic);
                    player.start();
                }
            } else if (player != null && player.getState() == 400) {
                Audio.stopAudio();
            } else {
                previousMusic = music;
                currenMusic = name;
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public static final String guessContentType(String url) {
        String ext = "";
        String ct = "";
        int lastDot = url.lastIndexOf(46);
        if (lastDot >= 0) {
            ext = url.substring(lastDot + 1).toLowerCase();
        }
        if (ext.equals("mpg") || url.equals("avi")) {
            ct = "video/mpeg";
        } else if (ext.equals("mid") || ext.equals("kar")) {
            ct = "audio/midi";
        } else if (ext.equals("wav")) {
            ct = "audio/x-wav";
        } else if (ext.equals("jts")) {
            ct = "audio/x-tone-seq";
        } else if (ext.equals("txt")) {
            ct = "audio/x-txt";
        } else if (ext.equals("amr")) {
            ct = "audio/amr";
        } else if (ext.equals("awb")) {
            ct = "audio/amr-wb";
        } else if (ext.equals("gif")) {
            ct = "image/gif";
        }
        return ct;
    }
}

