/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class GameObject {
    public static final int MOVEUP = 0;
    public static final int MOVEDOWN = 1;
    public static final int MOVELEFT = 2;
    public static final int MOVERIGHT = 3;
    public static final int STAND = 4;
    public static final int WAIT = 5;
    public static final int ATTACK = 6;
    public static final int SKILLS = 7;
    public static final int BEHITMAGIC = 8;
    public static final int BEHITMELEE = 9;
    public static final int DIE = 10;
    public static final int YOUWIN = 11;
    public static final int SUPER = 12;
    public static final int USEITEM = 13;
    public static final int SPXNORMAL = 0;
    public static final int SPXSKILL = 1;
    public static final int SPXSUPER = 2;
    public static final int SPXITEM = 3;
    public static final int MAXSKILL = 4;
    public static final int STARTBATTLE = 0;
    public static final int STARTSKILL = 1;
    public static final int FACE_NORMAL = 0;
    public static final int FACE_HAPPY = 1;
    public static final int FACE_ANGRY = 2;
    public static final int FACE_SHORK = 3;
    public static final int FACE_SHY = 4;
    public static final int FACE_HURT = 5;
    public static final int FACE_SORROW = 6;
    public static final int FACE_CRY = 7;
    public static final int BATTLESTATE_NORMAL = 0;
    public static final int BATTLESTATE_ANGRY = 1;
    public static final int BATTLESTATE_HURT = 2;
    public static final int BATTLESTATE_DIE = 3;
    public EPoint m_Pos;
    public EPoint m_PosShadow1;
    public EPoint m_PosShadow2;
    public String Add_Skill;
    public int LV = 0;
    public int HP_Total = 0;
    public int SP_Total = 0;
    public int DP = 0;
    public int AP = 0;
    public int RP = 0;
    public int TP = 0;
    public int Next_Exp = 0;
    public int Now_Exp;
    public int Exp_Total;
    public int TP_Rate = 0;
    public int RP_Rate = 0;
    public int HP_Now = 0;
    public int[] m_HPR;
    public int SP_Now = 0;
    public int[] m_SPR;
    public int Strengh = 0;
    public int Stamina = 0;
    public int Intellect = 0;
    public int Agility = 0;
    public int C_Rate = 0;
    public int Add_Str = 0;
    public int Add_Sta = 0;
    public int Add_Inte = 0;
    public int Add_Agi = 0;
    public int m_HeroID;
    public boolean m_InGroup;
    public int m_UIID;
    public int m_BattlePos;
    public SpriteX m_HeroSpx;
    public EAnimControl m_HeroShadow1;
    public EAnimControl m_HeroShadow2;
    public EAnimControl m_Effect;
    public EPoint m_HitPos;
    public boolean m_CanUseSpell;
    public Vector SkillAttack;
    public Vector SkillHeal;
    public ESkill m_SuperSkill;
    public Vector HeroBuf;
    public Vector HeroDebuf;
    public Vector HeroWeaponUI;
    public Vector HeroHeadUI;
    public Vector HeroBodyUI;
    public Vector HeroCloveUI;
    public Vector HeroShoesUI;
    public ItemUnit[] m_Equipt = new ItemUnit[6];
    public int m_ActionState;
    public boolean m_InCommand;
    public int m_Face;
    public int m_BattleState;
    public GameStage m_GameStage;
    public ESkill m_Skill;
    public final int SKILL_PREPARE;
    public final int SKILL_GO;
    public final int SKILL_DONE;
    public int m_SkillState;

    public GameObject(GameStage gameStage) {
        this.SKILL_PREPARE = 0;
        this.SKILL_GO = 1;
        this.SKILL_DONE = 2;
        this.m_GameStage = gameStage;
        this.SkillAttack = new Vector();
        this.SkillHeal = new Vector();
        this.HeroBuf = new Vector();
        this.HeroDebuf = new Vector();
        this.HeroWeaponUI = new Vector();
        this.HeroHeadUI = new Vector();
        this.HeroBodyUI = new Vector();
        this.HeroCloveUI = new Vector();
        this.HeroShoesUI = new Vector();
        for (int i2 = 0; i2 < 6; ++i2) {
            this.m_Equipt[i2] = null;
        }
        this.m_CanUseSpell = true;
        this.m_Pos = new EPoint(this.m_GameStage.m_Hero.PosX, this.m_GameStage.m_Hero.PosY);
        this.m_PosShadow1 = new EPoint(this.m_GameStage.m_Hero.PosX, this.m_GameStage.m_Hero.PosY);
        this.m_PosShadow2 = new EPoint(this.m_GameStage.m_Hero.PosX, this.m_GameStage.m_Hero.PosY);
        this.m_SkillState = 0;
        this.m_ActionState = 4;
    }

    public void ResetUIVector() {
        this.HeroWeaponUI.removeAllElements();
        this.HeroHeadUI.removeAllElements();
        this.HeroBodyUI.removeAllElements();
        this.HeroCloveUI.removeAllElements();
        this.HeroShoesUI.removeAllElements();
    }

    public void InitEquipt(int[] nArray) {
        EItem eItem = null;
        for (int i2 = 0; i2 < 6; ++i2) {
            if (nArray[i2] == -1) {
                this.m_Equipt[i2] = null;
                continue;
            }
            for (int i3 = 0; i3 < this.m_GameStage.m_Items.size(); ++i3) {
                EItem eItem2 = (EItem)this.m_GameStage.m_Items.elementAt(i3);
                if (eItem2.id != nArray[i2]) continue;
                eItem = eItem2;
                break;
            }
            this.m_Equipt[i2] = new ItemUnit(this.m_GameStage, eItem);
        }
    }

    public void ChangeHP(int n2) {
        this.HP_Now += n2;
        if (this.HP_Now >= this.HP_Total) {
            this.HP_Now = this.HP_Total;
        }
        this.m_HPR = Common.ChangetoFrame(this.HP_Now);
    }

    public void ChangeSP(int n2) {
        this.SP_Now += n2;
        if (this.SP_Now >= this.SP_Total) {
            this.SP_Now = this.SP_Total;
        }
        this.m_SPR = Common.ChangetoFrame(this.SP_Now);
    }

    public void ChangeRP(int n2) {
        this.RP += n2;
        if (this.RP >= 100) {
            this.RP = 100;
        }
    }

    public abstract void Create(int var1);

    public void Init() {
        switch (this.m_HeroID) {
            case 1: {
                this.m_HeroSpx = new SpriteX("/res/Heros/boy.sprite", "/res/Heros/boy.png");
                break;
            }
            case 2: {
                this.m_HeroSpx = new SpriteX("/res/Heros/female1.sprite", "/res/Heros/female1.png");
                break;
            }
            case 3: {
                this.m_HeroSpx = new SpriteX("/res/Heros/sister.sprite", "/res/Heros/sister.png");
            }
        }
        this.m_HeroSpx.setAction(4);
        this.m_HeroSpx.enableUpdate(false);
        this.m_HitPos = new EPoint();
    }

    public abstract void InitBattle();

    public abstract void Release();

    public abstract void ReleaseBattle();

    public abstract void Update();

    public void ResetRound() {
        this.CheckBuf();
        this.InPosition(0);
        this.m_GameStage.m_Hero.m_ShowBlack = false;
        this.m_GameStage.m_Hero.m_InSkill = false;
        for (int i2 = 0; i2 < this.m_GameStage.m_EnemyMgr.m_Enemy.size(); ++i2) {
            ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt(i2)).UpdateBattle();
        }
        this.ChangeSpx(5, 0);
        this.m_PosShadow2.setPoint(this.m_Pos);
        this.m_PosShadow1.setPoint(this.m_Pos);
        this.m_Effect.m_PlayDone = true;
        this.m_HeroShadow1.m_PlayDone = true;
        this.m_HeroShadow2.m_PlayDone = true;
        this.m_GameStage.m_Hero.m_State = 2;
        this.m_GameStage.m_Hero.m_MagicAttack = false;
        this.m_GameStage.m_Hero.m_SuperAttack = false;
        this.m_GameStage.m_Hero.m_UseItem = false;
        this.TP = 0;
        this.m_GameStage.m_Hero.otheraction = false;
        this.m_InCommand = false;
        this.m_GameStage.m_Hero.m_Confirm = false;
        this.m_GameStage.m_Hero.m_ChooseDown = false;
        this.m_GameStage.m_Hero.m_ChooseUp = false;
        this.m_GameStage.m_Hero.m_CountDelay = 0;
        this.m_GameStage.m_Hero.m_ItemIndex = 0;
        this.m_GameStage.m_Hero.m_MagicIndex = 0;
        this.m_GameStage.m_Hero.m_ChooseIndex = 0;
        this.m_GameStage.m_Hero.m_SkillEffect = 0;
        this.m_GameStage.m_UI.ResetUI();
        this.m_GameStage.m_Hero.m_Damage = 0;
        this.m_GameStage.m_Hero.m_Heal = 0;
        this.m_GameStage.m_Hero.m_RecoverSP = 0;
    }

    public void UpdateSkillPrepare() {
        if (this.m_GameStage.m_Hero.m_SkillOn.getFrame() == 2) {
            this.m_GameStage.m_Hero.m_ShowBlack = false;
        }
        if (!this.m_GameStage.m_Hero.m_SkillOn.isEnableUpdate()) {
            this.m_GameStage.m_Hero.m_SkillOn.setVisible(false);
            this.m_SkillState = 1;
            this.m_HeroSpx.enableUpdate(true);
        }
        this.m_GameStage.m_Hero.m_SkillOn.update();
        if (this.m_GameStage.m_Hero.m_SkillOn.getFrame() == this.m_GameStage.m_Hero.m_SkillOn.getSequenceLength() - 1) {
            this.m_GameStage.m_Hero.m_SkillOn.enableUpdate(false);
        }
    }

    public void UpdateAttack() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (this.m_HeroID) {
            case 1: {
                n6 = 1;
                n5 = 2;
                n4 = 10;
                n3 = 13;
                n2 = 17;
                break;
            }
            case 2: {
                n6 = 1;
                n5 = 2;
                n4 = 3;
                n3 = 6;
                n2 = 11;
                break;
            }
            case 3: {
                n6 = 1;
                n5 = 2;
                n4 = 3;
                n3 = 6;
                n2 = 11;
            }
        }
        this.m_HeroShadow1.UpdateAnim();
        this.m_HeroShadow2.UpdateAnim();
        if (this.m_HeroSpx.getFrame() == n6) {
            this.m_HeroShadow1.StartAnim("attack");
        }
        if (this.m_HeroSpx.getFrame() == n5) {
            this.m_HeroShadow2.StartAnim("attack");
        }
        if (this.m_HeroSpx.getFrame() >= n4 && this.m_HeroSpx.getFrame() <= n4 + 2) {
            this.m_PosShadow2.setPoint(this.m_PosShadow1);
            this.m_PosShadow1.setPoint(this.m_Pos);
            if (this.m_HeroSpx.getFrame() <= n4 + 2) {
                this.m_Pos.x += Common.NormalAttackOffsetX(this.m_BattlePos, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_BattlePos);
                this.m_Pos.y += Common.NormalAttackOffsetY(this.m_BattlePos, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_BattlePos);
            }
        }
        if (this.m_HeroSpx.getFrame() == n3) {
            ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt(this.m_GameStage.m_Hero.m_ChooseIndex)).ChangeSpx(3);
            ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_BloodType = 0;
            this.m_GameStage.m_Hero.m_Damage = this.AP - ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).DP;
            if (this.m_GameStage.m_Hero.m_Damage <= 0) {
                this.m_GameStage.m_Hero.m_Damage = 1;
            }
            if (Soul.getRandom(0, 100) <= this.C_Rate) {
                this.m_GameStage.m_Critical = true;
                this.m_GameStage.m_Hero.m_Damage = this.m_GameStage.m_Hero.m_Damage * 3 / 2;
            }
            if (this.m_GameStage.m_Hero.m_Damage > 999) {
                this.m_GameStage.m_Hero.m_Damage = 999;
            }
            NumEffect numEffect = new NumEffect(this.m_GameStage.m_Hero.m_Damage, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_PosX + 20, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_PosY - 20, 0);
            this.m_GameStage.m_Common.AddEffect(numEffect);
        }
        if (this.m_HeroSpx.getFrame() >= n2 && this.m_HeroSpx.getFrame() <= n2 + 2) {
            this.m_PosShadow2.setPoint(this.m_PosShadow1);
            this.m_PosShadow1.setPoint(this.m_Pos);
            if (this.m_HeroSpx.getFrame() <= n2 + 2) {
                this.m_Pos.x -= Common.NormalAttackOffsetX(this.m_BattlePos, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_BattlePos);
                this.m_Pos.y -= Common.NormalAttackOffsetY(this.m_BattlePos, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_BattlePos);
            }
        }
        if (this.m_HeroSpx.getFrame() == this.m_HeroSpx.getSequenceLength() - 1) {
            for (int i2 = 0; i2 < this.m_GameStage.m_EnemyMgr.m_Enemy.size(); ++i2) {
                ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt(i2)).UpdateBattle();
            }
            this.ChangeSpx(5, 0);
            this.CheckBuf();
            this.m_PosShadow2.setPoint(this.m_Pos);
            this.m_PosShadow1.setPoint(this.m_Pos);
            this.m_GameStage.m_Hero.m_State = 2;
            this.m_GameStage.m_Hero.m_Attack = false;
            this.TP = 0;
            this.m_GameStage.m_Hero.otheraction = false;
            this.m_InCommand = false;
            this.m_GameStage.m_Hero.m_Confirm = false;
            this.m_GameStage.m_Hero.m_ChooseDown = false;
            this.m_GameStage.m_Hero.m_ChooseUp = false;
            this.m_GameStage.m_Hero.m_CountDelay = 0;
            this.m_Skill = null;
            this.m_GameStage.m_Hero.m_ChooseIndex = 0;
            this.m_GameStage.m_Hero.m_SkillEffect = 0;
            this.m_GameStage.m_UI.ResetUI();
            this.m_GameStage.m_Hero.m_Damage = 0;
        }
    }

    public void UpdateHitEffect() {
        this.m_Effect.UpdateAnim();
        switch (this.m_ActionState) {
            case 9: {
                if (this.m_HeroSpx.getFrame() != 1) break;
                this.m_Effect.StartAnim("hit");
                this.m_HitPos.setPoint(this.m_HeroSpx.getReferencePointX(0) + this.m_Pos.x, this.m_HeroSpx.getReferencePointY(0) + this.m_Pos.y);
            }
        }
    }

    public void UpdateEnemyMove() {
        switch (this.m_ActionState) {
            case 5: {
                this.m_HeroSpx.update();
                break;
            }
            case 8: 
            case 9: {
                if (this.HP_Now <= 0 || this.m_ActionState == 10) break;
                this.m_HeroSpx.update();
                this.UpdateHitEffect();
                if (this.m_HeroSpx.getFrame() != this.m_HeroSpx.getSequenceLength() - 1) break;
                this.ChangeHP(-this.m_GameStage.m_EnemyMgr.m_Damage);
                this.ChangeSpx(5, 0);
                this.m_HitPos.setPoint(0, 0);
                for (int i2 = 0; i2 < this.HeroDebuf.size(); ++i2) {
                    Buf buf = (Buf)this.HeroDebuf.elementAt(i2);
                    if (buf.m_Buf != 6) continue;
                    buf.m_Round = 0;
                }
                break;
            }
        }
        this.UpdateFace();
    }

    public abstract void Show(Graphics var1);

    public abstract void ShowHeal(Graphics var1);

    public void ShowItemEffect(Graphics graphics) {
        if (this.m_Effect.GetAnim() != null && !this.m_Effect.m_PlayDone) {
            switch (this.m_GameStage.m_ItemMgr.m_Item.m_Item.oeType) {
                case 1: 
                case 2: {
                    if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type == 8) {
                        this.m_GameStage.m_CommenEffect.paintAddFrame(graphics, ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_Pos.x + ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_HeroSpx.getReferencePointX(0), ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_Pos.y + ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_HeroSpx.getReferencePointY(0), this.m_Effect.GetFrameSpx());
                        return;
                    }
                    if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type != 9) break;
                    for (int i2 = 0; i2 < this.m_GameStage.m_Hero.m_Heros.size(); ++i2) {
                        GameObject gameObject = (GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt(i2);
                        if (!gameObject.m_InGroup) continue;
                        this.m_GameStage.m_CommenEffect.paintAddFrame(graphics, gameObject.m_Pos.x + gameObject.m_HeroSpx.getReferencePointX(0), gameObject.m_Pos.y + gameObject.m_HeroSpx.getReferencePointY(0), this.m_Effect.GetFrameSpx());
                    }
                    return;
                }
                case 0: {
                    if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type == 6) {
                        this.m_GameStage.m_CommenEffect.paintLightenFrame(graphics, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_PosX, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_PosY, this.m_Effect.GetFrameSpx());
                        return;
                    }
                    if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type != 7) break;
                    for (int i3 = 0; i3 < this.m_GameStage.m_EnemyMgr.m_Enemy.size(); ++i3) {
                        this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt(i3);
                        Object var3_6 = null;
                        this.m_GameStage.m_CommenEffect.paintLightenFrame(graphics, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)i3)).m_PosX, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)i3)).m_PosY, this.m_Effect.GetFrameSpx());
                    }
                    return;
                }
                case 3: {
                    if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type == 10) {
                        this.m_GameStage.m_CommenEffect.paintAddFrame(graphics, ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_Pos.x + ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_HeroSpx.getReferencePointX(0), ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_Pos.y + ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_HeroSpx.getReferencePointY(0), this.m_Effect.GetFrameSpx());
                        return;
                    }
                    if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type != 11) break;
                    for (int i4 = 0; i4 < this.m_GameStage.m_Hero.m_Heros.size(); ++i4) {
                        GameObject gameObject = (GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt(i4);
                        if (!gameObject.m_InGroup) continue;
                        this.m_GameStage.m_CommenEffect.paintAddFrame(graphics, gameObject.m_Pos.x + gameObject.m_HeroSpx.getReferencePointX(0), gameObject.m_Pos.y + gameObject.m_HeroSpx.getReferencePointY(0), this.m_Effect.GetFrameSpx());
                    }
                    break;
                }
            }
        }
    }

    public void ShowPlayer(Graphics graphics) {
        if (this.m_SkillState == 1) {
            if (this.m_HeroShadow2.GetAnim() != null && !this.m_HeroShadow2.m_PlayDone) {
                this.m_HeroSpx.paintAlphaFrame(graphics, this.m_PosShadow2.x, this.m_PosShadow2.y, this.m_HeroShadow2.GetFrameSpx(), 100);
            }
            if (this.m_HeroShadow1.GetAnim() != null && !this.m_HeroShadow1.m_PlayDone) {
                this.m_HeroSpx.paintAlphaFrame(graphics, this.m_PosShadow1.x, this.m_PosShadow1.y, this.m_HeroShadow1.GetFrameSpx(), 170);
            }
        }
        this.m_HeroSpx.paint(graphics, this.m_Pos.x, this.m_Pos.y);
    }

    public abstract void ChangeSpx(int var1, int var2);

    public void CheckSkill(int n2) {
        if (n2 == 0) {
            this.m_GameStage.m_Hero.m_SkillEffect = 0;
            this.m_GameStage.m_Hero.m_ChooseIndex = 0;
            return;
        }
        if (n2 == 99) {
            this.m_Skill = this.m_SuperSkill;
            this.m_GameStage.m_Hero.m_SkillEffect = this.m_Skill.type;
            if (this.m_Skill.type == 0) {
                this.m_GameStage.m_Hero.m_ChooseIndex = 0;
                return;
            }
            if (this.m_Skill.type == 2) {
                this.m_GameStage.m_Hero.m_ChooseIndex = this.m_BattlePos;
                return;
            }
            if (this.m_Skill.type == 4) {
                this.m_GameStage.m_Hero.m_ChooseIndex = this.m_BattlePos;
                return;
            }
        } else {
            this.m_Skill = (ESkill)this.m_GameStage.m_UI.m_Magic[this.m_UIID].elementAt(n2 - 1);
            this.m_GameStage.m_Hero.m_SkillEffect = this.m_Skill.type;
            if (this.m_Skill.type == 0) {
                this.m_GameStage.m_Hero.m_ChooseIndex = 0;
                return;
            }
            if (this.m_Skill.type == 2) {
                this.m_GameStage.m_Hero.m_ChooseIndex = this.m_BattlePos;
                return;
            }
            if (this.m_Skill.type == 4) {
                this.m_GameStage.m_Hero.m_ChooseIndex = this.m_BattlePos;
            }
        }
    }

    public void ResetHero() {
        this.TP = 0;
        this.m_InCommand = false;
        this.m_Skill = null;
    }

    public void Damage() {
        if (this.m_GameStage.m_Hero.m_Damage <= 0) {
            this.m_GameStage.m_Hero.m_Damage = 1;
        }
        if (Soul.getRandom(0, 100) <= this.C_Rate) {
            this.m_GameStage.m_Critical = true;
            this.m_GameStage.m_Hero.m_Damage = this.m_GameStage.m_Hero.m_Damage * 3 / 2;
        }
        if (this.m_GameStage.m_Hero.m_Damage > 999) {
            this.m_GameStage.m_Hero.m_Damage = 999;
        }
        NumEffect numEffect = new NumEffect(this.m_GameStage.m_Hero.m_Damage, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_PosX + 20, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_PosY - 20, 0);
        this.m_GameStage.m_Common.AddEffect(numEffect);
    }

    public void InPosition(int n2) {
        switch (n2) {
            case 0: {
                this.m_Pos.setPoint(this.m_GameStage.m_GameData.m_PosInBattle[this.m_BattlePos]);
                this.m_PosShadow1.setPoint(this.m_Pos);
                this.m_PosShadow2.setPoint(this.m_PosShadow1);
                return;
            }
            case 1: {
                this.m_Pos.setPoint(this.m_GameStage.m_GameData.m_PosInBattle[1]);
                this.m_PosShadow1.setPoint(this.m_Pos);
                this.m_PosShadow2.setPoint(this.m_PosShadow1);
            }
        }
    }

    public boolean CheckExp() {
        if (this.Now_Exp >= this.Next_Exp) {
            this.Now_Exp -= this.Next_Exp;
            ++this.LV;
            this.Create(this.LV);
            return true;
        }
        return false;
    }

    public void CheckExp1() {
        if (this.Now_Exp >= this.Next_Exp) {
            this.Now_Exp -= this.Next_Exp;
            ++this.LV;
            this.Create(this.LV);
            this.CheckExp1();
        }
    }

    public void InitEquipt() {
        this.HP_Total += Soul.m_Addon[this.m_HeroID - 1][0];
        this.SP_Total += Soul.m_Addon[this.m_HeroID - 1][1];
        this.Strengh += Soul.m_Addon[this.m_HeroID - 1][2];
        this.Stamina += Soul.m_Addon[this.m_HeroID - 1][3];
        this.Intellect += Soul.m_Addon[this.m_HeroID - 1][4];
        this.Agility += Soul.m_Addon[this.m_HeroID - 1][5];
        this.AP += 2 * Soul.m_Addon[this.m_HeroID - 1][2];
        this.DP += 3 * Soul.m_Addon[this.m_HeroID - 1][3];
        for (int i2 = 0; i2 < this.m_Equipt.length; ++i2) {
            if (this.m_Equipt[i2] == null) continue;
            this.HP_Total += this.m_Equipt[i2].m_Item.ee[0];
            this.SP_Total += this.m_Equipt[i2].m_Item.ee[1];
            this.Strengh += this.m_Equipt[i2].m_Item.ee[4];
            this.Stamina += this.m_Equipt[i2].m_Item.ee[5];
            this.Intellect += this.m_Equipt[i2].m_Item.ee[6];
            this.Agility += this.m_Equipt[i2].m_Item.ee[7];
            this.AP += 2 * this.m_Equipt[i2].m_Item.ee[4];
            this.DP += 3 * this.m_Equipt[i2].m_Item.ee[5];
            this.AP += this.m_Equipt[i2].m_Item.ee[2];
            this.DP += this.m_Equipt[i2].m_Item.ee[3];
            this.TP_Rate = this.Agility;
            this.C_Rate = this.Agility / 5;
        }
    }

    public void CheckBuf() {
        Buf buf;
        int n2;
        for (n2 = 0; n2 < this.HeroBuf.size(); ++n2) {
            buf = (Buf)this.HeroBuf.elementAt(n2);
            if (buf.m_Round > 0) continue;
            this.AP = buf.m_ap;
            this.DP = buf.m_dp;
            this.TP_Rate = buf.m_tpRate;
            this.HeroBuf.removeElement(buf);
            --n2;
            this.m_GameStage.m_UI.m_BufIndex = 0;
        }
        for (n2 = 0; n2 < this.HeroDebuf.size(); ++n2) {
            buf = (Buf)this.HeroDebuf.elementAt(n2);
            if (buf.m_Round > 0) continue;
            this.HeroDebuf.removeElement(buf);
            --n2;
            this.m_GameStage.m_UI.m_DebufIndex = 0;
        }
    }

    public void UpdateItemEffect() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        switch (this.m_HeroID) {
            case 1: {
                n5 = 3;
                n4 = 5;
                n3 = 3;
                n2 = 4;
                break;
            }
            case 2: {
                n5 = 5;
                n4 = 8;
                n3 = 5;
                n2 = 6;
                break;
            }
            case 3: {
                n5 = 2;
                n4 = 5;
                n3 = 2;
                n2 = 3;
            }
        }
        switch (this.m_GameStage.m_ItemMgr.m_Item.m_Item.oeType) {
            case 1: {
                this.m_Effect.UpdateAnim();
                if (this.m_HeroSpx.getFrame() == n5) {
                    this.m_Effect.StartAnim("heal");
                }
                if (this.m_HeroSpx.getFrame() != n4) break;
                this.m_GameStage.m_Hero.m_Heal = this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe[0];
                if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type == 8) {
                    if (((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HP_Now <= 0) break;
                    ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt(this.m_GameStage.m_Hero.m_ChooseIndex)).ChangeHP(this.m_GameStage.m_Hero.m_Heal);
                    block24: for (n5 = 1; n5 < this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe.length; ++n5) {
                        switch (this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe[n5]) {
                            case 6: {
                                for (n4 = 0; n4 < ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroDebuf.size(); ++n4) {
                                    Buf buf = (Buf)((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroDebuf.elementAt(n4);
                                    if (buf.m_Buf != 3) continue;
                                    ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroDebuf.removeElement(buf);
                                    continue block24;
                                }
                                continue block24;
                            }
                            case 8: {
                                for (n4 = 0; n4 < ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroDebuf.size(); ++n4) {
                                    Buf buf = (Buf)((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroDebuf.elementAt(n4);
                                    if (buf.m_Buf != 6) continue;
                                    ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroDebuf.removeElement(buf);
                                    continue block24;
                                }
                                continue block24;
                            }
                            case 9: {
                                for (n4 = 0; n4 < ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroDebuf.size(); ++n4) {
                                    Buf buf = (Buf)((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroDebuf.elementAt(n4);
                                    if (buf.m_Buf != 4) continue;
                                    ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroDebuf.removeElement(buf);
                                    ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_CanUseSpell = true;
                                    continue block24;
                                }
                                continue block24;
                            }
                        }
                    }
                    if (this.m_GameStage.m_Hero.m_Heal == 0) break;
                    NumEffect numEffect = new NumEffect(this.m_GameStage.m_Hero.m_Heal, ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_Pos.x + 40, ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_Pos.y - 20, 1);
                    this.m_GameStage.m_Common.AddEffect(numEffect);
                    return;
                }
                if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type != 9) break;
                for (n5 = 0; n5 < this.m_GameStage.m_Hero.m_Heros.size(); ++n5) {
                    GameObject gameObject = (GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt(n5);
                    if (!gameObject.m_InGroup || gameObject.HP_Now <= 0) continue;
                    gameObject.ChangeHP(this.m_GameStage.m_Hero.m_Heal);
                    NumEffect numEffect = new NumEffect(this.m_GameStage.m_Hero.m_Heal, gameObject.m_Pos.x + 40, gameObject.m_Pos.y - 20, 1);
                    this.m_GameStage.m_Common.AddEffect(numEffect);
                }
                return;
            }
            case 2: {
                this.m_Effect.UpdateAnim();
                if (this.m_HeroSpx.getFrame() == n5) {
                    this.m_Effect.StartAnim("heal");
                }
                if (this.m_HeroSpx.getFrame() != n4) break;
                this.m_GameStage.m_Hero.m_RecoverSP = this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe[0];
                if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type == 8) {
                    if (((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HP_Now <= 0) break;
                    ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt(this.m_GameStage.m_Hero.m_ChooseIndex)).ChangeSP(this.m_GameStage.m_Hero.m_RecoverSP);
                    NumEffect numEffect = new NumEffect(this.m_GameStage.m_Hero.m_RecoverSP, ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_Pos.x + 40, ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_Pos.y - 20, 2);
                    this.m_GameStage.m_Common.AddEffect(numEffect);
                    return;
                }
                if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type != 9) break;
                for (n5 = 0; n5 < this.m_GameStage.m_Hero.m_Heros.size(); ++n5) {
                    GameObject gameObject = (GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt(n5);
                    if (!gameObject.m_InGroup || gameObject.HP_Now <= 0) continue;
                    gameObject.ChangeSP(this.m_GameStage.m_Hero.m_RecoverSP);
                    NumEffect numEffect = new NumEffect(this.m_GameStage.m_Hero.m_RecoverSP, gameObject.m_Pos.x + 40, gameObject.m_Pos.y - 20, 2);
                    this.m_GameStage.m_Common.AddEffect(numEffect);
                }
                return;
            }
            case 0: {
                this.m_Effect.UpdateAnim();
                if (this.m_HeroSpx.getFrame() == n3) {
                    this.m_Effect.StartAnim("itemattack");
                }
                if (this.m_HeroSpx.getFrame() != n2) break;
                this.m_GameStage.m_Hero.m_Damage = this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe[0];
                if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type == 6) {
                    ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt(this.m_GameStage.m_Hero.m_ChooseIndex)).ChangeSpx(3);
                    NumEffect numEffect = new NumEffect(this.m_GameStage.m_Hero.m_Damage, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_PosX + 20, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_PosY - 20, 0);
                    this.m_GameStage.m_Common.AddEffect(numEffect);
                    return;
                }
                if (this.m_GameStage.m_ItemMgr.m_Item.m_Item.type != 7) break;
                for (n5 = 0; n5 < this.m_GameStage.m_EnemyMgr.m_Enemy.size(); ++n5) {
                    ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt(n5)).ChangeSpx(3);
                    NumEffect numEffect = new NumEffect(this.m_GameStage.m_Hero.m_Damage, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)n5)).m_PosX + 20, ((EnemyUnit)this.m_GameStage.m_EnemyMgr.m_Enemy.elementAt((int)n5)).m_PosY - 20, 0);
                    this.m_GameStage.m_Common.AddEffect(numEffect);
                }
                return;
            }
            case 3: {
                this.m_Effect.UpdateAnim();
                if (this.m_HeroSpx.getFrame() == n5) {
                    this.m_Effect.StartAnim("itembuf");
                }
                if (this.m_HeroSpx.getFrame() != n4 || this.m_GameStage.m_ItemMgr.m_Item.m_Item.type != 10) break;
                if (((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HP_Now > 0) {
                    block31: for (n5 = 1; n5 < this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe.length; ++n5) {
                        switch (this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe[n5]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                if (((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroBuf.size() == 0) {
                                    Buf buf = new Buf(this.m_GameStage, (GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt(this.m_GameStage.m_Hero.m_ChooseIndex), this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe[n5] - 1);
                                    ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroBuf.addElement(buf);
                                    continue block31;
                                }
                                for (n4 = 0; n4 < ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroBuf.size(); ++n4) {
                                    Buf buf = new Buf(this.m_GameStage, this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe[n5] - 1);
                                    Buf buf2 = (Buf)((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroBuf.elementAt(n4);
                                    if (buf2.m_Buf == buf.m_Buf) {
                                        buf.SetContent(buf2.m_ap, buf2.m_dp, buf2.m_tpRate);
                                        ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroBuf.removeElement(buf2);
                                        ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroBuf.addElement(buf);
                                        continue block31;
                                    }
                                    if (n4 != ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroBuf.size() - 1) continue;
                                    buf.SetContent(buf2.m_ap, buf2.m_dp, buf2.m_tpRate);
                                    ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroBuf.addElement(buf);
                                    continue block31;
                                }
                                continue block31;
                            }
                            case 4: {
                                ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).RP = 100;
                                continue block31;
                            }
                            case 5: {
                                ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).HeroDebuf.removeAllElements();
                                ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_CanUseSpell = true;
                            }
                        }
                    }
                }
                block33: for (n5 = 1; n5 < this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe.length; ++n5) {
                    switch (this.m_GameStage.m_ItemMgr.m_Item.m_Item.oe[n5]) {
                        case 10: {
                            if (((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_ActionState != 10) continue block33;
                            ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt(this.m_GameStage.m_Hero.m_ChooseIndex)).ChangeSpx(5, 0);
                            ++Soul.m_StillAlive;
                            ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt(this.m_GameStage.m_Hero.m_ChooseIndex)).ChangeHP(1000);
                            ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt(this.m_GameStage.m_Hero.m_ChooseIndex)).ChangeSP(500);
                            NumEffect numEffect = new NumEffect(1000, ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_Pos.x + 40, ((GameObject)this.m_GameStage.m_Hero.m_Heros.elementAt((int)this.m_GameStage.m_Hero.m_ChooseIndex)).m_Pos.y - 20, 1);
                            this.m_GameStage.m_Common.AddEffect(numEffect);
                        }
                    }
                }
                break;
            }
        }
    }

    public void UpdateFace() {
        if (this.HP_Now > 0 && this.HP_Now < this.HP_Total / 3) {
            this.m_Face = 5;
            this.m_BattleState = 2;
        } else if (this.HP_Now <= 0 && this.m_ActionState != 10) {
            this.HP_Now = 0;
            this.SP_Now = 0;
            this.TP = 0;
            this.RP = 0;
            this.m_HPR = Common.ChangetoFrame(this.HP_Now);
            this.m_SPR = Common.ChangetoFrame(this.SP_Now);
            for (int i2 = 0; i2 < this.HeroBuf.size(); ++i2) {
                Buf buf = (Buf)this.HeroBuf.elementAt(i2);
                this.AP = buf.m_ap;
                this.DP = buf.m_dp;
                this.TP_Rate = buf.m_tpRate;
            }
            this.HeroBuf.removeAllElements();
            this.HeroDebuf.removeAllElements();
            this.m_GameStage.m_UI.m_BufIndex = 0;
            this.m_CanUseSpell = true;
            this.m_GameStage.m_UI.m_DebufIndex = 0;
            this.ChangeSpx(10, 0);
            this.m_BattleState = 3;
            if (--Soul.m_StillAlive <= 0) {
                this.m_GameStage.m_LastState = this.m_GameStage.m_FrameState;
                this.m_GameStage.m_FrameState = 6;
            }
            this.m_GameStage.m_UI.m_Anim_Rage[this.m_UIID].m_PlayDone = true;
        } else if (this.m_ActionState != 10) {
            this.m_Face = 0;
            this.m_BattleState = 0;
        }
        if (this.HeroDebuf.size() != 0) {
            this.m_Face = 6;
        }
        if (this.RP >= 100) {
            if (this.m_UIID != -1 && (this.m_GameStage.m_UI.m_Anim_Rage[this.m_UIID].GetAnim() == null || this.m_GameStage.m_UI.m_Anim_Rage[this.m_UIID].m_PlayDone)) {
                this.m_GameStage.m_UI.m_Anim_Rage[this.m_UIID].StartAnim("rage");
            }
            this.RP = 100;
            this.m_Face = 2;
            this.m_BattleState = 1;
        }
    }
}

