/*
 * Decompiled with CFR 0.152.
 */
package mappy;

import java.io.InputStream;
import java.util.Hashtable;
import mappy.ChunkLoadException;
import mappy.ChunkLoader;
import mappy.ChunkLoaderANDT;
import mappy.ChunkLoaderATHR;
import mappy.ChunkLoaderBGFX;
import mappy.ChunkLoaderBKDT;
import mappy.ChunkLoaderBODY;
import mappy.ChunkLoaderCMAP;
import mappy.ChunkLoaderFORM;
import mappy.ChunkLoaderMPHD;
import mappy.ChunkLoaderTSTR;
import mappy.JavaMappyException;
import mappy.Logger;
import mappy.Map;
import mappy.MapLoader$DefaultChunkLoader;
import mappy.ParameterChecker;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MapLoader {
    private static final Logger a = Logger.createLogger("MapLoader");
    private Hashtable a = new Hashtable();

    public MapLoader() {
        this.a("ANDT", new ChunkLoaderANDT());
        this.a("ATHR", new ChunkLoaderATHR());
        this.a("BGFX", new ChunkLoaderBGFX());
        this.a("BKDT", new ChunkLoaderBKDT());
        this.a("CMAP", new ChunkLoaderCMAP());
        this.a("FORM", new ChunkLoaderFORM());
        this.a("MPHD", new ChunkLoaderMPHD());
        this.a("TSTR", new ChunkLoaderTSTR());
        ChunkLoaderBODY chunkLoaderBODY = new ChunkLoaderBODY();
        this.a("BODY", chunkLoaderBODY);
        this.a("LYR1", chunkLoaderBODY);
        this.a("LYR2", chunkLoaderBODY);
        this.a("LYR3", chunkLoaderBODY);
        this.a("LYR4", chunkLoaderBODY);
        this.a("LYR5", chunkLoaderBODY);
        this.a("LYR6", chunkLoaderBODY);
        this.a("LYR7", chunkLoaderBODY);
    }

    public static Map loadMap(InputStream inputStream) {
        return new MapLoader().a(inputStream);
    }

    private Map a(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input parameter [inputStream] was null");
        }
        a.trace("loadMap() - Starting...");
        a.info("Loading Map from InputStream");
        Map map = new Map();
        try {
            ChunkLoader chunkLoader = this.a(inputStream);
            if (!chunkLoader.getChunkName().equals("FORM")) {
                throw new JavaMappyException("Map does not start with chunk [FORM] :: Chunk ID = [" + chunkLoader.getChunkName() + "]");
            }
            chunkLoader.loadChunk(null);
            for (long i2 = (long)(chunkLoader.getChunkLength() - 4); i2 > 0L; i2 -= (long)chunkLoader.getChunkLength()) {
                chunkLoader = this.a(inputStream);
                chunkLoader.loadChunk(map);
                if (chunkLoader.getBytesRemaining() > 0) {
                    a.warn("Chunk [" + chunkLoader.getChunkName() + "] still has [" + chunkLoader.getBytesRemaining() + "] bytes remaining, skipping...");
                }
                i2 -= 8L;
            }
        }
        catch (JavaMappyException javaMappyException) {
            JavaMappyException javaMappyException2 = javaMappyException;
            throw javaMappyException;
        }
        catch (Exception exception) {
            throw new JavaMappyException("Could not load map", exception);
        }
        a.trace("loadMap() - Done.");
        return map;
    }

    private ChunkLoader a(InputStream inputStream) {
        ParameterChecker.checkNotNull(inputStream, "inputStream");
        ChunkLoader chunkLoader = null;
        String string = null;
        a.trace("createChunkLoader() - Starting...");
        try {
            byte[] byArray = new byte[4];
            string = "Could not read the chunk ID.";
            MapLoader.a(inputStream, byArray, 4);
            String string2 = new String(byArray);
            string = "Could not read the chunk length for Chunk ID [" + string2 + "]";
            MapLoader.a(inputStream, byArray, 4);
            int n2 = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                n2 <<= 8;
                n2 |= byArray[i2] & 0xFF;
            }
            string = "Could not read the raw chunk data for Chunk ID [" + string2 + "]";
            byArray = new byte[n2];
            if (string2.equals("FORM")) {
                MapLoader.a(inputStream, byArray, 4);
            } else {
                MapLoader.a(inputStream, byArray, n2);
            }
            string = "Problem setting Default Chunk Loader attributes.";
            chunkLoader = new MapLoader$DefaultChunkLoader();
            chunkLoader.a(string2, byArray);
            string = "Could not find a ChunkLoader for ID=[" + string2 + "].";
            ChunkLoader chunkLoader2 = (ChunkLoader)this.a.get(string2);
            if (chunkLoader2 == null) {
                throw new RuntimeException();
            }
            chunkLoader = chunkLoader2;
            string = "Problem initialiising Chunk Loader.";
            chunkLoader.a(string2, byArray);
        }
        catch (Exception exception) {
            if (chunkLoader != null) {
                a.warn(string);
            }
            throw new ChunkLoadException(string, exception);
        }
        a.info(chunkLoader);
        a.trace("createChunkLoader() - Done.");
        return chunkLoader;
    }

    private void a(String string, ChunkLoader chunkLoader) {
        this.a.put(string, chunkLoader);
    }

    private static void a(InputStream inputStream, byte[] byArray, int n2) {
        for (int i2 = 0; i2 > -1 && i2 < n2; i2 += inputStream.read(byArray, i2, n2 - i2)) {
        }
    }
}

