/*
 * Decompiled with CFR 0.152.
 */
package mappy;

import mappy.MapHeader;
import mappy.ParameterChecker;
import mappy.Renderer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class Viewer {
    protected final MapHeader a;
    protected final Renderer a;
    protected int a;
    protected int b;
    protected int c;
    protected int d;
    protected int e;
    protected int f;
    protected boolean a;

    public Viewer(MapHeader mapHeader, Renderer renderer, int n2, int n3, int n4, int n5) {
        ParameterChecker.checkNotNull(mapHeader, "mapHeader");
        ParameterChecker.checkNotNull(renderer, "renderer");
        this.a = mapHeader;
        this.a = renderer;
        this.setViewWidth(n2);
        this.setViewHeight(n3);
        this.setViewOffsetX(n4);
        this.setViewOffsetY(n5);
        this.a = mapHeader.isRisingPillarMode();
    }

    public int getViewWidth() {
        return this.a;
    }

    public void setViewWidth(int n2) {
        ParameterChecker.checkMinMax(n2, "viewWidth", 1, this.a.getMapPixelWidth());
        this.a = n2;
    }

    public int getViewHeight() {
        return this.b;
    }

    public void setViewHeight(int n2) {
        ParameterChecker.checkMinMax(n2, "viewHeight", 1, this.a.getMapPixelHeight());
        this.b = n2;
    }

    public int getViewOffsetX() {
        return this.c;
    }

    public void setViewOffsetX(int n2) {
        ParameterChecker.checkMin(n2, "viewOffsetX", 0);
        this.c = n2;
    }

    public int getViewOffsetY() {
        return this.d;
    }

    public void setViewOffsetY(int n2) {
        ParameterChecker.checkMin(n2, "viewOffsetY", 0);
        this.d = n2;
    }

    public Renderer getRenderer() {
        return this.a;
    }

    public MapHeader getMapHeader() {
        return this.a;
    }

    public boolean isPillarRiserMode() {
        return this.a;
    }

    public void setPillarRiserMode(boolean bl) {
        this.a = bl;
    }

    public int getPixelX() {
        return this.e;
    }

    public void setPixelX(int n2) {
        ParameterChecker.checkMinMax(n2, "pixelX", 0, this.a.getMapPixelWidth() - this.a);
        this.e = n2;
    }

    public void addPixelX(int n2) {
        this.e += n2;
    }

    public int getPixelY() {
        return this.f;
    }

    public void setPixelY(int n2) {
        ParameterChecker.checkMinMax(n2, "pixelY", 0, this.a.getMapPixelHeight() - this.b);
        this.f = n2;
    }

    public void addPixelY(int n2) {
        this.f += n2;
    }

    public int getBlockX() {
        return this.e / this.a.getBlockWidth();
    }

    public void setBlockX(int n2) {
        ParameterChecker.checkMinMax(n2, "blockX", 0, this.a.getMapBlockWidth() - this.a / this.a.getBlockWidth());
        this.e = n2 * this.a.getBlockWidth();
    }

    public void addBlockX(int n2) {
        this.e += n2 * this.a.getBlockWidth();
    }

    public int getBlockY() {
        return this.f / this.a.getBlockHeight();
    }

    public void setBlockY(int n2) {
        ParameterChecker.checkMinMax(n2, "blockY", 0, this.a.getMapBlockHeight() - this.b / this.a.getBlockHeight());
        this.f = n2 * this.a.getBlockHeight();
    }

    public void addBlockY(int n2) {
        this.f += n2 * this.a.getBlockHeight();
    }

    public abstract void draw(Object var1, boolean var2);

    public abstract void draw(Object var1, boolean var2, int var3, int var4, int var5, int var6);
}

