/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Animation {
    String[] texts;
    public int vectorIndex = -1;
    private String imgPath = "";
    private static final int ANIM_IMAGE_COUNT = 45;
    public static final int FIRST_ANIM_IMAGE_ID = 3;
    public static Image[] s_animImages = new Image[45];
    private Image m_animImage;
    public int m_ID;
    public int m_imageID;
    public int m_imageIndex;
    private short m_imageWidth;
    private short m_imageHeight;
    private short[] m_modules;
    private short[][] m_frames;
    public short[][] m_actions;
    public byte[] m_vXYs;
    public Image animImg = null;
    private static DirectGraphics s_dg;

    public Animation(String[] texts) {
        this.texts = texts;
    }

    public Animation(String file, int effect, Vector vector) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(file);
        sb.append(".bin");
        DataInputStream dis = new DataInputStream(sb.toString().getClass().getResourceAsStream(sb.toString()));
        String path = dis.readUTF();
        boolean isAdd = true;
        for (int i = 0; i < vector.size(); i += 3) {
            if (!path.equals((String)vector.elementAt(i)) || effect != (Integer)vector.elementAt(i + 1)) continue;
            this.animImg = (Image)vector.elementAt(i + 2);
            this.m_imageWidth = (short)this.animImg.getWidth();
            this.m_imageHeight = (short)this.animImg.getHeight();
            isAdd = false;
            this.vectorIndex = i / 3;
            break;
        }
        if (isAdd) {
            StringBuffer msb = new StringBuffer();
            msb.append(path);
            msb.append(".png");
            this.animImg = Tool.updateImg(effect, msb.toString());
            this.m_imageWidth = (short)this.animImg.getWidth();
            this.m_imageHeight = (short)this.animImg.getHeight();
            vector.addElement(file);
            vector.addElement(new Integer(effect));
            vector.addElement(this.animImg);
            this.vectorIndex = vector.size();
        }
        this.loadMoudle(dis);
        this.loadFrame(dis);
        this.loadAction(dis);
        dis.close();
        dis = null;
    }

    public Animation(String file, int effect, boolean loadImg) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(file);
        sb.append(".bin");
        DataInputStream dis = new DataInputStream(sb.toString().getClass().getResourceAsStream(sb.toString()));
        String path = dis.readUTF();
        StringBuffer msb = new StringBuffer();
        msb.append(path);
        msb.append(".png");
        if (loadImg) {
            this.animImg = Tool.updateImg(effect, msb.toString());
            this.m_imageWidth = (short)this.animImg.getWidth();
            this.m_imageHeight = (short)this.animImg.getHeight();
        } else {
            this.imgPath = msb.toString();
        }
        this.loadMoudle(dis);
        this.loadFrame(dis);
        this.loadAction(dis);
        dis.close();
        dis = null;
    }

    public short[] getModules() {
        return this.m_modules;
    }

    public void load(DataInputStream dis) throws Exception {
        this.m_imageID = dis.readUnsignedShort();
        this.m_imageIndex = this.m_imageID - 3;
        if (s_animImages[this.m_imageIndex] == null) {
            Animation.s_animImages[this.m_imageIndex] = Image.createImage((String)("/" + this.texts[this.m_imageID]));
            this.m_imageWidth = (short)s_animImages[this.m_imageIndex].getWidth();
            this.m_imageHeight = (short)s_animImages[this.m_imageIndex].getHeight();
        } else {
            this.m_imageWidth = (short)s_animImages[this.m_imageIndex].getWidth();
            this.m_imageHeight = (short)s_animImages[this.m_imageIndex].getHeight();
        }
        this.loadMoudle(dis);
        this.loadFrame(dis);
        this.loadAction(dis);
    }

    public void loadMoudle(DataInputStream dis) throws Exception {
        int count = dis.readInt();
        this.m_modules = new short[count * 4];
        for (int i = 0; i < count; ++i) {
            this.m_modules[i * 4] = (short)dis.readInt();
            this.m_modules[i * 4 + 1] = (short)dis.readInt();
            this.m_modules[i * 4 + 2] = (short)dis.readInt();
            this.m_modules[i * 4 + 3] = (short)dis.readInt();
        }
    }

    public void loadFrame(DataInputStream dis) throws Exception {
        int count = dis.readUnsignedByte();
        this.m_frames = new short[count][];
        for (int i = 0; i < count; ++i) {
            dis.skipBytes(2);
            int count2 = dis.readUnsignedByte();
            this.m_frames[i] = new short[count2 * 4];
            for (int ii = 0; ii < count2 * 4; ++ii) {
                this.m_frames[i][ii] = (short)dis.readUnsignedShort();
            }
        }
    }

    public void loadAction(DataInputStream dis) throws Exception {
        int count = dis.readUnsignedByte();
        this.m_actions = new short[count][];
        this.m_vXYs = new byte[count * 2];
        for (int i = 0; i < count; ++i) {
            dis.skipBytes(1);
            int count2 = dis.readUnsignedByte();
            this.m_actions[i] = new short[count2];
            for (int j = 0; j < count2; ++j) {
                int data1 = dis.readUnsignedByte();
                int data2 = dis.readUnsignedByte();
                this.m_actions[i][j] = (short)((data2 << 8) + data1);
            }
            this.m_vXYs[i * 2] = (byte)(dis.readShort() >> 8);
            this.m_vXYs[i * 2 + 1] = (byte)(dis.readShort() >> 8);
        }
    }

    public void draw(GCanvas gamecanvas, int x, int y, boolean flipX, boolean flipY, int frameIndex) {
        Graphics g = gamecanvas.g;
        Image img = null;
        img = this.animImg == null ? s_animImages[this.m_imageIndex] : this.animImg;
        short[] frame = this.m_frames[frameIndex];
        for (int i = 0; i < frame.length; i += 4) {
            int modID = (frame[i] & 0xFFFF) << 2;
            int flag = frame[i + 1] & 0xFFFF;
            int modX = this.m_modules[modID];
            int modY = this.m_modules[modID + 1];
            int modW = this.m_modules[modID + 2];
            short modH = this.m_modules[modID + 3];
            if (modX + modW > this.m_imageWidth) {
                modW = (short)(this.m_imageWidth - modX);
            }
            if (modY + modH > this.m_imageHeight) {
                modH = (short)(this.m_imageHeight - modY);
            }
            if (modW <= 0 || modH <= 0) continue;
            boolean flipX_real = flipX ^ (flag & 1) != 0;
            boolean flipY_real = flipY ^ (flag & 2) != 0;
            int posX = x;
            int posY = y;
            posX = flipX ? (posX -= frame[i + 2]) : (posX += frame[i + 2]);
            posY = flipY ? (posY -= frame[i + 3]) : (posY += frame[i + 3]);
            if (flipX_real) {
                posX -= modW;
            }
            if (flipY_real) {
                posY -= modH;
            }
            flag = Animation.trans(flipX_real, flipY_real);
            if (posX + modW < 0 || posX >= 240) continue;
            int clipX = posX;
            int clipY = posY;
            int clipW = modW;
            short clipH = modH;
            if (clipX < 0) {
                clipW += clipX;
                clipX = 0;
            }
            if (clipX + clipW > 240) {
                clipW = 240 - clipX;
            }
            g.setClip(clipX, clipY, clipW, (int)clipH);
            g.clipRect(clipX, clipY, clipW, (int)clipH);
            posX -= flipX_real ? this.m_imageWidth - modX - modW : modX;
            posY -= flipY_real ? this.m_imageHeight - modY - modH : modY;
            if (flag == 0) {
                g.drawImage(img, posX, posY, 20);
                continue;
            }
            g.drawRegion(img, 0, 0, (int)this.m_imageWidth, (int)this.m_imageHeight, flag, posX, posY, 20);
        }
        g.setClip(0, 0, GCanvas.s_screenwidth, GCanvas.s_screenheight);
        g.clipRect(0, 0, GCanvas.s_screenwidth, GCanvas.s_screenheight);
    }

    public void dispose() {
        int i;
        this.animImg = null;
        this.m_modules = null;
        if (this.m_frames != null) {
            for (i = 0; i < this.m_frames.length; ++i) {
                this.m_frames[i] = null;
            }
            this.m_frames = null;
        }
        if (this.m_actions != null) {
            for (i = 0; i < this.m_actions.length; ++i) {
                this.m_actions[i] = null;
            }
            this.m_actions = null;
        }
        this.m_vXYs = null;
    }

    public static int trans(boolean flipX, boolean flipY) {
        if (flipX) {
            if (flipY) {
                return 3;
            }
            return 2;
        }
        if (flipY) {
            return 1;
        }
        return 0;
    }

    public void loadImage(int effect) {
        this.animImg = Tool.updateImg(effect, this.imgPath);
        this.m_imageWidth = (short)this.animImg.getWidth();
        this.m_imageHeight = (short)this.animImg.getHeight();
    }
}

