/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Block {
    GCanvas gameCanvas;
    Menu[] menu = null;
    public static Image[] graphImg = null;
    public String[] imgPath;
    public short[] imgEff;
    public int graphImgCount;
    public int actorCount;
    private int menuIndex = 0;
    private int[] nextIndex;
    public static int s_selectedIndex = 0;
    private int updateIndex = 0;
    private boolean s_isRunning = true;
    private static final int INTERVAL = 80;
    private long s_tickCounter = 0L;
    private static final int TRIGGER_TIME = 0;
    private static final int TRIGGER_KEY = 1;
    private Graphics g;

    public Block(GCanvas gameCanvas) {
        this.gameCanvas = gameCanvas;
    }

    public void loadBlock(String fileName) {
        DataInputStream dis = new DataInputStream(fileName.getClass().getResourceAsStream(fileName));
        try {
            int i;
            this.graphImgCount = dis.readShort();
            graphImg = new Image[this.graphImgCount];
            this.imgPath = new String[this.graphImgCount];
            this.imgEff = new short[this.graphImgCount];
            for (i = 0; i < this.graphImgCount; ++i) {
                this.imgPath[i] = dis.readUTF();
                this.imgEff[i] = dis.readShort();
                Block.graphImg[i] = Tool.updateImg(this.imgEff[i], this.imgPath[i]);
            }
            this.actorCount = dis.readShort();
            this.menu = new Menu[dis.readInt()];
            for (i = 0; i < this.menu.length; ++i) {
                this.menu[i] = new Menu(this.gameCanvas);
                this.menu[i].loadMenu(dis);
            }
            for (i = 0; i < this.graphImgCount; ++i) {
                Block.graphImg[i] = null;
            }
            graphImg = null;
            dis.close();
            dis = null;
            if (fileName.equals("/battle.bin")) {
                this.menu[18].param[1] = GCanvas.s_rightConfirm ? 1 : 0;
                this.menu[19].param[0] = GCanvas.s_rightConfirm ? 1 : 0;
                this.menu[20].param[0] = GCanvas.s_rightConfirm ? 1 : 0;
            } else if (fileName.equals("/logo.bin")) {
                this.menu[1].param[0] = GCanvas.s_rightConfirm ? 1 : 0;
            } else if (fileName.equals("/cover.bin")) {
                this.menu[2].param[1] = GCanvas.s_rightConfirm ? 1 : 0;
                this.menu[3].param[0] = GCanvas.s_rightConfirm ? 1 : 0;
                this.menu[4].param[0] = GCanvas.s_rightConfirm ? 1 : 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void unloadBlock() {
        if (this.menu == null) {
            return;
        }
        for (int i = 0; i < this.menu.length; ++i) {
            this.menu[i].unloadMenu();
        }
        this.menu = null;
    }

    public void unloadBlockImg() {
        for (int i = 0; i < this.menu.length; ++i) {
            this.menu[i].unloadMenuImg();
        }
    }

    public void loadBlockImg() {
        try {
            int i;
            graphImg = new Image[this.graphImgCount];
            for (i = 0; i < this.graphImgCount; ++i) {
                Block.graphImg[i] = Tool.updateImg(this.imgEff[i], this.imgPath[i]);
            }
            for (i = 0; i < this.menu.length; ++i) {
                this.menu[i].loadMenuImg();
            }
            for (i = 0; i < graphImg.length; ++i) {
                Block.graphImg[i] = null;
            }
            graphImg = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateKeyAI() {
        block8: {
            block11: {
                block10: {
                    block9: {
                        if (this.menu[this.menuIndex].trigger == 0 && this.s_tickCounter >= (long)this.menu[this.menuIndex].time) {
                            if (this.nextIndex.length < 1) {
                                this.s_isRunning = false;
                                return;
                            }
                            this.setMenuIndex(this.nextIndex[s_selectedIndex]);
                        }
                        if (this.menu[this.menuIndex].trigger != 1) break block8;
                        if (!this.menu[this.menuIndex].anykey) break block9;
                        Block block = this;
                        if (block.gameCanvas.anyKeyPressed()) break block10;
                    }
                    Block block = this;
                    if (!block.gameCanvas.keyConfirmed()) break block11;
                }
                if (this.nextIndex.length < 1) {
                    this.s_isRunning = false;
                    return;
                }
                if (s_selectedIndex >= this.nextIndex.length) {
                    s_selectedIndex = 0;
                }
                this.setMenuIndex(this.nextIndex[s_selectedIndex]);
            }
            Block block = this;
            if (block.gameCanvas.keyCanceled() && this.menu[this.menuIndex].allowBack) {
                this.setMenuIndex(this.menu[this.menuIndex].parent);
            }
        }
    }

    public void run(GCanvas gameCanvas) {
        this.setMenuIndex(this.getMainIndex());
        this.s_isRunning = true;
        this.g = gameCanvas.g;
        while (this.s_isRunning) {
            try {
                long tick = System.currentTimeMillis() + 80L;
                this.g.setFont(GCanvas.s_font);
                gameCanvas.updateKeyBegin();
                this.updateKeyAI();
                if (this.menuIndex != -1) {
                    this.menu[this.menuIndex].draw(this.g, this.s_tickCounter, GCanvas.keyCurrent);
                }
                gameCanvas.updateKeyEnd();
                gameCanvas.flush();
                while (tick > System.currentTimeMillis()) {
                    Thread.yield();
                }
                ++this.s_tickCounter;
            }
            catch (Throwable t) {}
        }
    }

    private int getMainIndex() {
        for (int i = 0; i < this.menu.length; ++i) {
            if (this.menu[i].parent != -1) continue;
            return i;
        }
        return -1;
    }

    public int getMenuIndex() {
        return this.menuIndex;
    }

    public void setMenuIndex(int menuIndex) {
        this.s_tickCounter = 0L;
        this.menuIndex = menuIndex;
        if (menuIndex != -1) {
            int count = 0;
            int[] temp = new int[this.menu.length];
            for (int i = 0; i < this.menu.length; ++i) {
                if (this.menu[i].parent != this.menu[menuIndex].id) continue;
                temp[count++] = i;
            }
            this.nextIndex = new int[count];
            Tool.arraycopy(temp, 0, this.nextIndex, 0, count);
        }
    }
}

