/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;

public class Actor {
    Scene scene;
    String[] texts;
    public static Actor s_player;
    public static Actor[] s_head;
    public static Actor s_face;
    public static Actor s_eff;
    public static Actor[] s_follow;
    public static final int ID_FIRST = 0;
    public static final int ID_SECOND = 1;
    public static final int ID_THIRD = 2;
    public static final int ID_FORTH = 3;
    public short[] m_vXYs = new short[0];
    public short[] m_parameter = new short[0];
    public boolean m_flipOldX = false;
    public static final int FM_FOLLOW = 0;
    public static final int FM_FLEX = 1;
    public static final int FM_MEET = 2;
    private static final int FP_POSX = 0;
    private static final int FP_POSY = 1;
    private static final int FP_LAYER = 2;
    private static final int FP_ACTION = 3;
    private static final int FP_CYCLE = 4;
    private static final int FP_COUNT = 5;
    private static final int DELAY = 2;
    public Actor followActor = null;
    private int[][] followParam = null;
    public static int followMode;
    private static final int PARAM_LAYER = 0;
    private int followIndex = 0;
    private int followBegin = 0;
    private int followLenth = 0;
    public boolean m_isWake = true;
    public int m_viewLen = 32;
    public int m_viewBox0 = 0;
    public int m_viewBox1 = 1;
    public int m_viewBox2 = 2;
    public int m_viewBox3 = 3;
    public int m_ID;
    public int m_activeBox0;
    public int m_activeBox1;
    public int m_activeBox2;
    public int m_activeBox3;
    public int m_animID;
    public Animation m_anim;
    protected int m_actionIDNow;
    protected boolean m_actionCycle = true;
    protected boolean m_actionOver;
    protected int m_frameIDNow;
    public int m_frameIndex;
    protected int m_frameDuration;
    protected boolean m_flipX;
    protected boolean m_flipY;
    protected boolean m_active;
    protected int m_layer = 0;
    protected int m_actionIDbefore;
    public boolean m_inScreen = true;
    public boolean m_isVisible = true;
    public int m_vel;
    public int m_offheight = 0;
    public int m_posX;
    public int m_posY;
    public int m_vX;
    public int m_vY;
    public int m_prePosX;
    public int m_prePosY;
    public int m_initPosX;
    public int m_initPosY;
    public static boolean s_isChangeGameStatus;
    public static int s_isCollideID;
    public boolean m_runScript = false;
    public static boolean isRunPoleScript;
    public static int s_limitlevel;
    public static int SID_LOADLEVEL;
    public static int SID_FLY;
    public static int SID_STEAL;
    public static int SID_CANTOUT;
    public static int SID_CANTIN;
    public static int SID_LOWLEVEL;
    public static short s_scriptParam;
    public static String s_artName;
    public static final String s_boxhead = "\u83b7\u53d6";
    private static final int PP_LEVEL = 0;
    private static final int PP_ACTORID = 1;
    private static final int PP_ACTION = 2;
    private static final int PP_UPDATETILE = 3;
    public static boolean isRunPointScript;
    private static final int REBORN_TIME = 200;
    private int m_timerToReborn = 0;
    private int m_collide = 0;
    private static final int COL_TOP = 1;
    private static final int COL_BOTTOM = 2;
    private static final int COL_LEFT = 4;
    private static final int COL_RIGHT = 8;
    private int m_startX;
    private int m_startY;
    private int m_endX;
    private int m_endY;
    private boolean m_isDirX = true;
    public static final int HIGH_LAYER = 8;
    public int lastColNum = 8;
    public static final int MAX_MISSION_NUM = 50;
    public static final int MAX_ACCEPT_NUM = 5;
    public static byte s_missionCount;
    public static byte[] s_missionFlag;
    public static short[][] s_missionVariable;
    private static final int ART_ARM = 0;
    private static final int ART_GOODS = 1;
    public static final int ID_STR_HELP0 = 0;
    public static final int ID_STR_HELP1 = 1;
    public static final int ID_STR_HELP2 = 2;
    public static final int ID_FIRST_PNG = 3;
    public static final int ID_MENGPO_PNG = 3;
    public static final int ID_SICAOBING_PNG = 4;
    public static final int ID_ZHALAN1_PNG = 5;
    public static final int ID_BEIBEI_PNG = 6;
    public static final int ID_CHUANG_PNG = 7;
    public static final int ID_MUBEI_PNG = 8;
    public static final int ID_HUANGJIN01_PNG = 9;
    public static final int ID_SHOUSHANG_PNG = 10;
    public static final int ID_JIEHUN_PNG = 11;
    public static final int ID_YAN_PNG = 12;
    public static final int ID_TANHAO_PNG = 13;
    public static final int ID_LIUBEI_PNG = 14;
    public static final int ID_GUSHENCANJUAN_PNG = 15;
    public static final int ID_ZHUGE_PNG = 16;
    public static final int ID_ZHOUYU02_PNG = 17;
    public static final int ID_ZHAOYUN02_PNG = 18;
    public static final int ID_ZHANGFEI02_PNG = 19;
    public static final int ID_SUN05_PNG = 20;
    public static final int ID_SUN04_PNG = 21;
    public static final int ID_SHEN02_PNG = 22;
    public static final int ID_SHEN01_PNG = 23;
    public static final int ID_SHANG_PNG = 24;
    public static final int ID_LIDIAN02_PNG = 25;
    public static final int ID_JIAO02_PNG = 26;
    public static final int ID_HUANGJIN02_PNG = 27;
    public static final int ID_HAN05_PNG = 28;
    public static final int ID_HAN04_PNG = 29;
    public static final int ID_GUANYU02_PNG = 30;
    public static final int ID_CAOJUN02_PNG = 31;
    public static final int ID_CAOQI_PNG = 32;
    public static final int ID_CAOCAO_PNG = 33;
    public static final int ID_XIANGZI_PNG = 34;
    public static final int ID_CUNCHUDIAN_PNG = 35;
    public static final int ID_SANJIANTOU_PNG = 36;
    public static final int ID_POINT_PNG = 37;
    public static final int ID_BIAOQING_PNG = 38;
    public static final int ID_JT_PNG = 39;
    public static final int ID_ZHANGYAO02_PNG = 40;
    public static final int ID_CHUGE02_PNG = 41;
    public static final int ID_HUO1_PNG = 42;
    public static final int ID_6_PNG = 43;
    public static final int ID_1_PNG = 44;
    public static final int ID_4_PNG = 45;
    public static final int ID_3_PNG = 46;
    public static final int ID_5_PNG = 47;
    public static final int ID_PNG_COUNT = 45;
    public static final int ID_MONSTER = 0;
    public static final int MONSTER_DAHUO = 0;
    public static final int MONSTER_DAHUO1 = 1;
    public static final int MONSTER_DAHUO2 = 2;
    public static final int ID_FIRSTROLE = 1;
    public static final int FIRSTROLE_RESTN = 0;
    public static final int FIRSTROLE_RESTS = 1;
    public static final int FIRSTROLE_RESTW = 2;
    public static final int FIRSTROLE_RESTE = 3;
    public static final int FIRSTROLE_NORTH = 4;
    public static final int FIRSTROLE_SOUTH = 5;
    public static final int FIRSTROLE_WEST = 6;
    public static final int FIRSTROLE_EAST = 7;
    public static final int FIRSTROLE_FLYN = 8;
    public static final int FIRSTROLE_FLYS = 9;
    public static final int FIRSTROLE_FLYW = 10;
    public static final int FIRSTROLE_FLYE = 11;
    public static final int FIRSTROLE_FLYNORTH = 12;
    public static final int FIRSTROLE_FLYESOUTH = 13;
    public static final int FIRSTROLE_FLYEWEST = 14;
    public static final int FIRSTROLE_FLYEEAST = 15;
    public static final int ID_SECONDROLE = 2;
    public static final int SECONDROLE_RESTN = 0;
    public static final int SECONDROLE_RESTS = 1;
    public static final int SECONDROLE_RESTW = 2;
    public static final int SECONDROLE_RESTE = 3;
    public static final int SECONDROLE_NORTH = 4;
    public static final int SECONDROLE_SOUTH = 5;
    public static final int SECONDROLE_WEST = 6;
    public static final int SECONDROLE_EAST = 7;
    public static final int ID_POINT = 3;
    public static final int POINT_POINT = 0;
    public static final int ID_POLE = 4;
    public static final int POLE_JIANTOU = 0;
    public static final int POLE_SA = 1;
    public static final int POLE_SB = 2;
    public static final int POLE_SC = 3;
    public static final int POLE_SD = 4;
    public static final int POLE_SE = 5;
    public static final int ID_FACE = 5;
    public static final int FACE_XIN = 0;
    public static final int FACE_WENHAO = 1;
    public static final int FACE_FANU = 2;
    public static final int FACE_WUYU = 3;
    public static final int FACE_KU = 4;
    public static final int FACE_XIAO = 5;
    public static final int ID_HEADFIRSTROLE = 6;
    public static final int HEADFIRSTROLE_LIYUCHENG = 0;
    public static final int ID_HEADSECONDROLE = 7;
    public static final int HEADSECONDROLE_LINZIYUE = 0;
    public static final int ID_HEADTHIRDROLE = 8;
    public static final int HEADTHIRDROLE_HANZHICONG = 0;
    public static final int ID_HEADFORTHROLE = 9;
    public static final int HEADFORTHROLE_QINLIANGHAN = 0;
    public static final int ID_ROADSIGN = 10;
    public static final int ROADSIGN_SHANG = 0;
    public static final int ROADSIGN_XIA = 1;
    public static final int ROADSIGN_ZUO = 2;
    public static final int ROADSIGN_YOU = 3;
    public static final int ID_SAVE = 11;
    public static final int SAVE_UNTITLED1 = 0;
    public static final int ID_EFFECT = 12;
    public static final int EFFECT_UNTITLED1 = 0;
    public static final int ID_BOX = 13;
    public static final int BOX_GUAN = 0;
    public static final int BOX_KAI = 1;
    public static final int BOX_GUAN1 = 2;
    public static final int BOX_KAI1 = 3;
    public static final int ID_CAO = 14;
    public static final int CAO_RESTN = 0;
    public static final int CAO_RESTS = 1;
    public static final int ID_CAOQI = 15;
    public static final int CAOQI_RESTN = 0;
    public static final int CAOQI_RESTS = 1;
    public static final int CAOQI_RESTW = 2;
    public static final int CAOQI_RESTE = 3;
    public static final int ID_CAOJUN = 16;
    public static final int CAOJUN_RESTN = 0;
    public static final int CAOJUN_RESTS = 1;
    public static final int CAOJUN_RESTW = 2;
    public static final int CAOJUN_RESTE = 3;
    public static final int CAOJUN_NORTH = 4;
    public static final int CAOJUN_SOUTH = 5;
    public static final int CAOJUN_WEST = 6;
    public static final int CAOJUN_EAST = 7;
    public static final int ID_GUANYU = 17;
    public static final int GUANYU_RESTN = 0;
    public static final int GUANYU_RESTS = 1;
    public static final int GUANYU_RESTW = 2;
    public static final int GUANYU_RESTE = 3;
    public static final int GUANYU_NORTH = 4;
    public static final int GUANYU_SOUTH = 5;
    public static final int GUANYU_WEST = 6;
    public static final int GUANYU_EAST = 7;
    public static final int ID_HANJIN = 18;
    public static final int HANJIN_RESTN = 0;
    public static final int HANJIN_RESTS = 1;
    public static final int HANJIN_RESTW = 2;
    public static final int HANJIN_RESTE = 3;
    public static final int HANJIN_NORTH = 4;
    public static final int HANJIN_SOUTH = 5;
    public static final int HANJIN_WEST = 6;
    public static final int HANJIN_EAST = 7;
    public static final int ID_HANJINMA = 19;
    public static final int HANJINMA_RESTN = 0;
    public static final int HANJINMA_RESTS = 1;
    public static final int HANJINMA_RESTW = 2;
    public static final int HANJINMA_RESTE = 3;
    public static final int ID_HUANGJIN = 20;
    public static final int HUANGJIN_RESTN = 0;
    public static final int HUANGJIN_RESTS = 1;
    public static final int HUANGJIN_RESTW = 2;
    public static final int HUANGJIN_RESTE = 3;
    public static final int ID_ZHANGJIAO = 21;
    public static final int ZHANGJIAO_RESTN = 0;
    public static final int ZHANGJIAO_RESTS = 1;
    public static final int ID_LIDIAN = 22;
    public static final int LIDIAN_RESTN = 0;
    public static final int LIDIAN_RESTS = 1;
    public static final int LIDIAN_RESTW = 2;
    public static final int LIDIAN_RESTE = 3;
    public static final int LIDIAN_NORTH = 4;
    public static final int LIDIAN_SOUTH = 5;
    public static final int LIDIAN_WEST = 6;
    public static final int LIDIAN_EAST = 7;
    public static final int ID_SHANGREN = 23;
    public static final int SHANGREN_RESTN = 0;
    public static final int SHANGREN_RESTS = 1;
    public static final int ID_SHENYANMA = 24;
    public static final int SHENYANMA_RESTN = 0;
    public static final int SHENYANMA_RESTS = 1;
    public static final int SHENYANMA_RESTW = 2;
    public static final int SHENYANMA_RESTE = 3;
    public static final int ID_SHENYAN = 25;
    public static final int SHENYAN_RESTN = 0;
    public static final int SHENYAN_RESTS = 1;
    public static final int SHENYAN_RESTW = 2;
    public static final int SHENYAN_RESTE = 3;
    public static final int SHENYAN_NORTH = 4;
    public static final int SHENYAN_SOUTH = 5;
    public static final int SHENYAN_WEST = 6;
    public static final int SHENYAN_EAST = 7;
    public static final int ID_SUNJUN = 26;
    public static final int SUNJUN_RESTS = 0;
    public static final int SUNJUN_RESTN = 1;
    public static final int SUNJUN_RESTW = 2;
    public static final int SUNJUN_RESTE = 3;
    public static final int SUNJUN_NORTH = 4;
    public static final int SUNJUN_SOUTH = 5;
    public static final int SUNJUN_WEST = 6;
    public static final int SUNJUN_EAST = 7;
    public static final int ID_SUNJUNMA = 27;
    public static final int SUNJUNMA_RESTN = 0;
    public static final int SUNJUNMA_RESTS = 1;
    public static final int SUNJUNMA_RESTW = 2;
    public static final int SUNJUNMA_RESTE = 3;
    public static final int ID_ZHANGFEI = 28;
    public static final int ZHANGFEI_RESTN = 0;
    public static final int ZHANGFEI_RESTS = 1;
    public static final int ZHANGFEI_RESTW = 2;
    public static final int ZHANGFEI_RESTE = 3;
    public static final int ZHANGFEI_NORTH = 4;
    public static final int ZHANGFEI_SOUTH = 5;
    public static final int ZHANGFEI_WEST = 6;
    public static final int ZHANGFEI_EAST = 7;
    public static final int ID_ZHAOYUN = 29;
    public static final int ZHAOYUN_RESTN = 0;
    public static final int ZHAOYUN_RESTS = 1;
    public static final int ZHAOYUN_RESTW = 2;
    public static final int ZHAOYUN_RESTE = 3;
    public static final int ZHAOYUN_NORTH = 4;
    public static final int ZHAOYUN_SOUTH = 5;
    public static final int ZHAOYUN_WEST = 6;
    public static final int ZHAOYUN_EAST = 7;
    public static final int ID_ZHOUYU = 30;
    public static final int ZHOUYU_RESTN = 0;
    public static final int ZHOUYU_RESTS = 1;
    public static final int ZHOUYU_RESTW = 2;
    public static final int ZHOUYU_RESTE = 3;
    public static final int ZHOUYU_NORTH = 4;
    public static final int ZHOUYU_SOUTH = 5;
    public static final int ZHOUYU_WEST = 6;
    public static final int ZHOUYU_EAST = 7;
    public static final int ID_ZHUGE = 31;
    public static final int ZHUGE_RESTN = 0;
    public static final int ZHUGE_RESTS = 1;
    public static final int ID_CANJUAN = 32;
    public static final int CANJUAN_GUSHENCANJUAN = 0;
    public static final int ID_LIUBEI = 33;
    public static final int LIUBEI_RESTN = 0;
    public static final int LIUBEI_RESTS = 1;
    public static final int ID_WENHAO = 34;
    public static final int WENHAO_TANHAO = 0;
    public static final int ID_XIAOGUO = 35;
    public static final int XIAOGUO_UNTITLED1 = 0;
    public static final int ID_JIEHUN = 36;
    public static final int JIEHUN_XINLANG = 0;
    public static final int JIEHUN_XINNIANG = 1;
    public static final int ID_SHOUSHANG = 37;
    public static final int SHOUSHANG_SHOUSHANG = 0;
    public static final int SHOUSHANG_ZHONGSHANG = 1;
    public static final int ID_HANJINGHUANG = 38;
    public static final int HANJINGHUANG_FITOUT = 0;
    public static final int HANJINGHUANG_HARM = 1;
    public static final int HANJINGHUANG_DUCK = 2;
    public static final int HANJINGHUANG_ATTACK0 = 3;
    public static final int HANJINGHUANG_BACKOFF = 4;
    public static final int ID_MUBEI = 39;
    public static final int MUBEI_MUBEI = 0;
    public static final int ID_CHUANG = 40;
    public static final int CHUANG_CHUANG = 0;
    public static final int ID_BEIBEI = 41;
    public static final int BEIBEI_BEIBEI = 0;
    public static final int ID_ZHALAN = 42;
    public static final int ZHALAN_ZHALAN1 = 0;
    public static final int ID_SHOUSHANG01 = 43;
    public static final int SHOUSHANG01_CAOBING = 0;
    public static final int ID_MENGPO = 44;
    public static final int MENGPO_RESTN = 0;
    public static final int MENGPO_RESTS = 1;

    public Actor() {
    }

    public Actor(Scene scene, String[] texts) {
        this.scene = scene;
        this.texts = texts;
    }

    public void loadActor(DataInputStream dis, int id) throws Exception {
        short bytesCount = dis.readShort();
        int temp_parameterCount = (bytesCount - 16) / 2;
        int temp_animID = dis.readUnsignedByte();
        this.m_ID = id;
        this.m_animID = temp_animID;
        this.m_actionIDNow = dis.readUnsignedByte();
        int flag = dis.readUnsignedByte();
        this.m_flipOldX = (flag & 1) != 0;
        this.m_flipY = (flag & 2) != 0;
        this.m_active = (flag & 8) != 0;
        this.m_layer = (flag & 0x10) != 0 ? 0 : 2;
        dis.skipBytes(1);
        this.m_posX = dis.readShort();
        this.m_posY = dis.readShort();
        this.m_activeBox0 = dis.readShort() - this.m_posX;
        this.m_activeBox1 = dis.readShort() - this.m_posY;
        this.m_activeBox2 = dis.readShort() - this.m_posX;
        this.m_activeBox3 = dis.readShort() - this.m_posY;
        if (temp_parameterCount != 0) {
            this.m_parameter = new short[temp_parameterCount];
            for (int j = 0; j < temp_parameterCount; ++j) {
                this.m_parameter[j] = dis.readShort();
            }
        }
        this.m_layer = 0;
        switch (temp_animID) {
            case 1: 
            case 2: {
                switch (temp_animID) {
                    case 1: {
                        GMap.centerPlayer = s_player = this;
                        Actor.s_follow[0] = this;
                        break;
                    }
                    case 2: {
                        Actor.s_follow[1] = this;
                    }
                }
                this.m_vel = 8;
                this.m_activeBox0 = -4;
                this.m_activeBox1 = -8;
                this.m_activeBox2 = 4;
                this.m_activeBox3 = 0;
                this.m_vX = 0;
                this.m_vY = 0;
                break;
            }
            case 0: {
                this.m_vel = 2;
                this.initLimitPos();
                this.m_isWake = false;
                this.m_viewBox0 = -this.m_viewLen;
                this.m_viewBox1 = -this.m_viewLen;
                this.m_viewBox2 = this.m_viewLen;
                this.m_viewBox3 = this.m_viewLen;
                break;
            }
            case 13: {
                boolean isOpen = false;
                boolean bl = isOpen = (this.scene.boxstatus >> this.m_parameter[3] & 1) == 1;
                if (isOpen) {
                    this.m_actionIDNow = 1;
                    break;
                }
                this.m_actionIDNow = 0;
                break;
            }
            case 5: {
                this.m_layer = 8;
                s_face = this;
                this.m_active = false;
                break;
            }
            case 12: {
                this.m_layer = 8;
                s_eff = this;
                this.m_active = false;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (s_head.length <= 0) break;
                Actor.s_head[temp_animID - 6] = this;
                break;
            }
        }
    }

    public void addFace(int action) {
        if (!Actor.s_face.m_active) {
            s_face.setAction(action, true);
            Actor.s_face.m_active = true;
            Actor.s_face.m_actionCycle = true;
            Actor.s_face.m_posX = this.m_posX;
            Actor.s_face.m_posY = this.m_posY - 25;
        }
    }

    public void addEffect(short action) {
        if (!Actor.s_eff.m_active) {
            s_eff.setAction(action, true);
            Actor.s_eff.m_active = true;
            Actor.s_eff.m_actionCycle = true;
            Actor.s_eff.m_posX = this.m_posX;
            Actor.s_eff.m_posY = this.m_posY;
        }
    }

    public void follow(Actor followActor) {
        this.followActor = followActor;
        this.followParam = new int[2][5];
        this.followParam[0][0] = followActor.m_posX;
        this.followParam[0][1] = followActor.m_posY;
        this.followParam[0][2] = followActor.m_layer;
        this.followParam[0][3] = followActor.m_actionIDNow;
        this.m_actionCycle = followActor.m_actionCycle;
        this.followIndex = 0;
        this.followLenth = 1;
        this.m_posX = followActor.m_posX;
        this.m_posY = followActor.m_posY;
        this.followBegin = 0;
    }

    private void updateFollowParam() {
        if (this.followLenth < 2) {
            this.followIndex = (this.followIndex + 1) % 2;
            this.followParam[this.followIndex][0] = this.followActor.m_posX;
            this.followParam[this.followIndex][1] = this.followActor.m_posY;
            this.followParam[this.followIndex][2] = this.followActor.m_layer;
            this.followParam[this.followIndex][3] = this.followActor.m_actionIDNow % 8;
            this.followParam[this.followIndex][4] = this.followActor.m_actionCycle ? 1 : 0;
            ++this.followLenth;
        } else {
            this.m_posX = this.followParam[this.followBegin][0];
            this.m_posY = this.followParam[this.followBegin][1];
            this.m_layer = this.followParam[this.followBegin][2];
            this.m_actionIDNow = this.followParam[this.followBegin][3];
            this.m_actionCycle = this.followParam[this.followBegin][4] == 1;
            this.setAction(this.m_actionIDNow, false);
            if (this.followActor.m_vX == 0 && this.followActor.m_vY == 0) {
                this.m_vX = 0;
                this.m_vY = 0;
            } else {
                this.followIndex = this.followBegin;
                this.followParam[this.followIndex][0] = this.followActor.m_posX;
                this.followParam[this.followIndex][1] = this.followActor.m_posY;
                this.followParam[this.followIndex][2] = this.followActor.m_layer;
                this.followParam[this.followIndex][3] = this.followActor.m_actionIDNow % 8;
                this.followParam[this.followIndex][4] = this.followActor.m_actionCycle ? 1 : 0;
                this.followBegin = (this.followBegin + 1) % 2;
            }
        }
    }

    private void updateFollow() {
        switch (followMode) {
            case 0: {
                if (!this.m_isVisible) {
                    this.m_isVisible = true;
                    this.follow(this.followActor);
                    this.setAction(this.followActor.m_actionIDNow % 8, false);
                }
                this.updateFollowParam();
                break;
            }
            case 1: {
                this.m_isVisible = true;
                this.updateFollowParam();
                break;
            }
            case 2: {
                this.m_posX = this.followActor.m_posX;
                this.m_posY = this.followActor.m_posY;
                if (!this.m_isVisible) break;
                this.m_layer = this.followActor.m_layer;
                this.m_isVisible = false;
            }
        }
    }

    public Actor clone(Actor actor) {
        Actor a2 = actor;
        Actor b2 = new Actor();
        b2.m_animID = a2.m_animID;
        b2.m_anim = a2.m_anim;
        b2.m_actionIDNow = a2.m_actionIDNow;
        b2.m_flipOldX = a2.m_flipOldX;
        b2.m_flipY = a2.m_flipY;
        b2.m_active = false;
        b2.m_posX = a2.m_posX;
        b2.m_posY = a2.m_posY;
        b2.m_activeBox0 = a2.m_activeBox0;
        b2.m_activeBox1 = a2.m_activeBox1;
        b2.m_activeBox2 = a2.m_activeBox2;
        b2.m_activeBox3 = a2.m_activeBox3;
        b2.m_parameter = new short[a2.m_parameter.length];
        Tool.arraycopy(a2.m_parameter, 0, b2.m_parameter, 0, a2.m_parameter.length);
        return b2;
    }

    public void dispose() {
        if (this.m_anim != null) {
            this.m_anim.dispose();
            this.m_anim = null;
        }
        this.m_parameter = null;
        this.m_vXYs = null;
    }

    public void defineCollisionRectangle(int x, int y, int w, int h) {
        this.m_activeBox0 = x;
        this.m_activeBox1 = y;
        this.m_activeBox2 = w;
        this.m_activeBox3 = h;
    }

    public void setAction(int actionIDNext, boolean mustChange) {
        if (!mustChange && this.m_actionIDNow == actionIDNext) {
            return;
        }
        if (actionIDNext < 0) {
            actionIDNext = -actionIDNext;
            this.m_flipX = !this.m_flipOldX;
        } else {
            this.m_flipX = this.m_flipOldX;
        }
        this.m_actionIDbefore = this.m_actionIDNow;
        this.m_actionIDNow = actionIDNext;
        this.m_frameIDNow = 0;
        this.m_frameIndex = this.m_anim.m_actions[this.m_actionIDNow][0] & 0x3FF;
        this.m_frameDuration = 0;
        this.m_actionOver = false;
    }

    public boolean ActionOver() {
        return this.m_actionOver;
    }

    public void setFrame(int frameID) {
        if (frameID >= this.m_anim.m_actions[this.m_actionIDNow].length) {
            frameID = this.m_anim.m_actions[this.m_actionIDNow].length - 1;
        }
        this.m_frameIndex = this.m_anim.m_actions[this.m_actionIDNow][frameID] & 0x3FF;
        this.m_frameDuration = (this.m_anim.m_actions[this.m_actionIDNow][frameID] & 0xFFFF) >> 10;
    }

    public int getframeDuration() {
        return this.m_frameDuration;
    }

    public void setFrameEx(short frame, int Dur) {
        this.m_frameIndex = frame & 0x3FF;
        this.m_frameDuration = Dur;
    }

    public int getFrame() {
        return this.m_frameIDNow;
    }

    public short getFrameEx() {
        return (short)(this.m_frameDuration << 10 | this.m_frameIndex & 0x3FF);
    }

    public void nextFrame() {
        if (this.m_actionIDNow >= this.m_anim.m_actions.length) {
            return;
        }
        if (this.m_frameIDNow >= this.m_anim.m_actions[this.m_actionIDNow].length) {
            this.m_frameIDNow = this.m_anim.m_actions[this.m_actionIDNow].length - 1;
        }
        ++this.m_frameDuration;
        if (this.m_frameDuration < (this.m_anim.m_actions[this.m_actionIDNow][this.m_frameIDNow] & 0xFFFF) >> 10) {
            return;
        }
        ++this.m_frameIDNow;
        if (this.m_frameIDNow >= this.m_anim.m_actions[this.m_actionIDNow].length) {
            this.m_actionOver = true;
            this.m_frameIDNow = this.m_actionCycle ? 0 : this.m_anim.m_actions[this.m_actionIDNow].length - 1;
        }
        this.m_frameIndex = this.m_anim.m_actions[this.m_actionIDNow][this.m_frameIDNow] & 0x3FF;
        this.m_frameDuration = 0;
    }

    public void updatePos() {
        if (GameControl.gameStatus != 3 && !this.m_runScript) {
            return;
        }
        if (this.followActor != null && !this.m_runScript) {
            this.updateFollow();
        } else {
            this.m_prePosX = this.m_posX;
            this.m_prePosY = this.m_posY;
            this.m_posX += this.m_vX;
            this.m_posY += this.m_vY;
            if (this == s_player) {
                this.m_posX = Tool.limit(this.m_posX, 0 - this.m_activeBox0, this.scene.map.mapLimitW - this.m_activeBox2);
                this.m_posY = Tool.limit(this.m_posY, 0 - this.m_activeBox1, this.scene.map.mapLimitH - this.m_activeBox3);
            }
        }
    }

    public void draw(GCanvas gamecanvas, int camX, int camY) {
        int x = this.m_posX - camX;
        int y = this.m_posY - camY;
        this.m_anim.draw(gamecanvas, x, y, this.m_flipX, this.m_flipY, this.m_frameIndex);
    }

    public void doAI() {
        if (this.m_runScript) {
            this.ai_doScript();
            return;
        }
        if (this.m_animID == 5) {
            this.ai_FACE();
        }
        if (GameControl.gameStatus != 3) {
            return;
        }
        s_isCollideID = -1;
        if (this == s_player) {
            this.ai_PLAYER();
        } else if (this.m_animID > 13) {
            this.ai_NPC();
        } else {
            switch (this.m_animID) {
                case 0: {
                    this.ai_MONSTER();
                    break;
                }
                case 3: {
                    this.ai_POINT();
                    break;
                }
                case 13: {
                    this.ai_BOX();
                    break;
                }
                case 4: {
                    this.ai_POLE();
                    break;
                }
                case 11: {
                    this.ai_CHUCUN();
                }
            }
        }
    }

    private void ai_CHUCUN() {
        if (this.collideActor(this, s_player)) {
            this.addFace(3);
            if (GCanvas.haveKeyPressed(256)) {
                GameControl.gamecontrol.saveRecord(1);
            }
        }
    }

    private void ai_POLE() {
        if (this.collideActor(this, s_player)) {
            switch (this.m_actionIDNow) {
                case 0: {
                    this.addFace(3);
                    if (!GCanvas.haveKeyPressed(256)) break;
                    if (GScript.m_variable[this.m_parameter[4]] >= this.m_parameter[5]) {
                        this.scene.updateAnimation = true;
                        this.scene.map.updateTile = this.m_parameter[3] == 1;
                        this.scene.level = this.m_parameter[0];
                        this.scene.gate = this.m_parameter[1];
                        this.scene.dir = (Actor.s_player.m_actionIDNow >> 3 << 3) + this.m_parameter[2];
                        GScript.runScript(SID_LOADLEVEL);
                        GameControl.gamecontrol.setGameStatus(9);
                        isRunPoleScript = true;
                        break;
                    }
                    GScript.runScript(SID_CANTOUT);
                    GameControl.gamecontrol.setGameStatus(9);
                    isRunPoleScript = true;
                    break;
                }
                case 4: {
                    this.addFace(3);
                    GameControl.gamecontrol.setMapTip(Tool.MAP_NAME[this.m_parameter[4]]);
                    if (!GCanvas.haveKeyPressed(256)) break;
                    if (GScript.m_variable[this.m_parameter[4]] > 0 && OwnTeam.myteam.mates[0].level >= this.m_parameter[5]) {
                        this.scene.updateAnimation = true;
                        this.scene.map.updateTile = this.m_parameter[3] == 1;
                        this.scene.level = this.m_parameter[0];
                        this.scene.gate = this.m_parameter[1];
                        this.scene.dir = (Actor.s_player.m_actionIDNow >> 3 << 3) + this.m_parameter[2];
                        GScript.runScript(SID_LOADLEVEL);
                        GameControl.gamecontrol.setGameStatus(9);
                        isRunPoleScript = true;
                        break;
                    }
                    if (OwnTeam.myteam.mates[0].level < this.m_parameter[5]) {
                        s_limitlevel = this.m_parameter[5];
                        GScript.runScript(SID_LOWLEVEL);
                        GameControl.gamecontrol.setGameStatus(9);
                        isRunPoleScript = true;
                        break;
                    }
                    GScript.runScript(SID_CANTIN);
                    GameControl.gamecontrol.setGameStatus(9);
                    isRunPoleScript = true;
                    break;
                }
                case 1: {
                    if (GScript.m_variable[this.m_parameter[1]] < this.m_parameter[2]) break;
                    GScript.runScript(this.m_parameter[0]);
                    GameControl.gamecontrol.setGameStatus(9);
                    isRunPoleScript = true;
                    break;
                }
                case 2: {
                    if (GScript.m_variable[this.m_parameter[4]] != this.m_parameter[5]) break;
                    this.scene.updateAnimation = true;
                    this.scene.map.updateTile = this.m_parameter[3] == 1;
                    this.scene.level = this.m_parameter[0];
                    this.scene.gate = this.m_parameter[1];
                    this.scene.dir = (Actor.s_player.m_actionIDNow >> 3 << 3) + this.m_parameter[2];
                    GScript.runScript(SID_LOADLEVEL);
                    GameControl.gamecontrol.setGameStatus(9);
                    isRunPoleScript = true;
                    break;
                }
                case 3: {
                    if (GScript.m_variable[this.m_parameter[1]] != this.m_parameter[2]) break;
                    GScript.runScript(this.m_parameter[0]);
                    GameControl.gamecontrol.setGameStatus(9);
                    isRunPoleScript = true;
                    break;
                }
                case 5: {
                    if (GScript.m_variable[this.m_parameter[5]] != this.m_parameter[6]) break;
                    this.scene.updateAnimation = true;
                    this.scene.map.updateTile = this.m_parameter[3] == 1;
                    this.scene.level = this.m_parameter[0];
                    this.scene.gate = this.m_parameter[1];
                    this.scene.dir = (Actor.s_player.m_actionIDNow >> 3 << 3) + this.m_parameter[2];
                    GScript.runScript(this.m_parameter[4]);
                    GameControl.gamecontrol.setGameStatus(9);
                    isRunPoleScript = true;
                }
            }
        }
    }

    private void ai_FACE() {
        if (this.m_actionOver) {
            this.m_active = false;
            this.m_actionCycle = true;
        }
    }

    private void ai_NPC() {
        if (this.collideActor(this, s_player)) {
            if (this.m_parameter.length == 1) {
                this.addFace(3);
                if (GCanvas.haveKeyPressed(256)) {
                    GScript.runScript(this.m_parameter[0]);
                    GameControl.gamecontrol.setGameStatus(9);
                }
            }
            if (this.m_parameter.length == 2) {
                this.addFace(3);
                if (GCanvas.haveKeyPressed(256)) {
                    GameControl.s_shoptype = this.m_parameter[0];
                    GameControl.s_npcsaleindex = this.m_parameter[1];
                    GameControl.gamecontrol.setGameStatus(8);
                    GameControl.gamecontrol.setMenuStatus(48, true);
                }
            }
            if (this.m_parameter.length == 3) {
                this.addFace(3);
                if (GCanvas.haveKeyPressed(256)) {
                    GameControl.s_shoptype = this.m_parameter[0];
                    GameControl.s_npcsaleindex = this.m_parameter[1];
                    GameControl.gamecontrol.setGameStatus(8);
                    GameControl.gamecontrol.setMenuStatus(48, true);
                    GScript.s_backStatus = 8;
                    GScript.runScript(this.m_parameter[2]);
                    GameControl.gamecontrol.setGameStatus(9);
                }
            }
        }
    }

    private void ai_BOX() {
        if (this.collideActor(this, s_player)) {
            if (this.m_actionIDNow == 0) {
                s_player.addFace(1);
                if (GCanvas.haveKeyPressed(256)) {
                    if (this.m_parameter[2] == 0 || GameControl.isLearnSteal) {
                        if (this.m_parameter[0] == 0) {
                            OwnTeam.myteam.addArm(this.m_parameter[1]);
                            s_artName = GameControl.strArmName[this.m_parameter[1]];
                        } else {
                            OwnTeam.myteam.addItem(this.m_parameter[1]);
                            s_artName = GameControl.strItemName[this.m_parameter[1]];
                        }
                        StringBuffer sb = new StringBuffer();
                        sb.append(s_boxhead);
                        sb.append(s_artName);
                        GameControl.gamecontrol.setMessage(sb.toString(), 2, 10);
                        GameControl.gamecontrol.setGameStatus(17);
                        this.setAction(this.m_actionIDNow + 1, false);
                        int n = this.scene.level;
                        Scene.s_boxFlag[n] = (short)(Scene.s_boxFlag[n] | 1 << this.m_parameter[3]);
                    } else {
                        s_scriptParam = 1;
                        GScript.runScript(SID_STEAL);
                        GameControl.gamecontrol.setGameStatus(9);
                    }
                }
            } else if (GCanvas.haveKeyPressed(256)) {
                s_scriptParam = 0;
                GScript.runScript(SID_STEAL);
                GameControl.gamecontrol.setGameStatus(9);
            }
        }
    }

    private void ai_POINT() {
        if (this.collideActor(this, s_player)) {
            if (this.m_parameter.length == 6 && OwnTeam.myteam.mates[0].level < this.m_parameter[4]) {
                GScript.runScript(this.m_parameter[5]);
                GameControl.gamecontrol.setGameStatus(9);
                return;
            }
            this.scene.updateAnimation = true;
            this.scene.map.updateTile = this.m_parameter[3] == 1;
            this.scene.level = this.m_parameter[0];
            this.scene.gate = this.m_parameter[1];
            this.scene.dir = (Actor.s_player.m_actionIDNow >> 3 << 3) + this.m_parameter[2];
            isRunPointScript = true;
        }
    }

    private void ai_doScript() {
        this.m_prePosX = this.m_posX;
        this.m_prePosY = this.m_posY;
        if (this.m_vX != 0 && Math.abs(this.m_posX - GameControl.s_destX) <= this.m_vel || this.m_vY != 0 && Math.abs(this.m_posY - GameControl.s_destY) <= this.m_vel) {
            this.m_runScript = false;
            this.m_vX = 0;
            this.m_vY = 0;
            if (this.checkScriptOver()) {
                GameControl.scriptStatus = 0;
            }
        }
    }

    public boolean checkScriptOver() {
        for (int i = 0; i < this.scene.s_actorCount; ++i) {
            Actor actor = this.scene.s_actors[i];
            if (!actor.m_runScript) continue;
            return false;
        }
        return true;
    }

    private void ai_MONSTER() {
        if (!this.m_isVisible) {
            this.m_vX = 0;
            this.m_vY = 0;
            ++this.m_timerToReborn;
            if (this.m_timerToReborn >= 200) {
                this.m_isVisible = true;
            }
            return;
        }
        if (!this.m_isWake) {
            this.m_posX = Tool.limit(this.m_posX, this.m_startX, this.m_endX);
            this.m_posY = Tool.limit(this.m_posY, this.m_startY, this.m_endY);
        }
        this.mapCollide();
        if (!s_isChangeGameStatus && this.m_isVisible && this.collideActor(this, s_player) && this.m_parameter.length >= 1) {
            s_isChangeGameStatus = true;
            this.m_timerToReborn = 0;
            int id = Tool.random(0, this.m_parameter.length - 1);
            GameControl.gamecontrol.etid = this.m_parameter[id];
            return;
        }
        if (this.isInView(s_player)) {
            if (!this.m_isWake) {
                this.m_isWake = true;
                this.zoomInView();
                this.m_vel = 6;
            }
            this.updateVelo(this.m_posX - Actor.s_player.m_posX, this.m_posY - Actor.s_player.m_posY);
        } else {
            if (this.m_isWake) {
                this.m_isWake = false;
                this.zoomOutView();
                this.m_vel = 2;
                this.initLimitPos();
            }
            if (this.m_isDirX) {
                if (this.m_posX == this.m_startX || this.m_posX == this.m_endX) {
                    this.m_vX *= -1;
                }
            } else if (this.m_posY == this.m_startY || this.m_posY == this.m_endY) {
                this.m_vY *= -1;
            }
        }
    }

    private boolean isLinkActor(Actor s_player) {
        block3: {
            int tileWidth;
            int dir;
            int spanY;
            int spanX;
            block2: {
                spanX = s_player.m_posX - this.m_posX;
                spanY = s_player.m_posY - this.m_posY;
                dir = 1;
                tileWidth = this.scene.map.tileWidth;
                int tileHeight = this.scene.map.tileHeight;
                if (Math.abs(spanY) < Math.abs(spanX) || Math.abs(spanY) <= 0) break block2;
                int k = (spanX << 8) / spanY;
                int startTile = this.m_posY / tileHeight;
                int endTile = s_player.m_posY / tileHeight;
                dir = startTile < endTile ? 1 : -1;
                for (int i = 1; i < dir * (endTile - startTile) - 1; ++i) {
                    int j = this.m_posX + (k * (i * tileHeight + tileHeight / 2) >> 8);
                    if (this.scene.map.phyBuffer[i * this.scene.map.mapWidth + j] != 0) continue;
                    return false;
                }
                break block3;
            }
            if (Math.abs(spanY) >= Math.abs(spanX)) break block3;
            int k = (spanY << 8) / spanX;
            int startTile = this.m_posX / tileWidth;
            int endTile = s_player.m_posX / tileWidth;
            dir = startTile < endTile ? 1 : -1;
            for (int i = 1; i < dir * (endTile - startTile) - 1; ++i) {
                int j = this.m_posY + (k * (i * tileWidth + tileWidth / 2) >> 8);
                if (this.scene.map.phyBuffer[j * this.scene.map.mapWidth + i] != 0) continue;
                return false;
            }
        }
        return true;
    }

    private int getLineParam(int i, int m_pos, int k) {
        return m_pos + (k * i >> 8);
    }

    private void initLimitPos() {
        this.m_isDirX = Tool.random(0, 1) == 0;
        int span = Tool.random(16, 24);
        if (this.m_isDirX) {
            this.m_startX = this.m_posX - span;
            this.m_endX = this.m_posX + span;
            this.m_startY = this.m_endY = this.m_posY;
            this.m_vX = (Tool.random(0, 1) == 0 ? 1 : -1) * this.m_vel;
            this.m_vY = 0;
        } else {
            this.m_startY = this.m_posY - span;
            this.m_endY = this.m_posY + span;
            this.m_startX = this.m_endX = this.m_posX;
            this.m_vY = (Tool.random(0, 1) == 0 ? 1 : -1) * this.m_vel;
            this.m_vX = 0;
        }
    }

    private void updateVelo(int spanX, int spanY) {
        int lx = Math.abs(spanX);
        int ly = Math.abs(spanY);
        int vx = this.m_vel;
        int vy = this.m_vel;
        if (lx != 0 || ly != 0) {
            vx = this.m_vel * lx / (lx + ly);
            vy = this.m_vel - vx;
        }
        this.m_vX = (spanX > 0 ? -1 : 1) * vx;
        this.m_vY = (spanY > 0 ? -1 : 1) * vy;
    }

    private boolean collideActor(Actor actor, Actor s_player) {
        if (actor.m_layer == s_player.m_layer || actor.m_animID == 3 || actor.m_animID == 4) {
            int x = s_player.m_posX + s_player.m_activeBox0;
            int y = s_player.m_posY + s_player.m_activeBox1;
            int w = s_player.m_posX + s_player.m_activeBox2;
            int h = s_player.m_posY + s_player.m_activeBox3;
            int ox = actor.m_posX + actor.m_activeBox0;
            int oy = actor.m_posY + actor.m_activeBox1;
            int ow = actor.m_posX + actor.m_activeBox2;
            int oh = actor.m_posY + actor.m_activeBox3;
            return Tool.collide(x, y, w, h, ox, oy, ow, oh);
        }
        return false;
    }

    private void zoomInView() {
        this.m_viewBox0 *= 3;
        this.m_viewBox1 *= 3;
        this.m_viewBox2 *= 3;
        this.m_viewBox3 *= 3;
        this.m_viewBox0 /= 2;
        this.m_viewBox1 /= 2;
        this.m_viewBox2 /= 2;
        this.m_viewBox3 /= 2;
    }

    private void zoomOutView() {
        this.m_viewBox0 *= 2;
        this.m_viewBox1 *= 2;
        this.m_viewBox2 *= 2;
        this.m_viewBox3 *= 2;
        this.m_viewBox0 /= 3;
        this.m_viewBox1 /= 3;
        this.m_viewBox2 /= 3;
        this.m_viewBox3 /= 3;
    }

    private boolean isInView(Actor actor) {
        if (this.m_layer == actor.m_layer) {
            int x = this.m_posX + this.m_viewBox0;
            int y = this.m_posY + this.m_viewBox1;
            int w = this.m_posX + this.m_viewBox2;
            int h = this.m_posY + this.m_viewBox3;
            int ox = actor.m_posX + actor.m_activeBox0;
            int oy = actor.m_posY + actor.m_activeBox1;
            int ow = actor.m_posX + actor.m_activeBox2;
            int oh = actor.m_posY + actor.m_activeBox3;
            return Tool.collide(x, y, w, h, ox, oy, ow, oh);
        }
        return false;
    }

    private void ai_PLAYER() {
        this.processCollide();
        this.updateKeyAI();
    }

    private void processNonVisibleMonster() {
        if (GameControl.s_isCollideNVMonster && Tool.random(0, 99) < 2) {
            GameControl.gamecontrol.etid = this.getEtidByPhy();
            if (GameControl.gamecontrol.etid != -1) {
                s_isChangeGameStatus = true;
            } else {
                GameControl.gamecontrol.etid = 0;
            }
        }
    }

    private int getEtidByPhy() {
        int phy = 0;
        int len = Tool.ETID_LIST[phy].length;
        return Tool.ETID_LIST[phy][Tool.random(0, len - 1)];
    }

    private void updateKeyAI() {
        this.m_vX = 0;
        this.m_vY = 0;
        if (GameControl.gameStatus == 3) {
            if (GCanvas.haveKeyPressed(1) || GCanvas.haveKeyHold(1)) {
                this.m_vX = 0;
                this.m_vY = -this.m_vel;
                this.m_actionCycle = true;
                if (this.m_layer == 8) {
                    this.setAction(12, false);
                } else {
                    this.setAction(4, false);
                    this.processNonVisibleMonster();
                }
            } else if (GCanvas.haveKeyPressed(16) || GCanvas.haveKeyHold(16)) {
                this.m_vX = 0;
                this.m_vY = this.m_vel;
                this.m_actionCycle = true;
                if (this.m_layer == 8) {
                    this.setAction(13, false);
                } else {
                    this.setAction(5, false);
                    this.processNonVisibleMonster();
                }
            } else if (GCanvas.haveKeyPressed(64) || GCanvas.haveKeyHold(64)) {
                this.m_vY = 0;
                this.m_vX = -this.m_vel;
                this.m_actionCycle = true;
                if (this.m_layer == 8) {
                    this.setAction(14, false);
                } else {
                    this.setAction(6, false);
                    this.processNonVisibleMonster();
                }
            } else if (GCanvas.haveKeyPressed(4) || GCanvas.haveKeyHold(4)) {
                this.m_vY = 0;
                this.m_vX = this.m_vel;
                this.m_actionCycle = true;
                if (this.m_layer == 8) {
                    this.setAction(15, false);
                } else {
                    this.setAction(7, false);
                    this.processNonVisibleMonster();
                }
            } else {
                this.setAction((this.m_actionIDNow >> 3 << 3) + this.m_actionIDNow % 4, false);
                if (GCanvas.haveKeyPressed(8)) {
                    if (!GameControl.isLearnFly && !Tool.isInIntArray(this.scene.level, Tool.NONVISI_LEVEL)) {
                        GScript.runScript(SID_FLY);
                        GameControl.gamecontrol.setGameStatus(9);
                    } else if (followMode == 0) {
                        followMode = 2;
                        this.m_layer = 8;
                        s_follow[0].setAction(this.m_actionIDNow % 8 + 8, false);
                    } else {
                        this.landingRole();
                    }
                }
            }
        }
    }

    public void landingRole() {
        int phy = this.getStandPhy();
        if (phy >= 8) {
            this.m_layer = (phy - 8) * 2;
            followMode = 0;
            s_follow[0].setAction(this.m_actionIDNow % 8, false);
            this.mapCollide();
        } else if (phy >= 4) {
            this.m_layer = (phy - 4) * 2;
        }
    }

    public void setLayer() {
        if (this.m_layer == 8) {
            return;
        }
        int phy = this.getStandPhy();
        if (phy >= 8) {
            this.m_layer = (phy - 8) * 2;
        } else if (phy >= 4) {
            this.m_layer = (phy - 4) * 2;
        }
    }

    private int getStandPhy() {
        int collideX = this.m_posX + this.m_activeBox0;
        int collideWidth = this.m_posX + this.m_activeBox2;
        int collideY = this.m_posY + this.m_activeBox1;
        int collideHeight = this.m_posY + this.m_activeBox3;
        int startTileX = collideX / this.scene.map.tileWidth;
        int startTileY = collideY / this.scene.map.tileHeight;
        int endTileX = collideWidth / this.scene.map.tileWidth;
        int endTileY = collideHeight / this.scene.map.tileHeight;
        int phy = -1;
        int row = startTileY;
        int col = startTileX;
        startTileX = Tool.limit(startTileX, 0, this.scene.map.mapWidth - 1);
        endTileX = Tool.limit(endTileX, 0, this.scene.map.mapWidth - 1);
        startTileY = Tool.limit(startTileY, 0, this.scene.map.mapHeight - 1);
        endTileY = Tool.limit(endTileY, 0, this.scene.map.mapHeight - 1);
        for (int i = startTileX; i <= endTileX; ++i) {
            for (int j = startTileY; j <= endTileY; ++j) {
                phy = this.scene.map.phyBuffer[j * this.scene.map.mapWidth + i];
                if (phy != 0) continue;
                return phy;
            }
        }
        return phy;
    }

    private void mapCollide() {
        byte collideNum;
        int j;
        int i;
        this.m_collide = 0;
        if (this.m_layer == 8) {
            return;
        }
        int collideX = this.m_posX + this.m_activeBox0;
        int collideWidth = this.m_posX + this.m_activeBox2;
        int collideY = this.m_posY + this.m_activeBox1;
        int collideHeight = this.m_posY + this.m_activeBox3;
        int startTileX = collideX / this.scene.map.tileWidth;
        int startTileY = collideY / this.scene.map.tileHeight;
        int endTileX = collideWidth / this.scene.map.tileWidth;
        int endTileY = collideHeight / this.scene.map.tileHeight;
        startTileX = Tool.limit(startTileX, 0, this.scene.map.mapWidth - 1);
        endTileX = Tool.limit(endTileX, 0, this.scene.map.mapWidth - 1);
        startTileY = Tool.limit(startTileY, 0, this.scene.map.mapHeight - 1);
        endTileY = Tool.limit(endTileY, 0, this.scene.map.mapHeight - 1);
        this.m_collide = 0;
        for (i = startTileX; i <= endTileX; ++i) {
            for (j = startTileY; j <= endTileY; ++j) {
                collideNum = this.scene.map.phyBuffer[j * this.scene.map.mapWidth + i];
                if (collideNum < 4 || collideNum >= 8) continue;
                this.m_layer = (collideNum - 4) * 2;
                this.m_collide = 1;
                break;
            }
            if (this.m_collide == 1) break;
        }
        this.m_collide = 0;
        for (i = startTileX; i <= endTileX; ++i) {
            for (j = startTileY; j <= endTileY; ++j) {
                collideNum = this.scene.map.phyBuffer[j * this.scene.map.mapWidth + i];
                if (collideNum != 0 && (this.m_layer != 0 || collideNum != 9) && (this.m_layer != 2 || collideNum != 8)) continue;
                if (i == startTileX && this.m_vX < 0) {
                    this.m_posX = (i + 1) * this.scene.map.tileWidth - this.m_activeBox0;
                    this.m_collide |= 4;
                }
                if (i == endTileX && this.m_vX > 0) {
                    this.m_posX = i * this.scene.map.tileWidth - this.m_activeBox2 - 1;
                    this.m_collide |= 8;
                }
                if (j == startTileY && this.m_vY < 0) {
                    this.m_posY = (j + 1) * this.scene.map.tileHeight - this.m_activeBox1;
                    this.m_collide |= 1;
                }
                if (j != endTileY || this.m_vY <= 0) continue;
                this.m_posY = j * this.scene.map.tileHeight - this.m_activeBox3 - 1;
                this.m_collide |= 2;
            }
        }
        int phy = -1;
        if ((this.m_collide & 4) != 0) {
            phy = this.scene.map.phyBuffer[startTileY * this.scene.map.mapWidth + startTileX];
            if (phy == -1 || this.m_layer == 0 && phy == 8 || this.m_layer == 2 && phy == 9) {
                this.m_posY -= this.m_vel - Math.abs(this.m_posX - this.m_prePosX);
                this.m_posY = Math.max((startTileY + 1) * this.scene.map.tileHeight - this.m_activeBox3 - 1, this.m_posY);
                return;
            }
            phy = this.scene.map.phyBuffer[endTileY * this.scene.map.mapWidth + startTileX];
            if (phy == -1 || this.m_layer == 0 && phy == 8 || this.m_layer == 2 && phy == 9) {
                this.m_posY += this.m_vel - Math.abs(this.m_posX - this.m_prePosX);
                this.m_posY = Math.min(endTileY * this.scene.map.tileHeight - this.m_activeBox1 + 1, this.m_posY);
                return;
            }
        }
        if ((this.m_collide & 8) != 0) {
            phy = this.scene.map.phyBuffer[startTileY * this.scene.map.mapWidth + endTileX];
            if (phy == -1 || this.m_layer == 0 && phy == 8 || this.m_layer == 2 && phy == 9) {
                this.m_posY -= this.m_vel - Math.abs(this.m_posX - this.m_prePosX);
                this.m_posY = Math.max((startTileY + 1) * this.scene.map.tileHeight - this.m_activeBox3 - 1, this.m_posY);
                return;
            }
            phy = this.scene.map.phyBuffer[endTileY * this.scene.map.mapWidth + endTileX];
            if (phy == -1 || this.m_layer == 0 && phy == 8 || this.m_layer == 2 && phy == 9) {
                this.m_posY += this.m_vel - Math.abs(this.m_posX - this.m_prePosX);
                this.m_posY = Math.min(endTileY * this.scene.map.tileHeight - this.m_activeBox1 + 1, this.m_posY);
                return;
            }
        }
        if ((this.m_collide & 1) != 0) {
            phy = this.scene.map.phyBuffer[startTileY * this.scene.map.mapWidth + startTileX];
            if (phy == -1 || this.m_layer == 0 && phy == 8 || this.m_layer == 2 && phy == 9) {
                this.m_posX -= this.m_vel - Math.abs(this.m_posY - this.m_prePosY);
                this.m_posX = Math.max(this.m_posX, (startTileX + 1) * this.scene.map.tileWidth - this.m_activeBox2 - 1);
                return;
            }
            phy = this.scene.map.phyBuffer[startTileY * this.scene.map.mapWidth + endTileX];
            if (phy == -1 || this.m_layer == 0 && phy == 8 || this.m_layer == 2 && phy == 9) {
                this.m_posX += this.m_vel - Math.abs(this.m_posY - this.m_prePosY);
                this.m_posX = Math.min(this.m_posX, endTileX * this.scene.map.tileWidth - this.m_activeBox0 + 1);
                return;
            }
        }
        if ((this.m_collide & 2) != 0) {
            phy = this.scene.map.phyBuffer[endTileY * this.scene.map.mapWidth + startTileX];
            if (phy == -1 || this.m_layer == 0 && phy == 8 || this.m_layer == 2 && phy == 9) {
                this.m_posX -= this.m_vel - Math.abs(this.m_posY - this.m_prePosY);
                this.m_posX = Math.max(this.m_posX, (startTileX + 1) * this.scene.map.tileWidth - this.m_activeBox2 - 1);
                return;
            }
            phy = this.scene.map.phyBuffer[endTileY * this.scene.map.mapWidth + endTileX];
            if (phy == -1 || this.m_layer == 0 && phy == 8 || this.m_layer == 2 && phy == 9) {
                this.m_posX += this.m_vel - Math.abs(this.m_posY - this.m_prePosY);
                this.m_posX = Math.min(this.m_posX, endTileX * this.scene.map.tileWidth - this.m_activeBox0 + 1);
                return;
            }
        }
    }

    private void processCollide() {
        int oldcollidenum = this.lastColNum;
        this.mapCollide();
    }

    public static byte openMission(short mid) {
        if (s_missionFlag[mid] != 0) {
            return s_missionFlag[mid];
        }
        for (int i = 0; i < s_missionVariable.length; ++i) {
            if (s_missionVariable[i] != null) continue;
            Actor.s_missionFlag[mid] = 1;
            s_missionCount = (byte)(s_missionCount + 1);
            switch (Tool.MISSION_TYPE[mid]) {
                case 0: {
                    Actor.s_missionVariable[i] = new short[3];
                    Actor.s_missionVariable[i][0] = mid;
                    Actor.s_missionVariable[i][1] = Tool.MISSION_VAR[mid][0];
                    Actor.s_missionVariable[i][2] = 0;
                    break;
                }
                case 1: {
                    Actor.s_missionVariable[i] = new short[2];
                    Actor.s_missionVariable[i][0] = mid;
                    Actor.s_missionVariable[i][1] = 0;
                    break;
                }
                case 2: {
                    Actor.s_missionVariable[i] = new short[4];
                    Actor.s_missionVariable[i][0] = mid;
                    Actor.s_missionVariable[i][1] = Tool.MISSION_VAR[mid][0];
                    Actor.s_missionVariable[i][2] = 0;
                }
            }
            return 0;
        }
        return -1;
    }

    public static void updateMission(int id, int num, boolean isObject) {
        block4: for (int i = 0; i < s_missionVariable.length; ++i) {
            if (s_missionVariable[i] == null) continue;
            short mid = s_missionVariable[i][0];
            switch (Tool.MISSION_TYPE[mid]) {
                case 0: {
                    if (id == s_missionVariable[i][1] && !isObject) {
                        short[] sArray = s_missionVariable[i];
                        sArray[2] = (short)(sArray[2] + num);
                    }
                    if (s_missionVariable[i][2] < Tool.MISSION_VAR[mid][1] || s_missionFlag[mid] != 1) continue block4;
                    Actor.s_missionFlag[mid] = 2;
                    continue block4;
                }
                case 2: {
                    if (id == s_missionVariable[i][1] && isObject) {
                        short[] sArray = s_missionVariable[i];
                        sArray[2] = (short)(sArray[2] + num);
                    }
                    if (s_missionVariable[i][2] < Tool.MISSION_VAR[mid][1] || s_missionFlag[mid] != 1) continue block4;
                    Actor.s_missionFlag[mid] = 2;
                }
            }
        }
    }

    public static void cancleMission(short missionID) {
        Actor.s_missionFlag[missionID] = 0;
        for (int i = 0; i < s_missionVariable.length; ++i) {
            short mid;
            if (s_missionVariable[i] == null || (mid = s_missionVariable[i][0]) != missionID) continue;
            Actor.s_missionVariable[i] = null;
            s_missionCount = (byte)(s_missionCount - 1);
            break;
        }
    }

    public static void endMission(short mid) {
        int i;
        Actor.s_missionFlag[mid] = 3;
        for (i = 0; i < s_missionVariable.length; ++i) {
            short id;
            if (s_missionVariable[i] == null || mid != (id = s_missionVariable[i][0])) continue;
            s_missionCount = (byte)(s_missionCount - 1);
            Actor.s_missionVariable[i] = null;
            if (Tool.MISSION_TYPE[mid] != 2) break;
            break;
        }
        for (i = 0; i < s_missionVariable.length - 1; ++i) {
            if (s_missionVariable[i] != null) continue;
            Actor.s_missionVariable[i] = s_missionVariable[i + 1];
            Actor.s_missionVariable[i + 1] = null;
        }
    }

    static {
        s_head = new Actor[4];
        s_follow = new Actor[4];
        followMode = 0;
        s_isChangeGameStatus = false;
        s_isCollideID = -1;
        isRunPoleScript = false;
        s_limitlevel = 0;
        SID_LOADLEVEL = 0;
        SID_FLY = 19;
        SID_STEAL = 18;
        SID_CANTOUT = 22;
        SID_CANTIN = 21;
        SID_LOWLEVEL = 20;
        s_scriptParam = 0;
        s_artName = "";
        isRunPointScript = false;
        s_missionCount = 0;
        s_missionFlag = new byte[50];
        s_missionVariable = new short[5][];
    }
}

