/*
 * Decompiled with CFR 0.152.
 */
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class ByteInputStream {
    public byte[] buf;
    private int pos = 0;
    private int count = 0;

    public ByteInputStream(byte[] data) {
        this.buf = data;
        this.pos = 0;
        this.count = data.length;
    }

    public int read(byte[] b2, int off, int len) {
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b2.length || len < 0 || off + len > b2.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        Tool.arraycopy(this.buf, this.pos, b2, off, len);
        this.pos += len;
        return len;
    }

    public final void readFully(byte[] b2, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b2, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    public int skipBytes(int n) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < n && (cur = (int)this.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new IOException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new IOException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new IOException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new IOException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        int ch8;
        int ch7;
        int ch6;
        int ch5;
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read()) | (ch5 = this.read()) | (ch6 = this.read()) | (ch7 = this.read()) | (ch8 = this.read())) < 0) {
            throw new EOFException();
        }
        return ((long)ch1 << 56) + ((long)(ch2 & 0xFF) << 48) + ((long)(ch3 & 0xFF) << 40) + ((long)(ch4 & 0xFF) << 32) + ((long)(ch5 & 0xFF) << 24) + (long)((ch6 & 0xFF) << 16) + (long)((ch7 & 0xFF) << 8) + (long)((ch8 & 0xFF) << 0);
    }

    public String readUTF() throws IOException {
        return ByteInputStream.readUTF(this);
    }

    public static final String readUTF(ByteInputStream in) throws IOException {
        int utflen = in.readUnsignedShort();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        in.readFully(bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str);
    }

    public void close() throws IOException {
    }
}

