/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GCanvas
extends FullCanvas {
    public static final int SCREEN_WIDTH = 240;
    public static final int SCREEN_HEIGHT = 320;
    public static final int SCREEN_TOP = 0;
    public static final int INTERFACE_HEIGHT = 0;
    public static final int PLAYINGAREA_HEIGHT = 320;
    public Image bufferImg = Image.createImage((int)240, (int)320);
    public Graphics g = this.bufferImg.getGraphics();
    public static GCanvas canvas;
    public static int s_screenwidth;
    public static int s_screenheight;
    public static Font s_font;
    public static final int TRANS_NORMAL = 0;
    public static final int TRANS_FLIPY = 1;
    public static final int TRANS_FLIPX = 2;
    public static final int TRANS_FLIPXY = 3;
    public static final int GK_UP = 1;
    public static final int GK_UPRIGHT = 2;
    public static final int GK_RIGHT = 4;
    public static final int GK_DOWNRIGHT = 8;
    public static final int GK_DOWN = 16;
    public static final int GK_DOWNLEFT = 32;
    public static final int GK_LEFT = 64;
    public static final int GK_UPLEFT = 128;
    public static final int GK_A = 256;
    public static final int GK_B = 512;
    public static final int GK_C = 1024;
    public static final int GK_D = 2048;
    public static final int GK_LEFT_SOFT = 4096;
    public static final int GK_RIGHT_SOFT = 8192;
    private static final int GAME_KEY_COUNT = 14;
    public static int keyCount;
    public static int keyCurrent;
    public static int keyPressed;
    public static int key;
    public static int keyOff;
    private static final int NOK_UP_ARROW = -1;
    private static final int NOK_DOWN_ARROW = -2;
    private static final int NOK_LEFT_ARROW = -3;
    private static final int NOK_RIGHT_ARROW = -4;
    private static final int NOK_MIDDLE = -5;
    private static final int NOK_LEFT_SOFT = -6;
    private static final int NOK_RIGHT_SOFT = -7;
    public static int[] lastPress;
    public static boolean[] s_isKeyPressed;
    public static int[] intervalPress;
    private static final int DOUBLEPRESS_INTERVAL = 5;
    final int offset_x;
    final int offset_y;
    public static boolean s_isSupportDouble;
    public static boolean lockCenterKey;
    public static boolean s_rightConfirm;
    public static final int BASIC_LINE = 0;

    public GCanvas(MIDlet midlet) {
        this.offset_x = 30;
        this.offset_y = 30;
        s_font = Font.getFont((int)0, (int)0, (int)8);
        this.g.setFont(s_font);
        canvas = this;
    }

    protected void hideNotify() {
    }

    protected void showNotify() {
    }

    public void flush() {
        this.repaint(0, 0, s_screenwidth, s_screenheight);
        this.serviceRepaints();
    }

    protected void paint(Graphics g) {
        g.drawImage(this.bufferImg, 0, 0, 0);
    }

    public void drawRegion(Graphics g, Image img, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        g.drawRegion(img, x_src, y_src, width, height, transform, x_dest, y_dest, anchor);
    }

    public static void updateKeyBegin() {
        keyPressed = ~key & keyCurrent;
        key = keyCurrent;
        ++keyCount;
    }

    public static void updateKeyEnd() {
        keyCurrent &= ~keyOff;
        keyOff = 0;
    }

    public static int log2(int number) {
        int result = 0;
        while (number >> 1 != 0) {
            number >>= 1;
            ++result;
        }
        return result;
    }

    public static boolean haveKeyDoublePressed(int gameKey) {
        int index = GCanvas.log2(gameKey);
        if (!s_isKeyPressed[index]) {
            return false;
        }
        GCanvas.s_isKeyPressed[index] = false;
        return intervalPress[index] > 0 && intervalPress[index] < 5;
    }

    protected void pointerPressed(int x, int y) {
        System.out.println("press " + x + "," + y);
        if (x < 30 && y > 290) {
            this.keyPressed(-6);
        }
        if (x > 210 && y > 290) {
            this.keyPressed(-7);
        }
        if (x < 30 && y < 30) {
            this.keyPressed(55);
        }
        if (x > 210 && y < 30) {
            this.keyPressed(57);
        }
        if (x > 95 && x < 145 && y < 266 & y > 170) {
            this.keyPressed(53);
        }
    }

    protected void pointerReleased(int x, int y) {
        GCanvas.resetKey();
        System.out.println("release " + x + "," + y);
        if (x < 30 && y > 290) {
            this.keyReleased(-6);
        }
        if (x > 210 && y > 290) {
            this.keyReleased(-7);
        }
        if (x < 30 && y < 30) {
            this.keyReleased(55);
        }
        if (x > 210 && y < 30) {
            this.keyReleased(57);
        }
        if (x > 95 && x < 145 && y < 266 & y > 170) {
            this.keyPressed(53);
        }
    }

    public static void resetKey() {
        keyCount = 0;
        keyCurrent = 0;
        keyPressed = 0;
        key = 0;
        keyOff = 0;
    }

    protected void keyPressed(int keyCode) {
        int gameKey = GCanvas.getKey(keyCode);
        keyCurrent |= gameKey;
        if (s_isSupportDouble && (gameKey == 64 || gameKey == 1 || gameKey == 16 || gameKey == 4)) {
            int index = GCanvas.log2(gameKey);
            GCanvas.intervalPress[index] = keyCount - 5 - lastPress[index];
            GCanvas.lastPress[index] = keyCount - 5;
            GCanvas.s_isKeyPressed[index] = true;
        }
    }

    protected void keyReleased(int keyCode) {
        int gameKey = GCanvas.getKey(keyCode);
        if ((key & gameKey) != 0) {
            keyCurrent &= ~gameKey;
        } else {
            keyOff |= gameKey;
        }
    }

    public static boolean haveKeyHold(int gameKey) {
        return (keyCurrent & gameKey) != 0;
    }

    public static boolean haveKeyPressed(int gameKey) {
        return (keyPressed & gameKey) != 0;
    }

    public static boolean anyKeyHold() {
        return keyCurrent != 0;
    }

    public static boolean anyKeyPressed() {
        return GCanvas.haveKeyPressed(16383);
    }

    public static boolean VKeyPressed() {
        boolean runkey = GCanvas.haveKeyPressed(17);
        runkey = runkey || GCanvas.haveKeyHold(17);
        return runkey;
    }

    public static boolean runUpKeyPressed() {
        boolean runkey = GCanvas.haveKeyPressed(1);
        runkey = runkey || GCanvas.haveKeyHold(1);
        return runkey;
    }

    public static boolean runDownKeyPressed() {
        boolean runkey = GCanvas.haveKeyPressed(16);
        runkey = runkey || GCanvas.haveKeyHold(16);
        return runkey;
    }

    public static boolean runKeyPressed() {
        boolean runkey = GCanvas.haveKeyPressed(68);
        runkey = runkey || GCanvas.haveKeyHold(68);
        return runkey;
    }

    public static boolean runLeftKeyPressed() {
        boolean runkey = GCanvas.haveKeyPressed(64);
        runkey = runkey || GCanvas.haveKeyHold(64);
        return runkey;
    }

    public static boolean runRightKeyPressed() {
        boolean runkey = GCanvas.haveKeyPressed(4);
        runkey = runkey || GCanvas.haveKeyHold(4);
        return runkey;
    }

    private static int getKey(int keyCode) {
        switch (keyCode) {
            case -1: 
            case 50: {
                return 1;
            }
            case -2: 
            case 56: {
                return 16;
            }
            case -3: 
            case 52: {
                return 64;
            }
            case -4: 
            case 54: {
                return 4;
            }
            case 49: {
                return 128;
            }
            case 55: {
                return 32;
            }
            case 51: {
                return 2;
            }
            case 57: {
                return 8;
            }
            case -5: 
            case 53: {
                return 256;
            }
            case 35: {
                return 512;
            }
            case 48: {
                return 1024;
            }
            case 42: {
                return 2048;
            }
            case -6: {
                return 4096;
            }
            case -7: {
                return 8192;
            }
        }
        return 0;
    }

    public static boolean keyCanceled() {
        if (s_rightConfirm) {
            return GCanvas.haveKeyPressed(4096);
        }
        return GCanvas.haveKeyPressed(8192);
    }

    public static boolean keyConfirmed() {
        int confirmKey = 0;
        confirmKey = s_rightConfirm ? 8192 : 4096;
        if (lockCenterKey) {
            return GCanvas.haveKeyPressed(confirmKey);
        }
        return GCanvas.haveKeyPressed(confirmKey | 0x100);
    }

    public static boolean keyConfirmedWithoutCenterKey() {
        int confirmKey = 0;
        confirmKey = s_rightConfirm ? 8192 : 4096;
        return GCanvas.haveKeyPressed(confirmKey);
    }

    public static void setKeyCustom(boolean confirmType) {
        s_rightConfirm = confirmType;
    }

    static {
        s_screenwidth = 240;
        s_screenheight = 320;
        keyCount = 0;
        keyCurrent = 0;
        keyPressed = 0;
        key = 0;
        keyOff = 0;
        lastPress = new int[14];
        s_isKeyPressed = new boolean[14];
        intervalPress = new int[14];
        s_isSupportDouble = false;
        lockCenterKey = false;
        s_rightConfirm = false;
    }
}

