/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class Scene {
    public int[] s_useAnimIDs;
    public Animation[] s_anims;
    public int s_actorCount;
    public Actor[] s_actors;
    public int s_inCameraActorCount;
    public Actor[] s_inCameraActors;
    GMap map;
    String[] texts;
    public int level;
    public int gate;
    public int dir;
    public boolean updateAnimation = true;
    byte[] bindata = null;
    DataInputStream dis;
    public static short[] s_boxFlag = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static short[] s_triggerFlag = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public int boxstatus = 0;
    public int trigger = 0;

    public Scene(GMap map, String[] texts) {
        this.map = map;
        this.texts = texts;
    }

    public void loadAnimation(String fileName, boolean isload) throws Exception {
        if (this.updateAnimation) {
            DataInputStream dis = new DataInputStream(fileName.getClass().getResourceAsStream(fileName));
            int animCount = dis.readUnsignedShort();
            this.s_anims = new Animation[animCount];
            for (int i = 0; i < animCount; ++i) {
                long loadMask = i < 64 ? this.map.loadAnimationMask : this.map.loadAnimationMaskExtra;
                int maskId = i < 64 ? i : i - 64;
                short length = dis.readShort();
                if ((1L << maskId & loadMask) != 0L) {
                    this.s_anims[i] = new Animation(this.texts);
                    this.s_anims[i].m_ID = i;
                    this.s_anims[i].load(dis);
                    continue;
                }
                dis.skip(length);
            }
            dis.close();
            Object var3_3 = null;
        }
    }

    public void loadActors(String fileName, int level) throws Exception {
        int i;
        this.level = level;
        this.boxstatus = s_boxFlag[level];
        this.trigger = s_triggerFlag[level];
        GameControl.s_isCollideNVMonster = Tool.isInIntArray(level, Tool.NONVISI_LEVEL);
        this.dis = new DataInputStream(fileName.getClass().getResourceAsStream(fileName));
        int count = this.dis.readUnsignedShort();
        int[] tmp_scBlockLengths = new int[count];
        for (i = 0; i < count; ++i) {
            tmp_scBlockLengths[i] = this.dis.readInt();
        }
        if (level > 0) {
            this.dis.skip(tmp_scBlockLengths[level - 1]);
        }
        this.s_actorCount = this.dis.readUnsignedShort();
        this.s_actors = new Actor[this.s_actorCount];
        this.s_inCameraActors = new Actor[this.s_actorCount];
        for (i = 0; i < this.s_actorCount; ++i) {
            this.s_actors[i] = new Actor(this, this.texts);
            this.s_actors[i].loadActor(this.dis, i);
        }
        this.dis.close();
        this.dis = null;
    }

    public void initActor() {
        for (int i = 0; i < this.s_actorCount; ++i) {
            Actor a2 = this.s_actors[i];
            a2.m_anim = this.s_anims[a2.m_animID];
            a2.setAction(a2.m_actionIDNow, false);
            a2.nextFrame();
        }
    }

    public void releaseAnimation() {
        if (this.updateAnimation) {
            int i;
            if (Animation.s_animImages != null) {
                for (i = 0; i < Animation.s_animImages.length; ++i) {
                    Animation.s_animImages[i] = null;
                }
            }
            if (this.s_anims != null) {
                for (i = 0; i < this.s_anims.length; ++i) {
                    if (this.s_anims[i] == null) continue;
                    this.s_anims[i].dispose();
                    this.s_anims[i] = null;
                }
            }
        }
    }

    public void releaseActor() {
        int i;
        if (this.s_actors != null) {
            for (i = 0; i < this.s_actors.length; ++i) {
                if (this.s_actors[i] == null) continue;
                this.s_actors[i].dispose();
                this.s_actors[i] = null;
            }
            this.s_actors = null;
        }
        if (this.s_inCameraActors != null) {
            for (i = 0; i < this.s_inCameraActors.length; ++i) {
                if (this.s_inCameraActors[i] == null) continue;
                this.s_inCameraActors[i].dispose();
                this.s_inCameraActors[i] = null;
            }
            this.s_inCameraActors = null;
        }
    }

    public void updateAI() {
        Actor.isRunPoleScript = false;
        Actor.isRunPointScript = false;
        for (int i = this.s_actorCount - 1; i >= 0; --i) {
            Actor a2 = this.s_actors[i];
            if (!a2.m_active) continue;
            a2.updatePos();
            a2.doAI();
            if (Actor.s_isChangeGameStatus) {
                Actor.s_isCollideID = a2 != Actor.s_player ? i : -1;
                return;
            }
            if (!Actor.isRunPoleScript) continue;
            return;
        }
        if (Actor.isRunPointScript) {
            GScript.runScript(Actor.SID_LOADLEVEL);
            GameControl.gamecontrol.setGameStatus(9);
        }
    }

    public void initScene() {
    }

    public void drawActor(boolean isNext) {
        Actor a2;
        int i;
        this.s_inCameraActorCount = 0;
        for (i = 0; i < this.s_actorCount; ++i) {
            a2 = this.s_actors[i];
            boolean bl = a2.m_inScreen = this.s_actors[i].m_posX + this.s_actors[i].m_activeBox2 >= this.map.camX && this.s_actors[i].m_posX + this.s_actors[i].m_activeBox0 <= this.map.camX + 240 && this.s_actors[i].m_posY + this.s_actors[i].m_activeBox3 >= this.map.camY && this.s_actors[i].m_posY + this.s_actors[i].m_activeBox1 <= this.map.camY + 320;
            if (a2 == null || !a2.m_active || !a2.m_inScreen) continue;
            int insertPos = 0;
            while (insertPos < this.s_inCameraActorCount) {
                if (this.s_inCameraActors[insertPos].m_layer < a2.m_layer) {
                    ++insertPos;
                    continue;
                }
                if (this.s_inCameraActors[insertPos].m_layer > a2.m_layer || this.s_inCameraActors[insertPos].m_posY + this.s_inCameraActors[insertPos].m_activeBox3 >= a2.m_posY + a2.m_activeBox3) break;
                ++insertPos;
            }
            for (int ii = this.s_inCameraActorCount; ii > insertPos; --ii) {
                this.s_inCameraActors[ii] = this.s_inCameraActors[ii - 1];
            }
            this.s_inCameraActors[insertPos] = a2;
            ++this.s_inCameraActorCount;
        }
        for (i = 0; i < this.s_inCameraActorCount; ++i) {
            a2 = this.s_inCameraActors[i];
            if (!a2.m_isVisible) continue;
            a2.draw(this.map.gameCanvas, this.map.camX, this.map.camY);
        }
        if (isNext) {
            for (i = 0; i < this.s_actorCount; ++i) {
                a2 = this.s_actors[i];
                if (a2 == null) continue;
                a2.nextFrame();
            }
        }
    }

    public int[] getActorPosByID(int actorid) {
        int[] pos = new int[]{this.s_actors[actorid].m_posX, this.s_actors[actorid].m_posY};
        return pos;
    }

    public static void saveRecordData(DataOutputStream dos) throws Exception {
        dos.writeShort(0);
        for (int i = 0; i < s_boxFlag.length; ++i) {
            dos.writeShort(s_boxFlag[i]);
        }
    }

    public static void loadRecordData(DataInputStream dis) throws Exception {
        short count = dis.readShort();
        for (int i = 0; i < s_boxFlag.length; ++i) {
            Scene.s_boxFlag[i] = dis.readShort();
        }
    }

    public static void initRecord() {
        for (int i = 0; i < s_boxFlag.length; ++i) {
            Scene.s_boxFlag[i] = 0;
        }
    }
}

