/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.Iterator;
import de.enough.polish.util.Map;

public class OAHashMap
implements Map {
    public static final int DEFAULT_INITIAL_CAPACITY = 17;
    public static final int DEFAULT_LOAD_FACTOR = 60;
    public static final int PROBING_LINEAR = 0;
    public static final int PROBING_QUADRACTIC = 1;
    public static final int PROBING_DOUBLE_HASHING = 2;
    private final int loadFactor;
    private Element[] buckets;
    private final boolean isPowerOfTwo;
    private int size;
    private final int probingStrategy;

    public OAHashMap() {
        this(17, 60, 0);
    }

    public OAHashMap(int initialCapacity) {
        this(initialCapacity, 60, 0);
    }

    public OAHashMap(int initialCapacity, int loadFactor) {
        this(initialCapacity, loadFactor, 0);
    }

    public OAHashMap(int initialCapacity, int loadFactor, int probingStrategy) {
        int capacity;
        this.probingStrategy = probingStrategy;
        for (capacity = 1; initialCapacity > capacity; capacity <<= 1) {
        }
        this.isPowerOfTwo = capacity == initialCapacity;
        this.buckets = new Element[initialCapacity];
        this.loadFactor = loadFactor;
    }

    private int calculateInterval(int hashCode, int length) {
        int interval = hashCode &= Integer.MAX_VALUE;
        int newHashCode = 0;
        do {
            newHashCode = 31 * newHashCode + (interval >> 3) - 1;
        } while ((interval >>= 3) > 0);
        interval = this.isPowerOfTwo ? newHashCode & Integer.MAX_VALUE & length - 1 : ((newHashCode *= 28629151) & Integer.MAX_VALUE) % length;
        if (interval == this.buckets.length) {
            --interval;
        }
        return interval;
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("HashMap cannot accept null key [" + key + "] or value [" + value + "].");
        }
        if (this.size * 100 / this.buckets.length > this.loadFactor) {
            this.increaseSize();
        }
        int hashCode = key.hashCode() & Integer.MAX_VALUE;
        int index = this.isPowerOfTwo ? hashCode & this.buckets.length - 1 : hashCode % this.buckets.length;
        return this.put(null, key, value, this.buckets, index, this.buckets[index], hashCode);
    }

    private Object put(Element newElement, Object key, Object value, Element[] elements, int index, Element element, int hashCode) {
        int interval = 1;
        if (element != null) {
            if (this.probingStrategy == 2) {
                interval = this.calculateInterval(hashCode, elements.length);
            } else if (this.probingStrategy == 1) {
                interval = 3;
            }
        }
        while (true) {
            if (element == null) {
                if (newElement != null) {
                    element = newElement;
                } else {
                    element = new Element(hashCode, key, value);
                    ++this.size;
                }
                elements[index] = element;
                return null;
            }
            if (newElement == null && element.hashCodeValue == hashCode && element.key.equals(key)) {
                Object oldValue = element.value;
                element.value = value;
                return oldValue;
            }
            index += interval;
            index = this.isPowerOfTwo ? (index &= elements.length - 1) : (index %= elements.length);
            if (this.probingStrategy == 1) {
                ++interval;
            }
            element = elements[index];
        }
    }

    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        int hashCode = key.hashCode() & Integer.MAX_VALUE;
        int index = this.isPowerOfTwo ? hashCode & this.buckets.length - 1 : hashCode % this.buckets.length;
        Element element = this.buckets[index];
        if (element == null) {
            return null;
        }
        int interval = 1;
        if (this.probingStrategy == 2) {
            interval = this.calculateInterval(hashCode, this.buckets.length);
        } else if (this.probingStrategy == 1) {
            interval = 3;
        }
        do {
            if (element.hashCodeValue == hashCode && element.key.equals(key)) {
                return element.value;
            }
            index += interval;
            index = this.isPowerOfTwo ? (index &= this.buckets.length - 1) : (index %= this.buckets.length);
            if (this.probingStrategy != 1) continue;
            ++interval;
        } while ((element = this.buckets[index]) != null);
        return null;
    }

    public Object remove(Object key) {
        throw new RuntimeException("remove not supported.");
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Element element = this.buckets[i];
            if (element == null || !element.value.equals(value)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = null;
        }
        this.size = 0;
    }

    public Object[] values() {
        return this.values(new Object[this.size]);
    }

    public Object[] values(Object[] objects) {
        int index = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            Element element = this.buckets[i];
            if (element == null) continue;
            objects[index] = element.value;
            ++index;
        }
        return objects;
    }

    public Object[] keys() {
        return this.keys(new Object[this.size]);
    }

    public Object[] keys(Object[] objects) {
        int index = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            Element element = this.buckets[i];
            if (element == null) continue;
            objects[index] = element.key;
            ++index;
        }
        return objects;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.size * 23);
        buffer.append(super.toString()).append("{\n");
        Object[] values = this.values();
        for (int i = 0; i < values.length; ++i) {
            buffer.append(values[i]);
            buffer.append('\n');
        }
        buffer.append('}');
        return buffer.toString();
    }

    private void increaseSize() {
        int newCapacity = this.isPowerOfTwo ? this.buckets.length << 1 : (this.buckets.length << 1) - 1;
        Element[] newBuckets = new Element[newCapacity];
        for (int i = 0; i < this.buckets.length; ++i) {
            Element element = this.buckets[i];
            if (element == null) continue;
            int index = this.isPowerOfTwo ? element.hashCodeValue & newCapacity - 1 : element.hashCodeValue % newCapacity;
            Element existingElement = newBuckets[index];
            if (existingElement == null) {
                newBuckets[index] = element;
                continue;
            }
            this.put(element, existingElement.key, existingElement.value, newBuckets, index, existingElement, element.hashCodeValue);
        }
        this.buckets = newBuckets;
    }

    public Iterator keysIterator() {
        return null;
    }

    private static final class Element {
        public final Object key;
        public final int hashCodeValue;
        public Object value;

        public Element(int hashCode, Object key, Object value) {
            this.hashCodeValue = hashCode;
            this.key = key;
            this.value = value;
        }
    }
}

