/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.xml;

import de.enough.polish.util.ArrayList;
import java.util.Hashtable;

public class XmlDomNode {
    private XmlDomNode parent;
    private final ArrayList childList;
    private Hashtable attributes;
    private String name;
    private int type;
    private String text;

    public XmlDomNode(XmlDomNode parent, String name, int type) {
        this(parent, name, null, type);
    }

    public XmlDomNode(XmlDomNode parent, String name, Hashtable attributes, int type) {
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.name = name;
        this.attributes = attributes;
        this.type = type;
        this.childList = new ArrayList();
    }

    public XmlDomNode getChild(String childName) {
        XmlDomNode child;
        int i;
        for (i = 0; i < this.childList.size(); ++i) {
            child = (XmlDomNode)this.childList.get(i);
            if (!childName.equals(child.getName())) continue;
            return child;
        }
        childName = childName.toLowerCase();
        for (i = 0; i < this.childList.size(); ++i) {
            child = (XmlDomNode)this.childList.get(i);
            if (!childName.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public XmlDomNode getChild(int index) {
        return (XmlDomNode)this.childList.get(index);
    }

    public void addChild(XmlDomNode childNode) {
        this.childList.add(childNode);
    }

    public int getChildCount() {
        return this.childList.size();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public XmlDomNode getParent() {
        return this.parent;
    }

    public void setParent(XmlDomNode parent) {
        this.parent = parent;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Hashtable attributes) {
        this.attributes = attributes;
    }

    public String getAttribute(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(attributeName);
    }
}

