/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwaEX;

import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWAImageARGB;
import CWA2DAPI.cwabase2d.CWASprite;
import javax.microedition.lcdui.Image;

public class CWAImageUtil {
    public static byte TEXTURE_MIX = 0;
    public static byte TEXTURE_BLEND = 1;
    public static byte TEXTURE_REPLACE = (byte)2;

    public static CWAImageARGB getImageARGB(Image image, CWAImageARGB cWAImageARGB) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        int[] nArray = new int[n * n2];
        image.getRGB(nArray, 0, n, 0, 0, n, n2);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != -1 && nArray[i] != -16777216) continue;
            nArray[i] = 0xFFFFFF;
        }
        cWAImageARGB.init(nArray, n, n2);
        return cWAImageARGB;
    }

    public static CWAImageARGB getFrameImg(CWASprite cWASprite, int n, int[] nArray, byte by, CWAImageARGB cWAImageARGB) {
        Image image = Image.createImage((int)nArray[2], (int)nArray[3]);
        image.getGraphics().setColor(0);
        image.getGraphics().fillRect(0, 0, nArray[2], nArray[3]);
        cWASprite.drawFrame(image.getGraphics(), n, -nArray[0], -nArray[1], by, 20);
        cWAImageARGB.x = nArray[0];
        cWAImageARGB.y = nArray[1];
        return CWAImageUtil.getImageARGB(image, cWAImageARGB);
    }

    public static CWAImageARGB reSize(CWAImageARGB cWAImageARGB, int n, int n2) {
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = j * cWAImageARGB.w / n;
                int n4 = i * cWAImageARGB.h / n2;
                nArray[j + i * n] = cWAImageARGB.argb[n3 + n4 * cWAImageARGB.w];
            }
        }
        cWAImageARGB.init(nArray, n, n2);
        cWAImageARGB.x = cWAImageARGB.x * n / cWAImageARGB.w / 10;
        cWAImageARGB.y = cWAImageARGB.y * n / cWAImageARGB.w / 10;
        return cWAImageARGB;
    }

    public static CWAImageARGB scale(CWAImageARGB cWAImageARGB, int n) {
        int n2 = cWAImageARGB.w * n / 10;
        int n3 = cWAImageARGB.h * n / 10;
        int[] nArray = new int[n2 * n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4 = j * cWAImageARGB.w / n2;
                int n5 = i * cWAImageARGB.h / n3;
                nArray[j + i * n2] = cWAImageARGB.argb[n4 + n5 * cWAImageARGB.w];
            }
        }
        cWAImageARGB.init(nArray, n2, n3);
        cWAImageARGB.x = cWAImageARGB.x * n / 10;
        cWAImageARGB.y = cWAImageARGB.y * n / 10;
        return cWAImageARGB;
    }

    public static CWAImageARGB reLightContrast(CWAImageARGB cWAImageARGB, int n, int n2) {
        for (int i = 0; i < cWAImageARGB.h; ++i) {
            for (int j = 0; j < cWAImageARGB.w; ++j) {
                int n3 = cWAImageARGB.argb[i * cWAImageARGB.w + j];
                int n4 = n3 >> 24;
                int n5 = n3 >> 16 & 0xFF;
                int n6 = n3 >> 8 & 0xFF;
                n3 &= 0xFF;
                n5 = n5 * n + n2;
                n6 = n6 * n + n2;
                n3 = n3 * n + n2;
                if (n5 > 255) {
                    n5 = 255;
                } else if (n5 < 0) {
                    n5 = 0;
                }
                if (n6 > 255) {
                    n6 = 255;
                } else if (n6 < 0) {
                    n6 = 0;
                }
                if (n3 > 255) {
                    n3 = 255;
                } else if (n3 < 0) {
                    n3 = 0;
                }
                cWAImageARGB.argb[i * cWAImageARGB.w + j] = n4 << 24 | n5 << 16 | n6 << 8 | n3;
            }
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB negative(CWAImageARGB cWAImageARGB) {
        for (int i = 0; i < cWAImageARGB.h; ++i) {
            for (int j = 0; j < cWAImageARGB.w; ++j) {
                int n = cWAImageARGB.argb[i * cWAImageARGB.w + j];
                int n2 = n >> 24;
                int n3 = 255 - (n >> 16 & 0xFF);
                int n4 = 255 - (n >> 8 & 0xFF);
                n = 255 - (n & 0xFF);
                cWAImageARGB.argb[i * cWAImageARGB.w + j] = n2 << 24 | n3 << 16 | n4 << 8 | n;
            }
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB transparent(CWAImageARGB cWAImageARGB, int n) {
        if (n < 0 || n > 255) {
            return cWAImageARGB;
        }
        for (int i = 0; i < cWAImageARGB.length; ++i) {
            if (cWAImageARGB.argb[i] == 0xFFFFFF || cWAImageARGB.argb[i] == 0) continue;
            if (cWAImageARGB.argb[i] == -16777216) {
                int n2 = i;
                int cfr_ignored_0 = cWAImageARGB.argb[n2];
                cWAImageARGB.argb[n2] = 0;
                continue;
            }
            cWAImageARGB.argb[i] = n << 24 | cWAImageARGB.argb[i] & 0xFFFFFF;
        }
        return cWAImageARGB;
    }

    public static Image transparent(Image image, int n) {
        CWAImageARGB cWAImageARGB = new CWAImageARGB();
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        Image image2 = Image.createImage((int)n2, (int)n3);
        image2.getGraphics().setColor(0);
        image2.getGraphics().fillRect(0, 0, n2, n3);
        image2.getGraphics().drawImage(image, 0, 0, 20);
        cWAImageARGB.init(CWATools.getPixels(image2), n2, n3);
        CWAImageUtil.transparent(cWAImageARGB, n);
        image = CWATools.drawPixels(cWAImageARGB.argb, cWAImageARGB.w, cWAImageARGB.h, true);
        cWAImageARGB.release();
        return image;
    }

    public static CWAImageARGB changeColor(CWAImageARGB cWAImageARGB, int n, int n2, int n3, int n4) {
        for (int i = 0; i < cWAImageARGB.argb.length; ++i) {
            if (cWAImageARGB.argb[i] == 0xFFFFFF) continue;
            cWAImageARGB.argb[i] = n < 0 || n > 255 ? n2 << 16 | n3 << 8 | n4 : n << 24 | n2 << 16 | n3 << 8 | n4;
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB texture2D(CWAImageARGB cWAImageARGB, CWAImageARGB cWAImageARGB2, byte by) {
        int n = 0;
        int n2 = 0;
        if (by == TEXTURE_MIX) {
            cWAImageARGB = CWAImageUtil.reLightContrast(cWAImageARGB, 5, 5);
        }
        for (int i = 0; i < cWAImageARGB.h; ++i) {
            for (int j = 0; j < cWAImageARGB.w; ++j) {
                int n3 = cWAImageARGB.argb[i * cWAImageARGB.w + j];
                int n4 = cWAImageARGB2.argb[n2 * cWAImageARGB2.w + n];
                if (n3 >> 24 != 0) {
                    if (by == TEXTURE_MIX) {
                        cWAImageARGB.argb[i * cWAImageARGB.w + j] = n3 & n4;
                    } else if (by == TEXTURE_BLEND) {
                        cWAImageARGB.argb[i * cWAImageARGB.w + j] = n3 | n4;
                    } else if (by == TEXTURE_REPLACE) {
                        cWAImageARGB.argb[i * cWAImageARGB.w + j] = n4;
                    }
                }
                if (n < cWAImageARGB2.w - 1) {
                    ++n;
                    continue;
                }
                n = 0;
            }
            n2 = n2 < cWAImageARGB2.h - 1 ? ++n2 : 0;
            n = 0;
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB blackWhite(CWAImageARGB cWAImageARGB) {
        for (int i = 0; i < cWAImageARGB.h; ++i) {
            for (int j = 0; j < cWAImageARGB.w; ++j) {
                int n = cWAImageARGB.argb[i * cWAImageARGB.w + j];
                int n2 = n >> 24;
                int n3 = n >> 16 & 0xFF;
                int n4 = n >> 8 & 0xFF;
                n &= 0xFF;
                n3 = n = (int)(0.299 * (double)n3 + 0.587 * (double)n4 + 0.114 * (double)n);
                n4 = n;
                if (cWAImageARGB.argb[i * cWAImageARGB.w + j] == -1 || cWAImageARGB.argb[i * cWAImageARGB.w + j] == -16777216) {
                    int n5 = i * cWAImageARGB.w + j;
                    cWAImageARGB.argb[n5] = cWAImageARGB.argb[n5] & 0xFFFFFF;
                    continue;
                }
                cWAImageARGB.argb[i * cWAImageARGB.w + j] = n2 << 24 | n3 << 16 | n4 << 8 | n;
            }
        }
        return cWAImageARGB;
    }

    public static Image blackWhite(Image image) {
        CWAImageARGB cWAImageARGB = new CWAImageARGB();
        cWAImageARGB.init(CWATools.getPixels(image), image.getWidth(), image.getHeight());
        for (int i = 0; i < cWAImageARGB.h; ++i) {
            for (int j = 0; j < cWAImageARGB.w; ++j) {
                int n = cWAImageARGB.argb[i * cWAImageARGB.w + j];
                int n2 = n >> 24;
                int n3 = n >> 16 & 0xFF;
                int n4 = n >> 8 & 0xFF;
                n &= 0xFF;
                n3 = n = (int)(0.299 * (double)n3 + 0.587 * (double)n4 + 0.114 * (double)n);
                n4 = n;
                if (cWAImageARGB.argb[i * cWAImageARGB.w + j] == -1 || cWAImageARGB.argb[i * cWAImageARGB.w + j] == -16777216) {
                    int n5 = i * cWAImageARGB.w + j;
                    cWAImageARGB.argb[n5] = cWAImageARGB.argb[n5] & 0xFFFFFF;
                    continue;
                }
                cWAImageARGB.argb[i * cWAImageARGB.w + j] = n2 << 24 | n3 << 16 | n4 << 8 | n;
            }
        }
        image = CWATools.drawPixels(cWAImageARGB.argb, cWAImageARGB.w, cWAImageARGB.h, true);
        cWAImageARGB.release();
        return image;
    }

    public static CWAImageARGB crayon(CWAImageARGB cWAImageARGB) {
        for (int i = 0; i < cWAImageARGB.h; ++i) {
            for (int j = 0; j < cWAImageARGB.w; ++j) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6 = cWAImageARGB.argb[i * cWAImageARGB.w + j];
                int n7 = n6 >> 24;
                int n8 = n6 >> 16 & 0xFF;
                int n9 = n6 >> 8 & 0xFF;
                int n10 = n6 & 0xFF;
                if (i + 1 == cWAImageARGB.h) {
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                } else {
                    n6 = cWAImageARGB.argb[(i + 1) * cWAImageARGB.w + j];
                    n5 = n6 >> 16 & 0xFF;
                    n4 = n6 >> 8 & 0xFF;
                    n3 = n6 & 0xFF;
                }
                if (j + 1 == cWAImageARGB.w) {
                    n2 = 0;
                    n = 0;
                    n6 = 0;
                } else {
                    n6 = cWAImageARGB.argb[i * cWAImageARGB.w + j + 1];
                    n2 = n6 >> 16 & 0xFF;
                    n = n6 >> 8 & 0xFF;
                    n6 &= 0xFF;
                }
                n8 = (int)Math.sqrt(2 * (n8 - n5) * (n8 - n5) + (n8 - n2) * (n8 - n2));
                n9 = (int)Math.sqrt(2 * (n9 - n4) * (n9 - n4) + (n9 - n) * (n9 - n));
                n10 = (int)Math.sqrt(2 * (n10 - n3) * (n10 - n3) + (n10 - n6) * (n10 - n6));
                n8 = 255 - n8;
                n9 = 255 - n9;
                n10 = 255 - n10;
                cWAImageARGB.argb[i * cWAImageARGB.w + j] = n7 << 24 | n8 << 16 | n9 << 8 | n10;
            }
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB hoodwink(CWAImageARGB cWAImageARGB) {
        for (int i = 0; i < cWAImageARGB.h; ++i) {
            for (int j = 0; j < cWAImageARGB.w; ++j) {
                int n = cWAImageARGB.argb[i * cWAImageARGB.w + j];
                int n2 = n >> 24;
                int n3 = n >> 16 & 0xFF;
                int n4 = n >> 8 & 0xFF;
                n &= 0xFF;
                n3 = (int)(0.299 * (double)n3);
                n4 = (int)(0.587 * (double)n4);
                n = (int)(0.114 * (double)n);
                cWAImageARGB.argb[i * cWAImageARGB.w + j] = n2 << 24 | n3 << 16 | n4 << 8 | n;
            }
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB neonLight(CWAImageARGB cWAImageARGB) {
        for (int i = 0; i < cWAImageARGB.h; ++i) {
            for (int j = 0; j < cWAImageARGB.w; ++j) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6 = cWAImageARGB.argb[i * cWAImageARGB.w + j];
                int n7 = n6 >> 24;
                int n8 = n6 >> 16 & 0xFF;
                int n9 = n6 >> 8 & 0xFF;
                int n10 = n6 & 0xFF;
                if (i + 1 == cWAImageARGB.h) {
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                } else {
                    n6 = cWAImageARGB.argb[(i + 1) * cWAImageARGB.w + j];
                    n5 = n6 >> 16 & 0xFF;
                    n4 = n6 >> 8 & 0xFF;
                    n3 = n6 & 0xFF;
                }
                if (j + 1 == cWAImageARGB.w) {
                    n2 = 0;
                    n = 0;
                    n6 = 0;
                } else {
                    n6 = cWAImageARGB.argb[i * cWAImageARGB.w + j + 1];
                    n2 = n6 >> 16 & 0xFF;
                    n = n6 >> 8 & 0xFF;
                    n6 &= 0xFF;
                }
                n8 = (int)Math.sqrt(2 * (n8 - n5) * (n8 - n5) + (n8 - n2) * (n8 - n2));
                n9 = (int)Math.sqrt(2 * (n9 - n4) * (n9 - n4) + (n9 - n) * (n9 - n));
                n10 = (int)Math.sqrt(2 * (n10 - n3) * (n10 - n3) + (n10 - n6) * (n10 - n6));
                cWAImageARGB.argb[i * cWAImageARGB.w + j] = n7 << 24 | n8 << 16 | n9 << 8 | n10;
            }
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB rotate(CWAImageARGB cWAImageARGB, int n, int n2, double d) {
        if (Math.abs(d % 360.0) < 1.0) {
            return cWAImageARGB;
        }
        int n3 = n > cWAImageARGB.w / 2 ? n : cWAImageARGB.w - n;
        int n4 = n2 > cWAImageARGB.h / 2 ? n2 : cWAImageARGB.h - n2;
        double d2 = Math.sqrt(n3 * n3 + n4 * n4);
        n3 = (int)(d2 * 2.0 + 1.0);
        int[] nArray = new int[n3 * n3];
        double d3 = d * Math.PI / 180.0;
        for (int i = 0; i < cWAImageARGB.w; ++i) {
            for (int j = 0; j < cWAImageARGB.h; ++j) {
                if (cWAImageARGB.argb[j * cWAImageARGB.w + i] >> 24 == 0) continue;
                double d4 = d2 + (double)(i - n) * Math.cos(d3) + (double)(j - n2) * Math.sin(d3);
                double d5 = d2 + (double)(j - n2) * Math.cos(d3) - (double)(i - n) * Math.sin(d3);
                nArray[(int)d5 * n3 + (int)d4] = cWAImageARGB.argb[j * cWAImageARGB.w + i];
            }
        }
        cWAImageARGB.init(nArray, n3, n3);
        return cWAImageARGB;
    }
}

