/*
 * Decompiled with CFR 0.152.
 */
package custom;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import custom.Main;
import custom.Utils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CGraphics {
    private static int width;
    private static int height;
    private static int x;
    private static int y;
    static final byte[] moveDis;
    private static final int SPLASH_COLOR = 0;
    private static final int SPLASH_SPEED = 3;
    private static final int SPLASH_SIZE = 10;
    private static final int SPLASH_TYPE_SIZE = 6;
    private static boolean is_bStarEffectSplash;
    private static boolean is_bOpenEffectSplash;
    private static int openEffectID;
    private static int m_effectConut;

    public static int trans(boolean flipX, boolean flipY, boolean roate) {
        if (!flipX && !flipY) {
            return roate ? 4 : 0;
        }
        if (flipX && !flipY) {
            return roate ? 5 : 1;
        }
        if (!flipX && flipY) {
            return roate ? 6 : 2;
        }
        return roate ? 7 : 3;
    }

    public static void drawString(String str, Graphics g, int x, int y, int color, int anchor) {
        switch (anchor) {
            case 20: {
                break;
            }
            case 24: {
                x -= CGraphics.getStringWidth(str);
                break;
            }
            case 17: {
                x -= CGraphics.getStringWidth(str) / 2;
                break;
            }
            case 3: {
                x -= CGraphics.getStringWidth(str) / 2;
                y -= CGraphics.getTextInterval() / 2;
                break;
            }
            case 36: {
                y += CGraphics.getTextInterval();
                break;
            }
            case 40: {
                x -= CGraphics.getStringWidth(str);
                y += CGraphics.getTextInterval();
                break;
            }
            case 33: {
                x -= CGraphics.getStringWidth(str) / 2;
                y += CGraphics.getTextInterval();
            }
        }
        g.setColor(color);
        g.drawString(str, x, y, 20);
    }

    public static int getTextAnchorWidth(String str, int anchor) {
        int x = 0;
        switch (anchor) {
            case 20: {
                break;
            }
            case 24: {
                x -= CGraphics.getStringWidth(str);
                break;
            }
            case 17: {
                x -= CGraphics.getStringWidth(str) / 2;
                break;
            }
            case 3: {
                x -= CGraphics.getStringWidth(str) / 2;
                break;
            }
            case 36: {
                break;
            }
            case 40: {
                x -= CGraphics.getStringWidth(str);
                break;
            }
            case 33: {
                x -= CGraphics.getStringWidth(str) / 2;
            }
        }
        return x;
    }

    public static int getTextAnchorHeight(int anchor) {
        int y = 0;
        switch (anchor) {
            case 20: {
                break;
            }
            case 24: {
                break;
            }
            case 17: {
                break;
            }
            case 3: {
                y -= CGraphics.getTextInterval() / 2;
                break;
            }
            case 36: {
                y += CGraphics.getTextInterval();
                break;
            }
            case 40: {
                y += CGraphics.getTextInterval();
                break;
            }
            case 33: {
                y += CGraphics.getTextInterval();
            }
        }
        return y;
    }

    public static void drawRegionWithAnchor(Image image, Graphics g, int x, int y, int anchor) {
        switch (anchor) {
            case 20: {
                break;
            }
            case 24: {
                x -= image.getWidth();
                break;
            }
            case 17: {
                x -= image.getWidth() / 2;
            }
        }
        g.drawImage(image, x, y, 20);
    }

    public static void drawRegion(int dx, int dy, int w, int h, int sx, int sy, Image image, Graphics g, int manipulation) {
        CGraphics.drawRegionNokia(dx, dy, w, h, sx, sy, image, g, manipulation);
    }

    public static void drawRegionNokia(int dx, int dy, int w, int h, int sx, int sy, Image image, Graphics g, int manipulation) {
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        width = w;
        height = h;
        x = sx;
        y = sy;
        switch (manipulation) {
            case 0: {
                break;
            }
            case 1: {
                manipulation = 8192;
                x = image.getWidth() - sx - w;
                break;
            }
            case 2: {
                manipulation = 16384;
                y = image.getHeight() - sy - h;
                break;
            }
            case 3: {
                manipulation = 180;
                x = image.getWidth() - sx - w;
                y = image.getHeight() - sy - h;
                break;
            }
            case 4: {
                width = h;
                height = w;
                manipulation = 270;
                x = image.getHeight() - sy - h;
                y = sx;
                break;
            }
            case 7: {
                width = h;
                height = w;
                manipulation = 90;
                x = sy;
                y = image.getWidth() - sx - w;
                break;
            }
            case 5: {
                width = h;
                height = w;
                x = sy;
                y = sx;
                manipulation = 16474;
                break;
            }
            case 6: {
                x = image.getHeight() - sy - h;
                y = image.getWidth() - sx - w;
                width = h;
                height = w;
                manipulation = 16654;
                break;
            }
        }
        g.setClip(dx, dy, width, height);
        if (manipulation == 0) {
            g.drawImage(image, dx - x, dy - y, 20);
        } else {
            dg.drawImage(image, dx - x, dy - y, 20, manipulation);
        }
    }

    public static void drawWaveNumber(int num, int step, int x, int y, int w, int interval, int signIdx, Image image, Graphics g) {
        if (step > 25 || step > moveDis.length + 8 && step % 2 == 0) {
            return;
        }
        String numStr = String.valueOf(num);
        int length = numStr.length();
        int curNum = 0;
        int h = image.getHeight();
        int offset = step < moveDis.length ? step : moveDis.length;
        int extra = 0;
        if (signIdx > 9) {
            ++length;
            extra = 1;
        }
        for (int i = 0; i < length; ++i) {
            int curIdx = step - i;
            if (curIdx < 1) continue;
            int n = curIdx = curIdx > moveDis.length - 1 ? moveDis.length - 1 : curIdx;
            if (i == 0 && signIdx > 9) {
                CGraphics.drawRegion(x, y - (moveDis[curIdx] << 2) - offset, w, h, w * signIdx, 0, image, g, 20);
                continue;
            }
            curNum = numStr.charAt(i - extra) - 48;
            CGraphics.drawRegion(x + i * (w + interval), y - (moveDis[curIdx] << 2) - offset, w, h, w * curNum, 0, image, g, 20);
        }
    }

    public static final void fillRect(Graphics g, int now, int max, int x, int y, int width, int height, boolean horizon) {
        g.setClip(0, 0, 240, 320);
        if (max > 0) {
            int w = width;
            int h = height;
            g.setColor(0);
            g.drawRect(x, y, width, height);
            ++x;
            ++y;
            --width;
            --height;
            w = width--;
            h = height--;
            if (horizon) {
                w = now * width / max;
                if (w > width) {
                    w = width;
                }
                w = w < 0 ? 0 : w;
                g.setColor(127, 200 * w / width, 0);
                g.fillRect(x, y, w, h);
            } else {
                h = now * height / max;
                if (h > height) {
                    h = height;
                }
                h = h < 0 ? 0 : h;
                g.setColor(127, 200 * h / height, 0);
                g.fillRect(x, y + height - h + 1, w, h);
            }
        }
    }

    public static void fillRect(Graphics g, int x, int y, int w, int h, int color) {
        g.setColor(color);
        g.fillRect(x, y, w, h);
    }

    public static void startEffectSplash(boolean is_bOpen) {
        m_effectConut = 0;
        is_bStarEffectSplash = true;
        is_bOpenEffectSplash = is_bOpen;
        if (is_bOpenEffectSplash) {
            openEffectID = Utils.getRandom(0, 6);
        }
    }

    public static void drawEffect(Graphics g) {
        if (is_bStarEffectSplash) {
            is_bStarEffectSplash = CGraphics.drawEffect(g, is_bStarEffectSplash, is_bOpenEffectSplash, openEffectID);
        }
    }

    private static boolean drawEffect(Graphics g, boolean isOn, boolean isIn, int type) {
        return CGraphics.drawEffect(g, isOn, isIn, type, 0, 0, 240, 320, 0, 3, 10);
    }

    private static boolean drawEffect(Graphics g, boolean isOn, boolean isIn, int type, int x, int y, int w, int h, int color, int speed, int unitSize) {
        switch (type) {
            case 0: {
                isOn = CGraphics.drawEffectFade1(g, x, y, w, h, unitSize, speed, color, isIn, isOn);
                break;
            }
            case 1: {
                isOn = CGraphics.drawEffectFade2(g, x, y, w, h, unitSize, speed, color, isIn, isOn);
                break;
            }
            case 2: {
                isOn = CGraphics.drawEffectFade3(g, x, y, w, h, unitSize, speed, color, isIn, isOn);
                break;
            }
            case 3: {
                isOn = CGraphics.drawEffectFade4(g, x, y, w, h, unitSize, speed, color, isIn, isOn);
                break;
            }
            case 4: {
                isOn = CGraphics.drawEffectFade5(g, x, y, w, h, unitSize, speed, color, isIn, isOn);
                break;
            }
            case 5: {
                isOn = CGraphics.drawEffectFade6(g, x, y, w, h, 0, unitSize, speed, color, isIn, isOn);
                break;
            }
            case 6: {
                isOn = CGraphics.drawEffectFade6(g, x, y, w, h, 1, unitSize, speed, color, isIn, isOn);
                break;
            }
            case 7: {
                isOn = CGraphics.drawEffectFade7(g, x, y, w, h, speed, color, isIn, isOn);
            }
        }
        return isOn;
    }

    private static boolean drawEffectFade1(Graphics g, int X, int Y, int WIDTH_GAME, int HEIGHT_GAME, int unitSize, int speed, int color, boolean isIn, boolean isOn) {
        if (isOn) {
            int row = HEIGHT_GAME / unitSize;
            int H = 0;
            H = isIn ? unitSize - m_effectConut * speed : m_effectConut * speed;
            g.setClip(X, Y, WIDTH_GAME, HEIGHT_GAME);
            for (int i = 0; i < row; ++i) {
                CGraphics.fillRect(g, X, Y + i * unitSize, WIDTH_GAME, H, color);
            }
            if (m_effectConut * speed < unitSize) {
                ++m_effectConut;
            } else {
                m_effectConut = 0;
                isOn = false;
            }
        }
        return isOn;
    }

    private static boolean drawEffectFade2(Graphics g, int X, int Y, int WIDTH_GAME, int HEIGHT_GAME, int unitSize, int speed, int color, boolean isIn, boolean isOn) {
        if (isOn) {
            int row = WIDTH_GAME / unitSize;
            int H = 0;
            H = isIn ? unitSize - m_effectConut * speed : m_effectConut * speed;
            g.setClip(X, Y, WIDTH_GAME, HEIGHT_GAME);
            for (int i = 0; i < row; ++i) {
                CGraphics.fillRect(g, X + i * unitSize, Y, H, HEIGHT_GAME, color);
            }
            if (m_effectConut * speed < unitSize) {
                ++m_effectConut;
            } else {
                m_effectConut = 0;
                isOn = false;
            }
        }
        return isOn;
    }

    private static boolean drawEffectFade3(Graphics g, int X, int Y, int WIDTH_GAME, int HEIGHT_GAME, int unitSize, int speed, int color, boolean isIn, boolean isOn) {
        if (isOn) {
            int row = HEIGHT_GAME / unitSize;
            int y = 0;
            int h = 0;
            g.setClip(X, Y, WIDTH_GAME, HEIGHT_GAME);
            if (isIn) {
                y = unitSize / 2;
                for (int i = 0; i < row; ++i) {
                    h = unitSize - (m_effectConut - i) * speed;
                    CGraphics.fillRect(g, 0, y + i * unitSize - h / 2, WIDTH_GAME, h, color);
                }
            } else {
                y = HEIGHT_GAME - unitSize / 2;
                for (int i = 0; i < row; ++i) {
                    h = (m_effectConut - i) * speed;
                    CGraphics.fillRect(g, 0, y - i * unitSize - h / 2, WIDTH_GAME, h, color);
                }
            }
            if ((m_effectConut - row) * speed < unitSize) {
                ++m_effectConut;
            } else {
                m_effectConut = 0;
                isOn = false;
            }
        }
        return isOn;
    }

    private static boolean drawEffectFade4(Graphics g, int X, int Y, int WIDTH_GAME, int HEIGHT_GAME, int unitSize, int speed, int color, boolean isIn, boolean isOn) {
        if (isOn) {
            int row = WIDTH_GAME / unitSize;
            int y = 0;
            int h = 0;
            g.setClip(X, Y, WIDTH_GAME, HEIGHT_GAME);
            if (isIn) {
                y = unitSize / 2;
                for (int i = 0; i < row; ++i) {
                    h = unitSize - (m_effectConut - i) * speed;
                    CGraphics.fillRect(g, X + y + i * unitSize - h / 2, Y, h, HEIGHT_GAME, color);
                }
            } else {
                y = WIDTH_GAME - unitSize / 2;
                for (int i = 0; i < row; ++i) {
                    h = (m_effectConut - i) * speed;
                    CGraphics.fillRect(g, X + y - i * unitSize - h / 2, Y, h, HEIGHT_GAME, color);
                }
            }
            if ((m_effectConut - row) * speed < unitSize) {
                ++m_effectConut;
            } else {
                m_effectConut = 0;
                isOn = false;
            }
        }
        return isOn;
    }

    private static boolean drawEffectFade5(Graphics g, int X, int Y, int WIDTH_GAME, int HEIGHT_GAME, int unitSize, int speed, int color, boolean isIn, boolean isOn) {
        if (isOn) {
            int i;
            int col = WIDTH_GAME / unitSize;
            int row = HEIGHT_GAME / unitSize;
            int x = -(col * unitSize - WIDTH_GAME) / 2;
            int y = -(row * unitSize - HEIGHT_GAME) / 2;
            int w = 0;
            if (isIn) {
                w = unitSize - m_effectConut * speed;
                if (w % 2 == 1) {
                    ++w;
                }
            } else {
                if (w % 2 == 1) {
                    ++w;
                }
                w = m_effectConut * speed / 2 * 2;
            }
            g.setClip(X, Y, WIDTH_GAME, HEIGHT_GAME);
            for (i = 0; i < col + 1; ++i) {
                CGraphics.fillRect(g, X + x + i * unitSize - w / 2, Y, w, HEIGHT_GAME, color);
            }
            for (i = 0; i < row + 1; ++i) {
                CGraphics.fillRect(g, X, Y + y + i * unitSize - w / 2, WIDTH_GAME, w, color);
            }
            if ((m_effectConut - col) * speed < unitSize) {
                ++m_effectConut;
            } else {
                m_effectConut = 0;
                isOn = false;
            }
        }
        return isOn;
    }

    private static boolean drawEffectFade6(Graphics g, int X, int Y, int WIDTH_GAME, int HEIGHT_GAME, int teyp, int unitSize, int speed, int color, boolean isIn, boolean isOn) {
        if (isOn) {
            int row = WIDTH_GAME / unitSize + 1;
            int col = HEIGHT_GAME / unitSize + 1;
            if (teyp == 0) {
                row = WIDTH_GAME / unitSize + 1;
                col = HEIGHT_GAME / unitSize + 1;
            } else if (teyp == 1) {
                col = WIDTH_GAME / unitSize + 1;
                row = HEIGHT_GAME / unitSize + 1;
            } else if (teyp == 2) {
                // empty if block
            }
            int y = 0;
            int x = 0;
            int h = 0;
            g.setClip(X, Y, WIDTH_GAME, HEIGHT_GAME);
            if (isIn) {
                y = unitSize / 2;
                for (int i = 0; i < row; ++i) {
                    for (int j = 0; j < col; ++j) {
                        h = unitSize - (m_effectConut - i) * speed;
                        if (teyp == 0) {
                            CGraphics.fillRect(g, X + y + i * unitSize - h / 2, Y + y + j * unitSize - h / 2, h, h, color);
                            continue;
                        }
                        if (teyp != 1) continue;
                        CGraphics.fillRect(g, X + y + j * unitSize - h / 2, Y + y + i * unitSize - h / 2, h, h, color);
                    }
                }
            } else {
                y = WIDTH_GAME - unitSize / 2;
                x = HEIGHT_GAME - unitSize / 2;
                for (int i = 0; i < row; ++i) {
                    h = (m_effectConut - i) * speed;
                    for (int j = 0; j < col; ++j) {
                        if (teyp == 0) {
                            CGraphics.fillRect(g, X + y - i * unitSize - h / 2, Y + x - j * unitSize - h / 2, h, h, color);
                            continue;
                        }
                        if (teyp != 1) continue;
                        CGraphics.fillRect(g, X + y - j * unitSize - h / 2, Y + x - i * unitSize - h / 2, h, h, color);
                    }
                }
            }
            if ((m_effectConut - row) * speed < unitSize || (m_effectConut - col) * speed < unitSize) {
                ++m_effectConut;
            } else {
                m_effectConut = 0;
                isOn = false;
            }
        }
        return isOn;
    }

    private static boolean drawEffectFade7(Graphics g, int X, int Y, int WIDTH_GAME, int HEIGHT_GAME, int speed, int color, boolean isIn, boolean isOn) {
        if (isOn) {
            int step = 0;
            step = isIn ? (speed - m_effectConut) * (255 / speed) : m_effectConut * (255 / speed);
            if (step < 0) {
                step = 0;
            }
            if (step > 255) {
                step = 255;
            }
            CGraphics.drawArgbFill(g, X, Y, WIDTH_GAME, HEIGHT_GAME, color | step << 24);
            if (step < 255 || step > 0) {
                ++m_effectConut;
            } else {
                m_effectConut = 0;
                isOn = false;
            }
        }
        return isOn;
    }

    public static void drawArgbFill(Graphics g, int x, int y, int w, int h, int argbColor) {
        if ((argbColor & 0xFF000000) == -16777216) {
            CGraphics.fillRect(g, x, y, w, h, argbColor);
        } else if ((argbColor & 0xFF000000) != 0) {
            int[] argb = new int[w * h];
            for (int i = 0; i < argb.length; ++i) {
                argb[i] = argbColor;
            }
            g.drawRGB(argb, 0, w, x, y, w, h, true);
        }
    }

    private static int getStringWidth(String str) {
        int strW = Main.s_fontSmall.stringWidth(str);
        return strW;
    }

    private static int getTextInterval() {
        int strH = Main.s_fontSmall.getHeight() + 2;
        return strH;
    }

    static {
        moveDis = new byte[]{0, 1, 2, 3, 4, 3, 2, 1};
        openEffectID = 0;
        m_effectConut = 0;
    }
}

