/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.Scenario;
import com.ximad.pvn.utils.ArrayList;
import com.ximad.pvn.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLScenario {
    private int countScenarios = 0;
    private int currentScenario = 0;
    private ArrayList scenarios;
    private ArrayList levels;

    public void loadFromXML() {
        int i;
        this.countScenarios = 0;
        this.scenarios = new ArrayList();
        this.parseScenarios();
        for (i = 0; i < this.countScenarios; ++i) {
            this.levels = new ArrayList();
            this.parseLevels(i + 1);
            ((Scenario)this.scenarios.get((int)i)).level = this.levels;
        }
        GameParameters.scenarios = this.scenarios;
        GameParameters.scenarios_size = this.countScenarios;
        for (i = 0; i < 4; ++i) {
            GameParameters.tutorials[i] = 1;
        }
        Utils.log("!!!!! parse scenarios, size = " + this.countScenarios);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseScenarios() {
        InputStream is = this.getClass().getResourceAsStream("/xml/scenarios.xml");
        if (is == null) {
            Utils.print("/xml/scenarios.xml ----  not found!!");
            return;
        }
        ScenarioHandler sh = new ScenarioHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)sh);
        }
        catch (ParserConfigurationException e) {
            Utils.log("!!! parse error11");
        }
        catch (SAXException e) {
            Utils.log("!!! parse error12");
        }
        catch (IOException e) {
            Utils.log("!!! parse error13");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Utils.log("!!! parse error14");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLevels(int index) {
        this.currentScenario = index;
        InputStream is = this.getClass().getResourceAsStream("/xml/scenario" + index + ".xml");
        if (is == null) {
            Utils.print("/xml/scenario" + index + ".xml");
            return;
        }
        LevelHandler lh = new LevelHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)lh);
        }
        catch (ParserConfigurationException e) {
            Utils.log("!!! parse error");
        }
        catch (SAXException e) {
            Utils.log("!!! parse error");
        }
        catch (IOException e) {
            Utils.log("!!! parse error");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Utils.log("!!! parse error");
                }
            }
        }
    }

    class LevelHandler
    extends DefaultHandler {
        private boolean startDocument = false;
        private boolean endDocument = false;

        LevelHandler() {
        }

        public void startDocument() {
            this.startDocument = true;
        }

        public void endDocument() {
            this.endDocument = true;
        }

        public void startElement(String uri, String name, String qName, Attributes atts) {
            if (this.startDocument && !this.endDocument && qName.equals("level")) {
                String namE = "";
                String open = "false";
                boolean isOpen = false;
                String complete = "false";
                boolean isComplete = false;
                int highscore = 0;
                String medal = "no";
                int pandaused = 0;
                int pandanotused = 0;
                int obstacles = 0;
                int ninjas = 0;
                long score = 0L;
                try {
                    namE = atts.getValue("name");
                    open = atts.getValue("isOpen");
                    isOpen = open.equals("true");
                    complete = atts.getValue("isComplete");
                    isComplete = complete.equals("true");
                    highscore = Integer.parseInt(atts.getValue("hightscore"));
                    medal = atts.getValue("medal");
                    pandaused = Integer.parseInt(atts.getValue("pandaused"));
                    pandanotused = Integer.parseInt(atts.getValue("pandanotused"));
                    obstacles = Integer.parseInt(atts.getValue("obstacles"));
                    ninjas = Integer.parseInt(atts.getValue("ninjas"));
                    score = Long.parseLong(atts.getValue("score"));
                }
                catch (Exception e) {
                    Utils.log("!!! level parser error: scenario = " + XMLScenario.this.currentScenario + " / element = " + name + " / name = " + namE);
                }
                XMLScenario.this.levels.add(new LevelCompleteStat(namE, 0, 0, isOpen, isComplete, highscore, medal, pandaused, pandanotused, ninjas, obstacles, score));
            }
        }
    }

    class ScenarioHandler
    extends DefaultHandler {
        private boolean startDocument = false;
        private boolean endDocument = false;

        ScenarioHandler() {
        }

        public void startDocument() {
            this.startDocument = true;
        }

        public void endDocument() {
            this.endDocument = true;
        }

        public void startElement(String uri, String name, String qName, Attributes atts) {
            if (this.startDocument && !this.endDocument && qName.equals("scenario")) {
                String namE = "";
                String open = "false";
                boolean isOpen = false;
                int countLevels = 0;
                int levelsComplete = 0;
                int totalScore = 0;
                try {
                    namE = atts.getValue("name");
                    open = atts.getValue("isOpen");
                    isOpen = open.equals("true");
                    countLevels = Integer.parseInt(atts.getValue("countLevels"));
                    levelsComplete = Integer.parseInt(atts.getValue("levelsComplete"));
                    totalScore = Integer.parseInt(atts.getValue("totalScore"));
                }
                catch (Exception e) {
                    Utils.log("!!! scenario parser error: element = " + name + " / name = " + namE);
                }
                XMLScenario.this.scenarios.add(new Scenario(0, namE, isOpen, countLevels, totalScore, levelsComplete));
                XMLScenario.this.countScenarios++;
            }
        }
    }
}

