/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Effect;
import game.Enemy;
import game.GameObject;
import game.Human;
import game.Map;
import game.SceneGame;
import javax.microedition.lcdui.Graphics;
import main.MainCanvas;
import util.AniManager;
import util.Animation;
import util.Key;
import util.Utility;

public class Controllable
extends Human {
    public Effect m_explore = null;
    public Effect m_bomb = null;
    public Effect m_rush = null;
    public Effect m_fire = null;
    public static final int MAX_ATTACK = 4;
    public boolean rush_stop = false;
    protected boolean m_stunt = false;
    protected int m_hitnum = 0;
    protected long hitTime = 0L;
    protected int m_oldhitnum = 0;
    protected boolean m_bombactive = false;
    protected long m_bombtime = 0L;
    public static final byte M_STANDING = 0;
    public static final byte M_WALKING = 1;
    public static final byte M_HITTED = 2;
    public static final byte M_PICKUP = 3;
    public static final byte M_ATTACK = 4;
    public static final byte M_HITTEDDOWN = 5;
    public static final byte M_ONGROUND = 6;
    public static final byte M_STANDUP = 7;
    public static final byte M_RUSH = 8;
    public static final byte M_STUNT1 = 9;
    public static final byte M_STUNT2 = 10;
    public static final byte M_STUNT3 = 11;
    public static final byte M_EXPLORE1 = 12;
    public static final byte M_EXPLORE2 = 13;
    public static final byte M_EXPLORE3 = 14;
    public static final byte M_E1OVER = 15;
    public static final byte M_E2OVER = 16;
    public static final byte M_E3OVER = 17;
    public static final byte M_BOMB = 18;
    public static final byte I_STANDING = 0;
    public static final byte I_WALKING = 1;
    public static final byte I_HITTED = 2;
    public static final byte I_PICKUP = 3;
    public static final byte I_ATTACKWITHWEAPON = 4;
    public static final byte I_ATTACK1 = 5;
    public static final byte I_ATTACK2 = 6;
    public static final byte I_ATTACK3 = 7;
    public static final byte I_ATTACK4 = 8;
    public static final byte I_HITTEDDOWN = 9;
    public static final byte I_ONGROUND = 10;
    public static final byte I_STANDUP = 11;
    public static final byte I_RUSH = 12;
    public static final byte I_STANDINGWITHWEAPON = 13;
    public static final byte I_WALKINGWITHWEAPON = 14;
    public static final byte I_HITTEDWITHWEAPON = 15;
    public static final byte I_STUNT1 = 16;
    public static final byte I_STUNT2 = 17;
    public static final byte I_STUNT3 = 18;
    public static final byte I_EXPLORE1 = 19;
    public static final byte I_EXPLORE2 = 20;
    public static final byte I_EXPLORE3 = 21;
    public static final byte I_E1OVER = 22;
    public static final byte I_E2OVER = 23;
    public static final byte I_E3OVER = 24;
    public static final byte I_BOMB = 25;
    private static final byte[] distx_attck4 = new byte[]{4, 4, 16, 3, 2, 1};
    private static final byte[] distx_rush = new byte[]{0, 0, 0, 30, 25, 20, 15, 5, 2, 1, 0};
    public static final byte[] distx_stunt2 = new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3};
    public static final byte[] distx_stunt3 = new byte[]{15, 15, 15, 15, 15, 15, 15, 10, 10, 5, 5, 15, 15, 15, 15, 15, 15, 15, 10, 10, 5, 5, 0, 15, 15, 15, 15, 15, 15, 15, 15};
    private static final int HIT_VIBRATE_TIME = 500;
    private static final int ENERGY_COST = 200;
    public static int keyDbug;

    public Controllable(SceneGame game, Animation ani) {
        super(game, ani);
        this.m_explore = new Effect(game, game.ani_effect, 0, 0, 0, false);
        this.m_rush = new Effect(game, game.ani_effect, 0, 0, 1, false);
        this.m_bomb = new Effect(game, game.ani_bomb, 0, 0, 9, false);
        this.m_fire = new Effect(game, game.ani_fire, 0, 0, 10, false);
        this.m_maxHealth = 1000;
        this.m_health = game.m_health;
        this.m_maxMagic = 1800;
        this.m_magic = game.m_magic;
        this.setPlayerState((byte)0);
    }

    public void init(byte type, byte initialState) {
    }

    public void update() {
        try {
            byte tempx = 0;
            int curframe = this.NowFrame();
            boolean facing = this.getfacing();
            if (this.m_bombactive && Utility.GetTime() - this.m_bombtime > 30000L) {
                this.m_bombactive = false;
            }
            if (this.m_flashing && Utility.GetTime() - this.m_flashTime > 1500L) {
                this.m_flashing = false;
            }
            if (Utility.GetTime() - this.hitTime > 1000L) {
                this.m_hitnum = 0;
            }
            switch (this.m_state) {
                case 0: {
                    this.loopAnimation();
                    if (Utility.GetTime() - this.m_stateTime <= 800L) break;
                    this.m_attack = false;
                    this.m_attackStep = 0;
                    break;
                }
                case 8: {
                    this.updateattack(curframe);
                    if (this.m_attackstand != 0) break;
                    if (!this.rush_stop) {
                        tempx = distx_rush[curframe];
                        this.updatedistx(tempx);
                    }
                    if (!this.loopcompleted()) break;
                    this.setPlayerState((byte)0);
                    break;
                }
                case 4: {
                    this.updateattack(curframe);
                    if (this.m_attackstand != 0) break;
                    if (!this.m_keepweapon && this.m_attackStep == 3) {
                        tempx = distx_attck4[curframe];
                        this.updatedistx(tempx);
                    }
                    if (!this.loopcompleted()) break;
                    this.setPlayerState((byte)0);
                    break;
                }
                case 1: {
                    if (Utility.GetTime() - this.m_stateTime > 800L) {
                        this.m_attack = false;
                        this.m_attackStep = 0;
                    }
                    this.loopAnimation();
                    this.updateWalking(this.m_facingDir);
                    break;
                }
                case 5: {
                    this.updatehittedflying(curframe, facing);
                    if (!this.loopcompleted()) break;
                    this.setPlayerState((byte)6);
                    break;
                }
                case 6: {
                    if (Utility.GetTime() - this.m_stateTime <= 1000L) break;
                    if (this.getHealth() <= 0) {
                        this.m_scene.createresultimg(false);
                        this.m_scene.setState(4);
                    } else {
                        this.setPlayerState((byte)7);
                    }
                    this.startFlashing(Utility.GetTime());
                    break;
                }
                case 2: {
                    if (this.m_bombactive) {
                        if (!this.loopcompleted()) break;
                        this.setPlayerState((byte)0);
                        break;
                    }
                    this.m_shakedist = (byte)(this.m_shakedist ^ 1);
                    if (this.m_shakedist == 0) {
                        this.distX = -1;
                    } else if (this.m_shakedist == 1) {
                        this.distX = 1;
                    }
                    if (Utility.GetTime() - this.m_stateTime <= 400L || !this.loopcompleted()) break;
                    this.setPlayerState((byte)0);
                    break;
                }
                case 3: 
                case 7: 
                case 15: 
                case 16: 
                case 17: {
                    if (this.m_state == 2 && this.getHealth() <= 0) {
                        this.setPlayerState((byte)5);
                    }
                    if (!this.loopcompleted()) break;
                    this.setPlayerState((byte)0);
                    break;
                }
                case 18: {
                    if (!this.m_bomb.loopcompleted()) break;
                    this.m_bombactive = true;
                    this.m_bombtime = Utility.GetTime();
                    this.setPlayerState((byte)0);
                    break;
                }
                case 12: {
                    if (!this.m_explore.loopcompleted()) break;
                    this.setPlayerState((byte)9);
                    break;
                }
                case 13: {
                    if (!this.m_explore.loopcompleted()) break;
                    this.setPlayerState((byte)10);
                    break;
                }
                case 14: {
                    if (!this.m_explore.loopcompleted()) break;
                    this.setPlayerState((byte)11);
                    break;
                }
                case 9: {
                    this.updateattack(curframe);
                    if (!this.loopcompleted()) break;
                    this.setPlayerState((byte)15);
                    break;
                }
                case 10: {
                    this.updateattack(curframe);
                    tempx = distx_stunt2[curframe];
                    this.updatedistx(tempx);
                    if (!this.loopcompleted()) break;
                    this.setPlayerState((byte)16);
                    break;
                }
                case 11: {
                    this.updateattack(curframe);
                    if (this.m_attackstand != 0) break;
                    if (curframe == 8 || curframe == 19) {
                        this.changefacing();
                    }
                    tempx = distx_stunt3[curframe];
                    this.updatedistx(tempx);
                    if (!this.loopcompleted()) break;
                    this.setPlayerState((byte)17);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateattack(int curframe) {
        if (this.m_attackstand > 0) {
            --this.m_attackstand;
            return;
        }
        boolean canattack = false;
        AniManager judgeani = null;
        judgeani = this.m_keepweapon && this.m_state == 4 ? this.m_weapon.getAniManager() : this.getAniManager();
        boolean bl = canattack = judgeani.get_cBoxAtt_w() != 0 && judgeani.get_cBoxAtt_h() != 0;
        if (canattack) {
            this.m_attack = this.attack(curframe);
        }
        if (!this.m_keepweapon) {
            if (!this.m_attack) {
                this.m_attackStep = 0;
            } else if (this.islast()) {
                this.m_attackStep = this.m_attackStep < 3 ? ++this.m_attackStep : 0;
            }
        } else {
            this.m_attackStep = 0;
        }
    }

    protected boolean attack(int _curframe) {
        try {
            int i = 0;
            int length = this.m_scene.renderlist.length;
            boolean attacksomeone = false;
            GameObject _go = null;
            boolean move = false;
            for (i = 0; i < length - 1; ++i) {
                int[] hitrect;
                Enemy enemy;
                boolean invincibility;
                boolean isEnemy = this.m_scene.isactiveenemy(i);
                if (!isEnemy || (invincibility = (enemy = (Enemy)this.m_scene.renderlist[i]).invincibility())) continue;
                int dist = this.GetVerticalDistance(enemy.getY());
                boolean weapon = this.m_keepweapon && this.m_state == 4;
                _go = weapon ? this.m_weapon : this;
                int[] attackrect = _go.getAttackBox();
                boolean attack = MainCanvas.collision(attackrect, hitrect = enemy.getHittedBox());
                if (attack && dist < 10) {
                    attacksomeone = true;
                    boolean isstunt = this.checkisstunt();
                    boolean fatmandefend = false;
                    if (!isstunt && enemy.fatmandefend()) {
                        fatmandefend = true;
                    }
                    int ex = attackrect[0] + (attackrect[2] >> 1);
                    int ey = attackrect[1] + (attackrect[3] >> 1);
                    int e_type = this.CheckAttackEffect(isstunt);
                    if (weapon) {
                        e_type = this.m_weapon.CheckAttackEffect();
                        if (fatmandefend) {
                            e_type = 2;
                        }
                    }
                    this.createAttackEffect(hitrect, ex, ey, e_type);
                    if (enemy.getObjectType() != 3) {
                        enemy.setFacingTo(this);
                    }
                    if (fatmandefend) {
                        this.m_attackstand = 2;
                        enemy.updatedistx(-5);
                        continue;
                    }
                    int damage = this.checkdamage(isstunt);
                    if (weapon) {
                        damage = this.m_weapon.CheckDamage();
                    }
                    if (this.m_bombactive) {
                        damage += damage >> 1;
                    }
                    this.dodamdage(enemy, damage, isstunt);
                    boolean hitdown = false;
                    if (weapon) {
                        this.m_attackstand = 2;
                        hitdown = this.m_weapon.CheckHitdownTo(enemy);
                        this.m_weapon.m_state = (byte)(this.m_weapon.m_state + 1);
                    } else {
                        hitdown = this.hitdown(enemy, _curframe, isstunt);
                    }
                    if (hitdown) {
                        enemy.setEnemyState((byte)5);
                    } else {
                        enemy.setEnemyState((byte)2);
                        int attdist = this.attackdist();
                        if (attdist > 0) {
                            if (!move) {
                                this.updatedistx(attdist);
                                move = true;
                            }
                            enemy.updatedistx(-attdist);
                        }
                    }
                    ++this.m_hitnum;
                    this.hitTime = Utility.GetTime();
                    enemy.m_hitted = true;
                    continue;
                }
                enemy.m_hitted = false;
            }
            return attacksomeone;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void render(Graphics g) {
        try {
            Map map = this.m_scene.getMap();
            int _x = map.getViewportX() + this.getX() - map.getCameraX() + this.distX;
            int _y = map.getViewportY() + this.getY() - map.getCameraY() + this.distY;
            AniManager ani_hero = this.getAniManager();
            int shadowx = _x - this.distX;
            int shadowy = _y - this.distY;
            this.m_flashTimer = this.m_flashing ? (byte)(this.m_flashTimer ^ 1) : (byte)0;
            if (this.m_flashTimer == 0) {
                g.drawImage(this.m_scene.img_largeshadow, shadowx, shadowy, 3);
                ani_hero.draw(g, _x, _y);
                if (this.m_keepweapon && this.checkkeepweaponstate()) {
                    this.m_weapon.setPositionX(this.getX());
                    this.m_weapon.setPositionY(this.getY());
                    this.m_weapon.getAniManager().setfacingx(this.getfacing());
                    this.m_weapon.getAniManager().setFrame(this.m_state, this.NowFrame());
                    this.m_weapon.renderweaponwithmother(g, _x, _y);
                }
                if (this.m_state == 12 || this.m_state == 13 || this.m_state == 14) {
                    int index = this.m_state - 12;
                    int[][] ex_dist = new int[][]{{0, 45}, {13, 53}, {-11, 35}};
                    this.m_explore.getAniManager().draw(g, _x - ex_dist[index][0], _y - ex_dist[index][1]);
                }
                if (this.m_state == 8) {
                    this.m_rush.getAniManager().setFrame(1, this.NowFrame());
                    this.m_rush.getAniManager().setfacingx(ani_hero.getfacingx());
                    this.m_rush.getAniManager().draw(g, _x, _y);
                }
                if (this.m_state == 11) {
                    this.m_rush.getAniManager().setFrame(6, this.NowFrame());
                    this.m_rush.getAniManager().setfacingx(ani_hero.getfacingx());
                    this.m_rush.getAniManager().draw(g, _x, _y);
                }
                if (this.m_state == 18) {
                    this.m_bomb.getAniManager().draw(g, _x, _y);
                }
                if (this.m_bombactive) {
                    this.m_fire.getAniManager().nextFrame_Cyc();
                    this.m_fire.getAniManager().draw(g, _x + 5, _y);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void processkey() {
        switch (this.m_state) {
            case 0: 
            case 1: {
                if (this.m_state == 1) {
                    if (Key.IsKeyReleased(4)) {
                        if (this.getAniManager().getfacingx()) {
                            this.setPlayerState((byte)0);
                            return;
                        }
                    } else if (Key.IsKeyReleased(8)) {
                        if (!this.getAniManager().getfacingx()) {
                            this.setPlayerState((byte)0);
                            return;
                        }
                    } else if (Key.IsKeyReleased(1) || Key.IsKeyReleased(2)) {
                        this.setPlayerState((byte)0);
                        return;
                    }
                }
                if (Key.IsKeyDoublePressed(4)) {
                    if (!this.getAniManager().getfacingx()) break;
                    this.setPlayerState((byte)8);
                    return;
                }
                if (Key.IsKeyDoublePressed(8)) {
                    if (this.getAniManager().getfacingx()) break;
                    this.setPlayerState((byte)8);
                    return;
                }
                if (Key.IsKeyPressed(262144)) {
                    if (this.somethingpicked()) {
                        this.setPlayerState((byte)3);
                    } else {
                        ++keyDbug;
                        this.setPlayerState((byte)4);
                    }
                    return;
                }
                if (Key.IsKeyPressed(16)) {
                    if (this.m_magic < 200) break;
                    this.reduceMagic(200);
                    this.setPlayerState((byte)12);
                    this.m_explore.getAniManager().set_indexAnimate(0);
                    break;
                }
                if (Key.IsKeyPressed(16384)) {
                    if (this.m_bombactive || this.m_magic < 200) break;
                    this.setPlayerState((byte)18);
                    this.reduceMagic(200);
                    break;
                }
                if (Key.IsKeyPressed(32768)) {
                    if (!SceneGame.is_bTestVersion) break;
                    if (MainCanvas.areaid >= MainCanvas.max_area) {
                        this.m_scene.createresultimg(true);
                        this.m_scene.setState(3);
                        this.m_scene.m_player.setPlayerState((byte)0);
                        break;
                    }
                    this.m_scene.setState(2);
                    this.m_scene.stageclear = false;
                    this.m_scene.y_black = 0;
                    this.m_scene.nextstageloaded = false;
                    break;
                }
                if (Key.IsKeyHold(4)) {
                    if (!this.getAniManager().getfacingx()) {
                        this.getAniManager().setfacingx(true);
                        break;
                    }
                    this.setWalkingDir((byte)2);
                    if (this.m_state != 0) break;
                    this.setPlayerState((byte)1);
                    break;
                }
                if (Key.IsKeyHold(8)) {
                    if (this.getAniManager().getfacingx()) {
                        this.getAniManager().setfacingx(false);
                        break;
                    }
                    this.setWalkingDir((byte)3);
                    if (this.m_state != 0) break;
                    this.setPlayerState((byte)1);
                    break;
                }
                if (Key.IsKeyHold(1)) {
                    this.setWalkingDir((byte)0);
                    if (this.m_state != 0) break;
                    this.setPlayerState((byte)1);
                    break;
                }
                if (!Key.IsKeyHold(2)) break;
                this.setWalkingDir((byte)1);
                if (this.m_state != 0) break;
                this.setPlayerState((byte)1);
                break;
            }
            case 15: {
                if (!Key.IsKeyPressed(16) || this.m_magic < 200) break;
                this.reduceMagic(200);
                this.setPlayerState((byte)13);
                this.m_explore.getAniManager().set_indexAnimate(0);
                break;
            }
            case 16: {
                if (!Key.IsKeyPressed(16) || this.m_magic < 200) break;
                this.reduceMagic(200);
                this.setPlayerState((byte)14);
                this.m_explore.getAniManager().set_indexAnimate(0);
                break;
            }
            case 2: {
                if (Key.IsKeyPressed(16)) {
                    if (this.m_magic < 200) break;
                    this.reduceMagic(200);
                    this.setPlayerState((byte)12);
                    this.m_explore.getAniManager().set_indexAnimate(0);
                    break;
                }
                if (!Key.IsKeyPressed(16384) || this.m_bombactive || this.m_magic < 200) break;
                this.setPlayerState((byte)18);
                this.reduceMagic(200);
            }
        }
    }

    public void setPlayerState(byte _state) {
        try {
            super.setObjectState(_state);
            this.m_attackstand = 0;
            if (this.m_keepweapon && (_state == 5 || _state == 6 || _state == 7 || _state == 9 || _state == 10 || _state == 11)) {
                this.weapondropfromhero();
            }
            if (_state != 11 && _state != 9 && _state != 10 && _state != 8 && _state != 4 && _state != 0 && _state != 15 && _state != 16 && _state != 17 && _state != 12 && _state != 13 && _state != 14 && _state != 1) {
                this.m_attackStep = 0;
                this.m_attack = false;
            }
            if (_state == 8) {
                this.rush_stop = false;
            }
            if (_state == 4) {
                if (this.m_keepweapon) {
                    this.getAniManager().set_indexAnimate(4);
                } else if (this.m_attackStep == 0) {
                    this.getAniManager().set_indexAnimate(5);
                } else if (this.m_attackStep == 1) {
                    this.getAniManager().set_indexAnimate(6);
                } else if (this.m_attackStep == 2) {
                    this.getAniManager().set_indexAnimate(7);
                } else if (this.m_attackStep == 3) {
                    this.getAniManager().set_indexAnimate(8);
                }
            } else if (_state == 0) {
                if (this.m_keepweapon) {
                    this.getAniManager().set_indexAnimate(13);
                } else {
                    this.getAniManager().set_indexAnimate(0);
                }
            } else if (_state == 1) {
                if (this.m_keepweapon) {
                    this.getAniManager().set_indexAnimate(14);
                } else {
                    this.getAniManager().set_indexAnimate(1);
                }
            } else if (_state == 2) {
                if (this.m_keepweapon) {
                    this.getAniManager().set_indexAnimate(15);
                } else {
                    this.getAniManager().set_indexAnimate(2);
                }
            } else if (_state == 3) {
                this.getAniManager().set_indexAnimate(3);
            } else if (_state == 5) {
                this.getAniManager().set_indexAnimate(9);
            } else if (_state == 6) {
                this.getAniManager().set_indexAnimate(10);
            } else if (_state == 7) {
                this.getAniManager().set_indexAnimate(11);
            } else if (_state == 8) {
                this.getAniManager().set_indexAnimate(12);
            } else if (_state == 9) {
                this.getAniManager().set_indexAnimate(16);
            } else if (_state == 10) {
                this.getAniManager().set_indexAnimate(17);
            } else if (_state == 11) {
                this.getAniManager().set_indexAnimate(18);
            } else if (_state == 12) {
                this.getAniManager().set_indexAnimate(19);
            } else if (_state == 13) {
                this.getAniManager().set_indexAnimate(20);
            } else if (_state == 14) {
                this.getAniManager().set_indexAnimate(21);
            } else if (_state == 15) {
                this.getAniManager().set_indexAnimate(22);
            } else if (_state == 16) {
                this.getAniManager().set_indexAnimate(23);
            } else if (_state == 17) {
                this.getAniManager().set_indexAnimate(24);
            } else if (_state == 18) {
                this.getAniManager().set_indexAnimate(25);
                this.m_bomb.getAniManager().set_indexAnimate(0);
            }
            this.getAniManager().reSetFrame();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean checkkeepweaponstate() {
        return this.m_state == 0 || this.m_state == 1 || this.m_state == 2 || this.m_state == 3 || this.m_state == 4;
    }

    protected boolean checkisstunt() {
        return this.m_state == 9 || this.m_state == 10 || this.m_state == 11;
    }

    protected int CheckAttackEffect(boolean isstunt) {
        if (isstunt || this.m_bombactive) {
            boolean bl = this.m_stunt = !this.m_stunt;
            if (this.m_stunt) {
                return 4;
            }
            return 5;
        }
        return 2;
    }

    protected int checkdamage(boolean isstunt) {
        int damage = 0;
        damage = isstunt ? 30 : (this.m_state == 4 && this.m_attackStep == 3 ? 20 : 15);
        return damage;
    }

    protected void dodamdage(Enemy enemy, int damage, boolean isstunt) {
        enemy.reduceHealth(damage);
        this.m_scene.m_coin += damage;
        if (!isstunt) {
            this.addMagic(damage);
        }
    }

    protected void getdamage(int damage) {
        this.reduceHealth(damage);
        this.addMagic(damage << 1);
    }

    protected boolean hitdown(Enemy enemy, int curframe, boolean isstunt) {
        if (enemy.m_objectType == 3) {
            return false;
        }
        if (isstunt) {
            if (this.m_state == 11 && curframe > 19) {
                this.m_attackstand = 2;
                return true;
            }
            this.m_attackstand = 1;
            return false;
        }
        if (this.m_state == 4 && this.m_attackStep == 3) {
            this.m_attackstand = 1;
            return true;
        }
        if (this.m_state == 8) {
            this.m_attackstand = 2;
            this.rush_stop = true;
            return true;
        }
        this.m_attackstand = 1;
        return false;
    }

    protected int attackdist() {
        if (this.m_keepweapon) {
            return 5;
        }
        if (this.m_state == 4 && this.m_attackStep != 3) {
            return 3;
        }
        return 0;
    }

    protected boolean canbeattack() {
        return (this.m_state == 0 || this.m_state == 1 || this.m_state == 2 || this.m_state == 4 || this.m_state == 8) && !this.m_flashing;
    }

    protected boolean checkbombed() {
        return this.m_state == 12 || this.m_state == 18 || this.m_state == 13 || this.m_state == 14;
    }
}

