/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Bombs;
import game.Controllable;
import game.GameObject;
import game.Human;
import game.Map;
import game.SceneGame;
import game.Weapon;
import javax.microedition.lcdui.Graphics;
import main.MainCanvas;
import util.AniManager;
import util.Animation;
import util.MathTool;
import util.Utility;

public class Enemy
extends Human {
    protected boolean needupdate = false;
    protected int m_attacktype = 0;
    protected int m_attackloop = 0;
    protected int m_curloop = 0;
    protected AniManager am_bomb = null;
    protected int x_am_bomb = 0;
    protected int y_am_bomb = 0;
    public static final byte E_STANDING = 0;
    public static final byte E_WALKING = 1;
    public static final byte E_HITTED = 2;
    public static final byte EMOTO_FOOTSIE = 3;
    public static final byte EMOTO_HI = 4;
    public static final byte EMOTO_GUNOUT = 5;
    public static final byte EMOTO_SHOOT = 6;
    public static final byte E_PICKUP = 3;
    public static final byte E_ATTACK = 4;
    public static final byte E_HITTEDDOWN = 5;
    public static final byte E_STANDUP = 6;
    public static final byte E_RUNBACK = 7;
    public static final byte E_ONGROUND = 8;
    public static final byte EFAT_DEF = 3;
    public static final byte EBITCH_QUICKATTACK = 3;
    public static final byte EJOKER_BOLAUGH = 3;
    public static final byte EJOKER_LAUGH1 = 9;
    public static final byte EJOKER_LAUGH2 = 10;
    public static final byte EJOKER_FOOTSIE = 11;
    public static final byte EJOKER_LONGLAUGH = 12;
    public static final byte E_MOVEOUT = 13;
    public static final byte EFAT_ATTACKWAITING = 14;
    public static final byte EMOTO_BOMB = 15;
    private byte m_roguetype = 0;
    private boolean m_gotoattack = false;
    private boolean m_cross = false;
    protected boolean m_gotoplayer = false;
    private boolean m_walkingupdown = false;
    private int m_targetx = 0;
    private int m_targety = 0;
    private int crossStep = 0;
    private int m_crossy = 0;
    private int m_keepfromplayerx = 0;
    private int m_keepfromplayery = 0;
    private int m_attackangle = 0;
    private long mototime = 0L;
    private long m_kotime = 0L;
    public static final byte AT_NORMAL = 0;
    public static final byte AT_ALLATONE = 1;
    public static final byte AT_ALLSTEP = 2;
    public static final byte AT_ONTOPLAYER = 3;
    public static final byte AT_GROUND = 4;
    public static final byte AT_DTOPLAYER = 5;

    public Enemy(SceneGame game, Animation ani) {
        super(game, ani);
    }

    public void init(byte type, byte initialState) {
        this.m_objectType = type;
        this.setEnemyState(initialState);
        this.m_keepfromplayerx = this.getAniManager().getFrameWidth() + (this.getAniManager().getFrameWidth() >> 1);
        this.m_keepfromplayery = 20;
        this.m_walkingSpeedX = 4;
        this.m_walkingSpeedY = 4;
    }

    public void update() {
        try {
            boolean facingy;
            boolean facingx;
            int disty;
            int distx;
            int dist;
            int curframe;
            int viewright;
            int viewleft;
            int py;
            int px;
            Map map;
            Controllable player;
            block135: {
                block134: {
                    player = this.m_scene.m_player;
                    map = this.m_scene.getMap();
                    px = player.getX();
                    py = player.getY();
                    viewleft = map.getCameraX() - map.getViewportX();
                    viewright = map.getCameraX() + map.getViewportWidth() - map.getViewportX();
                    curframe = this.NowFrame();
                    dist = this.GetDistance(player);
                    distx = this.GetHorizontalDistance(px);
                    disty = this.GetVerticalDistance(py);
                    facingx = this.x_getFacingTo(player);
                    facingy = this.y_getFacingTo(player);
                    if (this.m_scene.getState() == 2) {
                        this.setFacingTo(player);
                        this.loopAnimation();
                        return;
                    }
                    if (this.m_scene.getState() == 3) break block134;
                    if (this.m_scene.getState() != 4 && !this.m_scene.missionclear) break block135;
                }
                this.needupdate = true;
            }
            if (!this.needupdate) {
                this.setFacingTo(player);
                this.loopAnimation();
                if (map.inthearea(player) && this.InScreen(map)) {
                    this.needupdate = true;
                    if (this.m_objectType == 3) {
                        this.setEnemyState((byte)3);
                        this.m_kotime = 3000L;
                    }
                }
                return;
            }
            if (player.checkbombed()) {
                return;
            }
            if (this.m_state == 2) {
                if (this.getHealth() <= 0) {
                    if (this.m_objectType == 3) {
                        this.setEnemyState((byte)15);
                        this.am_bomb = new AniManager(this.m_scene.ani_bombexplore);
                        this.x_am_bomb = this.getX() + MathTool.getRandom(-(this.getAniManager().getFrameWidth() >> 1), this.getAniManager().getFrameWidth() >> 1);
                        this.y_am_bomb = this.getY() - MathTool.getRandom(2, this.getAniManager().getFrameHeight());
                        this.startFlashing(Utility.GetTime());
                    } else {
                        this.setEnemyState((byte)5);
                    }
                    return;
                }
                this.m_shakedist = (byte)(this.m_shakedist ^ 1);
                if (this.m_shakedist == 0) {
                    this.distX = -1;
                } else if (this.m_shakedist == 1) {
                    this.distX = 1;
                }
                if (this.m_objectType == 3) {
                    if (this.m_laststate == 1 || this.m_laststate == 4) {
                        if (Utility.GetTime() - this.m_stateTime > 50L && this.loopcompleted()) {
                            this.setEnemyState(this.m_laststate);
                        }
                    } else {
                        this.updatedistx(-5);
                        if (MathTool.randRatio(5)) {
                            this.aimplayer_motoman(map, py);
                            this.m_gotoattack = false;
                            this.m_attackloop = 0;
                        }
                        if (Utility.GetTime() - this.m_stateTime > 700L && this.loopcompleted()) {
                            this.setEnemyState((byte)0);
                            this.m_gotoattack = false;
                            this.m_attackloop = 0;
                            if (this.m_positionX < map.moveleft - 20 || this.m_positionX > map.moveright + 20) {
                                this.startwaitingformoto();
                                this.setEnemyState((byte)1);
                            }
                        }
                    }
                } else {
                    if (player.m_state == 11 && this.getObjectType() != 3) {
                        this.setFacingTo(player);
                    }
                    if (player.checkisstunt() && player.m_state == 10) {
                        this.updatedistx(-Controllable.distx_stunt2[player.getAniManager().getNowFrame()]);
                    }
                    if (Utility.GetTime() - this.m_stateTime > 800L && this.loopcompleted()) {
                        this.setEnemyState((byte)0);
                    }
                }
            } else if (this.m_state == 5 && this.m_objectType != 3) {
                if (player.m_attackstand > 0) {
                    return;
                }
                this.updatehittedflying(curframe, this.getfacing());
                if (this.loopcompleted()) {
                    this.setEnemyState((byte)8);
                }
            } else if (this.m_state == 5 && this.m_objectType == 3) {
                if (this.loopcompleted()) {
                    this.setEnemyState((byte)6);
                }
            } else if (this.m_state == 11 || this.m_state == 3 && this.m_objectType == 4 || this.m_state == 9 || this.m_state == 10 || this.m_state == 12) {
                if (this.fittoattack(distx, disty)) {
                    if (MathTool.randRatio(20)) {
                        this.jokerstartattack(0);
                        return;
                    }
                    if (MathTool.randRatio(8)) {
                        this.startescape(map, px, py, facingx, facingy);
                        return;
                    }
                }
                if (this.loopcompleted()) {
                    this.setEnemyState((byte)0);
                }
            } else if (this.m_state == 15 && this.m_objectType == 3) {
                if (this.am_bomb.nextFrame_toEnd()) {
                    this.am_bomb.reSetFrame();
                    this.x_am_bomb = this.getX() + MathTool.getRandom(-(this.getAniManager().getFrameWidth() >> 1), this.getAniManager().getFrameWidth() >> 1);
                    this.y_am_bomb = this.getY() - MathTool.getRandom(2, this.getAniManager().getFrameHeight());
                }
                if (Utility.GetTime() - this.m_flashTime >= 3000L) {
                    if (this.m_scene.bossappear && MainCanvas.missionid == 1) {
                        this.m_scene.missionclear = true;
                        this.m_dying = false;
                        this.m_flashing = false;
                        this.setdead();
                        this.m_scene.createresultimg(true);
                        this.m_scene.setState(3);
                        player.setPlayerState((byte)0);
                    } else {
                        this.m_dying = false;
                        this.m_flashing = false;
                        this.setdead();
                        this.dropItem(map);
                        boolean gotonext = this.m_scene.checkareaclear();
                        if (gotonext) {
                            this.gonext(map);
                        }
                    }
                }
            } else if (this.m_state == 8 && this.m_objectType != 3) {
                if (this.getHealth() <= 0) {
                    boolean dying = this.isDying();
                    if (dying) {
                        long time = 1000L;
                        if (this.m_objectType == 4) {
                            time = 5000L;
                        }
                        if (Utility.GetTime() - this.m_flashTime > time) {
                            this.m_dying = false;
                            this.m_flashing = false;
                            this.setdead();
                            if (this.m_objectType == 0) {
                                this.weapondropfromroque();
                            } else if (this.m_objectType == 4) {
                                this.m_scene.createresultimg(true);
                                this.m_scene.setState(3);
                                this.m_scene.m_player.setPlayerState((byte)0);
                                return;
                            }
                            this.dropItem(this.m_scene.map);
                            boolean gotonext = this.m_scene.checkareaclear();
                            if (gotonext) {
                                this.gonext(this.m_scene.map);
                            }
                            return;
                        }
                    } else {
                        this.setDying();
                        if (this.m_objectType == 4) {
                            this.m_scene.missionclear = true;
                        }
                    }
                } else if (Utility.GetTime() - this.m_stateTime > 1500L) {
                    this.setEnemyState((byte)6);
                }
            } else if (this.m_state == 7 && this.m_objectType != 3) {
                int backspeedx = this.m_walkingSpeedX << 1;
                int backspeedy = this.m_walkingSpeedY << 1;
                this.loopAnimation();
                boolean canmove = this.moveTo(this.m_targetx, this.m_targety, backspeedx, backspeedy);
                if (canmove) {
                    if (this.moveToPoint(this.m_targetx, this.m_targety, backspeedx, backspeedy)) {
                        this.setEnemyState((byte)0);
                    }
                } else {
                    this.setEnemyState((byte)0);
                }
            } else if (this.m_state == 6 && this.m_objectType != 3) {
                if (this.loopcompleted()) {
                    this.setEnemyState((byte)0);
                    if (this.m_objectType == 4) {
                        this.startescape(map, px, py, facingx, facingy);
                    }
                }
            } else if (this.m_state == 6 && this.m_objectType == 3) {
                this.loopAnimation();
                if (player.canbeattack() && disty < this.m_keepfromplayery && MathTool.randRatio(30)) {
                    player.getdamage(10);
                    player.setPlayerState((byte)2);
                    player.updatedistx(-5);
                    player.m_hitted = true;
                }
                if (Utility.GetTime() - this.m_stateTime >= 800L) {
                    this.setEnemyState((byte)3);
                    this.m_kotime = 1000L;
                    this.m_gotoattack = false;
                }
            } else if (this.m_state == 4 && this.m_objectType != 3) {
                if (this.m_objectType == 4) {
                    this.jokerattack(map, player, curframe, facingx, disty);
                    if (this.loopcompleted()) {
                        ++this.m_curloop;
                        if (this.m_curloop >= this.m_attackloop) {
                            if (this.m_attacktype == 1) {
                                this.setEnemyState((byte)3);
                            } else {
                                this.setEnemyState((byte)0);
                            }
                            this.m_curloop = 0;
                            this.m_attackloop = 0;
                        } else {
                            this.getAniManager().set_indexAnimate(4);
                        }
                    }
                } else {
                    if (this.m_scene.getState() != 3 && !this.m_scene.missionclear) {
                        if (this.m_objectType == 0) {
                            this.attack(this.m_weapon, player, facingx, disty);
                        } else {
                            this.attack(this, player, facingx, disty);
                        }
                    }
                    if (this.m_objectType == 1) {
                        int[] speed = new int[]{8, 8, 8, 6, 4, 3, 2, 1, 0, 0};
                        this.moveAsAngle(this.m_attackangle, speed[curframe] << 1, speed[curframe]);
                    }
                    if (this.m_objectType == 0) {
                        if (Utility.GetTime() - this.m_stateTime > 700L && this.loopcompleted()) {
                            this.setEnemyState((byte)0);
                        }
                    } else if (this.m_objectType == 2) {
                        if (Utility.GetTime() - this.m_stateTime > 250L && this.loopcompleted()) {
                            this.setEnemyState((byte)0);
                        }
                    } else if (this.loopcompleted()) {
                        this.setEnemyState((byte)0);
                    }
                }
            } else if (this.m_state == 14) {
                long[] pertime = new long[]{500L, 600L};
                if (Utility.GetTime() - this.m_stateTime > pertime[this.NowFrame()]) {
                    this.m_stateTime = Utility.GetTime();
                    if (this.loopcompleted()) {
                        this.setEnemyState((byte)4);
                    }
                }
            } else if (this.m_state == 3 && this.m_objectType == 1) {
                this.setFacingTo(player);
                if (Utility.GetTime() - this.m_stateTime > 2000L) {
                    this.setEnemyState((byte)0);
                }
            } else if (this.m_state == 3 && this.m_objectType == 3) {
                this.loopAnimation();
                if (Utility.GetTime() - this.m_stateTime > this.m_kotime) {
                    if (this.m_gotoattack) {
                        this.setEnemyState((byte)5);
                    } else {
                        this.setEnemyState((byte)0);
                        this.m_attackloop = 0;
                    }
                }
            } else if (this.m_state == 3 && this.m_objectType == 2) {
                this.attack(this, player, facingx, disty);
                if (Utility.GetTime() - this.m_stateTime > 500L && this.loopcompleted()) {
                    this.setEnemyState((byte)0);
                }
            } else if (this.m_state == 13) {
                this.loopAnimation();
                if (!this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                    this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY);
                }
            } else {
                if (this.m_scene.getState() == 3 || this.m_scene.missionclear) {
                    this.startmoveout(px, py, facingx);
                    return;
                }
                if (this.getObjectType() != 3) {
                    this.setFacingTo(player);
                }
                if (this.getObjectType() == 1) {
                    this.updatefatmans(map, px, py, dist, distx, disty, facingx, facingy);
                } else if (this.getObjectType() == 0) {
                    if (this.getroguetype() == 0) {
                        this.updaterogues_logy(map, px, py, dist, distx, disty, facingx, facingy);
                    } else if (this.getroguetype() == 1) {
                        this.updaterogues_normal(map, px, py, dist, distx, disty, facingx, facingy);
                    } else if (this.getroguetype() == 2) {
                        this.updaterogues_cross(map, px, py, dist, distx, disty, facingx, facingy);
                    } else if (this.getroguetype() == 3) {
                        this.updaterogues_crazy(map, px, py, dist, distx, disty, facingx, facingy);
                    }
                } else if (this.getObjectType() == 4) {
                    this.updatejokerboss(player, map, px, py, dist, distx, disty, facingx, facingy);
                } else if (this.getObjectType() == 2) {
                    this.updatebitchs(map, px, py, dist, distx, disty, facingx, facingy);
                } else if (this.getObjectType() == 3) {
                    this.updatemotoman(player, map, px, py, disty, facingx, viewleft, viewright);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void render(Graphics g) {
        try {
            if (this.m_dead) {
                return;
            }
            Map map = this.m_scene.getMap();
            int _x = map.getViewportX() + this.getX() - map.getCameraX() + this.distX;
            int _y = map.getViewportY() + this.getY() - map.getCameraY() + this.distY;
            AniManager ani_hero = this.getAniManager();
            this.m_flashTimer = this.m_flashing ? (byte)(this.m_flashTimer ^ 1) : (byte)0;
            if (this.m_flashTimer == 0) {
                if (!this.m_gotoplayer || this.m_objectType != 3) {
                    if (this.m_objectType == 3 && this.m_state == 15) {
                        ani_hero.draw(g, _x, _y);
                    } else {
                        int shadowx = _x - this.distX;
                        int shadowy = _y - this.distY;
                        g.drawImage(this.m_scene.img_largeshadow, shadowx, shadowy, 3);
                        ani_hero.draw(g, _x, _y);
                    }
                }
                if (this.getObjectType() == 0) {
                    AniManager ani_weapon = this.m_weapon.getAniManager();
                    this.m_weapon.setPositionX(this.getX());
                    this.m_weapon.setPositionY(this.getY());
                    ani_weapon.setfacingx(ani_hero.getfacingx());
                    ani_weapon.setFrame(this.m_state, ani_hero.getNowFrame());
                    this.m_weapon.renderweaponwithmother(g, _x, _y);
                }
                if (this.m_state == 2 || this.m_state == 5) {
                    int barw = ani_hero.getFrameWidth();
                    int barx = _x - (barw >> 1);
                    int bary = _y - ani_hero.getFrameHeight() - 5;
                    int barh = 5;
                    g.setColor(0x4F4F4F);
                    g.fillRect(barx, bary, barw, barh);
                    int fillw = this.m_health * (barw - 2) / this.m_maxHealth;
                    if (this.m_health > 0 && fillw == 0) {
                        fillw = 1;
                    }
                    g.setColor(0xF8F800);
                    g.fillRect(barx + 1, bary + 1, fillw, barh - 2);
                }
            }
            if (this.m_objectType == 3 && this.m_state == 15) {
                int _bx = map.getViewportX() + this.x_am_bomb - map.getCameraX();
                int _by = map.getViewportY() + this.y_am_bomb - map.getCameraY();
                this.am_bomb.draw(g, _bx, _by);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Enemy render error :  index == " + this.getFlag() + " type == " + this.getObjectType() + "   " + ex.toString());
        }
    }

    protected void startgotoAttack(Map map, int disty, int px, int py, boolean facingx, boolean facingy) {
        int rand = 0;
        this.m_targetx = facingx ? px + this.m_keepfromplayerx : px - this.m_keepfromplayerx;
        rand = MathTool.getRandom(-15, 15);
        this.m_targetx += rand;
        if (map.x_outview(this.m_targetx)) {
            if (this.m_objectType == 4) {
                this.m_targetx = facingx ? px - this.m_keepfromplayerx : px + this.m_keepfromplayerx;
            } else {
                this.startcross(map, disty, px, py, facingx, facingy);
            }
            return;
        }
        this.m_targety = py;
        rand = MathTool.getRandom(-10, 10);
        this.m_targety += rand;
        this.m_targetx = map.x_rangeinmap(this.m_targetx);
        this.m_targety = map.y_rangeinmap(this.m_targety);
        this.setEnemyState((byte)1);
        this.m_gotoattack = true;
    }

    protected void startcross(Map map, int disty, int px, int py, boolean facingx, boolean facingy) {
        int rand = 0;
        this.m_targetx = facingx ? px - this.m_keepfromplayerx - 20 : px + this.m_keepfromplayerx + 20;
        rand = MathTool.getRandom(-15, 15);
        this.m_targetx += rand;
        if (map.x_outview(this.m_targetx)) {
            this.startgotoAttack(map, disty, px, py, facingx, facingy);
            return;
        }
        this.m_crossy = disty > this.m_keepfromplayery ? this.getY() : (facingy ? py + this.m_keepfromplayery + 10 : py - this.m_keepfromplayery - 10);
        this.m_crossy = map.y_rangeinmap(this.m_crossy);
        this.m_targety = py;
        rand = MathTool.getRandom(-10, 10);
        this.m_targety += rand;
        this.m_targety = map.y_rangeinmap(this.m_targety);
        this.crossStep = 0;
        this.setEnemyState((byte)1);
        this.m_cross = true;
    }

    protected void startmoveout(int px, int py, boolean facingx) {
        this.m_targetx = facingx ? px + 240 : px - 240;
        this.getAniManager().setfacingx(!facingx);
        this.m_targety = py;
        this.setEnemyState((byte)13);
    }

    protected void startgotoplayer(Map map, int px, int py, boolean facingx, boolean facingy) {
        int rand = 0;
        this.m_targetx = facingx ? px + this.m_keepfromplayerx : px - this.m_keepfromplayerx;
        rand = MathTool.getRandom(-15, 15);
        this.m_targetx += rand;
        this.m_targety = facingy ? py + this.m_keepfromplayery + 20 : py - this.m_keepfromplayery - 20;
        rand = MathTool.getRandom(-10, 10);
        this.m_targety += rand;
        this.m_targetx = map.x_rangeinmap(this.m_targetx);
        this.m_targety = map.y_rangeinmap(this.m_targety);
        this.setEnemyState((byte)1);
        this.m_gotoplayer = true;
    }

    protected void startescape(Map map, int px, int py, boolean facingx, boolean facingy) {
        if (this.m_state == 7 && this.m_objectType != 3) {
            return;
        }
        this.m_targetx = facingx ? (map.closetomoveright(this.getX()) ? px - this.m_keepfromplayerx - 20 : px + this.m_keepfromplayerx + 20) : (map.closetomoveleft(this.getX()) ? px + this.m_keepfromplayerx + 20 : px - this.m_keepfromplayerx - 20);
        this.m_targety = facingy ? py + this.m_keepfromplayery + 20 : py - this.m_keepfromplayery - 20;
        this.m_targetx = map.x_rangeinmap(this.m_targetx);
        this.m_targety = map.y_rangeinmap(this.m_targety);
        this.setEnemyState((byte)7);
    }

    protected void startupdown(boolean facingy) {
        this.setEnemyState((byte)1);
        this.m_walkingupdown = true;
        if (facingy) {
            this.setFacing((byte)0);
        } else {
            this.setFacing((byte)1);
        }
    }

    protected void updaterogues_cross(Map map, int px, int py, int dist, int distx, int disty, boolean facingx, boolean facingy) {
        try {
            int rand = 0;
            int keepdist = 100;
            if (this.fittoattack(distx, disty) && (this.m_state == 0 || this.m_state == 1) && MathTool.randRatio(40)) {
                this.setEnemyState((byte)4);
                return;
            }
            if (this.m_state == 0) {
                this.loopAnimation();
                if (this.getX() < map.moveleft || this.getX() > map.moveright) {
                    this.startgotoplayer(map, px, py, facingx, facingy);
                    return;
                }
                if (this.fittoescape(distx, disty)) {
                    if (MathTool.randRatio(70)) {
                        this.startescape(map, px, py, facingx, facingy);
                        return;
                    }
                } else if (dist > 100) {
                    this.startgotoplayer(map, px, py, facingx, facingy);
                } else {
                    rand = MathTool.getRandom(100);
                    if (rand <= 5) {
                        this.startgotoAttack(map, disty, px, py, facingx, facingy);
                    } else if (rand <= 20) {
                        this.startcross(map, disty, px, py, facingx, facingy);
                    }
                    if (Utility.GetTime() - this.m_stateTime > (long)this.getRogurStandTime()) {
                        rand = MathTool.getRandom(100);
                        if (rand <= 15) {
                            this.startgotoAttack(map, disty, px, py, facingx, facingy);
                        } else if (rand <= 70) {
                            this.startcross(map, disty, px, py, facingx, facingy);
                        } else {
                            this.m_stateTime = Utility.GetTime();
                        }
                    }
                }
            } else if (this.m_state == 1) {
                this.loopAnimation();
                if (this.m_cross) {
                    if (this.CrossToTarget()) {
                        if (this.fittoattack(distx, disty)) {
                            this.setEnemyState((byte)4);
                        } else {
                            this.setEnemyState((byte)0);
                        }
                        this.m_cross = false;
                    }
                } else {
                    int speedx = 0;
                    int speedy = 0;
                    if (this.m_gotoattack) {
                        speedx = this.m_walkingSpeedX << 1;
                        speedy = this.m_walkingSpeedY << 1;
                    } else {
                        speedx = this.m_walkingSpeedX;
                        speedy = this.m_walkingSpeedY;
                    }
                    boolean canmove = this.moveTo(this.m_targetx, this.m_targety, speedx, speedy);
                    if (canmove) {
                        if (this.moveToPoint(this.m_targetx, this.m_targety, speedx, speedy)) {
                            if (this.m_gotoattack) {
                                if (this.fittoattack(distx, disty)) {
                                    this.setEnemyState((byte)4);
                                } else {
                                    this.setEnemyState((byte)0);
                                }
                                this.m_gotoattack = false;
                            } else if (this.m_gotoplayer) {
                                this.setEnemyState((byte)0);
                                this.m_gotoplayer = false;
                            }
                        }
                    } else {
                        this.setEnemyState((byte)0);
                        if (this.m_gotoattack) {
                            this.m_gotoattack = false;
                        } else if (this.m_gotoplayer) {
                            this.m_gotoplayer = false;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void updaterogues_crazy(Map map, int px, int py, int dist, int distx, int disty, boolean facingx, boolean facingy) {
        try {
            ++this.m_stateTime;
            int rand = 0;
            int keepdist = 100;
            if (this.fittoattack(distx, disty) && (this.m_state == 0 || this.m_state == 1) && MathTool.randRatio(90)) {
                this.setEnemyState((byte)4);
                return;
            }
            if (this.m_state == 0) {
                this.loopAnimation();
                if (this.getX() < map.moveleft || this.getX() > map.moveright) {
                    this.startgotoplayer(map, px, py, facingx, facingy);
                    return;
                }
                if (this.fittoescape(distx, disty)) {
                    if (MathTool.randRatio(10)) {
                        this.startescape(map, px, py, facingx, facingy);
                        return;
                    }
                } else if (dist > 100) {
                    this.startgotoplayer(map, px, py, facingx, facingy);
                } else if (Utility.GetTime() - this.m_stateTime > 300L) {
                    rand = MathTool.getRandom(100);
                    if (rand <= 50) {
                        this.startgotoAttack(map, disty, px, py, facingx, facingy);
                    } else if (rand <= 80) {
                        this.startcross(map, disty, px, py, facingx, facingy);
                    } else {
                        this.m_stateTime = Utility.GetTime();
                    }
                }
            } else if (this.m_state == 1) {
                this.loopAnimation();
                if (this.m_cross) {
                    if (this.CrossToTarget()) {
                        if (this.fittoattack(distx, disty)) {
                            this.setEnemyState((byte)4);
                        } else {
                            this.setEnemyState((byte)0);
                        }
                        this.m_cross = false;
                    }
                } else {
                    boolean canmove = this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY);
                    if (canmove) {
                        if (this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                            if (this.m_gotoattack) {
                                if (this.fittoattack(distx, disty)) {
                                    this.setEnemyState((byte)4);
                                } else {
                                    this.setEnemyState((byte)0);
                                }
                                this.m_gotoattack = false;
                            } else if (this.m_gotoplayer) {
                                this.setEnemyState((byte)0);
                                this.m_gotoplayer = false;
                            }
                        }
                    } else {
                        this.setEnemyState((byte)0);
                        if (this.m_gotoattack) {
                            this.m_gotoattack = false;
                        } else if (this.m_gotoplayer) {
                            this.m_gotoplayer = false;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void updaterogues_normal(Map map, int px, int py, int dist, int distx, int disty, boolean facingx, boolean facingy) {
        try {
            int rand = 0;
            int keepdist = 100;
            if (this.fittoattack(distx, disty) && (this.m_state == 0 || this.m_state == 1) && MathTool.randRatio(5)) {
                this.setEnemyState((byte)4);
                return;
            }
            if (this.m_state == 0) {
                this.loopAnimation();
                if (this.fittoescape(distx, disty) && MathTool.randRatio(this.getRogueEscapeRate())) {
                    this.startescape(map, px, py, facingx, facingy);
                    return;
                }
                if (this.getX() < map.moveleft || this.getX() > map.moveright) {
                    this.startgotoplayer(map, px, py, facingx, facingy);
                    return;
                }
                if (dist > 100) {
                    rand = MathTool.getRandom(100);
                    if (rand <= 5) {
                        this.startupdown(facingy);
                    } else if (rand <= 20) {
                        this.startgotoplayer(map, px, py, facingx, facingy);
                    } else if (rand <= 25) {
                        this.startcross(map, disty, px, py, facingx, facingy);
                    }
                } else {
                    if (MathTool.randRatio(3)) {
                        this.startescape(map, px, py, facingx, facingy);
                        return;
                    }
                    if (Utility.GetTime() - this.m_stateTime > (long)this.getRogurStandTime()) {
                        rand = MathTool.getRandom(100);
                        int crossrate = this.getRogueCrossRate();
                        int toaprate = this.getRogueToAppRate();
                        if (rand <= toaprate) {
                            this.startgotoAttack(map, disty, px, py, facingx, facingy);
                        } else if (rand <= crossrate + toaprate) {
                            this.startcross(map, disty, px, py, facingx, facingy);
                        } else {
                            this.m_stateTime = Utility.GetTime();
                        }
                    }
                }
            } else if (this.m_state == 1) {
                this.loopAnimation();
                if (this.m_cross) {
                    if (this.CrossToTarget()) {
                        if (this.fittoattack(distx, disty)) {
                            this.setEnemyState((byte)4);
                        } else {
                            this.setEnemyState((byte)0);
                        }
                        this.m_cross = false;
                    }
                } else if (this.m_walkingupdown) {
                    this.m_targetx = this.getX();
                    this.m_targety = py;
                    boolean canmove = this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY);
                    if (canmove) {
                        if (this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                            rand = MathTool.getRandom(100);
                            if (rand <= 3) {
                                this.startgotoAttack(map, disty, px, py, facingx, facingy);
                            }
                            if (rand <= 6) {
                                this.startcross(map, disty, px, py, facingx, facingy);
                            } else {
                                this.setEnemyState((byte)0);
                            }
                            this.m_walkingupdown = false;
                        }
                    } else {
                        this.setEnemyState((byte)0);
                        if (this.m_walkingupdown) {
                            this.m_walkingupdown = false;
                        }
                    }
                } else {
                    boolean canmove = this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY);
                    if (canmove) {
                        if (this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                            if (this.m_gotoattack) {
                                if (this.fittoattack(distx, disty)) {
                                    this.setEnemyState((byte)4);
                                } else {
                                    this.setEnemyState((byte)0);
                                }
                                this.m_gotoattack = false;
                            } else if (this.m_gotoplayer) {
                                this.setEnemyState((byte)0);
                                this.m_gotoplayer = false;
                            }
                        }
                    } else {
                        this.setEnemyState((byte)0);
                        if (this.m_gotoattack) {
                            this.m_gotoattack = false;
                        } else if (this.m_gotoplayer) {
                            this.m_gotoplayer = false;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void updaterogues_logy(Map map, int px, int py, int dist, int distx, int disty, boolean facingx, boolean facingy) {
        try {
            int rand = 0;
            int keepdist = 100;
            if (this.fittoattack(distx, disty) && (this.m_state == 0 || this.m_state == 1) && MathTool.randRatio(2)) {
                this.setEnemyState((byte)4);
                return;
            }
            if (this.m_state == 0) {
                this.loopAnimation();
                if (this.fittoescape(distx, disty) && MathTool.randRatio(this.getRogueEscapeRate())) {
                    this.startescape(map, px, py, facingx, facingy);
                    return;
                }
                if (this.getX() < map.moveleft || this.getX() > map.moveright) {
                    this.startgotoplayer(map, px, py, facingx, facingy);
                    return;
                }
                if (dist > 100) {
                    rand = MathTool.getRandom(100);
                    if (rand <= 20) {
                        this.startgotoplayer(map, px, py, facingx, facingy);
                    } else if (rand <= 40) {
                        this.startupdown(facingy);
                    }
                } else {
                    if (MathTool.randRatio(3)) {
                        this.startescape(map, px, py, facingx, facingy);
                        return;
                    }
                    if (Utility.GetTime() - this.m_stateTime > (long)this.getRogurStandTime()) {
                        int toaprate;
                        rand = MathTool.getRandom(100);
                        if (rand <= (toaprate = this.getRogueToAppRate())) {
                            this.startgotoAttack(map, disty, px, py, facingx, facingy);
                        } else {
                            this.m_stateTime = Utility.GetTime();
                        }
                    }
                }
            } else if (this.m_state == 1) {
                this.loopAnimation();
                if (this.m_walkingupdown) {
                    this.m_targetx = this.getX();
                    this.m_targety = py;
                    boolean canmove = this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY);
                    if (canmove) {
                        if (this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                            rand = MathTool.getRandom(100);
                            if (rand <= 3) {
                                this.startgotoAttack(map, disty, px, py, facingx, facingy);
                            }
                            this.setEnemyState((byte)0);
                            this.m_walkingupdown = false;
                        }
                    } else {
                        this.setEnemyState((byte)0);
                        if (this.m_walkingupdown) {
                            this.m_walkingupdown = false;
                        }
                    }
                } else {
                    boolean canmove = this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY);
                    if (canmove) {
                        if (this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                            if (this.m_gotoattack) {
                                if (this.fittoattack(distx, disty)) {
                                    this.setEnemyState((byte)4);
                                } else {
                                    this.setEnemyState((byte)0);
                                }
                                this.m_gotoattack = false;
                            } else if (this.m_gotoplayer) {
                                this.setEnemyState((byte)0);
                                this.m_gotoplayer = false;
                            }
                        }
                    } else {
                        this.setEnemyState((byte)0);
                        if (this.m_gotoattack) {
                            this.m_gotoattack = false;
                        } else if (this.m_gotoplayer) {
                            this.m_gotoplayer = false;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void updatefatmans(Map map, int px, int py, int dist, int distx, int disty, boolean facingx, boolean facingy) {
        int rand = 0;
        int keepdist = 120;
        if (dist <= 120) {
            if (distx >= 50) {
                if ((this.m_state == 0 || this.m_state == 1) && MathTool.randRatio(7)) {
                    this.setEnemyState((byte)14);
                    this.m_attackangle = MathTool.getAngle(this.m_positionX, this.m_positionY, px, py);
                    return;
                }
            } else if (MathTool.randRatio(20)) {
                this.startescape(map, px, py, facingx, facingy);
            }
        }
        if (this.m_state == 0) {
            this.loopAnimation();
            if (this.getX() < map.moveleft || this.getX() > map.moveright) {
                this.startgotoplayer(map, px, py, facingx, facingy);
                return;
            }
            if (this.fittoescape(distx, disty)) {
                if (MathTool.randRatio(20)) {
                    this.startescape(map, px, py, facingx, facingy);
                    return;
                }
            } else if (dist >= 120) {
                this.startgotoplayer(map, px, py, facingx, facingy);
            } else if (Utility.GetTime() - this.m_stateTime >= 1500L) {
                rand = MathTool.getRandom(100);
                if (rand <= 15) {
                    this.startgotoAttack(map, disty, px, py, facingx, facingy);
                } else if (rand <= 60) {
                    this.startcross(map, disty, px, py, facingx, facingy);
                } else {
                    this.m_stateTime = Utility.GetTime();
                }
            } else if (MathTool.randRatio(20)) {
                this.startcross(map, disty, px, py, facingx, facingy);
            }
        } else if (this.m_state == 1) {
            this.loopAnimation();
            if (this.fittoescape(distx, disty) && MathTool.randRatio(5)) {
                this.startescape(map, px, py, facingx, facingy);
                return;
            }
            if (this.m_cross) {
                if (this.CrossToTarget()) {
                    if (dist <= 120 && distx >= 50 && MathTool.randRatio(30)) {
                        this.m_attackangle = MathTool.getAngle(this.m_positionX, this.m_positionY, px, py);
                        this.setEnemyState((byte)14);
                    } else {
                        this.setEnemyState((byte)0);
                    }
                    this.m_cross = false;
                }
            } else {
                boolean canmove = this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY);
                if (canmove) {
                    if (this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                        if (this.m_gotoattack) {
                            if (dist <= 120 && distx >= 50 && MathTool.randRatio(30)) {
                                this.setEnemyState((byte)14);
                                this.m_attackangle = MathTool.getAngle(this.m_positionX, this.m_positionY, px, py);
                            } else {
                                this.setEnemyState((byte)0);
                            }
                            this.m_gotoattack = false;
                        } else if (this.m_gotoplayer) {
                            this.setEnemyState((byte)0);
                            this.m_gotoplayer = false;
                        }
                    }
                } else {
                    this.setEnemyState((byte)0);
                    if (this.m_gotoattack) {
                        this.m_gotoattack = false;
                    } else if (this.m_gotoplayer) {
                        this.m_gotoplayer = false;
                    }
                }
            }
        }
    }

    protected void updatebitchs(Map map, int px, int py, int dist, int distx, int disty, boolean facingx, boolean facingy) {
        boolean fitescape;
        int rand = 0;
        int keepdist = 120;
        boolean fitattack = distx >= 30 && distx <= 120 && disty <= 20;
        boolean bl = fitescape = distx <= 50 && disty <= 15;
        if (fitattack && MathTool.randRatio(10)) {
            this.bitchattack();
            return;
        }
        if (this.m_state == 0) {
            this.loopAnimation();
            if (this.getX() < map.moveleft || this.getX() > map.moveright) {
                this.startgotoplayer(map, px, py, facingx, facingy);
                return;
            }
            if (fitescape) {
                if (MathTool.randRatio(70)) {
                    this.startescape(map, px, py, facingx, facingy);
                    return;
                }
            } else if (distx >= 160) {
                this.startgotoplayer(map, px, py, facingx, facingy);
            } else if (distx >= 120) {
                if (MathTool.randRatio(12)) {
                    this.startupdown(facingy);
                }
            } else if (Utility.GetTime() - this.m_stateTime >= 1500L) {
                rand = MathTool.getRandom(100);
                if (rand <= 5) {
                    this.setEnemyState((byte)4);
                } else if (rand <= 15) {
                    this.startgotoAttack(map, disty, px, py, facingx, facingy);
                } else if (rand <= 20) {
                    this.startescape(map, px, py, facingx, facingy);
                } else {
                    this.m_stateTime = Utility.GetTime();
                }
            }
        } else if (this.m_state == 1) {
            this.loopAnimation();
            if (fitescape && MathTool.randRatio(40)) {
                this.startescape(map, px, py, facingx, facingy);
                return;
            }
            if (this.m_walkingupdown) {
                this.m_targetx = this.getX();
                this.m_targety = py;
                boolean canmove = this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY);
                if (canmove) {
                    if (this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                        rand = MathTool.getRandom(100);
                        if (rand <= 30) {
                            this.startgotoAttack(map, disty, px, py, facingx, facingy);
                        } else {
                            this.setEnemyState((byte)0);
                        }
                        this.m_walkingupdown = false;
                    }
                } else {
                    this.setEnemyState((byte)0);
                    if (this.m_walkingupdown) {
                        this.m_walkingupdown = false;
                    }
                }
            } else {
                boolean canmove = this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY);
                if (canmove) {
                    if (this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                        if (this.m_gotoattack) {
                            if (fitattack && MathTool.randRatio(80)) {
                                this.bitchattack();
                            } else if (fitescape) {
                                if (MathTool.randRatio(40)) {
                                    this.startescape(map, px, py, facingx, facingy);
                                    return;
                                }
                            } else {
                                this.setEnemyState((byte)0);
                            }
                            this.m_gotoattack = false;
                        } else if (this.m_gotoplayer) {
                            this.setEnemyState((byte)0);
                            this.m_gotoplayer = false;
                        }
                    }
                } else {
                    this.setEnemyState((byte)0);
                    if (this.m_gotoattack) {
                        this.m_gotoattack = false;
                    } else if (this.m_gotoplayer) {
                        this.m_gotoplayer = false;
                    }
                }
            }
        }
    }

    protected void updatemotoman(Controllable player, Map map, int px, int py, int disty, boolean facingx, int viewleft, int viewright) {
        int speedx = this.m_walkingSpeedX << 2;
        int speedy = this.m_walkingSpeedY << 1;
        if (this.m_state == 0) {
            this.loopAnimation();
            if (this.m_attackloop < 3) {
                this.aimplayer_motoman(map, py);
                ++this.m_attackloop;
            } else {
                this.setEnemyState((byte)3);
                this.m_kotime = 2000L;
                this.m_gotoattack = true;
            }
        } else if (this.m_state == 1 || this.m_state == 4) {
            this.loopAnimation();
            if (this.m_gotoplayer) {
                if (Utility.GetTime() - this.mototime >= 3000L) {
                    this.m_gotoplayer = false;
                    if (this.m_targetx > viewright) {
                        this.setPositionX(viewright);
                    }
                    if (this.m_targetx < viewleft) {
                        this.setPositionX(viewleft);
                    }
                    if (this.m_attackloop >= 3) {
                        this.setPositionY(py);
                    } else {
                        int inity = MathTool.getRandom(map.moveup, map.movedown);
                        this.setPositionY(inity);
                    }
                    this.setFacingTo(player);
                    this.setEnemyState((byte)0);
                }
            } else {
                this.attack(this, player, facingx, disty);
                this.moveTo(this.m_targetx, this.m_targety, speedx, speedy);
                if (this.moveToPoint(this.m_targetx, this.m_targety, speedx, speedy)) {
                    this.startwaitingformoto();
                }
            }
        }
    }

    protected void startwaitingformoto() {
        this.mototime = Utility.GetTime();
        this.m_gotoplayer = true;
    }

    protected void updatejokerboss(Controllable player, Map map, int px, int py, int dist, int distx, int disty, boolean facingx, boolean facingy) {
        int keepdist = 100;
        if (this.fittoattack(distx, disty)) {
            if (MathTool.randRatio(20)) {
                this.jokerstartattack(0);
                return;
            }
            if (MathTool.randRatio(8)) {
                this.startescape(map, px, py, facingx, facingy);
                return;
            }
        }
        if (this.m_state == 0) {
            this.loopAnimation();
            if (this.getX() < map.moveleft || this.getX() > map.moveright) {
                this.startgotoAttack(map, disty, px, py, facingx, facingy);
                return;
            }
            if (this.fittoescape(distx, disty)) {
                if (MathTool.randRatio(15)) {
                    this.startescape(map, px, py, facingx, facingy);
                    return;
                }
            } else {
                if (dist > 100) {
                    if (MathTool.randRatio(20)) {
                        this.startupdown(facingy);
                        return;
                    }
                } else if (MathTool.randRatio(10)) {
                    this.startupdown(facingy);
                    return;
                }
                if (MathTool.randRatio(10)) {
                    this.startgotoAttack(map, disty, px, py, facingx, facingy);
                } else {
                    if (MathTool.randRatio(6)) {
                        this.startescape(map, px, py, facingx, facingy);
                        return;
                    }
                    if (MathTool.randRatio(10)) {
                        this.jokerstartattack(2);
                        this.m_walkingupdown = false;
                    } else if (MathTool.randRatio(10)) {
                        this.jokerstartattack(1);
                        this.m_walkingupdown = false;
                    } else if (MathTool.randRatio(6)) {
                        this.jokerstartattack(4);
                        this.m_walkingupdown = false;
                    }
                }
                if (MathTool.randRatio(20)) {
                    byte next = (byte)MathTool.getRandom(9, 11);
                    this.setEnemyState(next);
                    return;
                }
                if (MathTool.randRatio(20)) {
                    this.startgotoAttack(map, disty, px, py, facingx, facingy);
                }
            }
        } else if (this.m_state == 1) {
            this.loopAnimation();
            if (this.fittoescape(distx, disty) && MathTool.randRatio(4)) {
                this.startescape(map, px, py, facingx, facingy);
                return;
            }
            if (this.m_walkingupdown) {
                if (this.getFacing() == 0) {
                    if (this.m_positionY > map.moveup) {
                        this.m_positionY -= this.m_walkingSpeedY;
                    } else {
                        this.setFacing((byte)1);
                    }
                } else if (this.getFacing() == 1) {
                    if (this.m_positionY < map.movedown) {
                        this.m_positionY += this.m_walkingSpeedY;
                    } else {
                        this.setFacing((byte)0);
                    }
                }
                if (MathTool.randRatio(10)) {
                    this.startgotoAttack(map, disty, px, py, facingx, facingy);
                    this.m_walkingupdown = false;
                } else if (disty < 5) {
                    if (MathTool.randRatio(20)) {
                        this.jokerstartattack(3);
                        this.m_walkingupdown = false;
                    }
                } else if (MathTool.randRatio(10)) {
                    this.jokerstartattack(2);
                    this.m_walkingupdown = false;
                } else if (MathTool.randRatio(10)) {
                    this.jokerstartattack(4);
                    this.m_walkingupdown = false;
                }
            } else if (this.m_gotoattack) {
                boolean canmove = this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX << 1, this.m_walkingSpeedY << 1);
                if (canmove) {
                    if (this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX << 1, this.m_walkingSpeedY << 1) && this.m_gotoattack) {
                        if (this.fittoattack(distx, disty)) {
                            this.jokerstartattack(0);
                            this.m_attackangle = MathTool.getAngle(this.m_positionX, this.m_positionY, player.getX(), player.getY());
                        } else {
                            this.setEnemyState((byte)0);
                        }
                        this.m_gotoattack = false;
                    }
                } else {
                    this.setEnemyState((byte)0);
                    if (this.m_gotoattack) {
                        this.m_gotoattack = false;
                    }
                }
            }
        }
    }

    protected void jokerstartattack(int _type) {
        MainCanvas cfr_ignored_0 = this.m_scene.m_canvas;
        if (MainCanvas.missionid == 0 && (_type == 1 || _type == 2)) {
            return;
        }
        this.m_attacktype = _type;
        this.m_attackloop = this.m_attacktype == 2 ? MathTool.getRandom(2, 5) : 1;
        this.setEnemyState((byte)4);
    }

    public void bitchattack() {
        int rand = MathTool.getRandom(100);
        if (rand <= 80) {
            this.setEnemyState((byte)4);
        } else {
            this.setEnemyState((byte)3);
        }
    }

    protected void jokerattack(Map map, Controllable player, int nowframe, boolean facing, int disty) {
        AniManager ani_man = this.getAniManager();
        int framenum = ani_man.getFrameNum();
        int rand = 0;
        switch (this.m_attacktype) {
            case 0: {
                this.attack(this, player, facing, disty);
                break;
            }
            case 1: {
                if (nowframe != framenum - 2) break;
                rand = MathTool.getRandom(2, 5);
                int i = 0;
                boolean angleav = false;
                Bombs temp_bomb = null;
                if (this.getY() > map.moveup + 20 && this.getY() < map.movedown - 20) {
                    angleav = true;
                }
                for (i = 0; i < rand; ++i) {
                    temp_bomb = angleav ? new Bombs(this.m_scene, this.m_scene.ani_grenade, this.getX(), this.getY(), 1, facing) : new Bombs(this.m_scene, this.m_scene.ani_grenade, this.getX(), this.getY(), 5, facing);
                    this.m_scene.settolist(temp_bomb);
                }
                break;
            }
            case 2: {
                if (nowframe != framenum - 2) break;
                boolean angleav = false;
                Bombs temp_bomb = null;
                if (this.getY() > map.moveup + 20 && this.getY() < map.movedown - 20) {
                    angleav = true;
                }
                temp_bomb = angleav ? new Bombs(this.m_scene, this.m_scene.ani_grenade, this.getX(), this.getY(), 1, facing) : new Bombs(this.m_scene, this.m_scene.ani_grenade, this.getX(), this.getY(), 5, facing);
                this.m_scene.settolist(temp_bomb);
                break;
            }
            case 3: {
                if (nowframe != framenum - 2) break;
                Bombs temp_bomb = new Bombs(this.m_scene, this.m_scene.ani_grenade, this.getX(), this.getY(), 3, facing);
                this.m_scene.settolist(temp_bomb);
                break;
            }
            case 4: {
                if (nowframe != framenum - 2) break;
                Bombs temp_bomb = new Bombs(this.m_scene, this.m_scene.ani_grenade, this.getX(), this.getY(), 4, facing);
                this.m_scene.settolist(temp_bomb);
            }
        }
    }

    protected boolean fatmandefend() {
        if (this.m_objectType == 1) {
            if (this.m_state == 0 || this.m_state == 1) {
                if (MathTool.randRatio(30)) {
                    this.setEnemyState((byte)3);
                    return true;
                }
            } else if (this.m_state == 3) {
                return true;
            }
        }
        return false;
    }

    protected boolean CrossToTarget() {
        boolean go = false;
        switch (this.crossStep) {
            case 0: {
                if (this.moveToPoint(this.m_positionX, this.m_crossy, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                    ++this.crossStep;
                } else {
                    go = this.moveTo(this.m_positionX, this.m_crossy, this.m_walkingSpeedX, this.m_walkingSpeedY);
                }
                return false;
            }
            case 1: {
                if (this.moveToPoint(this.m_targetx, this.m_crossy, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                    ++this.crossStep;
                } else {
                    go = this.moveTo(this.m_targetx, this.m_crossy, this.m_walkingSpeedX, this.m_walkingSpeedY);
                }
                return false;
            }
            case 2: {
                if (this.moveToPoint(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY)) {
                    ++this.crossStep;
                } else {
                    go = this.moveTo(this.m_targetx, this.m_targety, this.m_walkingSpeedX, this.m_walkingSpeedY);
                }
                return false;
            }
            case 3: {
                return true;
            }
        }
        if (!go) {
            this.setEnemyState((byte)0);
            this.m_cross = false;
        }
        return false;
    }

    protected void setEnemyState(byte _state) {
        try {
            if (this.m_state == _state && this.m_state != 2 && this.m_state != 3) {
                return;
            }
            if (_state == 2 || _state == 5 && this.m_objectType != 3) {
                this.needupdate = true;
            }
            if (this.m_state != 2 && _state == 2) {
                this.m_laststate = this.m_state;
            }
            super.setObjectState(_state);
            if (this.m_state == 13) {
                this.getAniManager().set_indexAnimate(1);
            } else if (this.m_state == 14) {
                this.getAniManager().set_indexAnimate(9);
            } else if (this.m_state == 15) {
                this.getAniManager().set_indexAnimate(2);
            } else {
                this.getAniManager().set_indexAnimate(_state);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void setroguetype(byte type) {
        if (this.getObjectType() == 0) {
            this.m_roguetype = type;
        }
    }

    protected byte getroguetype() {
        if (this.getObjectType() == 0) {
            return this.m_roguetype;
        }
        return -1;
    }

    protected int getRogueToAppRate() {
        switch (this.m_roguetype) {
            case 0: {
                return 5;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 80;
            }
        }
        return 50;
    }

    protected int getRogueCrossRate() {
        switch (this.m_roguetype) {
            case 0: {
                return 2;
            }
            case 1: {
                return 30;
            }
            case 2: {
                return 60;
            }
            case 3: {
                return 10;
            }
        }
        return 50;
    }

    protected int getRogurStandTime() {
        switch (this.m_roguetype) {
            case 0: {
                return 5000;
            }
            case 1: {
                return 5000;
            }
            case 2: {
                return 5000;
            }
            case 3: {
                return 1000;
            }
        }
        return 5000;
    }

    protected int getRogueEscapeRate() {
        switch (this.m_roguetype) {
            case 0: {
                return 10;
            }
            case 1: {
                return 20;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 10;
            }
        }
        return 10;
    }

    protected boolean fittoattack(int _distx, int _disty) {
        int halfx = this.m_keepfromplayerx >> 1;
        return _distx >= halfx && _distx <= this.m_keepfromplayerx + halfx && _disty <= 10;
    }

    protected boolean fittoescape(int _distx, int _disty) {
        int halfx = this.m_keepfromplayerx >> 1;
        return _distx <= halfx && _disty <= 10;
    }

    protected void rogueattack(Controllable player, boolean facing, int disty) {
        if (player.canbeattack()) {
            int[] hitrect;
            int[] attackrect;
            boolean attack;
            boolean canattack = false;
            boolean bl = canattack = this.m_weapon.getAniManager().get_cBoxAtt_w() != 0 && this.m_weapon.getAniManager().get_cBoxAtt_h() != 0;
            if (canattack && (attack = MainCanvas.collision(attackrect = this.m_weapon.getAttackBox(), hitrect = player.getHittedBox())) && disty < 10) {
                int ex = attackrect[0] + (attackrect[2] >> 1);
                int ey = attackrect[1] + (attackrect[3] >> 1);
                int e_type = this.m_weapon.CheckAttackEffect();
                int damage = this.m_weapon.CheckDamage();
                player.getdamage(damage);
                this.createAttackEffect(hitrect, ex, ey, e_type);
                boolean hitdown = this.m_weapon.CheckHitdownTo(player);
                this.m_weapon.m_state = (byte)(this.m_weapon.m_state + 1);
                player.setfacing(!facing);
                if (hitdown) {
                    player.setPlayerState((byte)5);
                } else {
                    player.setPlayerState((byte)2);
                    player.updatedistx(-5);
                }
                player.m_hitted = true;
            }
        }
    }

    protected void attack(GameObject go, Controllable player, boolean facing, int disty) {
        if (player.canbeattack()) {
            boolean canattack = false;
            boolean bl = canattack = go.getAniManager().get_cBoxAtt_w() != 0 && go.getAniManager().get_cBoxAtt_h() != 0;
            if (canattack) {
                int[] attackrect = go.getAttackBox();
                int[] hitrect = player.getHittedBox();
                boolean attack = MainCanvas.collision(attackrect, hitrect);
                boolean weapon = go.getCatlog() == 1;
                Weapon weapon_keeped = null;
                if (weapon) {
                    weapon_keeped = (Weapon)go;
                }
                int keepy = 10;
                if (weapon) {
                    keepy = 10;
                } else if (this.m_objectType == 1) {
                    keepy = 15;
                } else if (this.m_objectType == 2) {
                    keepy = 6;
                }
                if (attack && disty < keepy) {
                    int ex = attackrect[0] + (attackrect[2] >> 1);
                    int ey = attackrect[1] + (attackrect[3] >> 1);
                    int e_type = 2;
                    if (weapon) {
                        e_type = weapon_keeped.CheckAttackEffect();
                    }
                    int damage = this.CheckDamage();
                    if (weapon) {
                        damage = weapon_keeped.CheckDamage();
                    }
                    player.getdamage(damage);
                    this.createAttackEffect(hitrect, ex, ey, e_type);
                    boolean hitdown = false;
                    hitdown = weapon ? weapon_keeped.CheckHitdownTo(player) : this.CheckHitdown();
                    player.setfacing(!facing);
                    if (hitdown) {
                        player.setPlayerState((byte)5);
                    } else {
                        player.setPlayerState((byte)2);
                        player.updatedistx(-5);
                    }
                    player.m_hitted = true;
                }
            }
        }
    }

    protected final int CheckDamage() {
        if (this.m_objectType == 1) {
            return 50;
        }
        if (this.m_objectType == 2) {
            return 15;
        }
        if (this.m_objectType == 3) {
            return 20;
        }
        if (this.m_objectType == 4) {
            return 40;
        }
        return 20;
    }

    protected final boolean CheckHitdown() {
        if (this.m_objectType == 1) {
            return true;
        }
        if (this.m_objectType == 3) {
            return true;
        }
        if (this.m_objectType == 2) {
            return this.m_state == 3 && this.NowFrame() == this.getAniManager().getFrameNum() - 2;
        }
        return this.m_objectType == 4;
    }

    protected boolean invincibility() {
        if (!this.needupdate) {
            return true;
        }
        if ((this.m_state == 5 || this.m_state == 8) && this.m_objectType != 3) {
            return true;
        }
        return (this.m_gotoplayer || this.m_state == 15) && this.m_objectType == 3;
    }

    protected void aimplayer_motoman(Map map, int py) {
        this.m_targetx = this.getfacing() ? map.moveleft - 30 : map.moveright + 30;
        this.m_targety = py;
        this.m_attackangle = MathTool.getAngle(this.getX(), this.getY(), this.m_targetx, this.m_targety);
        if (MathTool.randRatio(50)) {
            this.setEnemyState((byte)1);
        } else {
            this.setEnemyState((byte)4);
        }
    }

    protected void gonext(Map map) {
        if (this.m_scene.bossappear) {
            this.m_scene.waitingforenemy = Utility.GetTime();
        } else if (map.areaindex <= map.range.length - 1) {
            ++map.areaindex;
            this.m_scene.renewlist(map.areaindex);
            this.m_scene.areaclear = true;
        } else {
            this.m_scene.stageclear = true;
        }
    }
}

