/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Map;
import game.SceneGame;
import javax.microedition.lcdui.Graphics;
import main.MainCanvas;
import util.AniManager;
import util.Animation;
import util.MathTool;
import util.Utility;

public abstract class GameObject {
    public static final int CAT_HUMAN = 0;
    public static final int CAT_WEAPON = 1;
    public static final int CAT_ITEMS = 2;
    public static final int CAT_BOMB = 3;
    protected int m_nw = 0;
    protected int m_nh = 0;
    protected int distX = 0;
    protected int distY = 0;
    protected int m_objectType = -1;
    protected int m_flags = -1;
    protected int m_catalog = 0;
    protected int m_renderindex = 0;
    protected int m_positionX;
    protected int m_positionY;
    protected boolean m_dead = false;
    protected boolean m_dying = false;
    protected boolean m_isVisible;
    protected byte m_state = 0;
    protected byte m_laststate = 0;
    protected long m_stateTime = 0L;
    protected boolean m_flashing;
    protected long m_flashTime;
    protected byte m_flashTimer = 0;
    protected SceneGame m_scene;
    private AniManager ani_man = null;

    public GameObject(SceneGame s, Animation ani) {
        this.setGameScene(s);
        this.ani_man = new AniManager(ani);
    }

    protected final void setGameScene(SceneGame s) {
        this.m_scene = s;
    }

    public abstract void init(byte var1, byte var2);

    public abstract void update();

    public abstract void render(Graphics var1);

    public abstract boolean isDead();

    protected final int getX() {
        return this.m_positionX;
    }

    protected final int getY() {
        return this.m_positionY;
    }

    protected final int getCatlog() {
        return this.m_catalog;
    }

    protected final int getRenderIndex() {
        return this.m_renderindex;
    }

    protected final int getObjectType() {
        return this.m_objectType;
    }

    protected final int getFlag() {
        return this.m_flags;
    }

    protected final int getState() {
        return this.m_state;
    }

    protected final boolean isVisible() {
        return this.m_isVisible;
    }

    protected final void setIsVisible(boolean val) {
        this.m_isVisible = val;
    }

    protected final AniManager getAniManager() {
        return this.ani_man;
    }

    protected void setdead() {
        this.m_dead = true;
    }

    protected abstract boolean isDying();

    protected void setDying() {
        this.m_dying = true;
        this.startFlashing(Utility.GetTime());
    }

    protected void setPositionX(int x) {
        this.m_positionX = x;
    }

    protected void setPositionY(int y) {
        this.m_positionY = y;
    }

    protected void setObjectState(byte _state) {
        try {
            this.m_state = _state;
            this.m_stateTime = Utility.GetTime();
            this.ani_man.reSetFrame();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected int[] getAttackBox() {
        int[] data = new int[]{this.getX() + this.ani_man.get_cBoxAtt_x(), this.getY() + this.ani_man.get_cBoxAtt_y(), this.ani_man.get_cBoxAtt_w(), this.ani_man.get_cBoxAtt_h()};
        return data;
    }

    protected int[] getHittedBox() {
        int[] data = new int[]{this.getX() + this.ani_man.get_cBoxHit_x(), this.getY() + this.ani_man.get_cBoxHit_y(), this.ani_man.get_cBoxHit_w(), this.ani_man.get_cBoxHit_h()};
        return data;
    }

    protected boolean InScreen(Map map) {
        int[] screen = new int[]{map.getViewportX(), map.getViewportY(), map.getViewportWidth(), map.getViewportHeight()};
        int[] gobox = this.getHittedBox();
        gobox[0] = map.getViewportX() + gobox[0] - map.getCameraX();
        gobox[1] = map.getViewportY() + gobox[1] - map.getCameraY();
        return MainCanvas.collision(screen, gobox);
    }

    protected boolean CalHitted(GameObject go) {
        int[] go_abox = go.getAttackBox();
        int[] m_hbox = this.getHittedBox();
        return MainCanvas.collision(go_abox, m_hbox);
    }

    protected boolean CalAttack(GameObject go) {
        int[] go_hbox = go.getHittedBox();
        int[] m_abox = this.getAttackBox();
        return MainCanvas.collision(go_hbox, m_abox);
    }

    protected boolean CalOvelap(GameObject go) {
        int[] go_hbox = go.getHittedBox();
        int[] m_hbox = this.getHittedBox();
        return MainCanvas.collision(go_hbox, m_hbox);
    }

    protected void startFlashing(long time) {
        this.m_flashing = true;
        this.m_flashTime = time;
    }

    protected void reset(int x, int y, int health, byte facing) {
    }

    protected boolean x_getFacingTo(GameObject go) {
        return this.m_positionX > go.m_positionX;
    }

    protected boolean y_getFacingTo(GameObject go) {
        return this.m_positionY > go.m_positionY;
    }

    protected final int GetHorizontalDistance(int tx) {
        return MathTool.getAbs(tx - this.m_positionX);
    }

    protected final int GetVerticalDistance(int ty) {
        return MathTool.getAbs(ty - this.m_positionY);
    }

    protected int GetDistance(GameObject go) {
        int dist = MathTool.getDistance(this.m_positionX, this.m_positionY, go.m_positionX, go.m_positionY);
        return dist;
    }

    protected void loopAnimation() {
        this.ani_man.nextFrame_Cyc();
    }

    protected boolean loopcompleted() {
        return this.ani_man.nextFrame_toEnd();
    }

    protected int NowFrame() {
        return this.ani_man.getNowFrame();
    }

    protected boolean islast() {
        return this.ani_man.isLastFrame();
    }

    protected boolean getfacing() {
        return this.ani_man.getfacingx();
    }

    protected void setfacing(boolean facing) {
        this.ani_man.setfacingx(facing);
    }

    protected boolean changefacing() {
        boolean now_facing = this.ani_man.getfacingx();
        this.ani_man.setfacingx(!now_facing);
        return !now_facing;
    }

    protected boolean moveTo(int tx, int ty, int stepx, int stepy) {
        int angle = 0;
        angle = MathTool.getAngle(this.getX(), this.getY(), tx, ty);
        return this.moveAsAngle(angle, stepx, stepy);
    }

    protected boolean moveToPoint(int tx, int ty, int stepx, int stepy) {
        return this.GetHorizontalDistance(tx) < stepx && this.GetVerticalDistance(ty) < stepy;
    }

    protected void moveTo(GameObject go, int stepx, int stepy) {
        this.moveTo(go.getX(), go.getY(), stepx, stepy);
    }

    protected boolean moveAsAngle(int angle, int stepx, int stepy) {
        int tempy;
        int tempx = this.getX() + MathTool.getRadiusX(angle, stepx);
        if (this.m_scene.CheckMove(this, tempx, tempy = this.getY() + MathTool.getRadiusY(angle, stepy))) {
            this.setPositionX(tempx);
            this.setPositionY(tempy);
            return true;
        }
        return false;
    }
}

