/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Effect;
import game.GameObject;
import game.Items;
import game.Map;
import game.SceneGame;
import game.Weapon;
import javax.microedition.lcdui.Graphics;
import util.Animation;
import util.MathTool;

public class Human
extends GameObject {
    protected int m_attackposition = 0;
    public static final byte HT_ROGUE = 0;
    public static final byte HT_FATMAN = 1;
    public static final byte HT_BITCH = 2;
    public static final byte HT_MOTOMAN = 3;
    public static final byte HT_BOSS = 4;
    public static final byte HT_HERO = 5;
    protected static final byte[] distx_hitdown = new byte[]{-15, -15, -15, -15, -15, -10};
    protected boolean m_attack = false;
    protected boolean m_hitted = false;
    protected int m_attackStep = 0;
    protected boolean m_talking = false;
    protected int m_health;
    protected int m_maxHealth;
    protected int m_magic;
    protected int m_maxMagic;
    protected boolean m_magicchange = false;
    protected byte m_shakedist = 0;
    protected int m_ap;
    protected int m_dp;
    protected int m_walkingSpeedX = 8;
    protected int m_walkingSpeedY = 4;
    protected byte m_facingDir;
    protected boolean m_invincible = false;
    protected int m_attackstand = 0;
    protected boolean m_keepweapon = false;
    protected int m_weapontype = 0;
    protected Weapon m_weapon = null;

    public Human(SceneGame game, Animation ani) {
        super(game, ani);
        this.m_catalog = 0;
    }

    public void init(byte type, byte initstate) {
    }

    public void update() {
    }

    public void updatehittedflying(int curframe, boolean facing) {
        if (curframe < 0 || curframe > distx_hitdown.length - 1) {
            return;
        }
        byte tempx = distx_hitdown[curframe];
        if (facing) {
            tempx = -tempx;
        }
        if (this.m_scene.CheckMove(this, this.getX() + tempx, this.getY())) {
            this.setPositionX(this.getX() + tempx);
        }
    }

    public void render(Graphics g) {
    }

    public boolean isDead() {
        return this.m_dead;
    }

    public boolean isDying() {
        return this.m_dying;
    }

    protected final int getHealth() {
        return this.m_health;
    }

    protected final int getMaxHealth() {
        return this.m_maxHealth;
    }

    protected final byte getFacing() {
        return this.m_facingDir;
    }

    protected final void setFacing(byte dir) {
        this.m_facingDir = dir;
    }

    protected void setFacingTo(Human man) {
        this.getAniManager().setfacingx(this.x_getFacingTo(man));
    }

    protected void setWalkingDir(byte facing) {
        this.m_facingDir = facing;
    }

    protected void updateWalking(byte dir) {
        int tempx = 0;
        int tempy = 0;
        switch (dir) {
            case 0: {
                tempx = this.m_positionX;
                tempy = this.m_positionY - this.m_walkingSpeedY;
                break;
            }
            case 1: {
                tempx = this.m_positionX;
                tempy = this.m_positionY + this.m_walkingSpeedY;
                break;
            }
            case 2: {
                tempx = this.m_positionX - this.m_walkingSpeedX;
                tempy = this.m_positionY;
                break;
            }
            case 3: {
                tempx = this.m_positionX + this.m_walkingSpeedX;
                tempy = this.m_positionY;
            }
        }
        if (this.m_scene.CheckMove(this, tempx, tempy)) {
            this.setPositionX(tempx);
            this.setPositionY(tempy);
        }
    }

    protected final void addHealth(int amount) {
        if (amount == 0) {
            return;
        }
        if (this.m_health == this.m_maxHealth) {
            return;
        }
        this.m_health += amount;
        if (this.m_health > this.m_maxHealth) {
            this.m_health = this.m_maxHealth;
        }
    }

    protected final void reduceHealth(int amount) {
        this.m_health -= amount;
        if (this.m_health < 0) {
            this.m_health = 0;
        }
    }

    protected final void setHealth(int amount) {
        this.m_health = amount;
        if (this.m_health > this.m_maxHealth) {
            this.m_health = this.m_maxHealth;
        }
        if (this.m_health < 0) {
            this.m_health = 0;
        }
    }

    protected final void FullHealth() {
        this.m_health = this.m_maxHealth;
    }

    protected final void resetHealth() {
        this.m_health = 0;
    }

    protected final void addMagic(int amount) {
        if (amount == 0) {
            return;
        }
        if (this.m_magic == this.m_maxMagic) {
            return;
        }
        this.m_magic += amount;
        if (this.m_magic > this.m_maxMagic) {
            this.m_magic = this.m_maxMagic;
        }
        this.m_magicchange = true;
    }

    protected final void reduceMagic(int amount) {
        this.m_magic -= amount;
        if (this.m_magic < 0) {
            this.m_magic = 0;
        }
    }

    protected final void setMagic(int amount) {
        this.m_magic = amount;
        if (this.m_magic > this.m_maxMagic) {
            this.m_magic = this.m_maxMagic;
        }
        if (this.m_magic < 0) {
            this.m_magic = 0;
        }
    }

    protected final void FullMagic() {
        this.m_magic = this.m_maxMagic;
    }

    protected final void restoreMagic() {
        this.m_magic = 0;
    }

    protected boolean somethingpicked() {
        int i = 0;
        int dist_y = 0;
        int length = 2 + 10 + 3 + 5;
        GameObject object = null;
        block4: for (i = 0; i < length; ++i) {
            int cat;
            object = this.m_scene.renderlist[i];
            if (object == null || (cat = object.getCatlog()) == 0 || cat == 3) continue;
            dist_y = this.GetVerticalDistance(object.getY());
            if (!this.CalOvelap(object) || dist_y >= 10) continue;
            switch (cat) {
                case 1: {
                    if (this.m_keepweapon) {
                        this.weapondropfromhero();
                    }
                    this.pickupweapon(i);
                    return true;
                }
                case 2: {
                    Items item = (Items)object;
                    if (item.collected) continue block4;
                    this.pickupitem(item);
                    return true;
                }
            }
        }
        return false;
    }

    protected void pickupitem(Items item) {
        item.getted();
    }

    protected void dropItem(Map map) {
        if (this.m_scene.checkitemdrop()) {
            int _x = this.getX();
            int _y = this.getY();
            _x = map.x_rangeinview(_x);
            if ((_y = map.y_rangeinview(_y)) > 300) {
                _y -= 20;
            }
            int type = 0;
            int rand = MathTool.getRandom(100);
            if (rand <= 25) {
                type = 1;
            } else if (rand <= 50) {
                type = 0;
            } else {
                return;
            }
            Items item = new Items(this.m_scene, this.m_scene.ani_item, type, _x, _y);
            this.m_scene.addItem(item);
        }
    }

    protected void pickupweapon(int index) {
        try {
            Weapon temp_weapon = new Weapon(this.m_scene, this.m_scene.ani_heroweapon[this.m_scene.renderlist[index].getObjectType()], this.m_scene.renderlist[index].getObjectType());
            this.setweapon(temp_weapon);
            this.m_scene.renderlist[index] = null;
            this.m_scene.m_player.m_attackStep = 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void weapondrop() {
        if (!this.m_keepweapon) {
            return;
        }
        this.m_keepweapon = false;
        this.m_weapon = null;
        this.m_weapontype = -1;
    }

    protected void weapondropfromhero() {
        if (MathTool.randRatio(30)) {
            int _x = this.getX();
            int _y = this.getY();
            this.m_scene.addWeapon(this.m_weapontype, _x, _y);
        }
        this.weapondrop();
    }

    protected void weapondropfromroque() {
        if (this.m_scene.checkweapondrop()) {
            if (MathTool.randRatio(30)) {
                int _x = this.getX();
                int _y = this.getY();
                this.m_scene.addWeapon(this.m_weapontype, _x, _y);
            }
            this.weapondrop();
        }
    }

    protected void setweapon(Weapon weapon) {
        if (weapon == null) {
            return;
        }
        this.m_weapon = weapon;
        this.m_weapon.setPositionX(this.getX());
        this.m_weapon.setPositionY(this.getY());
        this.m_keepweapon = true;
        this.m_weapontype = weapon.getObjectType();
    }

    protected Weapon getweapon() {
        return this.m_weapon;
    }

    protected void updatedistx(int _distx) {
        int tempx = _distx;
        if (this.getAniManager().getfacingx()) {
            tempx = -_distx;
        }
        if (this.m_scene.CheckMove(this, this.getX() + tempx, this.getY())) {
            this.setPositionX(this.getX() + tempx);
        }
    }

    protected void createAttackEffect(int[] _target, int _x, int _y, int _type) {
        this.m_attackposition = this.m_attackposition > 4 ? 0 : ++this.m_attackposition;
        if (this.m_attackposition == 0) {
            _x -= 6;
        } else if (this.m_attackposition == 1) {
            _x += 6;
        } else if (this.m_attackposition == 2) {
            _y -= 6;
        } else if (this.m_attackposition == 3) {
            _y += 6;
        }
        int hx = _target[0];
        int hy = _target[1];
        int hw = _target[2];
        int hh = _target[3];
        int e_x2 = hx + hw;
        int e_y2 = hy + hh;
        if (_x < hx) {
            _x = hx;
        }
        if (_x > e_x2) {
            _x = e_x2;
        }
        if (_y < hy) {
            _y = hy;
        }
        if (_y > e_y2) {
            _y = e_y2;
        }
        int index = this.m_scene.geteffectindex();
        boolean facing = this.getfacing();
        this.m_scene.m_effect[index] = new Effect(this.m_scene, this.m_scene.ani_effect, _x, _y, _type, facing);
    }
}

