/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Controllable;
import game.Enemy;
import game.GameObject;
import game.MapItems;
import game.SceneGame;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.MainCanvas;
import util.GraphicsTool;
import util.MathTool;
import util.Utility;

public class Map {
    public int m_cameradist = 0;
    private int m_width;
    private int m_height = 0;
    private int m_tilewidth;
    private int m_tileheight = 0;
    private int m_cameraX;
    private int m_cameraY = 0;
    private int m_targetcameraX;
    private int m_targetcameraY = 0;
    private final int m_cameraspeed;
    private short[] m_tileatt = null;
    private byte[] m_tileMapData = null;
    private int m_viewportX = 0;
    private int m_viewportY = 0;
    private int m_viewportW = 0;
    private int m_viewportH = 0;
    public int moveleft = 0;
    public int moveup = 0;
    public int moveright = 0;
    public int movedown = 0;
    public int mapleft = 0;
    public int mapright = 0;
    private int m_oldcameraX;
    private int m_oldcameraY = 0;
    private int m_blitX = 0;
    private int m_blitY = 0;
    private boolean m_redrawWholeBuffer = false;
    private Image m_tileImage = null;
    private Image m_mapBuffer;
    private Graphics m_mapBufferGraphics;
    private boolean m_usemapBuffer = false;
    private SceneGame m_scene = null;
    public int[] range = null;
    public int num_area = 0;
    public int areaindex = 0;
    private MapItems[] mi = null;
    private int num_mi = 0;

    public Map(SceneGame game) {
        this.m_cameraspeed = 12;
        this.m_scene = game;
    }

    public void loadResInfo(DataInputStream dis) {
        try {
            int i;
            if (dis == null) {
                return;
            }
            this.m_tilewidth = dis.readByte();
            this.m_tileheight = dis.readByte();
            byte nums_W = dis.readByte();
            byte nums_H = dis.readByte();
            int TileNum = dis.readByte();
            byte[] m_tiledata = new byte[TileNum];
            byte[] m_tileflipatt = new byte[TileNum];
            for (i = 0; i < TileNum; ++i) {
                m_tiledata[i] = dis.readByte();
                m_tileflipatt[i] = dis.readByte();
            }
            this.m_tileatt = new short[TileNum];
            for (i = 0; i < TileNum; ++i) {
                this.m_tileatt[i] = dis.readShort();
            }
            int nums_res_build = dis.readByte();
            byte[][] build_res = new byte[nums_res_build][2];
            for (int i2 = 0; i2 < nums_res_build; ++i2) {
                build_res[i2][0] = dis.readByte();
                build_res[i2][1] = dis.readByte();
            }
            int nums_res_sprite = dis.readByte();
            byte[][] sprite_res = new byte[nums_res_sprite][2];
            String[][] sprite_path = new String[nums_res_sprite][2];
            for (int i3 = 0; i3 < nums_res_sprite; ++i3) {
                sprite_path[i3][0] = dis.readUTF();
                sprite_path[i3][1] = dis.readUTF();
                sprite_res[i3][0] = dis.readByte();
                sprite_res[i3][1] = dis.readByte();
            }
            dis.close();
            Utility.doGC();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void LoadMap(DataInputStream dis) {
        try {
            if (dis == null) {
                return;
            }
            this.m_width = dis.readByte();
            this.m_height = dis.readByte();
            this.m_tilewidth = 32;
            this.m_tileheight = 32;
            this.setCameraY(this.m_height * this.m_tileheight - 320);
            this.mapleft = 0;
            this.mapright = this.m_width * this.m_tilewidth;
            this.moveup = (this.m_height - 4) * this.m_tileheight;
            this.movedown = this.m_height * this.m_tileheight;
            if (MainCanvas.missionid == 0 || MainCanvas.missionid == 1) {
                this.moveup += 16;
            }
            this.m_tileMapData = null;
            this.m_tileMapData = new byte[this.m_width * this.m_height];
            for (int m = 0; m < this.m_tileMapData.length; ++m) {
                this.m_tileMapData[m] = dis.readByte();
            }
            int nums_build = dis.readShort();
            this.num_mi = 0;
            this.areaindex = 0;
            byte[] build = new byte[nums_build];
            for (int i = 0; i < nums_build; ++i) {
                build[i] = dis.readByte();
                if (build[i] == 0) {
                    ++this.areaindex;
                    continue;
                }
                ++this.num_mi;
            }
            int mi_index = 0;
            this.mi = new MapItems[this.num_mi];
            this.range = new int[this.areaindex];
            this.areaindex = 0;
            byte[] build_x = new byte[nums_build];
            for (int i = 0; i < nums_build; ++i) {
                build_x[i] = dis.readByte();
                if (build[i] != 0) continue;
                this.range[this.areaindex++] = build_x[i] * this.m_tilewidth;
            }
            byte[] build_y = new byte[nums_build];
            block43: for (int i = 0; i < nums_build; ++i) {
                build_y[i] = dis.readByte();
                if (build[i] == 0) continue;
                int x = build_x[i] * this.m_tilewidth;
                int y = build_y[i] * this.m_tileheight;
                block1 : switch (MainCanvas.missionid) {
                    case 0: {
                        switch (build[i]) {
                            case 1: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_light0, this, build[i], x, y, 0, 1);
                                break;
                            }
                            case 2: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_light1, this, build[i], x, y, 0, 1);
                                break;
                            }
                            case 3: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_tb0, this, build[i], x, y, 1, 0);
                                break;
                            }
                            case 4: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_tb1, this, build[i], x - 20, y + 2, 1, 0);
                                break;
                            }
                            case 5: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_fz, this, build[i], x + 9, y + 16, 0, 0);
                                break;
                            }
                            case 6: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_bb0, this, build[i], x, y + 15, 0, 1);
                                break;
                            }
                            case 7: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_bb1, this, build[i], x, y, 0, 1);
                            }
                        }
                        continue block43;
                    }
                    case 1: {
                        switch (build[i]) {
                            case 1: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_win0, this, build[i], x, y, 1, 1);
                                break;
                            }
                            case 2: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_win1, this, build[i], x + 8, y, 1, 1);
                                break;
                            }
                            case 3: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_pai0, this, build[i], x, y, 0, 1);
                                break;
                            }
                            case 4: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_pai1, this, build[i], x, y, 0, 1);
                                break;
                            }
                            case 5: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_pai2, this, build[i], x, y, 0, 1);
                                break;
                            }
                            case 6: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_pai3, this, build[i], x, y - 8, 1, 1);
                                break;
                            }
                            case 7: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_pai4, this, build[i], x, y, 1, 1);
                                break;
                            }
                            case 8: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_pai3, this, build[i], x + 11, y, 0, 1);
                                break;
                            }
                            case 9: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_streetbitch, this, build[i], x, y, 0, 1);
                                break;
                            }
                            case 10: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_pip0, this, build[i], x + 1, y, 1, 1);
                                break;
                            }
                            case 11: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_pip1, this, build[i], x + 11, y, 1, 1);
                                break;
                            }
                            case 12: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_pip2, this, build[i], x, y, 1, 1);
                            }
                        }
                        continue block43;
                    }
                    case 2: {
                        switch (build[i]) {
                            case 1: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_steel, this, build[i], x, y, 1, 1);
                                break block1;
                            }
                            case 2: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_pail, this, build[i], x, y, 1, 1);
                                break block1;
                            }
                            case 3: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.img_net, this, build[i], x, y, 1, 1);
                                break block1;
                            }
                            case 4: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_man0, this, build[i], x, y, 0, 1);
                                break block1;
                            }
                            case 5: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_man1, this, build[i], x, y, 0, 1);
                                break block1;
                            }
                            case 6: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_man2, this, build[i], x, y, 0, 1);
                                break block1;
                            }
                            case 7: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_man3, this, build[i], x, y, 0, 1);
                                break block1;
                            }
                            case 8: {
                                this.mi[mi_index++] = new MapItems(this.m_scene, this.m_scene.ani_light, this, build[i], x - 4, y - 7 + 64, 0, 1);
                            }
                        }
                    }
                }
            }
            this.num_area = this.range.length - 1;
            this.areaindex = 0;
            build_x = null;
            build_y = null;
            build = null;
            Utility.doGC();
            int nums_sprite = dis.readByte();
            this.m_scene.enemy = new Enemy[nums_sprite - 1];
            int index = 0;
            for (int i = 0; i < nums_sprite; ++i) {
                dis.readByte();
            }
            byte[] sprite_x = new byte[nums_sprite];
            for (int i = 0; i < nums_sprite; ++i) {
                sprite_x[i] = dis.readByte();
            }
            byte[] sprite_y = new byte[nums_sprite];
            for (int i = 0; i < nums_sprite; ++i) {
                sprite_y[i] = dis.readByte();
            }
            byte sprite = 0;
            for (int i = 0; i < nums_sprite; i = (int)((byte)(i + 1))) {
                byte type = 0;
                byte life = 0;
                byte weapon = 0;
                sprite = dis.readByte();
                if (sprite == 0) {
                    type = dis.readByte();
                    life = dis.readByte();
                    weapon = dis.readByte();
                    this.m_scene.enemy[index] = this.m_scene.createRogue(type, weapon);
                } else if (sprite == 1) {
                    life = dis.readByte();
                    this.m_scene.enemy[index] = new Enemy(this.m_scene, this.m_scene.ani_fatman);
                } else if (sprite == 2) {
                    life = dis.readByte();
                    this.m_scene.enemy[index] = new Enemy(this.m_scene, this.m_scene.ani_bitch);
                } else if (sprite == 3) {
                    life = dis.readByte();
                    this.m_scene.enemy[index] = new Enemy(this.m_scene, this.m_scene.ani_motoman);
                } else if (sprite == 4) {
                    life = dis.readByte();
                    this.m_scene.enemy[index] = new Enemy(this.m_scene, this.m_scene.ani_boss);
                } else if (sprite == 5) {
                    this.m_scene.m_player = new Controllable(this.m_scene, this.m_scene.ani_hero);
                    this.m_scene.m_player.setPositionX(sprite_x[i] * this.m_tilewidth + (this.m_tilewidth >> 1));
                    this.m_scene.m_player.setPositionY(sprite_y[i] * this.m_tileheight + this.m_tileheight);
                }
                if (sprite != 5) {
                    this.m_scene.enemy[index].m_maxHealth = life * 100;
                    this.m_scene.enemy[index].FullHealth();
                    this.m_scene.enemy[index].setPositionX(sprite_x[i] * this.m_tilewidth + (this.m_tilewidth >> 1));
                    this.m_scene.enemy[index].setPositionY(sprite_y[i] * this.m_tileheight + this.m_tileheight);
                    this.m_scene.enemy[index].init(sprite, (byte)0);
                    ++index;
                }
                byte pNums = dis.readByte();
                for (int j = 0; j < 3; ++j) {
                    dis.readByte();
                }
            }
            this.m_scene.renewlist(this.areaindex);
            dis.close();
            Utility.doGC();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setTilesetImage(Image img) {
        this.m_tileImage = img;
    }

    public final void setCameraX(int x) {
        this.m_cameraX = x;
    }

    public final void setCameraY(int y) {
        this.m_cameraY = y;
    }

    public final int getCameraX() {
        return this.m_cameraX;
    }

    public final int getCameraY() {
        return this.m_cameraY;
    }

    public void setViewport(int _x, int _y, int _w, int _h) {
        if (this.m_usemapBuffer && (this.m_viewportW != _w || this.m_viewportH != _h)) {
            this.initMapBuffer();
        }
        this.m_viewportX = _x;
        this.m_viewportY = _y;
        this.m_viewportW = _w;
        this.m_viewportH = _h;
        this.m_cameradist = this.m_viewportW * 50 / 100;
    }

    public final int getViewportX() {
        return this.m_viewportX;
    }

    public final int getViewportY() {
        return this.m_viewportY;
    }

    public final int getViewportWidth() {
        return this.m_viewportW;
    }

    public final int getViewportHeight() {
        return this.m_viewportH;
    }

    public final int getWidth() {
        return this.m_width;
    }

    public final int getHeight() {
        return this.m_height;
    }

    public final int getTileWidth() {
        return this.m_tilewidth;
    }

    public final int getTileHeight() {
        return this.m_tileheight;
    }

    public final int getTileIndex(int x, int y) {
        if (x >= 0 && x < this.m_width && y >= 0 && y < this.m_height) {
            return this.m_width * y + x;
        }
        return -1;
    }

    public final byte getTileId(int id) {
        if (id >= 0 && id < this.m_tileMapData.length) {
            return this.m_tileMapData[id];
        }
        return -1;
    }

    public final int getTileY(int tileIndex) {
        if (tileIndex == -1) {
            return -1;
        }
        return MathTool.getDiv(tileIndex, this.m_width);
    }

    public void updateMap() {
        try {
            int i = 0;
            for (i = 0; i < this.num_mi; ++i) {
                this.mi[i].update();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void render(Graphics g) {
        try {
            GraphicsTool.ClipAll(g);
            boolean i = false;
            int oldClipX = g.getClipX();
            int oldClipY = g.getClipY();
            int oldClipW = g.getClipWidth();
            int oldClipH = g.getClipHeight();
            if (this.m_usemapBuffer) {
                this.renderTilemapBuffer(g, this.m_cameraX + 8, this.m_cameraY);
            } else {
                int clipX = oldClipX;
                int clipY = oldClipY;
                int clipW = oldClipW;
                int clipH = oldClipH;
                if (clipX < this.m_viewportX) {
                    clipX = this.m_viewportX;
                }
                if (clipY < this.m_viewportY) {
                    clipY = this.m_viewportY;
                }
                if (clipX + clipW > this.m_viewportX + this.m_viewportW) {
                    clipW -= clipX + clipW - (this.m_viewportX + this.m_viewportW);
                }
                if (clipY + clipH > this.m_viewportY + this.m_viewportH) {
                    clipH -= clipY + clipH - (this.m_viewportY + this.m_viewportH);
                }
                this.renderTilemap(g, this.m_cameraX, this.m_cameraY, clipX, clipY, clipW, clipH);
            }
            g.setClip(oldClipX, oldClipY, oldClipW, oldClipH);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void drawback(Graphics g) {
        int i = 0;
        for (i = 0; i < this.num_mi; ++i) {
            if (this.mi[i] == null || this.mi[i].mip != 1) continue;
            this.mi[i].render(g);
        }
    }

    public void drawfront(Graphics g) {
        int i = 0;
        for (i = 0; i < this.num_mi; ++i) {
            if (this.mi[i] == null || this.mi[i].mip != 0) continue;
            this.mi[i].render(g);
        }
    }

    private void renderTilemapBuffer(Graphics g, int worldX, int worldY) {
        Graphics offScreenBufferGraphics = this.m_mapBufferGraphics;
        int diffX = worldX - this.m_oldcameraX;
        int diffY = worldY - this.m_oldcameraY;
        if (this.m_redrawWholeBuffer || Math.abs(diffX) > this.m_viewportW || Math.abs(diffY) > this.m_viewportH) {
            this.m_redrawWholeBuffer = false;
            this.renderTilemap(offScreenBufferGraphics, worldX, worldY, 0, 0, this.m_viewportW, this.m_viewportH);
            this.m_blitX = 0;
            this.m_blitY = 0;
        } else {
            int updateWorldY;
            int updateWorldX;
            int newBlitX = this.m_blitX + diffX;
            if (diffX > 0) {
                updateWorldX = worldX + this.m_viewportW - diffX;
                if (newBlitX > this.m_viewportW) {
                    this.renderTilemap(offScreenBufferGraphics, updateWorldX, this.m_oldcameraY, this.m_blitX, this.m_blitY, this.m_viewportW - this.m_blitX, this.m_viewportH - this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, updateWorldX, this.m_oldcameraY + this.m_viewportH - this.m_blitY, this.m_blitX, 0, this.m_viewportW - this.m_blitX, this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, updateWorldX += this.m_viewportW - this.m_blitX, this.m_oldcameraY, 0, this.m_blitY, newBlitX - this.m_viewportW, this.m_viewportH - this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, updateWorldX, this.m_oldcameraY + this.m_viewportH - this.m_blitY, 0, 0, newBlitX - this.m_viewportW, this.m_blitY);
                    newBlitX -= this.m_viewportW;
                } else {
                    this.renderTilemap(offScreenBufferGraphics, updateWorldX, this.m_oldcameraY, this.m_blitX, this.m_blitY, diffX, this.m_viewportH - this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, updateWorldX, this.m_oldcameraY + this.m_viewportH - this.m_blitY, this.m_blitX, 0, diffX, this.m_blitY);
                }
            } else if (diffX < 0) {
                if (newBlitX < 0) {
                    updateWorldX = this.m_oldcameraX - this.m_blitX;
                    this.renderTilemap(offScreenBufferGraphics, updateWorldX, this.m_oldcameraY, 0, this.m_blitY, this.m_blitX, this.m_viewportH - this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, updateWorldX, this.m_oldcameraY + this.m_viewportH - this.m_blitY, 0, 0, this.m_blitX, this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, updateWorldX += newBlitX, this.m_oldcameraY, this.m_viewportW + newBlitX, this.m_blitY, -newBlitX, this.m_viewportH - this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, updateWorldX, this.m_oldcameraY + this.m_viewportH - this.m_blitY, this.m_viewportW + newBlitX, 0, -newBlitX, this.m_blitY);
                    newBlitX = this.m_viewportW + newBlitX;
                } else {
                    this.renderTilemap(offScreenBufferGraphics, worldX, this.m_oldcameraY, newBlitX, this.m_blitY, -diffX, this.m_viewportH - this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, worldX, this.m_oldcameraY + this.m_viewportH - this.m_blitY, newBlitX, 0, -diffX, this.m_blitY);
                }
            }
            this.m_blitX = newBlitX;
            int newBlitY = this.m_blitY + diffY;
            if (diffY > 0) {
                updateWorldY = worldY + this.m_viewportH - diffY;
                if (newBlitY > this.m_viewportH) {
                    this.renderTilemap(offScreenBufferGraphics, worldX, updateWorldY, this.m_blitX, this.m_blitY, this.m_viewportW - this.m_blitX, this.m_viewportH - this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, worldX + this.m_viewportW - this.m_blitX, updateWorldY, 0, this.m_blitY, this.m_blitX, this.m_viewportH - this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, worldX, updateWorldY += this.m_viewportH - this.m_blitY, this.m_blitX, 0, this.m_viewportW - this.m_blitX, newBlitY - this.m_viewportH);
                    this.renderTilemap(offScreenBufferGraphics, worldX + this.m_viewportW - this.m_blitX, updateWorldY, 0, 0, this.m_blitX, newBlitY - this.m_viewportH);
                    newBlitY -= this.m_viewportH;
                } else {
                    this.renderTilemap(offScreenBufferGraphics, worldX, updateWorldY, this.m_blitX, this.m_blitY, this.m_viewportW - this.m_blitX, diffY);
                    this.renderTilemap(offScreenBufferGraphics, worldX + this.m_viewportW - this.m_blitX, updateWorldY, 0, this.m_blitY, this.m_blitX, diffY);
                }
            } else if (diffY < 0) {
                if (newBlitY < 0) {
                    updateWorldY = this.m_oldcameraY - this.m_blitY;
                    this.renderTilemap(offScreenBufferGraphics, worldX, updateWorldY, this.m_blitX, 0, this.m_viewportW - this.m_blitX, this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, worldX + this.m_viewportW - this.m_blitX, updateWorldY, 0, 0, this.m_blitX, this.m_blitY);
                    this.renderTilemap(offScreenBufferGraphics, worldX, updateWorldY += newBlitY, this.m_blitX, this.m_viewportH + newBlitY, this.m_viewportW - this.m_blitX, -newBlitY);
                    this.renderTilemap(offScreenBufferGraphics, worldX + this.m_viewportW - this.m_blitX, updateWorldY, 0, this.m_viewportH + newBlitY, this.m_blitX, -newBlitY);
                    newBlitY = this.m_viewportH + newBlitY;
                } else {
                    this.renderTilemap(offScreenBufferGraphics, worldX, worldY, this.m_blitX, newBlitY, this.m_viewportW - this.m_blitX, -diffY);
                    this.renderTilemap(offScreenBufferGraphics, worldX + this.m_viewportW - this.m_blitX, worldY, 0, newBlitY, this.m_blitX, -diffY);
                }
            }
            this.m_blitY = newBlitY;
            int remW = this.m_viewportW - this.m_blitX;
            int remH = this.m_viewportH - this.m_blitY;
            offScreenBufferGraphics.setClip(0, 0, this.m_viewportW, this.m_viewportH);
            g.setClip(this.m_viewportX, this.m_viewportY, remW, remH);
            g.drawImage(this.m_mapBuffer, this.m_viewportX - this.m_blitX, this.m_viewportY - this.m_blitY, 20);
            g.setClip(this.m_viewportX + remW, this.m_viewportY, this.m_blitX, remH);
            g.drawImage(this.m_mapBuffer, remW + this.m_viewportX, this.m_viewportY - this.m_blitY, 20);
            g.setClip(this.m_viewportX, remH + this.m_viewportY, remW, this.m_blitY);
            g.drawImage(this.m_mapBuffer, this.m_viewportX - this.m_blitX, remH + this.m_viewportY, 20);
            g.setClip(this.m_viewportX + remW, remH + this.m_viewportY, this.m_blitX, this.m_blitY);
            g.drawImage(this.m_mapBuffer, remW + this.m_viewportX, remH + this.m_viewportY, 20);
        }
        this.m_oldcameraX = worldX;
        this.m_oldcameraY = worldY;
    }

    private void renderTilemap(Graphics g, int _cameraX, int _cameraY, int clipX, int clipY, int clipW, int clipH) {
        int cx;
        int tileIndex;
        int remainingW = 0;
        int numWholeTilesX = 0;
        int lastColW = 0;
        int remainingH = 0;
        int numWholeTilesY = 0;
        int lastRowH = 0;
        int offsetIntoTileX = MathTool.getModInt(_cameraX, this.m_tilewidth);
        int offsetIntoTileY = MathTool.getModInt(_cameraY, this.m_tileheight);
        int firstColW = 0;
        if (offsetIntoTileX > 0) {
            firstColW = this.m_tilewidth - offsetIntoTileX;
        }
        int firstRowH = 0;
        if (offsetIntoTileY > 0) {
            firstRowH = this.m_tileheight - offsetIntoTileY;
        }
        if (firstColW > clipW) {
            firstColW = clipW;
        } else {
            remainingW = clipW - firstColW;
            numWholeTilesX = MathTool.getDiv(remainingW, this.m_tilewidth);
            lastColW = MathTool.getModInt(remainingW, this.m_tilewidth);
        }
        if (firstRowH > clipH) {
            firstRowH = clipH;
        } else {
            remainingH = clipH - firstRowH;
            numWholeTilesY = MathTool.getDiv(remainingH, this.m_tileheight);
            lastRowH = MathTool.getModInt(remainingH, this.m_tileheight);
        }
        int tileIndexStart = tileIndex = this.getTileIndex(MathTool.getDiv(_cameraX, this.m_tilewidth), MathTool.getDiv(_cameraY, this.m_tileheight));
        byte tileData = 0;
        int tileClipX = clipX;
        int tileClipY = clipY;
        int TILE_INDEX_MAX = this.m_tileMapData.length - 1;
        if (firstRowH > 0) {
            if (firstColW > 0) {
                if (tileIndex >= 0) {
                    if (tileIndex > TILE_INDEX_MAX) {
                        return;
                    }
                    tileData = this.getTileId(tileIndex);
                    ++tileIndex;
                    g.setClip(tileClipX, tileClipY, firstColW, firstRowH);
                    this.RenderOneTile(g, tileData, tileClipX - offsetIntoTileX, tileClipY - offsetIntoTileY, 20);
                }
                tileClipX += firstColW;
            }
            for (cx = 0; cx < numWholeTilesX; ++cx) {
                if (tileIndex >= 0) {
                    if (tileIndex > TILE_INDEX_MAX) {
                        return;
                    }
                    tileData = this.getTileId(tileIndex);
                    ++tileIndex;
                    g.setClip(tileClipX, tileClipY, this.m_tilewidth, firstRowH);
                    this.RenderOneTile(g, tileData, tileClipX, tileClipY - offsetIntoTileY, 20);
                }
                tileClipX += this.m_tilewidth;
            }
            if (lastColW > 0 && tileIndex >= 0) {
                if (tileIndex > TILE_INDEX_MAX) {
                    return;
                }
                tileData = this.getTileId(tileIndex);
                ++tileIndex;
                g.setClip(tileClipX, tileClipY, lastColW, firstRowH);
                this.RenderOneTile(g, tileData, tileClipX, tileClipY - offsetIntoTileY, 20);
            }
            tileClipY += firstRowH;
            tileIndex = tileIndexStart += this.m_width;
        }
        for (int cy = 0; cy < numWholeTilesY; ++cy) {
            tileClipX = clipX;
            if (firstColW > 0) {
                if (tileIndex >= 0) {
                    if (tileIndex > TILE_INDEX_MAX) {
                        return;
                    }
                    tileData = this.getTileId(tileIndex);
                    ++tileIndex;
                    g.setClip(tileClipX, tileClipY, firstColW, this.m_tileheight);
                    this.RenderOneTile(g, tileData, tileClipX - offsetIntoTileX, tileClipY, 20);
                }
                tileClipX += firstColW;
            }
            for (int cx2 = 0; cx2 < numWholeTilesX; ++cx2) {
                if (tileIndex >= 0) {
                    if (tileIndex > TILE_INDEX_MAX) {
                        return;
                    }
                    tileData = this.getTileId(tileIndex);
                    ++tileIndex;
                    g.setClip(tileClipX, tileClipY, this.m_tilewidth, this.m_tileheight);
                    this.RenderOneTile(g, tileData, tileClipX, tileClipY, 20);
                }
                tileClipX += this.m_tilewidth;
            }
            if (lastColW > 0 && tileIndex >= 0) {
                if (tileIndex > TILE_INDEX_MAX) {
                    return;
                }
                tileData = this.getTileId(tileIndex);
                ++tileIndex;
                g.setClip(tileClipX, tileClipY, lastColW, this.m_tileheight);
                this.RenderOneTile(g, tileData, tileClipX, tileClipY, 20);
            }
            tileClipY += this.m_tileheight;
            tileIndex = tileIndexStart += this.m_width;
        }
        if (lastRowH > 0) {
            tileClipX = clipX;
            if (firstColW > 0) {
                if (tileIndex >= 0) {
                    if (tileIndex > TILE_INDEX_MAX) {
                        return;
                    }
                    tileData = this.getTileId(tileIndex);
                    ++tileIndex;
                    g.setClip(tileClipX, tileClipY, firstColW, lastRowH);
                    this.RenderOneTile(g, tileData, tileClipX - offsetIntoTileX, tileClipY, 20);
                }
                tileClipX += firstColW;
            }
            for (cx = 0; cx < numWholeTilesX; ++cx) {
                if (tileIndex >= 0) {
                    if (tileIndex > TILE_INDEX_MAX) {
                        return;
                    }
                    tileData = this.getTileId(tileIndex);
                    ++tileIndex;
                    g.setClip(tileClipX, tileClipY, this.m_tilewidth, lastRowH);
                    this.RenderOneTile(g, tileData, tileClipX, tileClipY, 20);
                }
                tileClipX += this.m_tilewidth;
            }
            if (lastColW > 0 && tileIndex >= 0) {
                if (tileIndex > TILE_INDEX_MAX) {
                    return;
                }
                tileData = this.getTileId(tileIndex);
                ++tileIndex;
                g.setClip(tileClipX, tileClipY, lastColW, lastRowH);
                this.RenderOneTile(g, tileData, tileClipX, tileClipY, 20);
            }
        }
    }

    private void RenderOneTile(Graphics g, int id, int _x, int _y, int anchor) {
        int iw = this.m_tileImage.getWidth() / this.m_tilewidth;
        int x = id % iw * this.m_tilewidth;
        int y = id / iw * this.m_tileheight;
        GraphicsTool.DrawRegion(g, this.m_tileImage, x, y, this.m_tilewidth, this.m_tileheight, _x, _y, anchor);
    }

    public void setUseMapBuffer(boolean useBuffer) {
        if (useBuffer && !this.m_usemapBuffer) {
            if (this.m_viewportW > 0 && this.m_viewportH > 0) {
                this.initMapBuffer();
            }
            this.m_usemapBuffer = true;
        } else if (!useBuffer && this.m_usemapBuffer) {
            this.m_mapBuffer = null;
            this.m_usemapBuffer = false;
        }
    }

    private void initMapBuffer() {
        try {
            this.m_mapBuffer = null;
            this.m_mapBuffer = Image.createImage((int)this.m_viewportW, (int)this.m_viewportH);
            this.m_mapBufferGraphics = this.m_mapBuffer.getGraphics();
            this.m_redrawWholeBuffer = true;
            this.m_oldcameraX = this.m_cameraX;
            this.m_oldcameraY = this.m_cameraY;
            this.m_blitX = 0;
            this.m_blitY = 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void SetMapImage(Image img) {
        this.m_tileImage = img;
    }

    public int gettargetcamerax(boolean facing, GameObject go) {
        int temp = 0;
        temp = go.getX() - this.m_cameraX < this.m_cameradist ? go.getX() - this.m_cameradist : (go.getX() - this.m_cameraX > this.getViewportWidth() - this.m_cameradist ? go.getX() - (this.getViewportWidth() - this.m_cameradist) : this.m_cameraX);
        return temp;
    }

    public void setCamera(GameObject go) {
        this.m_targetcameraX = this.gettargetcamerax(go.getAniManager().getfacingx(), go);
        this.setValidCameraPosition();
        this.setCameraX(this.m_targetcameraX);
        this.checkmoverange();
    }

    public void checkmoverange() {
        if (this.areaindex > 0) {
            this.moveleft = this.getCameraX();
            if (this.moveleft > this.range[this.areaindex - 1]) {
                this.moveleft = this.range[this.areaindex - 1];
            }
        } else {
            this.moveleft = 0;
        }
        this.moveright = this.mapright;
        if (this.areaindex <= this.range.length - 1) {
            this.moveright = this.range[this.areaindex];
        }
    }

    public void updateCamera(GameObject go) {
        boolean facing = go.getAniManager().getfacingx();
        this.m_targetcameraX = this.gettargetcamerax(facing, go);
        this.setValidCameraPosition();
        if (MathTool.getAbs(this.m_targetcameraX - this.m_cameraX) > 12) {
            if (this.m_targetcameraX < this.m_cameraX) {
                this.m_cameraX -= 12;
                if (this.m_cameraX < this.m_targetcameraX) {
                    this.m_cameraX = this.m_targetcameraX;
                }
            } else {
                this.m_cameraX += 12;
                if (this.m_cameraX > this.m_targetcameraX) {
                    this.m_cameraX = this.m_targetcameraX;
                }
            }
        } else {
            this.setCameraX(this.m_targetcameraX);
        }
    }

    public void setValidCameraPosition() {
        this.checkmoverange();
        int maxright = this.moveright - this.m_viewportW;
        if (this.m_targetcameraX < this.moveleft) {
            this.m_targetcameraX = this.moveleft;
        } else if (this.m_targetcameraX > maxright) {
            this.m_targetcameraX = maxright;
        }
    }

    public boolean inthearea(GameObject go) {
        int x = go.getX();
        if (this.areaindex == 0) {
            return x >= 0;
        }
        return x > this.range[this.areaindex - 1];
    }

    public boolean x_outview(int _x) {
        return _x < this.moveleft || _x >= this.moveright;
    }

    public int x_rangeinview(int _x) {
        int temp = _x;
        if (_x < this.moveleft) {
            temp = this.moveleft;
        }
        if (_x > this.moveright) {
            temp = this.moveright;
        }
        return temp;
    }

    public int y_rangeinview(int _y) {
        int temp = _y;
        if (_y < this.moveup) {
            temp = this.moveup;
        }
        if (_y > this.movedown) {
            temp = this.movedown;
        }
        return temp;
    }

    public int x_rangeinmap(int _x) {
        int temp = _x;
        if (_x < this.mapleft) {
            temp = this.mapleft;
        }
        if (_x > this.mapright) {
            temp = this.mapright;
        }
        return temp;
    }

    public int y_rangeinmap(int _y) {
        int temp = _y;
        if (_y < this.moveup) {
            temp = this.moveup;
        }
        if (_y > this.movedown) {
            temp = this.movedown;
        }
        return temp;
    }

    public boolean disapear(GameObject go) {
        int _x = go.getX();
        return _x < this.moveleft;
    }

    protected boolean closetomapright(int _x) {
        return this.mapright - _x < 20;
    }

    protected boolean closetomapleft(int _x) {
        return _x - this.mapleft < 20;
    }

    protected boolean closetomoveright(int _x) {
        return this.moveright - _x < 20;
    }

    protected boolean closetomoveleft(int _x) {
        return _x - this.moveleft < 20;
    }
}

